/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import androidx.test.espresso.NoActivityResumedException;
import androidx.test.espresso.core.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.core.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.core.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.remote.NoRemoteEspressoInstanceException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

final class InteractionResultsHandler {
    private static final String TAG = "InteractionResultsHandl";
    private static final int LOCAL_OR_REMOTE_ERROR_PRIORITY = Integer.MAX_VALUE;

    private InteractionResultsHandler() {
    }

    static <T> T gatherAnyResult(List<ListenableFuture<T>> list) {
        return InteractionResultsHandler.gatherAnyResult(list, MoreExecutors.directExecutor());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T gatherAnyResult(List<ListenableFuture<T>> var0, Executor var1_1) {
        Preconditions.checkNotNull(var0);
        Preconditions.checkState(var0.isEmpty() == false);
        var2_2 = var0.size();
        var3_3 = new LinkedBlockingQueue<E>(var2_2);
        var4_4 = var0.iterator();
        while (var4_4.hasNext()) {
            var6_7 = var5_5 = var4_4.next();
            var6_7.addListener(new Runnable((ListenableFuture)var6_7, var3_3){
                final /* synthetic */ ListenableFuture val$myTask;
                final /* synthetic */ LinkedBlockingQueue val$resultQ;
                {
                    this.val$myTask = listenableFuture;
                    this.val$resultQ = linkedBlockingQueue;
                }

                @Override
                public void run() {
                    if (this.val$myTask.isCancelled()) {
                        return;
                    }
                    this.val$resultQ.offer(InteractionResultsHandler.adaptResult(this.val$myTask));
                }
            }, MoreExecutors.directExecutor());
        }
        var4_4 = null;
        while (true) {
            try {
                if (var2_2 == 0 || var4_4 != null && var4_4.isPriority()) {
                    var5_5 = InteractionResultsHandler.finalResult(var4_4);
                    var6_7 = var0.iterator();
                }
                ** GOTO lbl-1000
            }
            catch (InterruptedException var5_6) {
                throw new RuntimeException("Interrupted while interacting", var5_6);
            }
            catch (Throwable var8_9) {
                var9_10 = var0.iterator();
                while (true) {
                    if (!var9_10.hasNext()) {
                        throw var8_9;
                    }
                    var10_11 = var9_10.next();
                    var10_11.cancel(true);
                }
            }
            while (true) {
                if (!var6_7.hasNext()) {
                    return (T)var5_5;
                }
                var7_8 = (ListenableFuture)var6_7.next();
                var7_8.cancel(true);
            }
lbl-1000:
            // 1 sources

            {
                var5_5 = (ExecutionResult)var3_3.take();
                --var2_2;
                var4_4 = InteractionResultsHandler.pickResult(var4_4, var5_5);
                continue;
            }
            break;
        }
    }

    private static <T> T finalResult(ExecutionResult<T> executionResult) {
        if (executionResult.isSuccess()) {
            return executionResult.getResult();
        }
        Throwable throwable = executionResult.getFailure();
        if (throwable instanceof ExecutionException) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 instanceof RuntimeException) {
                throw (RuntimeException)throwable2;
            }
            if (throwable2 instanceof Error) {
                throw (Error)throwable2;
            }
            throw new RuntimeException("Unknown error during interactions", executionResult.getFailure());
        }
        if (throwable instanceof InterruptedException) {
            throw new IllegalStateException("Interrupted while interacting remotely", throwable);
        }
        throw new RuntimeException("Error interacting remotely", throwable);
    }

    private static <T> ExecutionResult<T> adaptResult(Future<T> future) {
        try {
            Preconditions.checkState(future.isDone());
            return ExecutionResult.success(future.get());
        }
        catch (ExecutionException executionException) {
            return ExecutionResult.error(executionException, Integer.MAX_VALUE == InteractionResultsHandler.getPriority(executionException));
        }
        catch (InterruptedException interruptedException) {
            return ExecutionResult.error(interruptedException);
        }
        catch (RuntimeException runtimeException) {
            return ExecutionResult.error(runtimeException);
        }
        catch (Error error) {
            return ExecutionResult.error(error);
        }
    }

    private static <T> ExecutionResult<T> pickResult(ExecutionResult<T> executionResult, ExecutionResult<T> executionResult2) {
        if (executionResult2 == null) {
            return executionResult;
        }
        if (executionResult == null) {
            return executionResult2;
        }
        if (executionResult.isSuccess()) {
            return executionResult;
        }
        if (executionResult2.isSuccess()) {
            return executionResult2;
        }
        if (InteractionResultsHandler.getPriority(executionResult.getFailure()) > InteractionResultsHandler.getPriority(executionResult2.getFailure())) {
            return executionResult;
        }
        return executionResult2;
    }

    private static int getPriority(Throwable throwable) {
        if (null == throwable) {
            return Integer.MIN_VALUE;
        }
        if (!(throwable instanceof ExecutionException)) {
            return -2147483647;
        }
        if (throwable.getCause() instanceof NoRemoteEspressoInstanceException) {
            return 0;
        }
        if (throwable.getCause() instanceof NoActivityResumedException) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private static class ExecutionResult<T> {
        private final T result;
        private final boolean success;
        private final Throwable failure;
        private final boolean priority;

        private ExecutionResult(T t, boolean bl, Throwable throwable, boolean bl2) {
            this.result = t;
            this.success = bl;
            this.failure = throwable;
            this.priority = bl2;
        }

        public T getResult() {
            Preconditions.checkState(this.success);
            return this.result;
        }

        public boolean isPriority() {
            return this.priority;
        }

        public boolean isSuccess() {
            return this.success;
        }

        public Throwable getFailure() {
            Preconditions.checkState(!this.success);
            return this.failure;
        }

        public static <T> ExecutionResult<T> success(T t) {
            return new ExecutionResult<T>(t, true, null, true);
        }

        public static <T> ExecutionResult<T> error(Throwable throwable) {
            return ExecutionResult.error(throwable, false);
        }

        public static <T> ExecutionResult<T> error(Throwable throwable, boolean bl) {
            return new ExecutionResult<Object>(null, false, throwable, bl);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).omitNullValues().add("priority", this.priority).add("success", this.success).add("result", this.result).add("failure", this.failure).toString();
        }
    }
}

