/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.contrib;

import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.action.CoordinatesProvider;
import androidx.test.espresso.action.GeneralClickAction;
import androidx.test.espresso.action.PrecisionDescriber;
import androidx.test.espresso.action.Press;
import androidx.test.espresso.action.Tap;
import androidx.test.espresso.action.Tapper;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.viewpager.widget.PagerTitleStrip;
import androidx.viewpager.widget.ViewPager;
import org.hamcrest.Matcher;

public final class ViewPagerActions {
    private static final boolean DEFAULT_SMOOTH_SCROLL = false;

    private ViewPagerActions() {
    }

    public static ViewAction scrollRight() {
        return ViewPagerActions.scrollRight(false);
    }

    public static ViewAction scrollRight(final boolean smoothScroll) {
        return new ViewPagerScrollAction(){

            public String getDescription() {
                return "ViewPager move one page to the right";
            }

            @Override
            protected void performScroll(ViewPager viewPager) {
                int current = viewPager.getCurrentItem();
                viewPager.setCurrentItem(current + 1, smoothScroll);
            }
        };
    }

    public static ViewAction scrollLeft() {
        return ViewPagerActions.scrollLeft(false);
    }

    public static ViewAction scrollLeft(final boolean smoothScroll) {
        return new ViewPagerScrollAction(){

            public String getDescription() {
                return "ViewPager move one page to the left";
            }

            @Override
            protected void performScroll(ViewPager viewPager) {
                int current = viewPager.getCurrentItem();
                viewPager.setCurrentItem(current - 1, smoothScroll);
            }
        };
    }

    public static ViewAction scrollToLast() {
        return ViewPagerActions.scrollToLast(false);
    }

    public static ViewAction scrollToLast(final boolean smoothScroll) {
        return new ViewPagerScrollAction(){

            public String getDescription() {
                return "ViewPager move to last page";
            }

            @Override
            protected void performScroll(ViewPager viewPager) {
                int size = viewPager.getAdapter().getCount();
                if (size > 0) {
                    viewPager.setCurrentItem(size - 1, smoothScroll);
                }
            }
        };
    }

    public static ViewAction scrollToFirst() {
        return ViewPagerActions.scrollToFirst(false);
    }

    public static ViewAction scrollToFirst(final boolean smoothScroll) {
        return new ViewPagerScrollAction(){

            public String getDescription() {
                return "ViewPager move to first page";
            }

            @Override
            protected void performScroll(ViewPager viewPager) {
                int size = viewPager.getAdapter().getCount();
                if (size > 0) {
                    viewPager.setCurrentItem(0, smoothScroll);
                }
            }
        };
    }

    public static ViewAction scrollToPage(int page) {
        return ViewPagerActions.scrollToPage(page, false);
    }

    public static ViewAction scrollToPage(final int page, final boolean smoothScroll) {
        return new ViewPagerScrollAction(){

            public String getDescription() {
                return "ViewPager move to page";
            }

            @Override
            protected void performScroll(ViewPager viewPager) {
                viewPager.setCurrentItem(page, smoothScroll);
            }
        };
    }

    public static ViewAction clickBetweenTwoTitles(final String title1, final String title2) {
        return new GeneralClickAction((Tapper)Tap.SINGLE, new CoordinatesProvider(){

            public float[] calculateCoordinates(View view) {
                PagerTitleStrip pagerStrip = (PagerTitleStrip)view;
                int[] viewScreenPosition = new int[2];
                pagerStrip.getLocationOnScreen(viewScreenPosition);
                int title1Left = 0;
                int title1Right = 0;
                int title2Left = 0;
                int title2Right = 0;
                int childCount = pagerStrip.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    View child = pagerStrip.getChildAt(i);
                    if (!(child instanceof TextView)) continue;
                    TextView textViewChild = (TextView)child;
                    CharSequence childText = textViewChild.getText();
                    if (title1.equals(childText)) {
                        title1Left = textViewChild.getLeft();
                        title1Right = textViewChild.getRight();
                        continue;
                    }
                    if (!title2.equals(childText)) continue;
                    title2Left = textViewChild.getLeft();
                    title2Right = textViewChild.getRight();
                }
                if (title1Right < title2Left) {
                    return new float[]{viewScreenPosition[0] + (title1Right + title2Left) / 2, viewScreenPosition[1] + pagerStrip.getHeight() / 2};
                }
                return new float[]{viewScreenPosition[0] + (title2Right + title1Left) / 2, viewScreenPosition[1] + pagerStrip.getHeight() / 2};
            }
        }, (PrecisionDescriber)Press.FINGER, 0, 0);
    }

    private static abstract class ViewPagerScrollAction
    implements ViewAction {
        private ViewPagerScrollAction() {
        }

        public final Matcher<View> getConstraints() {
            return ViewMatchers.isDisplayed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void perform(UiController uiController, View view) {
            ViewPager viewPager = (ViewPager)view;
            CustomViewPagerListener customListener = new CustomViewPagerListener();
            viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)customListener);
            try {
                Espresso.registerIdlingResources((IdlingResource[])new IdlingResource[]{customListener});
                uiController.loopMainThreadUntilIdle();
                this.performScroll((ViewPager)view);
                uiController.loopMainThreadUntilIdle();
                customListener.mNeedsIdle = true;
                uiController.loopMainThreadUntilIdle();
                customListener.mNeedsIdle = false;
            }
            catch (Throwable throwable) {
                Espresso.unregisterIdlingResources((IdlingResource[])new IdlingResource[]{customListener});
                viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)customListener);
                throw throwable;
            }
            Espresso.unregisterIdlingResources((IdlingResource[])new IdlingResource[]{customListener});
            viewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)customListener);
        }

        protected abstract void performScroll(ViewPager var1);
    }

    private static final class CustomViewPagerListener
    implements ViewPager.OnPageChangeListener,
    IdlingResource {
        private int mCurrState = 0;
        @Nullable
        private IdlingResource.ResourceCallback mCallback;
        private boolean mNeedsIdle = false;

        private CustomViewPagerListener() {
        }

        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback resourceCallback) {
            this.mCallback = resourceCallback;
        }

        public String getName() {
            return "View pager listener";
        }

        public boolean isIdleNow() {
            if (!this.mNeedsIdle) {
                return true;
            }
            return this.mCurrState == 0;
        }

        public void onPageSelected(int position) {
            if (this.mCurrState == 0 && this.mCallback != null) {
                this.mCallback.onTransitionToIdle();
            }
        }

        public void onPageScrollStateChanged(int state) {
            this.mCurrState = state;
            if (this.mCurrState == 0 && this.mCallback != null) {
                this.mCallback.onTransitionToIdle();
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }
    }
}

