/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.contrib;

import android.app.Instrumentation;
import android.content.Intent;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public final class ActivityResultMatchers {
    private ActivityResultMatchers() {
    }

    public static Matcher<? super Instrumentation.ActivityResult> hasResultData(final Matcher<Intent> intentMatcher) {
        return new TypeSafeMatcher<Instrumentation.ActivityResult>(Instrumentation.ActivityResult.class){

            public void describeTo(Description description) {
                description.appendDescriptionOf((SelfDescribing)intentMatcher);
            }

            protected boolean matchesSafely(Instrumentation.ActivityResult item) {
                return intentMatcher.matches((Object)item.getResultData());
            }

            protected void describeMismatchSafely(Instrumentation.ActivityResult item, Description mismatchDescription) {
                intentMatcher.describeMismatch((Object)item.getResultData(), mismatchDescription);
            }
        };
    }

    public static Matcher<? super Instrumentation.ActivityResult> hasResultCode(final int resultCode) {
        return new TypeSafeMatcher<Instrumentation.ActivityResult>(Instrumentation.ActivityResult.class){

            public void describeTo(Description description) {
                description.appendText("has result code " + resultCode);
            }

            protected boolean matchesSafely(Instrumentation.ActivityResult activityResult) {
                return activityResult.getResultCode() == resultCode;
            }
        };
    }
}

