/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.contrib;

import android.view.View;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.test.espresso.matcher.BoundedMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public final class DrawerMatchers {
    public static Matcher<View> isClosed() {
        return DrawerMatchers.isClosed(0x800003);
    }

    public static Matcher<View> isClosed(final int gravity) {
        return new BoundedMatcher<View, DrawerLayout>(DrawerLayout.class){

            public void describeTo(Description description) {
                description.appendText("is drawer closed");
            }

            public boolean matchesSafely(DrawerLayout drawer) {
                return !drawer.isDrawerVisible(gravity);
            }
        };
    }

    public static Matcher<View> isOpen() {
        return DrawerMatchers.isOpen(0x800003);
    }

    public static Matcher<View> isOpen(final int gravity) {
        return new BoundedMatcher<View, DrawerLayout>(DrawerLayout.class){

            public void describeTo(Description description) {
                description.appendText("is drawer open");
            }

            public boolean matchesSafely(DrawerLayout drawer) {
                return drawer.isDrawerOpen(gravity);
            }
        };
    }

    private DrawerMatchers() {
    }
}

