/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.contrib;

import android.view.View;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.contrib.DrawerMatchers;
import androidx.test.espresso.contrib.R;
import androidx.test.espresso.matcher.ViewMatchers;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class DrawerActions {
    private static final AtomicInteger nextId = new AtomicInteger();
    private static final int TAG = DrawerActions.getTag();

    private static int getTag() {
        try {
            return R.id.androidx_test_espresso_contrib_drawer_layout_tag;
        }
        catch (NoClassDefFoundError e) {
            return -12721584;
        }
    }

    public static ViewAction close() {
        return DrawerActions.close(0x800003);
    }

    public static ViewAction close(final int gravity) {
        return new DrawerAction(){

            public String getDescription() {
                int n = gravity;
                return "close drawer with gravity " + n;
            }

            @Override
            protected Matcher<View> checkAction() {
                return DrawerMatchers.isOpen(gravity);
            }

            @Override
            protected void performAction(UiController uiController, DrawerLayout view) {
                view.closeDrawer(gravity);
                uiController.loopMainThreadUntilIdle();
                if (view.isDrawerVisible(gravity)) {
                    uiController.loopMainThreadForAtLeast(300L);
                }
            }
        };
    }

    public static ViewAction open() {
        return DrawerActions.open(0x800003);
    }

    public static ViewAction open(final int gravity) {
        return new DrawerAction(){

            public String getDescription() {
                int n = gravity;
                return "open drawer with gravity " + n;
            }

            @Override
            protected Matcher<View> checkAction() {
                return DrawerMatchers.isClosed(gravity);
            }

            @Override
            protected void performAction(UiController uiController, DrawerLayout view) {
                view.openDrawer(gravity);
            }
        };
    }

    static /* bridge */ /* synthetic */ AtomicInteger -$$Nest$sfgetnextId() {
        return nextId;
    }

    private DrawerActions() {
    }

    @Deprecated
    public static void closeDrawer(int drawerLayoutId) {
        DrawerActions.closeDrawer(drawerLayoutId, 0x800003);
    }

    @Deprecated
    public static void closeDrawer(int drawerLayoutId, int gravity) {
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.close(gravity)});
    }

    @Deprecated
    public static void openDrawer(int drawerLayoutId) {
        DrawerActions.openDrawer(drawerLayoutId, 0x800003);
    }

    @Deprecated
    public static void openDrawer(int drawerLayoutId, int gravity) {
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.open(gravity)});
    }

    private static final class IdlingDrawerListener
    extends DrawerLayout.SimpleDrawerListener
    implements IdlingResource {
        private final int id = DrawerActions.-$$Nest$sfgetnextId().getAndIncrement();
        private IdlingResource.ResourceCallback callback;
        private boolean idle = true;

        public String getName() {
            int n = this.id;
            return "IdlingDrawerListener::" + n;
        }

        private IdlingDrawerListener() {
        }

        public void onDrawerStateChanged(int newState) {
            if (newState == 0) {
                this.idle = true;
                if (this.callback != null) {
                    this.callback.onTransitionToIdle();
                }
            } else {
                this.idle = false;
            }
        }

        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback callback) {
            this.callback = callback;
        }

        public boolean isIdleNow() {
            return this.idle;
        }
    }

    private static abstract class DrawerAction
    implements ViewAction {
        protected abstract Matcher<View> checkAction();

        public final Matcher<View> getConstraints() {
            return ViewMatchers.isAssignableFrom(DrawerLayout.class);
        }

        private DrawerAction() {
        }

        public final void perform(UiController uiController, View view) {
            IdlingDrawerListener idlingListener;
            DrawerLayout drawer = (DrawerLayout)view;
            if (!this.checkAction().matches((Object)drawer)) {
                return;
            }
            Object tag = drawer.getTag(TAG);
            if (tag instanceof IdlingDrawerListener) {
                idlingListener = (IdlingDrawerListener)((Object)tag);
            } else {
                idlingListener = new IdlingDrawerListener();
                drawer.setTag(TAG, (Object)idlingListener);
                drawer.addDrawerListener((DrawerLayout.DrawerListener)idlingListener);
                IdlingRegistry.getInstance().register(new IdlingResource[]{idlingListener});
            }
            this.performAction(uiController, drawer);
            uiController.loopMainThreadUntilIdle();
            IdlingRegistry.getInstance().unregister(new IdlingResource[]{idlingListener});
            drawer.removeDrawerListener((DrawerLayout.DrawerListener)idlingListener);
            drawer.setTag(TAG, null);
        }

        protected abstract void performAction(UiController var1, DrawerLayout var2);
    }
}

