/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.contrib;

import android.view.View;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.test.espresso.Espresso;
import androidx.test.espresso.IdlingRegistry;
import androidx.test.espresso.IdlingResource;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.contrib.DrawerMatchers;
import androidx.test.espresso.contrib.R;
import androidx.test.espresso.matcher.ViewMatchers;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;

public final class DrawerActions {
    private static final AtomicInteger nextId = new AtomicInteger();
    private static final int TAG = DrawerActions.getTag();

    private static int getTag() {
        try {
            return R.id.androidx_test_espresso_contrib_drawer_layout_tag;
        }
        catch (NoClassDefFoundError e) {
            return -12721584;
        }
    }

    private DrawerActions() {
    }

    @Deprecated
    public static void openDrawer(int drawerLayoutId) {
        DrawerActions.openDrawer(drawerLayoutId, 0x800003);
    }

    @Deprecated
    public static void openDrawer(int drawerLayoutId, int gravity) {
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.open(gravity)});
    }

    public static ViewAction open() {
        return DrawerActions.open(0x800003);
    }

    public static ViewAction open(final int gravity) {
        return new DrawerAction(){

            public String getDescription() {
                int n = gravity;
                return new StringBuilder(36).append("open drawer with gravity ").append(n).toString();
            }

            @Override
            protected Matcher<View> checkAction() {
                return DrawerMatchers.isClosed(gravity);
            }

            @Override
            protected void performAction(UiController uiController, DrawerLayout view) {
                view.openDrawer(gravity);
            }
        };
    }

    @Deprecated
    public static void closeDrawer(int drawerLayoutId) {
        DrawerActions.closeDrawer(drawerLayoutId, 0x800003);
    }

    @Deprecated
    public static void closeDrawer(int drawerLayoutId, int gravity) {
        Espresso.onView((Matcher)ViewMatchers.withId((int)drawerLayoutId)).perform(new ViewAction[]{DrawerActions.close(gravity)});
    }

    public static ViewAction close() {
        return DrawerActions.close(0x800003);
    }

    public static ViewAction close(final int gravity) {
        return new DrawerAction(){

            public String getDescription() {
                int n = gravity;
                return new StringBuilder(37).append("close drawer with gravity ").append(n).toString();
            }

            @Override
            protected Matcher<View> checkAction() {
                return DrawerMatchers.isOpen(gravity);
            }

            @Override
            protected void performAction(UiController uiController, DrawerLayout view) {
                view.closeDrawer(gravity);
                uiController.loopMainThreadUntilIdle();
                if (view.isDrawerVisible(gravity)) {
                    uiController.loopMainThreadForAtLeast(300L);
                }
            }
        };
    }

    static /* synthetic */ AtomicInteger access$300() {
        return nextId;
    }

    private static final class IdlingDrawerListener
    extends DrawerLayout.SimpleDrawerListener
    implements IdlingResource {
        private final int id = DrawerActions.access$300().getAndIncrement();
        private IdlingResource.ResourceCallback callback;
        private boolean idle = true;

        private IdlingDrawerListener() {
        }

        public void onDrawerStateChanged(int newState) {
            if (newState == 0) {
                this.idle = true;
                if (this.callback != null) {
                    this.callback.onTransitionToIdle();
                }
            } else {
                this.idle = false;
            }
        }

        public String getName() {
            int n = this.id;
            return new StringBuilder(33).append("IdlingDrawerListener::").append(n).toString();
        }

        public boolean isIdleNow() {
            return this.idle;
        }

        public void registerIdleTransitionCallback(IdlingResource.ResourceCallback callback) {
            this.callback = callback;
        }
    }

    private static abstract class DrawerAction
    implements ViewAction {
        private DrawerAction() {
        }

        public final Matcher<View> getConstraints() {
            return ViewMatchers.isAssignableFrom(DrawerLayout.class);
        }

        public final void perform(UiController uiController, View view) {
            IdlingDrawerListener idlingListener;
            DrawerLayout drawer = (DrawerLayout)view;
            if (!this.checkAction().matches((Object)drawer)) {
                return;
            }
            Object tag = drawer.getTag(TAG);
            if (tag instanceof IdlingDrawerListener) {
                idlingListener = (IdlingDrawerListener)((Object)tag);
            } else {
                idlingListener = new IdlingDrawerListener();
                drawer.setTag(TAG, (Object)idlingListener);
                drawer.addDrawerListener((DrawerLayout.DrawerListener)idlingListener);
                IdlingRegistry.getInstance().register(new IdlingResource[]{idlingListener});
            }
            this.performAction(uiController, drawer);
            uiController.loopMainThreadUntilIdle();
            IdlingRegistry.getInstance().unregister(new IdlingResource[]{idlingListener});
            drawer.removeDrawerListener((DrawerLayout.DrawerListener)idlingListener);
            drawer.setTag(TAG, null);
        }

        protected abstract Matcher<View> checkAction();

        protected abstract void performAction(UiController var1, DrawerLayout var2);
    }
}

