/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.contrib;

import android.os.StrictMode;
import android.util.Log;
import android.view.View;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.action.ViewActions;
import androidx.test.espresso.contrib.Checks;
import androidx.test.espresso.util.HumanReadables;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.integrations.espresso.AccessibilityValidator;

@Deprecated
public final class AccessibilityChecks {
    private static final AccessibilityValidator CHECK_EXECUTOR = new AccessibilityValidator().setResultDescriptor(new AccessibilityCheckResult.AccessibilityCheckResultDescriptor(){

        public String describeView(View view) {
            return HumanReadables.describe((View)view);
        }
    });
    private static final ViewAssertion ACCESSIBILITY_CHECK_ASSERTION = new ViewAssertion(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void check(View view, NoMatchingViewException noViewFoundException) {
            if (noViewFoundException != null) {
                Log.e((String)AccessibilityChecks.TAG, (String)String.format("'accessibility checks could not be performed because view '%s' was notfound.\n", noViewFoundException.getViewMatcherDescription()));
                throw noViewFoundException;
            }
            if (view == null) {
                throw new NullPointerException();
            }
            StrictMode.ThreadPolicy originalPolicy = StrictMode.allowThreadDiskWrites();
            try {
                CHECK_EXECUTOR.checkAndReturnResults(view);
            }
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)originalPolicy);
            }
        }
    };
    private static boolean checksEnabled = false;
    private static final String TAG = "AccessibilityChecks";

    private AccessibilityChecks() {
    }

    public static AccessibilityValidator enable() {
        Checks.checkState(!checksEnabled, "Accessibility checks already enabled!", new Object[0]);
        checksEnabled = true;
        ViewActions.addGlobalAssertion((String)"Accessibility Checks", (ViewAssertion)ACCESSIBILITY_CHECK_ASSERTION);
        return CHECK_EXECUTOR;
    }

    public static ViewAssertion accessibilityAssertion() {
        return ACCESSIBILITY_CHECK_ASSERTION;
    }
}

