/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.util;

import android.util.Log;
import androidx.annotation.NonNull;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ProcessLock {
    private static final String TAG = "SupportSQLiteLock";
    private static final Map<String, Lock> sThreadLocks = new HashMap<String, Lock>();
    private final File mLockFile;
    private final Lock mThreadLock;
    private final boolean mFileLevelLock;
    private FileChannel mLockChannel;

    public ProcessLock(@NonNull String name, @NonNull File lockDir, boolean processLock) {
        this.mLockFile = new File(lockDir, name + ".lck");
        this.mThreadLock = ProcessLock.getThreadLock(this.mLockFile.getAbsolutePath());
        this.mFileLevelLock = processLock;
    }

    public void lock() {
        this.lock(this.mFileLevelLock);
    }

    public void lock(boolean processLock) {
        this.mThreadLock.lock();
        if (processLock) {
            try {
                File parentDir = this.mLockFile.getParentFile();
                if (parentDir != null) {
                    parentDir.mkdirs();
                }
                this.mLockChannel = new FileOutputStream(this.mLockFile).getChannel();
                this.mLockChannel.lock();
            }
            catch (IOException e) {
                this.mLockChannel = null;
                Log.w((String)TAG, (String)"Unable to grab file lock.", (Throwable)e);
            }
        }
    }

    public void unlock() {
        if (this.mLockChannel != null) {
            try {
                this.mLockChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mThreadLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lock getThreadLock(String key) {
        Map<String, Lock> map = sThreadLocks;
        synchronized (map) {
            Lock threadLock = sThreadLocks.get(key);
            if (threadLock == null) {
                threadLock = new ReentrantLock();
                sThreadLocks.put(key, threadLock);
            }
            return threadLock;
        }
    }
}

