/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.db.framework;

import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteDatabase;
import java.io.File;

class FrameworkSQLiteOpenHelper
implements SupportSQLiteOpenHelper {
    private final Context mContext;
    private final String mName;
    private final SupportSQLiteOpenHelper.Callback mCallback;
    private final boolean mUseNoBackupDirectory;
    private final Object mLock;
    private OpenHelper mDelegate;
    private boolean mWriteAheadLoggingEnabled;

    FrameworkSQLiteOpenHelper(Context context, String name, SupportSQLiteOpenHelper.Callback callback) {
        this(context, name, callback, false);
    }

    FrameworkSQLiteOpenHelper(Context context, String name, SupportSQLiteOpenHelper.Callback callback, boolean useNoBackupDirectory) {
        this.mContext = context;
        this.mName = name;
        this.mCallback = callback;
        this.mUseNoBackupDirectory = useNoBackupDirectory;
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenHelper getDelegate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDelegate == null) {
                FrameworkSQLiteDatabase[] dbRef = new FrameworkSQLiteDatabase[1];
                if (Build.VERSION.SDK_INT >= 23 && this.mName != null && this.mUseNoBackupDirectory) {
                    File file = new File(this.mContext.getNoBackupFilesDir(), this.mName);
                    this.mDelegate = new OpenHelper(this.mContext, file.getAbsolutePath(), dbRef, this.mCallback);
                } else {
                    this.mDelegate = new OpenHelper(this.mContext, this.mName, dbRef, this.mCallback);
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    this.mDelegate.setWriteAheadLoggingEnabled(this.mWriteAheadLoggingEnabled);
                }
            }
            return this.mDelegate;
        }
    }

    public String getDatabaseName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDelegate != null) {
                this.mDelegate.setWriteAheadLoggingEnabled(enabled);
            }
            this.mWriteAheadLoggingEnabled = enabled;
        }
    }

    public SupportSQLiteDatabase getWritableDatabase() {
        return this.getDelegate().getWritableSupportDatabase();
    }

    public SupportSQLiteDatabase getReadableDatabase() {
        return this.getDelegate().getReadableSupportDatabase();
    }

    public void close() {
        this.getDelegate().close();
    }

    static class OpenHelper
    extends SQLiteOpenHelper {
        final FrameworkSQLiteDatabase[] mDbRef;
        final SupportSQLiteOpenHelper.Callback mCallback;
        private boolean mMigrated;

        OpenHelper(Context context, String name, final FrameworkSQLiteDatabase[] dbRef, final SupportSQLiteOpenHelper.Callback callback) {
            super(context, name, null, callback.version, new DatabaseErrorHandler(){

                public void onCorruption(SQLiteDatabase dbObj) {
                    callback.onCorruption((SupportSQLiteDatabase)OpenHelper.getWrappedDb(dbRef, dbObj));
                }
            });
            this.mCallback = callback;
            this.mDbRef = dbRef;
        }

        synchronized SupportSQLiteDatabase getWritableSupportDatabase() {
            this.mMigrated = false;
            SQLiteDatabase db = super.getWritableDatabase();
            if (this.mMigrated) {
                this.close();
                return this.getWritableSupportDatabase();
            }
            return this.getWrappedDb(db);
        }

        synchronized SupportSQLiteDatabase getReadableSupportDatabase() {
            this.mMigrated = false;
            SQLiteDatabase db = super.getReadableDatabase();
            if (this.mMigrated) {
                this.close();
                return this.getReadableSupportDatabase();
            }
            return this.getWrappedDb(db);
        }

        FrameworkSQLiteDatabase getWrappedDb(SQLiteDatabase sqLiteDatabase) {
            return OpenHelper.getWrappedDb(this.mDbRef, sqLiteDatabase);
        }

        public void onCreate(SQLiteDatabase sqLiteDatabase) {
            this.mCallback.onCreate((SupportSQLiteDatabase)this.getWrappedDb(sqLiteDatabase));
        }

        public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
            this.mMigrated = true;
            this.mCallback.onUpgrade((SupportSQLiteDatabase)this.getWrappedDb(sqLiteDatabase), oldVersion, newVersion);
        }

        public void onConfigure(SQLiteDatabase db) {
            this.mCallback.onConfigure((SupportSQLiteDatabase)this.getWrappedDb(db));
        }

        public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.mMigrated = true;
            this.mCallback.onDowngrade((SupportSQLiteDatabase)this.getWrappedDb(db), oldVersion, newVersion);
        }

        public void onOpen(SQLiteDatabase db) {
            if (!this.mMigrated) {
                this.mCallback.onOpen((SupportSQLiteDatabase)this.getWrappedDb(db));
            }
        }

        public synchronized void close() {
            super.close();
            this.mDbRef[0] = null;
        }

        static FrameworkSQLiteDatabase getWrappedDb(FrameworkSQLiteDatabase[] refHolder, SQLiteDatabase sqLiteDatabase) {
            FrameworkSQLiteDatabase dbRef = refHolder[0];
            if (dbRef == null || !dbRef.isDelegate(sqLiteDatabase)) {
                refHolder[0] = new FrameworkSQLiteDatabase(sqLiteDatabase);
            }
            return refHolder[0];
        }
    }
}

