/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.driver.bundled;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Landroidx/sqlite/driver/bundled/NativeLibraryLoader;", "", "()V", "getResourceName", "", "name", "loadLibrary", "", "sqlite-bundled"})
@SourceDebugExtension(value={"SMAP\nNativeLibraryLoader.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeLibraryLoader.jvm.kt\nandroidx/sqlite/driver/bundled/NativeLibraryLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class NativeLibraryLoader {
    @NotNull
    public static final NativeLibraryLoader INSTANCE = new NativeLibraryLoader();

    private NativeLibraryLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadLibrary(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NativeLibraryLoader nativeLibraryLoader = this;
        synchronized (nativeLibraryLoader) {
            boolean bl = false;
            try {
                System.loadLibrary(name);
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                String libResourceName = INSTANCE.getResourceName(name);
                Object object = Files.createTempFile("androidx_" + name, null, new FileAttribute[0]);
                Path $this$loadLibrary_u24lambda_u243_u24lambda_u240 = object;
                boolean bl2 = false;
                $this$loadLibrary_u24lambda_u243_u24lambda_u240.toFile().deleteOnExit();
                Path libTempCopy = object;
                ClassLoader classLoader = NativeLibraryLoader.class.getClassLoader();
                Intrinsics.checkNotNull((Object)classLoader);
                object = classLoader.getResourceAsStream(libResourceName);
                Throwable throwable = null;
                try {
                    InputStream resourceStream = (InputStream)object;
                    boolean bl3 = false;
                    if (resourceStream == null) {
                        boolean bl4 = false;
                        String string = "Cannot find a suitable SQLite binary for " + System.getProperty("os.name") + " | " + System.getProperty("os.arch") + ". Please file a bug at https://issuetracker.google.com/issues/new?component=460784";
                        throw new IllegalStateException(string.toString());
                    }
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    long l = Files.copy(resourceStream, libTempCopy, copyOptionArray);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                System.load(libTempCopy.toFile().getCanonicalPath());
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    private final String getResourceName(String name) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String osName;
        block50: {
            block49: {
                String string6;
                block48: {
                    block47: {
                        string6 = System.getProperty("os.name");
                        if (string6 == null) break block47;
                        String string7 = string6;
                        Locale locale = Locale.US;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                        String string8 = string7.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"this as java.lang.String).toLowerCase(locale)");
                        string6 = string8;
                        if (string8 != null) break block48;
                    }
                    throw new IllegalStateException("Cannot read osName".toString());
                }
                osName = string6;
                string5 = System.getProperty("os.arch");
                if (string5 == null) break block49;
                String string9 = string5;
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                String string10 = string9.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"this as java.lang.String).toLowerCase(locale)");
                string5 = string10;
                if (string10 != null) break block50;
            }
            throw new IllegalStateException("Cannot read osArch".toString());
        }
        String osArch = string5;
        if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"linux", (boolean)false, (int)2, null)) {
            string4 = "linux";
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"mac", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"osx", (boolean)false, (int)2, null)) {
            string4 = "osx";
        } else if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"windows", (boolean)false, (int)2, null)) {
            string4 = "windows";
        } else {
            throw new IllegalStateException(("Unsupported operating system: " + osName).toString());
        }
        String osPrefix = string4;
        if (Intrinsics.areEqual((Object)osArch, (Object)"aarch64")) {
            string3 = "arm64";
        } else if (StringsKt.contains$default((CharSequence)osArch, (CharSequence)"arm", (boolean)false, (int)2, null)) {
            string3 = StringsKt.contains$default((CharSequence)osArch, (CharSequence)"64", (boolean)false, (int)2, null) ? "arm64" : "arm32";
        } else if (StringsKt.contains$default((CharSequence)osArch, (CharSequence)"64", (boolean)false, (int)2, null)) {
            string3 = "x64";
        } else if (StringsKt.contains$default((CharSequence)osArch, (CharSequence)"86", (boolean)false, (int)2, null)) {
            string3 = "x86";
        } else {
            throw new IllegalStateException(("Unsupported architecture: " + osArch).toString());
        }
        String archSuffix = string3;
        String resourceFolder = osPrefix + '_' + archSuffix;
        switch (osPrefix) {
            case "osx": 
            case "linux": {
                string2 = "lib";
                break;
            }
            case "windows": {
                string2 = "";
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported operating system: " + osName).toString());
            }
        }
        String prefix = string2;
        switch (osPrefix) {
            case "linux": {
                string = "so";
                break;
            }
            case "osx": {
                string = "dylib";
                break;
            }
            case "windows": {
                string = "dll";
                break;
            }
            default: {
                throw new IllegalStateException(("Unsupported operating system: " + osName).toString());
            }
        }
        String extension = string;
        return "natives/" + resourceFolder + '/' + prefix + name + '.' + extension;
    }
}

