/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.driver.bundled;

import androidx.annotation.RestrictTo;
import androidx.sqlite.SQLite;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import androidx.sqlite.driver.bundled.BundledSQLiteConnectionKt;
import androidx.sqlite.driver.bundled.BundledSQLiteStatement;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Landroidx/sqlite/driver/bundled/BundledSQLiteConnection;", "Landroidx/sqlite/SQLiteConnection;", "connectionPointer", "", "(J)V", "isClosed", "", "isClosed$annotations", "()V", "close", "", "prepare", "Landroidx/sqlite/SQLiteStatement;", "sql", "", "sqlite-bundled"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class BundledSQLiteConnection
implements SQLiteConnection {
    private final long connectionPointer;
    private volatile boolean isClosed;

    public BundledSQLiteConnection(long connectionPointer) {
        this.connectionPointer = connectionPointer;
    }

    private static /* synthetic */ void isClosed$annotations() {
    }

    @NotNull
    public SQLiteStatement prepare(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        if (this.isClosed) {
            SQLite.throwSQLiteException((int)21, (String)"connection is closed");
            throw new KotlinNothingValueException();
        }
        long statementPointer = BundledSQLiteConnectionKt.access$nativePrepare(this.connectionPointer, sql);
        return new BundledSQLiteStatement(this.connectionPointer, statementPointer);
    }

    public void close() {
        if (!this.isClosed) {
            BundledSQLiteConnectionKt.access$nativeClose(this.connectionPointer);
        }
        this.isClosed = true;
    }
}

