/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.icu.text.SimpleDateFormat;
import android.icu.util.Calendar;
import android.icu.util.GregorianCalendar;
import android.icu.util.TimeZone;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.security.identity.AccessControlProfile;
import androidx.security.identity.AccessControlProfileId;
import androidx.security.identity.PersonalizationData;
import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.builder.ArrayBuilder;
import co.nstant.in.cbor.builder.MapBuilder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.SimpleValueType;
import co.nstant.in.cbor.model.Special;
import co.nstant.in.cbor.model.SpecialType;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

class Util {
    private static final String TAG = "Util";
    private static final int COSE_LABEL_ALG = 1;
    private static final int COSE_LABEL_X5CHAIN = 33;
    private static final int COSE_ALG_ECDSA_256 = -7;
    static final int CBOR_SEMANTIC_TAG_ENCODED_CBOR = 24;

    private Util() {
    }

    static byte[] cborEncode(DataItem dataItem) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new CborEncoder((OutputStream)baos).encode(dataItem);
        }
        catch (CborException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Error encoding DataItem");
        }
        return baos.toByteArray();
    }

    static byte[] cborEncodeBoolean(boolean value) {
        return Util.cborEncode((DataItem)new CborBuilder().add(value).build().get(0));
    }

    static byte[] cborEncodeString(@NonNull String value) {
        return Util.cborEncode((DataItem)new CborBuilder().add(value).build().get(0));
    }

    static byte[] cborEncodeLong(long value) {
        return Util.cborEncode((DataItem)new CborBuilder().add(value).build().get(0));
    }

    static byte[] cborEncodeBytestring(@NonNull byte[] value) {
        return Util.cborEncode((DataItem)new CborBuilder().add(value).build().get(0));
    }

    static byte[] cborEncodeCalendar(@NonNull Calendar calendar) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        if (calendar.isSet(14) && calendar.get(14) != 0) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        }
        df.setTimeZone(calendar.getTimeZone());
        Date val = calendar.getTime();
        String dateString = df.format(val);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            new CborEncoder((OutputStream)baos).encode(new CborBuilder().addTag(0L).add(dateString).build());
        }
        catch (CborException e) {
            e.printStackTrace();
            Log.e((String)TAG, (String)"Error encoding Calendar");
        }
        byte[] data = baos.toByteArray();
        return data;
    }

    static DataItem cborToDataItem(byte[] data) {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            List dataItems = new CborDecoder((InputStream)bais).decode();
            if (dataItems.size() != 1) {
                throw new RuntimeException("Expected 1 item, found " + dataItems.size());
            }
            return (DataItem)dataItems.get(0);
        }
        catch (CborException e) {
            throw new RuntimeException("Error decoding data", e);
        }
    }

    static boolean cborDecodeBoolean(@NonNull byte[] data) {
        SimpleValue simple = (SimpleValue)Util.cborToDataItem(data);
        return simple.getSimpleValueType() == SimpleValueType.TRUE;
    }

    static String cborDecodeString(@NonNull byte[] data) {
        return ((UnicodeString)Util.cborToDataItem(data)).getString();
    }

    static long cborDecodeLong(@NonNull byte[] data) {
        return ((Number)Util.cborToDataItem(data)).getValue().longValue();
    }

    static byte[] cborDecodeBytestring(@NonNull byte[] data) {
        return ((ByteString)Util.cborToDataItem(data)).getBytes();
    }

    static Calendar cborDecodeCalendar(@NonNull byte[] data) {
        DataItem di = Util.cborToDataItem(data);
        if (!(di instanceof UnicodeString)) {
            throw new RuntimeException("Passed in data is not a Unicode-string");
        }
        if (!di.hasTag() || di.getTag().getValue() != 0L) {
            throw new RuntimeException("Passed in data is not tagged with tag 0");
        }
        String dateString = ((UnicodeString)di).getString();
        TimeZone parsedTz = TimeZone.getTimeZone((String)"UTC");
        if (!dateString.endsWith("Z")) {
            String timeZoneSubstr = dateString.substring(dateString.length() - 6);
            parsedTz = TimeZone.getTimeZone((String)("GMT" + timeZoneSubstr));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US);
        df.setTimeZone(parsedTz);
        Date date = null;
        try {
            date = df.parse(dateString);
        }
        catch (ParseException e) {
            df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);
            df.setTimeZone(parsedTz);
            try {
                date = df.parse(dateString);
            }
            catch (ParseException e2) {
                throw new RuntimeException("Error parsing string", e2);
            }
        }
        GregorianCalendar c = new GregorianCalendar();
        c.clear();
        c.setTimeZone(df.getTimeZone());
        c.setTime(date);
        return c;
    }

    static DataItem namespaceDataToCbor(PersonalizationData.NamespaceData entryNamespace) {
        CborBuilder entryBuilder = new CborBuilder();
        ArrayBuilder entryArrayBuilder = entryBuilder.addArray();
        for (String entryName : entryNamespace.getEntryNames()) {
            byte[] entryValue = entryNamespace.getEntryValue(entryName);
            Collection<AccessControlProfileId> accessControlProfileIds = entryNamespace.getAccessControlProfileIds(entryName);
            CborBuilder accessControlProfileIdsBuilder = new CborBuilder();
            ArrayBuilder accessControlProfileIdsArrayBuilder = accessControlProfileIdsBuilder.addArray();
            for (AccessControlProfileId id : accessControlProfileIds) {
                accessControlProfileIdsArrayBuilder.add((long)id.getId());
            }
            MapBuilder entryMapBuilder = entryArrayBuilder.addMap();
            entryMapBuilder.put("name", entryName);
            entryMapBuilder.put((DataItem)new UnicodeString("accessControlProfiles"), (DataItem)accessControlProfileIdsBuilder.build().get(0));
            entryMapBuilder.put((DataItem)new UnicodeString("value"), Util.cborToDataItem(entryValue));
        }
        return (DataItem)entryBuilder.build().get(0);
    }

    public static PersonalizationData.NamespaceData namespaceDataFromCbor(String namespaceName, DataItem dataItem) {
        if (!(dataItem instanceof Array)) {
            throw new RuntimeException("Item is not an Array");
        }
        Array array = (Array)dataItem;
        PersonalizationData.Builder builder = new PersonalizationData.Builder();
        for (DataItem item : array.getDataItems()) {
            if (!(item instanceof Map)) {
                throw new RuntimeException("Item is not a map");
            }
            Map map = (Map)item;
            String name = ((UnicodeString)map.get((DataItem)new UnicodeString("name"))).getString();
            ArrayList<AccessControlProfileId> accessControlProfileIds = new ArrayList<AccessControlProfileId>();
            Array accessControlProfileArray = (Array)map.get((DataItem)new UnicodeString("accessControlProfiles"));
            for (DataItem acpIdItem : accessControlProfileArray.getDataItems()) {
                accessControlProfileIds.add(new AccessControlProfileId(((Number)acpIdItem).getValue().intValue()));
            }
            DataItem cborValue = map.get((DataItem)new UnicodeString("value"));
            byte[] data = Util.cborEncode(cborValue);
            builder.putEntry(namespaceName, name, accessControlProfileIds, data);
        }
        return builder.build().getNamespaceData(namespaceName);
    }

    public static AccessControlProfile accessControlProfileFromCbor(DataItem item) {
        if (!(item instanceof Map)) {
            throw new RuntimeException("Item is not a map");
        }
        Map map = (Map)item;
        int accessControlProfileId = ((Number)map.get((DataItem)new UnicodeString("id"))).getValue().intValue();
        AccessControlProfile.Builder builder = new AccessControlProfile.Builder(new AccessControlProfileId(accessControlProfileId));
        item = map.get((DataItem)new UnicodeString("readerCertificate"));
        if (item != null) {
            byte[] rcBytes = ((ByteString)item).getBytes();
            CertificateFactory certFactory = null;
            try {
                certFactory = CertificateFactory.getInstance("X.509");
                builder.setReaderCertificate((X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(rcBytes)));
            }
            catch (CertificateException e) {
                throw new RuntimeException("Error decoding readerCertificate", e);
            }
        }
        builder.setUserAuthenticationRequired(false);
        item = map.get((DataItem)new UnicodeString("capabilityType"));
        if (item != null) {
            builder.setUserAuthenticationRequired(true);
            item = map.get((DataItem)new UnicodeString("timeout"));
            builder.setUserAuthenticationTimeout(item == null ? 0L : (long)((Number)item).getValue().intValue());
        }
        return builder.build();
    }

    static DataItem accessControlProfileToCbor(AccessControlProfile accessControlProfile) {
        CborBuilder cborBuilder = new CborBuilder();
        MapBuilder mapBuilder = cborBuilder.addMap();
        mapBuilder.put("id", (long)accessControlProfile.getAccessControlProfileId().getId());
        X509Certificate readerCertificate = accessControlProfile.getReaderCertificate();
        if (readerCertificate != null) {
            try {
                mapBuilder.put("readerCertificate", readerCertificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException("Error encoding reader mCertificate", e);
            }
        }
        if (accessControlProfile.isUserAuthenticationRequired()) {
            mapBuilder.put("capabilityType", 1L);
            long timeout = accessControlProfile.getUserAuthenticationTimeout();
            if (timeout != 0L) {
                mapBuilder.put("timeout", timeout);
            }
        }
        return (DataItem)cborBuilder.build().get(0);
    }

    static int[] integerCollectionToArray(Collection<Integer> collection) {
        int[] result = new int[collection.size()];
        int n = 0;
        for (int item : collection) {
            result[n++] = item;
        }
        return result;
    }

    @NonNull
    static X509Certificate generateAuthenticationKeyCert(String authKeyAlias, String credentialKeyAlias, byte[] proofOfProvisioningSha256) {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("AndroidKeyStore");
            ks.load(null);
            X509Certificate selfSignedCert = (X509Certificate)ks.getCertificate(authKeyAlias);
            PublicKey publicKey = selfSignedCert.getPublicKey();
            PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)ks.getEntry(credentialKeyAlias, null)).getPrivateKey();
            X500Name issuer = new X500Name("CN=Android Identity Credential Key");
            X500Name subject = new X500Name("CN=Android Identity Credential Authentication Key");
            Date now = new Date();
            long kMilliSecsInOneYear = 31536000000L;
            Date expirationDate = new Date(now.getTime() + 31536000000L);
            BigInteger serial = new BigInteger("1");
            JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, now, expirationDate, subject, publicKey);
            if (proofOfProvisioningSha256 != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                new CborEncoder((OutputStream)baos).encode(((CborBuilder)new CborBuilder().addArray().add("ProofOfBinding").add(proofOfProvisioningSha256).end()).build());
                byte[] encodedProofOfBinding = baos.toByteArray();
                builder.addExtension(new ASN1ObjectIdentifier("1.3.6.1.4.1.11129.2.1.26"), false, encodedProofOfBinding);
            }
            ContentSigner signer = new JcaContentSignerBuilder("SHA256withECDSA").build(privateKey);
            byte[] encodedCert = builder.build(signer).getEncoded();
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(encodedCert);
            X509Certificate result = (X509Certificate)cf.generateCertificate(bais);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing public key with private key", e);
        }
    }

    public static boolean validateCertificateChain(Collection<X509Certificate> certificateChain) {
        X509Certificate prevCertificate = null;
        for (X509Certificate certificate : certificateChain) {
            if (prevCertificate != null) {
                try {
                    prevCertificate.verify(certificate.getPublicKey());
                }
                catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
                    return false;
                }
            }
            prevCertificate = certificate;
        }
        return true;
    }

    static byte[] computeHkdf(String macAlgorithm, byte[] ikm, byte[] salt, byte[] info, int size) {
        Mac mac = null;
        try {
            mac = Mac.getInstance(macAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("No such algorithm: " + macAlgorithm, e);
        }
        if (size > 255 * mac.getMacLength()) {
            throw new RuntimeException("size too large");
        }
        try {
            if (salt == null || salt.length == 0) {
                mac.init(new SecretKeySpec(new byte[mac.getMacLength()], macAlgorithm));
            } else {
                mac.init(new SecretKeySpec(salt, macAlgorithm));
            }
            byte[] prk = mac.doFinal(ikm);
            byte[] result = new byte[size];
            int ctr = 1;
            int pos = 0;
            mac.init(new SecretKeySpec(prk, macAlgorithm));
            byte[] digest = new byte[]{};
            while (true) {
                mac.update(digest);
                mac.update(info);
                mac.update((byte)ctr);
                digest = mac.doFinal();
                if (pos + digest.length >= size) break;
                System.arraycopy(digest, 0, result, pos, digest.length);
                pos += digest.length;
                ++ctr;
            }
            System.arraycopy(digest, 0, result, pos, size - pos);
            return result;
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Error MACing", e);
        }
    }

    public static byte[] encodeCbor(List<DataItem> dataItems) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CborEncoder encoder = new CborEncoder((OutputStream)baos);
        try {
            encoder.encode(dataItems);
        }
        catch (CborException e) {
            throw new RuntimeException("Error encoding data", e);
        }
        return baos.toByteArray();
    }

    public static byte[] coseBuildToBeSigned(byte[] encodedProtectedHeaders, byte[] payload, byte[] detachedContent) {
        CborBuilder sigStructure = new CborBuilder();
        ArrayBuilder array = sigStructure.addArray();
        array.add("Signature1");
        array.add(encodedProtectedHeaders);
        byte[] emptyExternalAad = new byte[]{};
        array.add(emptyExternalAad);
        if (payload != null && payload.length > 0) {
            array.add(payload);
        } else {
            array.add(detachedContent);
        }
        array.end();
        return Util.encodeCbor(sigStructure.build());
    }

    private static byte[] signatureDerToCose(byte[] signature) {
        if (signature.length > 128) {
            throw new RuntimeException("Unexpected length " + signature.length + ", expected less than 128");
        }
        if (signature[0] != 48) {
            throw new RuntimeException("Unexpected first byte " + signature[0] + ", expected 0x30");
        }
        if ((signature[1] & 0x80) != 0) {
            throw new RuntimeException("Unexpected second byte " + signature[1] + ", bit 7 shouldn't be set");
        }
        int rOffset = 2;
        byte rSize = signature[rOffset + 1];
        byte[] rBytes = Util.stripLeadingZeroes(Arrays.copyOfRange(signature, rOffset + 2, rOffset + rSize + 2));
        int sOffset = rOffset + 2 + rSize;
        byte sSize = signature[sOffset + 1];
        byte[] sBytes = Util.stripLeadingZeroes(Arrays.copyOfRange(signature, sOffset + 2, sOffset + sSize + 2));
        if (rBytes.length > 32) {
            throw new RuntimeException("rBytes.length is " + rBytes.length + " which is > 32");
        }
        if (sBytes.length > 32) {
            throw new RuntimeException("sBytes.length is " + sBytes.length + " which is > 32");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int n;
            for (n = 0; n < 32 - rBytes.length; ++n) {
                baos.write(0);
            }
            baos.write(rBytes);
            for (n = 0; n < 32 - sBytes.length; ++n) {
                baos.write(0);
            }
            baos.write(sBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return baos.toByteArray();
    }

    private static byte[] encodePositiveBigInteger(BigInteger i) {
        byte[] bytes = i.toByteArray();
        if ((bytes[0] & 0x80) != 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                baos.write(0);
                baos.write(bytes);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Failed writing data", e);
            }
            bytes = baos.toByteArray();
        }
        return bytes;
    }

    private static byte[] signatureCoseToDer(byte[] signature) {
        if (signature.length != 64) {
            throw new RuntimeException("signature.length is " + signature.length + ", expected 64");
        }
        BigInteger r = new BigInteger(Arrays.copyOfRange(signature, 0, 32));
        BigInteger s = new BigInteger(Arrays.copyOfRange(signature, 32, 64));
        byte[] rBytes = Util.encodePositiveBigInteger(r);
        byte[] sBytes = Util.encodePositiveBigInteger(s);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(48);
            baos.write(2 + rBytes.length + 2 + sBytes.length);
            baos.write(2);
            baos.write(rBytes.length);
            baos.write(rBytes);
            baos.write(2);
            baos.write(sBytes.length);
            baos.write(sBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return baos.toByteArray();
    }

    public static byte[] coseSign1Sign(Signature s, @Nullable byte[] data, byte[] detachedContent, @Nullable Collection<X509Certificate> certificateChain) throws CertificateEncodingException {
        int detachedContentLen;
        int dataLen = data != null ? data.length : 0;
        int n = detachedContentLen = detachedContent != null ? detachedContent.length : 0;
        if (dataLen > 0 && detachedContentLen > 0) {
            throw new RuntimeException("data and detachedContent cannot both be non-empty");
        }
        CborBuilder protectedHeaders = new CborBuilder();
        MapBuilder protectedHeadersMap = protectedHeaders.addMap();
        protectedHeadersMap.put(1L, -7L);
        byte[] protectedHeadersBytes = Util.encodeCbor(protectedHeaders.build());
        byte[] toBeSigned = Util.coseBuildToBeSigned(protectedHeadersBytes, data, detachedContent);
        byte[] coseSignature = null;
        try {
            s.update(toBeSigned);
            byte[] derSignature = s.sign();
            coseSignature = Util.signatureDerToCose(derSignature);
        }
        catch (SignatureException e) {
            throw new RuntimeException("Error signing data");
        }
        CborBuilder builder = new CborBuilder();
        ArrayBuilder array = builder.addArray();
        array.add(protectedHeadersBytes);
        MapBuilder unprotectedHeaders = array.addMap();
        if (certificateChain != null && certificateChain.size() > 0) {
            if (certificateChain.size() == 1) {
                X509Certificate cert = certificateChain.iterator().next();
                unprotectedHeaders.put(33L, cert.getEncoded());
            } else {
                ArrayBuilder x5chainsArray = unprotectedHeaders.putArray(33L);
                for (X509Certificate cert : certificateChain) {
                    x5chainsArray.add(cert.getEncoded());
                }
            }
        }
        if (data == null || data.length == 0) {
            array.add((DataItem)new SimpleValue(SimpleValueType.NULL));
        } else {
            array.add(data);
        }
        array.add(coseSignature);
        return Util.encodeCbor(builder.build());
    }

    public static byte[] coseSign1Sign(PrivateKey key, @Nullable byte[] data, byte[] additionalData, @Nullable Collection<X509Certificate> certificateChain) throws NoSuchAlgorithmException, InvalidKeyException, CertificateEncodingException {
        Signature s = Signature.getInstance("SHA256withECDSA");
        s.initSign(key);
        return Util.coseSign1Sign(s, data, additionalData, certificateChain);
    }

    public static boolean coseSign1CheckSignature(byte[] signatureCose1, byte[] detachedContent, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException {
        int detachedContentLen;
        ByteArrayInputStream bais = new ByteArrayInputStream(signatureCose1);
        List dataItems = null;
        try {
            dataItems = new CborDecoder((InputStream)bais).decode();
        }
        catch (CborException e) {
            throw new RuntimeException("Given signature is not valid CBOR", e);
        }
        if (dataItems.size() != 1) {
            throw new RuntimeException("Expected just one data item");
        }
        DataItem dataItem = (DataItem)dataItems.get(0);
        if (dataItem.getMajorType() != MajorType.ARRAY) {
            throw new RuntimeException("Data item is not an array");
        }
        List items = ((Array)dataItem).getDataItems();
        if (items.size() < 4) {
            throw new RuntimeException("Expected at least four items in COSE_Sign1 array");
        }
        if (((DataItem)items.get(0)).getMajorType() != MajorType.BYTE_STRING) {
            throw new RuntimeException("Item 0 (protected headers) is not a byte-string");
        }
        byte[] encodedProtectedHeaders = ((ByteString)items.get(0)).getBytes();
        byte[] payload = new byte[]{};
        if (((DataItem)items.get(2)).getMajorType() == MajorType.SPECIAL) {
            if (((Special)items.get(2)).getSpecialType() != SpecialType.SIMPLE_VALUE) {
                throw new RuntimeException("Item 2 (payload) is a special but not a simple value");
            }
            SimpleValue simple = (SimpleValue)items.get(2);
            if (simple.getSimpleValueType() != SimpleValueType.NULL) {
                throw new RuntimeException("Item 2 (payload) is a simple but not the value null");
            }
        } else if (((DataItem)items.get(2)).getMajorType() == MajorType.BYTE_STRING) {
            payload = ((ByteString)items.get(2)).getBytes();
        } else {
            throw new RuntimeException("Item 2 (payload) is not nil or byte-string");
        }
        if (((DataItem)items.get(3)).getMajorType() != MajorType.BYTE_STRING) {
            throw new RuntimeException("Item 3 (signature) is not a byte-string");
        }
        byte[] coseSignature = ((ByteString)items.get(3)).getBytes();
        byte[] derSignature = Util.signatureCoseToDer(coseSignature);
        int dataLen = payload.length;
        int n = detachedContentLen = detachedContent != null ? detachedContent.length : 0;
        if (dataLen > 0 && detachedContentLen > 0) {
            throw new RuntimeException("data and detachedContent cannot both be non-empty");
        }
        byte[] toBeSigned = Util.coseBuildToBeSigned(encodedProtectedHeaders, payload, detachedContent);
        try {
            Signature verifier = Signature.getInstance("SHA256withECDSA");
            verifier.initVerify(publicKey);
            verifier.update(toBeSigned);
            return verifier.verify(derSignature);
        }
        catch (SignatureException e) {
            throw new RuntimeException("Error verifying signature");
        }
    }

    static boolean hasSubByteArray(byte[] haystack, byte[] needle) {
        int n = 0;
        while (needle.length + n <= haystack.length) {
            boolean found = true;
            for (int m = 0; m < needle.length; ++m) {
                if (needle[m] == haystack[n + m]) continue;
                found = false;
                break;
            }
            if (found) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static byte[] stripLeadingZeroes(byte[] value) {
        int n;
        for (n = 0; n < value.length && value[n] == 0; ++n) {
        }
        int newLen = value.length - n;
        byte[] ret = new byte[newLen];
        int m = 0;
        while (n < value.length) {
            ret[m++] = value[n++];
        }
        return ret;
    }

    static byte[] concatArrays(byte[] a, byte[] b) {
        byte[] ret = new byte[a.length + b.length];
        System.arraycopy(a, 0, ret, 0, a.length);
        System.arraycopy(b, 0, ret, a.length, b.length);
        return ret;
    }

    static byte[] prependSemanticTagForEncodedCbor(byte[] encodedCbor) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ByteString taggedBytestring = new ByteString(encodedCbor);
            taggedBytestring.setTag(24);
            new CborEncoder((OutputStream)baos).encode((DataItem)taggedBytestring);
        }
        catch (CborException e) {
            throw new RuntimeException("Error encoding with semantic tag for CBOR encoding", e);
        }
        return baos.toByteArray();
    }

    static byte[] buildDeviceAuthenticationCbor(String docType, byte[] encodedSessionTranscript, byte[] encodedDeviceNameSpaces) {
        ByteArrayOutputStream daBaos = new ByteArrayOutputStream();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(encodedSessionTranscript);
            DataItem sessionTranscript = (DataItem)new CborDecoder((InputStream)bais).decode().get(0);
            ByteString deviceNameSpacesBytesItem = new ByteString(encodedDeviceNameSpaces);
            deviceNameSpacesBytesItem.setTag(24);
            new CborEncoder((OutputStream)daBaos).encode(((CborBuilder)new CborBuilder().addArray().add("DeviceAuthentication").add(sessionTranscript).add(docType).add((DataItem)deviceNameSpacesBytesItem).end()).build());
        }
        catch (CborException e) {
            throw new RuntimeException("Error encoding DeviceAuthentication", e);
        }
        return daBaos.toByteArray();
    }

    static byte[] buildReaderAuthenticationCbor(byte[] sessionTranscriptBytes, byte[] requestMessageBytes) {
        ByteArrayOutputStream daBaos = new ByteArrayOutputStream();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(sessionTranscriptBytes);
            DataItem sessionTranscript = (DataItem)new CborDecoder((InputStream)bais).decode().get(0);
            ByteString requestMessageBytesItem = new ByteString(requestMessageBytes);
            requestMessageBytesItem.setTag(24);
            new CborEncoder((OutputStream)daBaos).encode(((CborBuilder)new CborBuilder().addArray().add("ReaderAuthentication").add(sessionTranscript).add((DataItem)requestMessageBytesItem).end()).build());
        }
        catch (CborException e) {
            throw new RuntimeException("Error encoding ReaderAuthentication", e);
        }
        return daBaos.toByteArray();
    }

    public static byte[] coseSign1GetData(byte[] signatureCose1) {
        ByteArrayInputStream bais = new ByteArrayInputStream(signatureCose1);
        List dataItems = null;
        try {
            dataItems = new CborDecoder((InputStream)bais).decode();
        }
        catch (CborException e) {
            throw new RuntimeException("Given signature is not valid CBOR", e);
        }
        if (dataItems.size() != 1) {
            throw new RuntimeException("Expected just one data item");
        }
        DataItem dataItem = (DataItem)dataItems.get(0);
        if (dataItem.getMajorType() != MajorType.ARRAY) {
            throw new RuntimeException("Data item is not an array");
        }
        List items = ((Array)dataItem).getDataItems();
        if (items.size() < 4) {
            throw new RuntimeException("Expected at least four items in COSE_Sign1 array");
        }
        byte[] payload = new byte[]{};
        if (((DataItem)items.get(2)).getMajorType() == MajorType.SPECIAL) {
            if (((Special)items.get(2)).getSpecialType() != SpecialType.SIMPLE_VALUE) {
                throw new RuntimeException("Item 2 (payload) is a special but not a simple value");
            }
            SimpleValue simple = (SimpleValue)items.get(2);
            if (simple.getSimpleValueType() != SimpleValueType.NULL) {
                throw new RuntimeException("Item 2 (payload) is a simple but not the value null");
            }
        } else if (((DataItem)items.get(2)).getMajorType() == MajorType.BYTE_STRING) {
            payload = ((ByteString)items.get(2)).getBytes();
        } else {
            throw new RuntimeException("Item 2 (payload) is not nil or byte-string");
        }
        return payload;
    }

    public static Collection<X509Certificate> coseSign1GetX5Chain(byte[] signatureCose1) throws CertificateException {
        ArrayList<X509Certificate> ret = new ArrayList<X509Certificate>();
        ByteArrayInputStream bais = new ByteArrayInputStream(signatureCose1);
        List dataItems = null;
        try {
            dataItems = new CborDecoder((InputStream)bais).decode();
        }
        catch (CborException e) {
            throw new RuntimeException("Given signature is not valid CBOR", e);
        }
        if (dataItems.size() != 1) {
            throw new RuntimeException("Expected just one data item");
        }
        DataItem dataItem = (DataItem)dataItems.get(0);
        if (dataItem.getMajorType() != MajorType.ARRAY) {
            throw new RuntimeException("Data item is not an array");
        }
        List items = ((Array)dataItem).getDataItems();
        if (items.size() < 4) {
            throw new RuntimeException("Expected at least four items in COSE_Sign1 array");
        }
        if (((DataItem)items.get(1)).getMajorType() != MajorType.MAP) {
            throw new RuntimeException("Item 1 (unprotected headers) is not a map");
        }
        Map map = (Map)items.get(1);
        DataItem x5chainItem = map.get((DataItem)new UnsignedInteger(33L));
        if (x5chainItem != null) {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            if (x5chainItem instanceof ByteString) {
                ByteArrayInputStream certBais = new ByteArrayInputStream(((ByteString)x5chainItem).getBytes());
                ret.add((X509Certificate)factory.generateCertificate(certBais));
            } else if (x5chainItem instanceof Array) {
                for (DataItem certItem : ((Array)x5chainItem).getDataItems()) {
                    if (!(certItem instanceof ByteString)) {
                        throw new RuntimeException("Unexpected type for array item in x5chain value");
                    }
                    ByteArrayInputStream certBais = new ByteArrayInputStream(((ByteString)certItem).getBytes());
                    ret.add((X509Certificate)factory.generateCertificate(certBais));
                }
            } else {
                throw new RuntimeException("Unexpected type for x5chain value");
            }
        }
        return ret;
    }
}

