/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.NonNull;
import androidx.security.identity.AccessControlProfile;
import androidx.security.identity.AlreadyPersonalizedException;
import androidx.security.identity.CredentialData;
import androidx.security.identity.PersonalizationData;
import androidx.security.identity.Util;
import androidx.security.identity.WritableIdentityCredential;
import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.builder.ArrayBuilder;
import co.nstant.in.cbor.builder.MapBuilder;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnicodeString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;

class SoftwareWritableIdentityCredential
extends WritableIdentityCredential {
    private static final String TAG = "SoftwareWritableIdentityCredential";
    private KeyPair mKeyPair = null;
    private Collection<X509Certificate> mCertificates = null;
    private String mDocType;
    private String mCredentialName;
    private Context mContext;

    SoftwareWritableIdentityCredential(Context context, @NonNull String credentialName, @NonNull String docType) throws AlreadyPersonalizedException {
        this.mContext = context;
        this.mDocType = docType;
        this.mCredentialName = credentialName;
        if (CredentialData.credentialAlreadyExists(context, credentialName)) {
            throw new AlreadyPersonalizedException("Credential with given name already exists");
        }
    }

    private Collection<X509Certificate> ensureCredentialKey(byte[] challenge) {
        if (this.mKeyPair != null) {
            return null;
        }
        String aliasForCredential = CredentialData.getAliasFromCredentialName(this.mCredentialName);
        try {
            KeyStore ks = KeyStore.getInstance("AndroidKeyStore");
            ks.load(null);
            if (ks.containsAlias(aliasForCredential)) {
                ks.deleteEntry(aliasForCredential);
            }
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", "AndroidKeyStore");
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(aliasForCredential, 12).setDigests(new String[]{"SHA-256", "SHA-512"});
            if (Build.VERSION.SDK_INT >= 24) {
                if (challenge == null) {
                    challenge = new byte[]{};
                }
                builder.setAttestationChallenge(challenge);
            }
            kpg.initialize((AlgorithmParameterSpec)builder.build());
            this.mKeyPair = kpg.generateKeyPair();
            Certificate[] certificates = ks.getCertificateChain(aliasForCredential);
            this.mCertificates = new ArrayList<X509Certificate>();
            for (Certificate certificate : certificates) {
                this.mCertificates.add((X509Certificate)certificate);
            }
        }
        catch (IOException | InvalidAlgorithmParameterException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new RuntimeException("Error creating CredentialKey", e);
        }
        return this.mCertificates;
    }

    @Override
    @NonNull
    public Collection<X509Certificate> getCredentialKeyCertificateChain(@NonNull byte[] challenge) {
        Collection<X509Certificate> certificates = this.ensureCredentialKey(challenge);
        if (certificates == null) {
            throw new RuntimeException("getCredentialKeyCertificateChain() must be called before personalize()");
        }
        return certificates;
    }

    static byte[] buildProofOfProvisioningWithSignature(String docType, PersonalizationData personalizationData, PrivateKey key) {
        byte[] signatureBytes;
        CborBuilder accessControlProfileBuilder = new CborBuilder();
        ArrayBuilder arrayBuilder = accessControlProfileBuilder.addArray();
        for (AccessControlProfile profile : personalizationData.getAccessControlProfiles()) {
            arrayBuilder.add(Util.accessControlProfileToCbor(profile));
        }
        CborBuilder dataBuilder = new CborBuilder();
        MapBuilder dataMapBuilder = dataBuilder.addMap();
        for (PersonalizationData.NamespaceData namespaceData : personalizationData.getNamespaceDatas()) {
            dataMapBuilder.put((DataItem)new UnicodeString(namespaceData.getNamespaceName()), Util.namespaceDataToCbor(namespaceData));
        }
        CborBuilder signedDataBuilder = new CborBuilder();
        signedDataBuilder.addArray().add("ProofOfProvisioning").add(docType).add((DataItem)accessControlProfileBuilder.build().get(0)).add((DataItem)dataBuilder.build().get(0)).add(false);
        try {
            ByteArrayOutputStream dtsBaos = new ByteArrayOutputStream();
            CborEncoder dtsEncoder = new CborEncoder((OutputStream)dtsBaos);
            dtsEncoder.encode((DataItem)signedDataBuilder.build().get(0));
            byte[] dataToSign = dtsBaos.toByteArray();
            signatureBytes = Util.coseSign1Sign(key, dataToSign, null, null);
        }
        catch (CborException | InvalidKeyException | NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new RuntimeException("Error building ProofOfProvisioning", e);
        }
        return signatureBytes;
    }

    @Override
    @NonNull
    public byte[] personalize(@NonNull PersonalizationData personalizationData) {
        try {
            this.ensureCredentialKey(null);
            byte[] encodedBytes = SoftwareWritableIdentityCredential.buildProofOfProvisioningWithSignature(this.mDocType, personalizationData, this.mKeyPair.getPrivate());
            byte[] proofOfProvisioning = Util.coseSign1GetData(encodedBytes);
            byte[] proofOfProvisioningSha256 = MessageDigest.getInstance("SHA-256").digest(proofOfProvisioning);
            CredentialData.createCredentialData(this.mContext, this.mDocType, this.mCredentialName, CredentialData.getAliasFromCredentialName(this.mCredentialName), this.mCertificates, personalizationData, proofOfProvisioningSha256, false);
            return encodedBytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error digesting ProofOfProvisioning", e);
        }
    }
}

