/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.security.identity.AlreadyPersonalizedException;
import androidx.security.identity.CipherSuiteNotSupportedException;
import androidx.security.identity.DocTypeNotSupportedException;
import androidx.security.identity.IdentityCredential;
import androidx.security.identity.IdentityCredentialStore;
import androidx.security.identity.IdentityCredentialStoreCapabilities;
import androidx.security.identity.SimpleIdentityCredentialStoreCapabilities;
import androidx.security.identity.SoftwareIdentityCredential;
import androidx.security.identity.SoftwareWritableIdentityCredential;
import androidx.security.identity.WritableIdentityCredential;
import java.util.LinkedHashSet;
import java.util.Set;

class SoftwareIdentityCredentialStore
extends IdentityCredentialStore {
    private static final String TAG = "SoftwareIdentityCredentialStore";
    private Context mContext = null;
    SimpleIdentityCredentialStoreCapabilities mCapabilities = null;

    private SoftwareIdentityCredentialStore(@NonNull Context context) {
        this.mContext = context;
    }

    @NonNull
    public static IdentityCredentialStore getInstance(@NonNull Context context) {
        return new SoftwareIdentityCredentialStore(context);
    }

    @NonNull
    public static IdentityCredentialStore getDirectAccessInstance(@NonNull Context context) {
        throw new RuntimeException("Direct-access IdentityCredential is not supported");
    }

    public static boolean isDirectAccessSupported(@NonNull Context context) {
        return false;
    }

    @Override
    @NonNull
    public String[] getSupportedDocTypes() {
        Set<String> docTypeSet = this.getCapabilities().getSupportedDocTypes();
        String[] docTypes = new String[docTypeSet.size()];
        int n = 0;
        for (String docType : docTypeSet) {
            docTypes[n++] = docType;
        }
        return docTypes;
    }

    @Override
    @NonNull
    public IdentityCredentialStoreCapabilities getCapabilities() {
        if (this.mCapabilities == null) {
            this.mCapabilities = new SimpleIdentityCredentialStoreCapabilities(false, 202101, false, new LinkedHashSet<String>(), true, true, true, true);
        }
        return this.mCapabilities;
    }

    @Override
    @NonNull
    public WritableIdentityCredential createCredential(@NonNull String credentialName, @NonNull String docType) throws AlreadyPersonalizedException, DocTypeNotSupportedException {
        return new SoftwareWritableIdentityCredential(this.mContext, credentialName, docType);
    }

    @Override
    @Nullable
    public IdentityCredential getCredentialByName(@NonNull String credentialName, int cipherSuite) throws CipherSuiteNotSupportedException {
        SoftwareIdentityCredential credential = new SoftwareIdentityCredential(this.mContext, credentialName, cipherSuite);
        if (credential.loadData()) {
            return credential;
        }
        return null;
    }

    @Override
    @Nullable
    public byte[] deleteCredentialByName(@NonNull String credentialName) {
        return SoftwareIdentityCredential.delete(this.mContext, credentialName);
    }
}

