/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.annotation.SuppressLint;
import android.content.Context;
import android.icu.util.Calendar;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.biometric.BiometricPrompt;
import androidx.security.identity.AccessControlProfile;
import androidx.security.identity.AccessControlProfileId;
import androidx.security.identity.CipherSuiteNotSupportedException;
import androidx.security.identity.CredentialData;
import androidx.security.identity.EphemeralPublicKeyNotFoundException;
import androidx.security.identity.IdentityCredential;
import androidx.security.identity.InvalidReaderSignatureException;
import androidx.security.identity.InvalidRequestMessageException;
import androidx.security.identity.MessageDecryptionException;
import androidx.security.identity.NoAuthenticationKeyAvailableException;
import androidx.security.identity.PersonalizationData;
import androidx.security.identity.ResultData;
import androidx.security.identity.SimpleResultData;
import androidx.security.identity.SoftwareWritableIdentityCredential;
import androidx.security.identity.UnknownAuthenticationKeyException;
import androidx.security.identity.Util;
import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.builder.MapBuilder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class SoftwareIdentityCredential
extends IdentityCredential {
    private static final String TAG = "SWIdentityCredential";
    private String mCredentialName;
    private Context mContext;
    private CredentialData mData;
    private KeyPair mEphemeralKeyPair = null;
    private SecretKey mSKDevice = null;
    private SecretKey mSKReader = null;
    private int mSKDeviceCounter;
    private int mSKReaderCounter;
    private byte[] mAuthKeyAssociatedData = null;
    private PrivateKey mAuthKey = null;
    private BiometricPrompt.CryptoObject mCryptoObject = null;
    private PublicKey mReaderEphemeralPublicKey = null;
    private byte[] mSessionTranscript = null;
    boolean mAllowUsingExhaustedKeys = true;
    boolean mAllowUsingExpiredKeys = false;
    private boolean mDidUserAuthResult = false;
    private boolean mDidUserAuthAlreadyCalled = false;

    SoftwareIdentityCredential(Context context, String credentialName, int cipherSuite) throws CipherSuiteNotSupportedException {
        if (cipherSuite != 1) {
            throw new CipherSuiteNotSupportedException("Unsupported Cipher Suite");
        }
        this.mContext = context;
        this.mCredentialName = credentialName;
    }

    boolean loadData() {
        this.mData = CredentialData.loadCredentialData(this.mContext, this.mCredentialName);
        return this.mData != null;
    }

    static byte[] delete(Context context, String credentialName) {
        return CredentialData.delete(context, credentialName, null);
    }

    @Override
    @NonNull
    public byte[] delete(@NonNull byte[] challenge) {
        return CredentialData.delete(this.mContext, this.mCredentialName, challenge);
    }

    @Override
    @NonNull
    public byte[] proveOwnership(@NonNull byte[] challenge) {
        return this.mData.proveOwnership(challenge);
    }

    private static HashMap<String, Collection<String>> parseRequestMessage(@Nullable byte[] requestMessage) {
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>();
        if (requestMessage == null) {
            return result;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(requestMessage);
            List dataItems = new CborDecoder((InputStream)bais).decode();
            if (dataItems.size() != 1) {
                throw new RuntimeException("Expected 1 item, found " + dataItems.size());
            }
            if (!(dataItems.get(0) instanceof Map)) {
                throw new RuntimeException("Item is not a map");
            }
            Map map = (Map)dataItems.get(0);
            DataItem nameSpaces = map.get((DataItem)new UnicodeString("nameSpaces"));
            if (!(nameSpaces instanceof Map)) {
                throw new RuntimeException("nameSpaces entry not found or not map");
            }
            for (DataItem keyItem : ((Map)nameSpaces).getKeys()) {
                if (!(keyItem instanceof UnicodeString)) {
                    throw new RuntimeException("Key item in NameSpaces map not UnicodeString");
                }
                String nameSpace = ((UnicodeString)keyItem).getString();
                ArrayList<String> names = new ArrayList<String>();
                DataItem valueItem = ((Map)nameSpaces).get(keyItem);
                if (!(valueItem instanceof Map)) {
                    throw new RuntimeException("Value item in NameSpaces map not Map");
                }
                for (DataItem item : ((Map)valueItem).getKeys()) {
                    if (!(item instanceof UnicodeString)) {
                        throw new RuntimeException("Item in nameSpaces array not UnicodeString");
                    }
                    names.add(((UnicodeString)item).getString());
                }
                result.put(nameSpace, names);
            }
        }
        catch (CborException e) {
            throw new RuntimeException("Error decoding request message", e);
        }
        return result;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    @NonNull
    public KeyPair createEphemeralKeyPair() {
        if (this.mEphemeralKeyPair == null) {
            try {
                KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
                ECGenParameterSpec ecSpec = new ECGenParameterSpec("prime256v1");
                kpg.initialize(ecSpec);
                this.mEphemeralKeyPair = kpg.generateKeyPair();
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
                throw new RuntimeException("Error generating ephemeral key", e);
            }
        }
        return this.mEphemeralKeyPair;
    }

    @Override
    public void setReaderEphemeralPublicKey(@NonNull PublicKey readerEphemeralPublicKey) {
        this.mReaderEphemeralPublicKey = readerEphemeralPublicKey;
    }

    @Override
    public void setSessionTranscript(@NonNull byte[] sessionTranscript) {
        if (this.mSessionTranscript != null) {
            throw new RuntimeException("SessionTranscript already set");
        }
        this.mSessionTranscript = (byte[])sessionTranscript.clone();
    }

    private void ensureSessionEncryptionKey() {
        if (this.mSKDevice != null) {
            return;
        }
        if (this.mReaderEphemeralPublicKey == null) {
            throw new RuntimeException("Reader ephemeral key not set");
        }
        if (this.mSessionTranscript == null) {
            throw new RuntimeException("Session transcript not set");
        }
        try {
            KeyAgreement ka = KeyAgreement.getInstance("ECDH");
            ka.init(this.mEphemeralKeyPair.getPrivate());
            ka.doPhase(this.mReaderEphemeralPublicKey, true);
            byte[] sharedSecret = ka.generateSecret();
            byte[] sessionTranscriptBytes = Util.prependSemanticTagForEncodedCbor(this.mSessionTranscript);
            byte[] salt = MessageDigest.getInstance("SHA-256").digest(sessionTranscriptBytes);
            byte[] info = new byte[]{83, 75, 68, 101, 118, 105, 99, 101};
            byte[] derivedKey = Util.computeHkdf("HmacSha256", sharedSecret, salt, info, 32);
            this.mSKDevice = new SecretKeySpec(derivedKey, "AES");
            info = new byte[]{83, 75, 82, 101, 97, 100, 101, 114};
            derivedKey = Util.computeHkdf("HmacSha256", sharedSecret, salt, info, 32);
            this.mSKReader = new SecretKeySpec(derivedKey, "AES");
            this.mSKDeviceCounter = 1;
            this.mSKReaderCounter = 1;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Error performing key agreement", e);
        }
    }

    @Override
    @NonNull
    public byte[] encryptMessageToReader(@NonNull byte[] messagePlaintext) {
        this.ensureSessionEncryptionKey();
        byte[] messageCiphertextAndAuthTag = null;
        try {
            ByteBuffer iv = ByteBuffer.allocate(12);
            iv.putInt(0, 0);
            iv.putInt(4, 1);
            iv.putInt(8, this.mSKDeviceCounter);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            GCMParameterSpec encryptionParameterSpec = new GCMParameterSpec(128, iv.array());
            cipher.init(1, (Key)this.mSKDevice, encryptionParameterSpec);
            messageCiphertextAndAuthTag = cipher.doFinal(messagePlaintext);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("Error encrypting message", e);
        }
        ++this.mSKDeviceCounter;
        return messageCiphertextAndAuthTag;
    }

    @Override
    @NonNull
    public byte[] decryptMessageFromReader(@NonNull byte[] messageCiphertext) throws MessageDecryptionException {
        this.ensureSessionEncryptionKey();
        ByteBuffer iv = ByteBuffer.allocate(12);
        iv.putInt(0, 0);
        iv.putInt(4, 0);
        iv.putInt(8, this.mSKReaderCounter);
        byte[] plainText = null;
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)this.mSKReader, new GCMParameterSpec(128, iv.array()));
            plainText = cipher.doFinal(messageCiphertext);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new MessageDecryptionException("Error decrypting message", e);
        }
        ++this.mSKReaderCounter;
        return plainText;
    }

    @Override
    @NonNull
    public Collection<X509Certificate> getCredentialKeyCertificateChain() {
        return this.mData.getCredentialKeyCertificateChain();
    }

    private void ensureCryptoObject() {
        String aliasForCryptoObject = this.mData.getPerReaderSessionKeyAlias();
        if (aliasForCryptoObject.isEmpty()) {
            return;
        }
        try {
            KeyStore ks = KeyStore.getInstance("AndroidKeyStore");
            ks.load(null);
            KeyStore.Entry entry = ks.getEntry(aliasForCryptoObject, null);
            SecretKey perReaderSessionKey = ((KeyStore.SecretKeyEntry)entry).getSecretKey();
            Cipher perReaderSessionCipher = Cipher.getInstance("AES/GCM/NoPadding");
            perReaderSessionCipher.init(1, perReaderSessionKey);
            this.mCryptoObject = new BiometricPrompt.CryptoObject(perReaderSessionCipher);
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException | NoSuchPaddingException e) {
            throw new RuntimeException("Error creating Cipher for perReaderSessionKey", e);
        }
    }

    private void ensureAuthKey() throws NoAuthenticationKeyAvailableException {
        if (this.mAuthKey != null) {
            return;
        }
        Pair<PrivateKey, byte[]> keyAndStaticData = this.mData.selectAuthenticationKey(this.mAllowUsingExhaustedKeys, this.mAllowUsingExpiredKeys);
        if (keyAndStaticData == null) {
            throw new NoAuthenticationKeyAvailableException("No authentication key available for signing");
        }
        this.mAuthKey = (PrivateKey)keyAndStaticData.first;
        this.mAuthKeyAssociatedData = (byte[])keyAndStaticData.second;
    }

    @Override
    public void setAllowUsingExhaustedKeys(boolean allowUsingExhaustedKeys) {
        this.mAllowUsingExhaustedKeys = allowUsingExhaustedKeys;
    }

    @Override
    public void setAllowUsingExpiredKeys(boolean allowUsingExpiredKeys) {
        this.mAllowUsingExpiredKeys = allowUsingExpiredKeys;
    }

    @Override
    @Nullable
    public BiometricPrompt.CryptoObject getCryptoObject() {
        this.ensureCryptoObject();
        return this.mCryptoObject;
    }

    private boolean hasEphemeralKeyInDeviceEngagement(@NonNull byte[] sessionTranscript) {
        if (this.mEphemeralKeyPair == null) {
            return false;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(sessionTranscript);
        List dataItems = null;
        try {
            dataItems = new CborDecoder((InputStream)bais).decode();
        }
        catch (CborException e) {
            Log.e((String)TAG, (String)"Error parsing SessionTranscript CBOR");
            return false;
        }
        if (dataItems.size() != 1 || !(dataItems.get(0) instanceof Array) || ((Array)dataItems.get(0)).getDataItems().size() != 2) {
            Log.e((String)TAG, (String)"SessionTranscript is not an array of length 2");
            return false;
        }
        if (!(((Array)dataItems.get(0)).getDataItems().get(0) instanceof ByteString)) {
            Log.e((String)TAG, (String)"First element of SessionTranscript array is not a bstr");
            return false;
        }
        byte[] deviceEngagementBytes = ((ByteString)((Array)dataItems.get(0)).getDataItems().get(0)).getBytes();
        ECPoint w = ((ECPublicKey)this.mEphemeralKeyPair.getPublic()).getW();
        byte[] x = Util.stripLeadingZeroes(w.getAffineX().toByteArray());
        byte[] y = Util.stripLeadingZeroes(w.getAffineY().toByteArray());
        return Util.hasSubByteArray(deviceEngagementBytes, x) || Util.hasSubByteArray(deviceEngagementBytes, y);
    }

    private boolean didUserAuth() {
        if (!this.mDidUserAuthAlreadyCalled) {
            this.mDidUserAuthResult = this.didUserAuthNoCache();
            this.mDidUserAuthAlreadyCalled = true;
        }
        return this.mDidUserAuthResult;
    }

    private boolean didUserAuthNoCache() {
        if (this.mCryptoObject == null) {
            return false;
        }
        try {
            Cipher cipher = this.mCryptoObject.getCipher();
            byte[] clearText = new byte[16];
            cipher.doFinal(clearText);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            return false;
        }
        return true;
    }

    @Override
    @NonNull
    public ResultData getEntries(@Nullable byte[] requestMessage, @NonNull java.util.Map<String, Collection<String>> entriesToRequest, @Nullable byte[] readerSignature) throws NoAuthenticationKeyAvailableException, InvalidReaderSignatureException, InvalidRequestMessageException, EphemeralPublicKeyNotFoundException {
        if (this.mSessionTranscript != null && !this.hasEphemeralKeyInDeviceEngagement(this.mSessionTranscript)) {
            throw new EphemeralPublicKeyNotFoundException("Did not find ephemeral public key X and Y coordinates in SessionTranscript (make sure leading zeroes are not used)");
        }
        HashMap<String, Collection<String>> requestMessageMap = SoftwareIdentityCredential.parseRequestMessage(requestMessage);
        Collection<X509Certificate> readerCertChain = null;
        if (readerSignature != null) {
            if (this.mSessionTranscript == null) {
                throw new InvalidReaderSignatureException("readerSignature non-null but sessionTranscript was null");
            }
            if (requestMessage == null) {
                throw new InvalidReaderSignatureException("readerSignature non-null but requestMessage was null");
            }
            try {
                readerCertChain = Util.coseSign1GetX5Chain(readerSignature);
            }
            catch (CertificateException e) {
                throw new InvalidReaderSignatureException("Error getting x5chain element", e);
            }
            if (readerCertChain.size() < 1) {
                throw new InvalidReaderSignatureException("No x5chain element in reader signature");
            }
            if (!Util.validateCertificateChain(readerCertChain)) {
                throw new InvalidReaderSignatureException("Error validating certificate chain");
            }
            PublicKey readerTopmostPublicKey = readerCertChain.iterator().next().getPublicKey();
            byte[] readerAuthentication = Util.buildReaderAuthenticationCbor(this.mSessionTranscript, requestMessage);
            byte[] readerAuthenticationBytes = Util.prependSemanticTagForEncodedCbor(readerAuthentication);
            try {
                if (!Util.coseSign1CheckSignature(readerSignature, readerAuthenticationBytes, readerTopmostPublicKey)) {
                    throw new InvalidReaderSignatureException("Reader signature check failed");
                }
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new InvalidReaderSignatureException("Error checking reader signature", e);
            }
        }
        SimpleResultData.Builder resultBuilder = new SimpleResultData.Builder();
        CborBuilder deviceNameSpaceBuilder = new CborBuilder();
        MapBuilder deviceNameSpacesMapBuilder = deviceNameSpaceBuilder.addMap();
        this.retrieveValues(requestMessage, requestMessageMap, readerCertChain, entriesToRequest, resultBuilder, (MapBuilder<CborBuilder>)deviceNameSpacesMapBuilder);
        ByteArrayOutputStream adBaos = new ByteArrayOutputStream();
        CborEncoder adEncoder = new CborEncoder((OutputStream)adBaos);
        DataItem deviceNameSpace = (DataItem)deviceNameSpaceBuilder.build().get(0);
        try {
            adEncoder.encode(deviceNameSpace);
        }
        catch (CborException e) {
            throw new RuntimeException("Error encoding deviceNameSpace", e);
        }
        byte[] authenticatedData = adBaos.toByteArray();
        resultBuilder.setAuthenticatedData(authenticatedData);
        if (this.mSessionTranscript != null) {
            this.ensureAuthKey();
            resultBuilder.setStaticAuthenticationData(this.mAuthKeyAssociatedData);
            byte[] deviceAuthentication = Util.buildDeviceAuthenticationCbor(this.mData.getDocType(), this.mSessionTranscript, authenticatedData);
            byte[] deviceAuthenticationBytes = Util.prependSemanticTagForEncodedCbor(deviceAuthentication);
            try {
                Signature authKeySignature = Signature.getInstance("SHA256withECDSA");
                authKeySignature.initSign(this.mAuthKey);
                resultBuilder.setEcdsaSignature(Util.coseSign1Sign(authKeySignature, null, deviceAuthenticationBytes, null));
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | CertificateEncodingException e) {
                throw new RuntimeException("Error signing DeviceAuthentication CBOR", e);
            }
        }
        return resultBuilder.build();
    }

    private void retrieveValues(byte[] requestMessage, HashMap<String, Collection<String>> requestMessageMap, Collection<X509Certificate> readerCertChain, java.util.Map<String, Collection<String>> entriesToRequest, SimpleResultData.Builder resultBuilder, MapBuilder<CborBuilder> deviceNameSpacesMapBuilder) {
        for (String namespaceName : entriesToRequest.keySet()) {
            Collection<String> entriesToRequestInNamespace = entriesToRequest.get(namespaceName);
            PersonalizationData.NamespaceData loadedNamespace = this.mData.lookupNamespaceData(namespaceName);
            Collection<String> requestMessageNamespace = requestMessageMap.get(namespaceName);
            this.retrieveValuesForNamespace(resultBuilder, deviceNameSpacesMapBuilder, entriesToRequestInNamespace, requestMessage, requestMessageNamespace, readerCertChain, namespaceName, loadedNamespace);
        }
    }

    private void retrieveValuesForNamespace(SimpleResultData.Builder resultBuilder, MapBuilder<CborBuilder> deviceNameSpacesMapBuilder, Collection<String> entriesToRequestInNamespace, byte[] requestMessage, Collection<String> requestMessageNamespace, Collection<X509Certificate> readerCertChain, String namespaceName, PersonalizationData.NamespaceData loadedNamespace) {
        MapBuilder deviceNamespaceBuilder = null;
        for (String requestedEntryName : entriesToRequestInNamespace) {
            byte[] value = null;
            if (loadedNamespace != null) {
                value = loadedNamespace.getEntryValue(requestedEntryName);
            }
            if (value == null) {
                resultBuilder.addErrorStatus(namespaceName, requestedEntryName, 1);
                continue;
            }
            if (!(requestMessage == null || requestMessageNamespace != null && requestMessageNamespace.contains(requestedEntryName))) {
                resultBuilder.addErrorStatus(namespaceName, requestedEntryName, 3);
                continue;
            }
            Collection<AccessControlProfileId> accessControlProfileIds = loadedNamespace.getAccessControlProfileIds(requestedEntryName);
            int status = this.checkAccess(accessControlProfileIds, readerCertChain);
            if (status != 0) {
                resultBuilder.addErrorStatus(namespaceName, requestedEntryName, status);
                continue;
            }
            resultBuilder.addEntry(namespaceName, requestedEntryName, value);
            if (deviceNamespaceBuilder == null) {
                deviceNamespaceBuilder = deviceNameSpacesMapBuilder.putMap(namespaceName);
            }
            DataItem dataItem = Util.cborToDataItem(value);
            deviceNamespaceBuilder.put((DataItem)new UnicodeString(requestedEntryName), dataItem);
        }
    }

    private int checkAccessSingleProfile(AccessControlProfile profile, Collection<X509Certificate> readerCertChain) {
        if (profile.isUserAuthenticationRequired() && !this.mData.checkUserAuthentication(profile.getAccessControlProfileId(), this.didUserAuth())) {
            return 4;
        }
        X509Certificate profileCert = profile.getReaderCertificate();
        if (profileCert != null) {
            if (readerCertChain == null) {
                return 5;
            }
            boolean foundMatchingCert = false;
            byte[] profilePublicKeyEncoded = profileCert.getPublicKey().getEncoded();
            for (X509Certificate readerCert : readerCertChain) {
                byte[] readerCertPublicKeyEncoded = readerCert.getPublicKey().getEncoded();
                if (!Arrays.equals(profilePublicKeyEncoded, readerCertPublicKeyEncoded)) continue;
                foundMatchingCert = true;
                break;
            }
            if (!foundMatchingCert) {
                return 5;
            }
        }
        return 0;
    }

    private int checkAccess(Collection<AccessControlProfileId> accessControlProfileIds, Collection<X509Certificate> readerCertChain) {
        int lastStatus = 6;
        for (AccessControlProfileId id : accessControlProfileIds) {
            AccessControlProfile profile = this.mData.getAccessControlProfile(id);
            lastStatus = this.checkAccessSingleProfile(profile, readerCertChain);
            if (lastStatus != 0) continue;
            return lastStatus;
        }
        return lastStatus;
    }

    @Override
    public void setAvailableAuthenticationKeys(int keyCount, int maxUsesPerKey) {
        this.mData.setAvailableAuthenticationKeys(keyCount, maxUsesPerKey);
    }

    @Override
    @NonNull
    public Collection<X509Certificate> getAuthKeysNeedingCertification() {
        return this.mData.getAuthKeysNeedingCertification();
    }

    @Override
    public void storeStaticAuthenticationData(@NonNull X509Certificate authenticationKey, @NonNull byte[] staticAuthData) throws UnknownAuthenticationKeyException {
        this.mData.storeStaticAuthenticationData(authenticationKey, null, staticAuthData);
    }

    @Override
    public void storeStaticAuthenticationData(@NonNull X509Certificate authenticationKey, @NonNull Calendar expirationDate, @NonNull byte[] staticAuthData) throws UnknownAuthenticationKeyException {
        this.mData.storeStaticAuthenticationData(authenticationKey, expirationDate, staticAuthData);
    }

    @Override
    @NonNull
    public int[] getAuthenticationDataUsageCount() {
        return this.mData.getAuthKeyUseCounts();
    }

    @Override
    @NonNull
    public byte[] update(@NonNull PersonalizationData personalizationData) {
        try {
            String docType = this.mData.getDocType();
            Collection<X509Certificate> certificates = this.mData.getCredentialKeyCertificateChain();
            PrivateKey credentialKey = this.mData.getCredentialKeyPrivate();
            int authKeyCount = this.mData.getAuthKeyCount();
            int authMaxUsesPerKey = this.mData.getAuthMaxUsesPerKey();
            byte[] encodedBytes = SoftwareWritableIdentityCredential.buildProofOfProvisioningWithSignature(docType, personalizationData, credentialKey);
            byte[] proofOfProvisioning = Util.coseSign1GetData(encodedBytes);
            byte[] proofOfProvisioningSha256 = MessageDigest.getInstance("SHA-256").digest(proofOfProvisioning);
            this.mData.deleteKeysForReplacement();
            this.mData = CredentialData.createCredentialData(this.mContext, docType, this.mCredentialName, CredentialData.getAliasFromCredentialName(this.mCredentialName), certificates, personalizationData, proofOfProvisioningSha256, true);
            this.mData.setAvailableAuthenticationKeys(authKeyCount, authMaxUsesPerKey);
            return encodedBytes;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error digesting ProofOfProvisioning", e);
        }
    }
}

