/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.identity;

import android.annotation.SuppressLint;
import android.icu.util.Calendar;
import androidx.annotation.NonNull;
import androidx.security.identity.AccessControlProfile;
import androidx.security.identity.AccessControlProfileId;
import androidx.security.identity.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;

public class PersonalizationData {
    @NonNull
    ArrayList<AccessControlProfile> mProfiles = new ArrayList();
    @NonNull
    LinkedHashMap<String, NamespaceData> mNamespaces = new LinkedHashMap();

    PersonalizationData() {
    }

    Collection<AccessControlProfile> getAccessControlProfiles() {
        return Collections.unmodifiableCollection(this.mProfiles);
    }

    Collection<String> getNamespaces() {
        return Collections.unmodifiableCollection(this.mNamespaces.keySet());
    }

    Collection<NamespaceData> getNamespaceDatas() {
        return Collections.unmodifiableCollection(this.mNamespaces.values());
    }

    NamespaceData getNamespaceData(String namespace) {
        return this.mNamespaces.get(namespace);
    }

    public static final class Builder {
        private PersonalizationData mData = new PersonalizationData();

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder putEntry(@NonNull String namespace, @NonNull String name, @NonNull Collection<AccessControlProfileId> accessControlProfileIds, @NonNull byte[] value) {
            NamespaceData namespaceData = this.mData.mNamespaces.get(namespace);
            if (namespaceData == null) {
                namespaceData = new NamespaceData(namespace);
                this.mData.mNamespaces.put(namespace, namespaceData);
            }
            namespaceData.mEntries.put(name, new EntryData(value, accessControlProfileIds));
            return this;
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder putEntryString(@NonNull String namespace, @NonNull String name, @NonNull Collection<AccessControlProfileId> accessControlProfileIds, @NonNull String value) {
            return this.putEntry(namespace, name, accessControlProfileIds, Util.cborEncodeString(value));
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder putEntryBytestring(@NonNull String namespace, @NonNull String name, @NonNull Collection<AccessControlProfileId> accessControlProfileIds, @NonNull byte[] value) {
            return this.putEntry(namespace, name, accessControlProfileIds, Util.cborEncodeBytestring(value));
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder putEntryInteger(@NonNull String namespace, @NonNull String name, @NonNull Collection<AccessControlProfileId> accessControlProfileIds, long value) {
            return this.putEntry(namespace, name, accessControlProfileIds, Util.cborEncodeLong(value));
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder putEntryBoolean(@NonNull String namespace, @NonNull String name, @NonNull Collection<AccessControlProfileId> accessControlProfileIds, boolean value) {
            return this.putEntry(namespace, name, accessControlProfileIds, Util.cborEncodeBoolean(value));
        }

        @SuppressLint(value={"BuilderSetStyle"})
        @NonNull
        public Builder putEntryCalendar(@NonNull String namespace, @NonNull String name, @NonNull Collection<AccessControlProfileId> accessControlProfileIds, @NonNull Calendar value) {
            return this.putEntry(namespace, name, accessControlProfileIds, Util.cborEncodeCalendar(value));
        }

        @NonNull
        public Builder addAccessControlProfile(@NonNull AccessControlProfile profile) {
            this.mData.mProfiles.add(profile);
            return this;
        }

        @NonNull
        public PersonalizationData build() {
            return this.mData;
        }
    }

    static class EntryData {
        byte[] mValue;
        Collection<AccessControlProfileId> mAccessControlProfileIds;

        EntryData(byte[] value, Collection<AccessControlProfileId> accessControlProfileIds) {
            this.mValue = value;
            this.mAccessControlProfileIds = accessControlProfileIds;
        }
    }

    static class NamespaceData {
        @NonNull
        protected String mNamespace;
        @NonNull
        protected LinkedHashMap<String, EntryData> mEntries = new LinkedHashMap();

        protected NamespaceData(@NonNull String namespace) {
            this.mNamespace = namespace;
        }

        String getNamespaceName() {
            return this.mNamespace;
        }

        Collection<String> getEntryNames() {
            return Collections.unmodifiableCollection(this.mEntries.keySet());
        }

        Collection<AccessControlProfileId> getAccessControlProfileIds(String name) {
            EntryData value = this.mEntries.get(name);
            if (value != null) {
                return value.mAccessControlProfileIds;
            }
            return null;
        }

        byte[] getEntryValue(String name) {
            EntryData value = this.mEntries.get(name);
            if (value != null) {
                return value.mValue;
            }
            return null;
        }
    }
}

