/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.crypto;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArraySet;
import androidx.security.crypto.MasterKey;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AesGcmKeyManager;
import com.google.crypto.tink.config.TinkConfig;
import com.google.crypto.tink.daead.AesSivKeyManager;
import com.google.crypto.tink.integration.android.AndroidKeysetManager;
import com.google.crypto.tink.subtle.Base64;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public final class EncryptedSharedPreferences
implements SharedPreferences {
    private static final String KEY_KEYSET_ALIAS = "__androidx_security_crypto_encrypted_prefs_key_keyset__";
    private static final String VALUE_KEYSET_ALIAS = "__androidx_security_crypto_encrypted_prefs_value_keyset__";
    private static final String NULL_VALUE = "__NULL__";
    final SharedPreferences mSharedPreferences;
    final List<SharedPreferences.OnSharedPreferenceChangeListener> mListeners;
    final String mFileName;
    final String mMasterKeyAlias;
    final Aead mValueAead;
    final DeterministicAead mKeyDeterministicAead;

    EncryptedSharedPreferences(@NonNull String name, @NonNull String masterKeyAlias, @NonNull SharedPreferences sharedPreferences, @NonNull Aead aead, @NonNull DeterministicAead deterministicAead) {
        this.mFileName = name;
        this.mSharedPreferences = sharedPreferences;
        this.mMasterKeyAlias = masterKeyAlias;
        this.mValueAead = aead;
        this.mKeyDeterministicAead = deterministicAead;
        this.mListeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
    }

    @NonNull
    public static SharedPreferences create(@NonNull Context context, @NonNull String fileName, @NonNull MasterKey masterKey, @NonNull PrefKeyEncryptionScheme prefKeyEncryptionScheme, @NonNull PrefValueEncryptionScheme prefValueEncryptionScheme) throws GeneralSecurityException, IOException {
        return EncryptedSharedPreferences.create(fileName, masterKey.getKeyAlias(), context, prefKeyEncryptionScheme, prefValueEncryptionScheme);
    }

    @Deprecated
    @NonNull
    public static SharedPreferences create(@NonNull String fileName, @NonNull String masterKeyAlias, @NonNull Context context, @NonNull PrefKeyEncryptionScheme prefKeyEncryptionScheme, @NonNull PrefValueEncryptionScheme prefValueEncryptionScheme) throws GeneralSecurityException, IOException {
        TinkConfig.register();
        Context applicationContext = context.getApplicationContext();
        KeysetHandle daeadKeysetHandle = new AndroidKeysetManager.Builder().withKeyTemplate(prefKeyEncryptionScheme.getKeyTemplate()).withSharedPref(applicationContext, KEY_KEYSET_ALIAS, fileName).withMasterKeyUri("android-keystore://" + masterKeyAlias).build().getKeysetHandle();
        KeysetHandle aeadKeysetHandle = new AndroidKeysetManager.Builder().withKeyTemplate(prefValueEncryptionScheme.getKeyTemplate()).withSharedPref(applicationContext, VALUE_KEYSET_ALIAS, fileName).withMasterKeyUri("android-keystore://" + masterKeyAlias).build().getKeysetHandle();
        DeterministicAead daead = (DeterministicAead)daeadKeysetHandle.getPrimitive(DeterministicAead.class);
        Aead aead = (Aead)aeadKeysetHandle.getPrimitive(Aead.class);
        return new EncryptedSharedPreferences(fileName, masterKeyAlias, applicationContext.getSharedPreferences(fileName, 0), aead, daead);
    }

    @NonNull
    public Map<String, ?> getAll() {
        HashMap<String, Object> allEntries = new HashMap<String, Object>();
        for (Map.Entry entry : this.mSharedPreferences.getAll().entrySet()) {
            if (this.isReservedKey((String)entry.getKey())) continue;
            String decryptedKey = this.decryptKey((String)entry.getKey());
            allEntries.put(decryptedKey, this.getDecryptedObject(decryptedKey));
        }
        return allEntries;
    }

    @Nullable
    public String getString(@Nullable String key, @Nullable String defValue) {
        Object value = this.getDecryptedObject(key);
        return value != null && value instanceof String ? (String)value : defValue;
    }

    @Nullable
    public Set<String> getStringSet(@Nullable String key, @Nullable Set<String> defValues) {
        Object value = this.getDecryptedObject(key);
        Set<String> returnValues = value instanceof Set ? (Set<String>)value : new ArraySet();
        return returnValues.size() > 0 ? returnValues : defValues;
    }

    public int getInt(@Nullable String key, int defValue) {
        Object value = this.getDecryptedObject(key);
        return value != null && value instanceof Integer ? (Integer)value : defValue;
    }

    public long getLong(@Nullable String key, long defValue) {
        Object value = this.getDecryptedObject(key);
        return value != null && value instanceof Long ? (Long)value : defValue;
    }

    public float getFloat(@Nullable String key, float defValue) {
        Object value = this.getDecryptedObject(key);
        return value != null && value instanceof Float ? ((Float)value).floatValue() : defValue;
    }

    public boolean getBoolean(@Nullable String key, boolean defValue) {
        Object value = this.getDecryptedObject(key);
        return value != null && value instanceof Boolean ? (Boolean)value : defValue;
    }

    public boolean contains(@Nullable String key) {
        if (this.isReservedKey(key)) {
            throw new SecurityException(key + " is a reserved key for the encryption keyset.");
        }
        String encryptedKey = this.encryptKey(key);
        return this.mSharedPreferences.contains(encryptedKey);
    }

    @NonNull
    public SharedPreferences.Editor edit() {
        return new Editor(this, this.mSharedPreferences.edit());
    }

    public void registerOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mListeners.add(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mListeners.remove(listener);
    }

    private Object getDecryptedObject(String key) {
        if (this.isReservedKey(key)) {
            throw new SecurityException(key + " is a reserved key for the encryption keyset.");
        }
        if (key == null) {
            key = NULL_VALUE;
        }
        Object returnValue = null;
        try {
            String encryptedKey = this.encryptKey(key);
            String encryptedValue = this.mSharedPreferences.getString(encryptedKey, null);
            if (encryptedValue != null) {
                byte[] cipherText = Base64.decode((String)encryptedValue, (int)0);
                byte[] value = this.mValueAead.decrypt(cipherText, encryptedKey.getBytes(StandardCharsets.UTF_8));
                ByteBuffer buffer = ByteBuffer.wrap(value);
                buffer.position(0);
                int typeId = buffer.getInt();
                EncryptedType type = EncryptedType.fromId(typeId);
                switch (type) {
                    case STRING: {
                        int stringLength = buffer.getInt();
                        ByteBuffer stringSlice = buffer.slice();
                        buffer.limit(stringLength);
                        String stringValue = StandardCharsets.UTF_8.decode(stringSlice).toString();
                        if (stringValue.equals(NULL_VALUE)) {
                            returnValue = null;
                            break;
                        }
                        returnValue = stringValue;
                        break;
                    }
                    case INT: {
                        returnValue = buffer.getInt();
                        break;
                    }
                    case LONG: {
                        returnValue = buffer.getLong();
                        break;
                    }
                    case FLOAT: {
                        returnValue = Float.valueOf(buffer.getFloat());
                        break;
                    }
                    case BOOLEAN: {
                        returnValue = buffer.get() != 0;
                        break;
                    }
                    case STRING_SET: {
                        ArraySet stringSet = new ArraySet();
                        while (buffer.hasRemaining()) {
                            int subStringLength = buffer.getInt();
                            ByteBuffer subStringSlice = buffer.slice();
                            subStringSlice.limit(subStringLength);
                            buffer.position(buffer.position() + subStringLength);
                            stringSet.add((Object)StandardCharsets.UTF_8.decode(subStringSlice).toString());
                        }
                        returnValue = stringSet.size() == 1 && NULL_VALUE.equals(stringSet.valueAt(0)) ? null : stringSet;
                    }
                }
            }
        }
        catch (GeneralSecurityException ex) {
            throw new SecurityException("Could not decrypt value. " + ex.getMessage(), ex);
        }
        return returnValue;
    }

    String encryptKey(String key) {
        if (key == null) {
            key = NULL_VALUE;
        }
        try {
            byte[] encryptedKeyBytes = this.mKeyDeterministicAead.encryptDeterministically(key.getBytes(StandardCharsets.UTF_8), this.mFileName.getBytes());
            return Base64.encode((byte[])encryptedKeyBytes);
        }
        catch (GeneralSecurityException ex) {
            throw new SecurityException("Could not encrypt key. " + ex.getMessage(), ex);
        }
    }

    String decryptKey(String encryptedKey) {
        try {
            byte[] clearText = this.mKeyDeterministicAead.decryptDeterministically(Base64.decode((String)encryptedKey, (int)0), this.mFileName.getBytes());
            String key = new String(clearText, StandardCharsets.UTF_8);
            if (key.equals(NULL_VALUE)) {
                key = null;
            }
            return key;
        }
        catch (GeneralSecurityException ex) {
            throw new SecurityException("Could not decrypt key. " + ex.getMessage(), ex);
        }
    }

    boolean isReservedKey(String key) {
        return KEY_KEYSET_ALIAS.equals(key) || VALUE_KEYSET_ALIAS.equals(key);
    }

    Pair<String, String> encryptKeyValuePair(String key, byte[] value) throws GeneralSecurityException {
        String encryptedKey = this.encryptKey(key);
        byte[] cipherText = this.mValueAead.encrypt(value, encryptedKey.getBytes(StandardCharsets.UTF_8));
        return new Pair((Object)encryptedKey, (Object)Base64.encode((byte[])cipherText));
    }

    private static enum EncryptedType {
        STRING(0),
        STRING_SET(1),
        INT(2),
        LONG(3),
        FLOAT(4),
        BOOLEAN(5);

        private final int mId;

        private EncryptedType(int id) {
            this.mId = id;
        }

        public int getId() {
            return this.mId;
        }

        public static EncryptedType fromId(int id) {
            switch (id) {
                case 0: {
                    return STRING;
                }
                case 1: {
                    return STRING_SET;
                }
                case 2: {
                    return INT;
                }
                case 3: {
                    return LONG;
                }
                case 4: {
                    return FLOAT;
                }
                case 5: {
                    return BOOLEAN;
                }
            }
            return null;
        }
    }

    private static final class Editor
    implements SharedPreferences.Editor {
        private final EncryptedSharedPreferences mEncryptedSharedPreferences;
        private final SharedPreferences.Editor mEditor;
        private final List<String> mKeysChanged;
        private AtomicBoolean mClearRequested = new AtomicBoolean(false);

        Editor(EncryptedSharedPreferences encryptedSharedPreferences, SharedPreferences.Editor editor) {
            this.mEncryptedSharedPreferences = encryptedSharedPreferences;
            this.mEditor = editor;
            this.mKeysChanged = new CopyOnWriteArrayList<String>();
        }

        @NonNull
        public SharedPreferences.Editor putString(@Nullable String key, @Nullable String value) {
            if (value == null) {
                value = EncryptedSharedPreferences.NULL_VALUE;
            }
            byte[] stringBytes = value.getBytes(StandardCharsets.UTF_8);
            int stringByteLength = stringBytes.length;
            ByteBuffer buffer = ByteBuffer.allocate(8 + stringByteLength);
            buffer.putInt(EncryptedType.STRING.getId());
            buffer.putInt(stringByteLength);
            buffer.put(stringBytes);
            this.putEncryptedObject(key, buffer.array());
            return this;
        }

        @NonNull
        public SharedPreferences.Editor putStringSet(@Nullable String key, @Nullable Set<String> values) {
            if (values == null) {
                values = new ArraySet();
                values.add(EncryptedSharedPreferences.NULL_VALUE);
            }
            ArrayList<byte[]> byteValues = new ArrayList<byte[]>(values.size());
            int totalBytes = values.size() * 4;
            for (String strValue : values) {
                byte[] byteValue = strValue.getBytes(StandardCharsets.UTF_8);
                byteValues.add(byteValue);
                totalBytes += byteValue.length;
            }
            ByteBuffer buffer = ByteBuffer.allocate(totalBytes += 4);
            buffer.putInt(EncryptedType.STRING_SET.getId());
            for (byte[] bytes : byteValues) {
                buffer.putInt(bytes.length);
                buffer.put(bytes);
            }
            this.putEncryptedObject(key, buffer.array());
            return this;
        }

        @NonNull
        public SharedPreferences.Editor putInt(@Nullable String key, int value) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putInt(EncryptedType.INT.getId());
            buffer.putInt(value);
            this.putEncryptedObject(key, buffer.array());
            return this;
        }

        @NonNull
        public SharedPreferences.Editor putLong(@Nullable String key, long value) {
            ByteBuffer buffer = ByteBuffer.allocate(12);
            buffer.putInt(EncryptedType.LONG.getId());
            buffer.putLong(value);
            this.putEncryptedObject(key, buffer.array());
            return this;
        }

        @NonNull
        public SharedPreferences.Editor putFloat(@Nullable String key, float value) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putInt(EncryptedType.FLOAT.getId());
            buffer.putFloat(value);
            this.putEncryptedObject(key, buffer.array());
            return this;
        }

        @NonNull
        public SharedPreferences.Editor putBoolean(@Nullable String key, boolean value) {
            ByteBuffer buffer = ByteBuffer.allocate(5);
            buffer.putInt(EncryptedType.BOOLEAN.getId());
            buffer.put(value ? (byte)1 : 0);
            this.putEncryptedObject(key, buffer.array());
            return this;
        }

        @NonNull
        public SharedPreferences.Editor remove(@Nullable String key) {
            if (this.mEncryptedSharedPreferences.isReservedKey(key)) {
                throw new SecurityException(key + " is a reserved key for the encryption keyset.");
            }
            this.mEditor.remove(this.mEncryptedSharedPreferences.encryptKey(key));
            this.mKeysChanged.remove(key);
            return this;
        }

        @NonNull
        public SharedPreferences.Editor clear() {
            this.mClearRequested.set(true);
            return this;
        }

        public boolean commit() {
            this.clearKeysIfNeeded();
            try {
                boolean bl = this.mEditor.commit();
                return bl;
            }
            finally {
                this.notifyListeners();
                this.mKeysChanged.clear();
            }
        }

        public void apply() {
            this.clearKeysIfNeeded();
            this.mEditor.apply();
            this.notifyListeners();
            this.mKeysChanged.clear();
        }

        private void clearKeysIfNeeded() {
            if (this.mClearRequested.getAndSet(false)) {
                for (String key : this.mEncryptedSharedPreferences.getAll().keySet()) {
                    if (this.mKeysChanged.contains(key) || this.mEncryptedSharedPreferences.isReservedKey(key)) continue;
                    this.mEditor.remove(this.mEncryptedSharedPreferences.encryptKey(key));
                }
            }
        }

        private void putEncryptedObject(String key, byte[] value) {
            if (this.mEncryptedSharedPreferences.isReservedKey(key)) {
                throw new SecurityException(key + " is a reserved key for the encryption keyset.");
            }
            this.mKeysChanged.add(key);
            if (key == null) {
                key = EncryptedSharedPreferences.NULL_VALUE;
            }
            try {
                Pair<String, String> encryptedPair = this.mEncryptedSharedPreferences.encryptKeyValuePair(key, value);
                this.mEditor.putString((String)encryptedPair.first, (String)encryptedPair.second);
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException("Could not encrypt data: " + ex.getMessage(), ex);
            }
        }

        private void notifyListeners() {
            for (SharedPreferences.OnSharedPreferenceChangeListener listener : this.mEncryptedSharedPreferences.mListeners) {
                for (String key : this.mKeysChanged) {
                    listener.onSharedPreferenceChanged((SharedPreferences)this.mEncryptedSharedPreferences, key);
                }
            }
        }
    }

    public static enum PrefValueEncryptionScheme {
        AES256_GCM(AesGcmKeyManager.aes256GcmTemplate());

        private final KeyTemplate mAeadKeyTemplate;

        private PrefValueEncryptionScheme(KeyTemplate keyTemplates) {
            this.mAeadKeyTemplate = keyTemplates;
        }

        KeyTemplate getKeyTemplate() {
            return this.mAeadKeyTemplate;
        }
    }

    public static enum PrefKeyEncryptionScheme {
        AES256_SIV(AesSivKeyManager.aes256SivTemplate());

        private final KeyTemplate mDeterministicAeadKeyTemplate;

        private PrefKeyEncryptionScheme(KeyTemplate keyTemplate) {
            this.mDeterministicAeadKeyTemplate = keyTemplate;
        }

        KeyTemplate getKeyTemplate() {
            return this.mDeterministicAeadKeyTemplate;
        }
    }
}

