/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.app.authenticator;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Build;
import androidx.annotation.NonNull;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

class AppAuthenticatorUtils {
    private static final char[] HEX_CHARACTERS = "0123456789abcdef".toCharArray();
    private Context mContext;

    AppAuthenticatorUtils(Context context) {
        this.mContext = context;
    }

    int getCallingPid() {
        return Binder.getCallingPid();
    }

    int getCallingUid() {
        return Binder.getCallingUid();
    }

    int getUidForPackage(String packageName) throws PackageManager.NameNotFoundException {
        ApplicationInfo appInfo = this.mContext.getPackageManager().getApplicationInfo(packageName, 0);
        return appInfo.uid;
    }

    static int getApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    static String computeDigest(@NonNull String digestAlgorithm, @NonNull byte[] data) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AppAuthenticatorUtilsException(digestAlgorithm + " not supported on this device", e);
        }
        return AppAuthenticatorUtils.toHexString(messageDigest.digest(data));
    }

    static String toHexString(@NonNull byte[] data) {
        char[] result = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            int resultIndex = i * 2;
            result[resultIndex] = HEX_CHARACTERS[data[i] >> 4 & 0xF];
            result[resultIndex + 1] = HEX_CHARACTERS[data[i] & 0xF];
        }
        return new String(result);
    }

    private static class AppAuthenticatorUtilsException
    extends RuntimeException {
        AppAuthenticatorUtilsException(@NonNull String message, Throwable reason) {
            super(message, reason);
        }
    }
}

