/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.app.authenticator;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.XmlRes;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import androidx.security.app.authenticator.AppAuthenticatorUtils;
import androidx.security.app.authenticator.AppAuthenticatorXmlException;
import androidx.security.app.authenticator.AppSignatureVerifier;
import androidx.security.app.authenticator.AutoValue_AppAuthenticator_AppAuthenticatorConfig;
import androidx.security.app.authenticator.AutoValue_AppAuthenticator_AppAuthenticatorResult;
import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class AppAuthenticator {
    private static final String TAG = "AppAuthenticator";
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_DENIED_NO_MATCH = -3;
    public static final int PERMISSION_DENIED_UNKNOWN_PACKAGE = -4;
    public static final int PERMISSION_DENIED_PACKAGE_UID_MISMATCH = -5;
    public static final int SIGNATURE_MATCH = 0;
    public static final int SIGNATURE_NO_MATCH = -1;
    private static final String ROOT_TAG = "app-authenticator";
    private static final String PERMISSION_TAG = "permission";
    private static final String EXPECTED_IDENTITY_TAG = "expected-identity";
    private static final String PACKAGE_TAG = "package";
    static final String ALL_PACKAGES_TAG = "all-packages";
    private static final String CERT_DIGEST_TAG = "cert-digest";
    private static final String NAME_ATTRIBUTE = "name";
    static final String DEFAULT_DIGEST_ALGORITHM = "SHA-256";
    private AppSignatureVerifier mAppSignatureVerifier;
    private AppAuthenticatorUtils mAppAuthenticatorUtils;

    AppAuthenticator(AppSignatureVerifier appSignatureVerifier, AppAuthenticatorUtils appAuthenticatorUtils) {
        this.mAppSignatureVerifier = appSignatureVerifier;
        this.mAppAuthenticatorUtils = appAuthenticatorUtils;
    }

    @VisibleForTesting(otherwise=5)
    void setAppSignatureVerifier(AppSignatureVerifier appSignatureVerifier) {
        this.mAppSignatureVerifier = appSignatureVerifier;
    }

    @VisibleForTesting(otherwise=5)
    void setAppAuthenticatorUtils(AppAuthenticatorUtils appAuthenticatorUtils) {
        this.mAppAuthenticatorUtils = appAuthenticatorUtils;
    }

    public void enforceCallingAppIdentity(@NonNull String packageName, @NonNull String permission) {
        this.enforceCallingAppIdentity(packageName, permission, this.mAppAuthenticatorUtils.getCallingPid(), this.mAppAuthenticatorUtils.getCallingUid());
    }

    public void enforceCallingAppIdentity(@NonNull String packageName, @NonNull String permission, int pid, int uid) {
        AppAuthenticatorResult result = this.checkCallingAppIdentityInternal(packageName, permission, pid, uid);
        if (result.getResultCode() != 0) {
            throw new SecurityException(result.getResultMessage());
        }
    }

    public int checkCallingAppIdentity(@NonNull String packageName, @NonNull String permission) {
        return this.checkCallingAppIdentity(packageName, permission, this.mAppAuthenticatorUtils.getCallingPid(), this.mAppAuthenticatorUtils.getCallingUid());
    }

    public int checkCallingAppIdentity(@NonNull String packageName, @NonNull String permission, int pid, int uid) {
        AppAuthenticatorResult result = this.checkCallingAppIdentityInternal(packageName, permission, pid, uid);
        if (result.getResultCode() != 0) {
            Log.e((String)TAG, (String)result.getResultMessage());
        }
        return result.getResultCode();
    }

    private AppAuthenticatorResult checkCallingAppIdentityInternal(String packageName, String permission, int pid, int uid) {
        int packageUid;
        try {
            packageUid = this.mAppAuthenticatorUtils.getUidForPackage(packageName);
        }
        catch (PackageManager.NameNotFoundException e) {
            return AppAuthenticatorResult.create(-4, "The app " + packageName + " was not found on the device");
        }
        if (packageUid != uid) {
            return AppAuthenticatorResult.create(-5, "The expected UID, " + uid + ", of the app " + packageName + " does not match the actual UID, " + packageUid);
        }
        if (this.mAppSignatureVerifier.verifySigningIdentity(packageName, permission)) {
            return AppAuthenticatorResult.create(0, null);
        }
        return AppAuthenticatorResult.create(-3, "The signing identity of app " + packageName + " does not match the expected identity");
    }

    public void enforceAppIdentity(@NonNull String packageName) {
        if (this.checkAppIdentity(packageName) != 0) {
            throw new SecurityException("The app " + packageName + " does not match the expected signing identity");
        }
    }

    public int checkAppIdentity(@NonNull String packageName) {
        if (this.mAppSignatureVerifier.verifyExpectedIdentity(packageName)) {
            return 0;
        }
        return -1;
    }

    @NonNull
    public static AppAuthenticator createFromInputStream(@NonNull Context context, @NonNull InputStream xmlInputStream) throws AppAuthenticatorXmlException, IOException {
        XmlPullParser parser;
        try {
            parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput(xmlInputStream, null);
        }
        catch (XmlPullParserException e) {
            throw new AppAuthenticatorXmlException("Unable to create parser from provided InputStream", e);
        }
        return AppAuthenticator.createFromParser(context, parser);
    }

    @NonNull
    public static AppAuthenticator createFromResource(@NonNull Context context, @XmlRes int xmlResource) throws AppAuthenticatorXmlException, IOException {
        Resources resources = context.getResources();
        XmlResourceParser parser = resources.getXml(xmlResource);
        return AppAuthenticator.createFromParser(context, (XmlPullParser)parser);
    }

    private static AppAuthenticator createFromParser(Context context, XmlPullParser parser) throws AppAuthenticatorXmlException, IOException {
        AppAuthenticatorConfig config = AppAuthenticator.createConfigFromParser(parser);
        return AppAuthenticator.createFromConfig(context, config);
    }

    static AppAuthenticator createFromConfig(Context context, @NonNull AppAuthenticatorConfig config) {
        AppSignatureVerifier verifier = AppSignatureVerifier.builder(context).setPermissionAllowMap(config.getPermissionAllowMap()).setExpectedIdentities(config.getExpectedIdentities()).setDigestAlgorithm(config.getDigestAlgorithm()).build();
        return new AppAuthenticator(verifier, new AppAuthenticatorUtils(context));
    }

    static AppAuthenticatorConfig createConfigFromParser(XmlPullParser parser) throws AppAuthenticatorXmlException, IOException {
        ArrayMap permissionAllowMap = new ArrayMap();
        ArrayMap expectedIdentities = new ArrayMap();
        try {
            AppAuthenticator.parseToNextStartTag(parser);
            String tag = parser.getName();
            if (TextUtils.isEmpty((CharSequence)tag) || !tag.equalsIgnoreCase(ROOT_TAG)) {
                throw new AppAuthenticatorXmlException("Provided XML does not contain the expected root tag: app-authenticator");
            }
            AppAuthenticator.assertExpectedAttribute(parser, ROOT_TAG, null, false);
            String digestAlgorithm = DEFAULT_DIGEST_ALGORITHM;
            int eventType = parser.nextTag();
            while (eventType == 2) {
                tag = parser.getName();
                if (tag.equalsIgnoreCase(PERMISSION_TAG)) {
                    AppAuthenticator.assertExpectedAttribute(parser, PERMISSION_TAG, NAME_ATTRIBUTE, true);
                    String permissionName = parser.getAttributeValue(null, NAME_ATTRIBUTE);
                    if (TextUtils.isEmpty((CharSequence)permissionName)) {
                        throw new AppAuthenticatorXmlException("The permission tag requires a non-empty value for the name attribute");
                    }
                    Map<String, Set<String>> allowedPackageCerts = AppAuthenticator.parsePackages(parser, true);
                    if (permissionAllowMap.containsKey(permissionName)) {
                        ((Map)permissionAllowMap.get(permissionName)).putAll(allowedPackageCerts);
                    } else {
                        permissionAllowMap.put(permissionName, allowedPackageCerts);
                    }
                } else if (tag.equalsIgnoreCase(EXPECTED_IDENTITY_TAG)) {
                    AppAuthenticator.assertExpectedAttribute(parser, EXPECTED_IDENTITY_TAG, null, true);
                    expectedIdentities.putAll(AppAuthenticator.parsePackages(parser, false));
                } else {
                    throw new AppAuthenticatorXmlException("Expected permission or expected-identity under root tag at line " + parser.getLineNumber());
                }
                eventType = parser.nextTag();
            }
            return AppAuthenticatorConfig.create((Map<String, Map<String, Set<String>>>)permissionAllowMap, (Map<String, Set<String>>)expectedIdentities, digestAlgorithm);
        }
        catch (XmlPullParserException e) {
            throw new AppAuthenticatorXmlException("Caught an exception parsing the provided XML:", e);
        }
    }

    private static Map<String, Set<String>> parsePackages(XmlPullParser parser, boolean allPackagesAllowed) throws AppAuthenticatorXmlException, IOException, XmlPullParserException {
        ArrayMap allowedPackageCerts = new ArrayMap();
        int eventType = parser.nextTag();
        while (eventType == 2) {
            Set<String> allowedCertDigests;
            String packageName;
            String tag = parser.getName();
            if (tag.equalsIgnoreCase(PACKAGE_TAG)) {
                AppAuthenticator.assertExpectedAttribute(parser, PACKAGE_TAG, NAME_ATTRIBUTE, true);
                packageName = parser.getAttributeValue(null, NAME_ATTRIBUTE);
                if (TextUtils.isEmpty((CharSequence)packageName)) {
                    throw new AppAuthenticatorXmlException("The package tag requires a non-empty value for the name attribute");
                }
            } else if (tag.equalsIgnoreCase(ALL_PACKAGES_TAG)) {
                packageName = ALL_PACKAGES_TAG;
                if (!allPackagesAllowed) {
                    throw new AppAuthenticatorXmlException("The all-packages tag is not allowed within this element on line " + parser.getLineNumber());
                }
            } else {
                throw new AppAuthenticatorXmlException("Unexpected tag " + tag + " on line " + parser.getLineNumber() + "; expected " + PACKAGE_TAG + "" + (allPackagesAllowed ? " or all-packages" : ""));
            }
            if ((allowedCertDigests = AppAuthenticator.parseCertDigests(parser)).isEmpty()) {
                throw new AppAuthenticatorXmlException("No cert-digest tag found within " + tag + " element on line " + parser.getLineNumber());
            }
            if (allowedPackageCerts.containsKey(packageName)) {
                ((Set)allowedPackageCerts.get(packageName)).addAll(allowedCertDigests);
            } else {
                allowedPackageCerts.put(packageName, allowedCertDigests);
            }
            eventType = parser.nextTag();
        }
        return allowedPackageCerts;
    }

    private static Set<String> parseCertDigests(XmlPullParser parser) throws AppAuthenticatorXmlException, IOException, XmlPullParserException {
        ArraySet allowedCertDigests = new ArraySet();
        int eventType = parser.nextTag();
        while (eventType == 2) {
            String tag = parser.getName();
            if (!tag.equalsIgnoreCase(CERT_DIGEST_TAG)) {
                throw new AppAuthenticatorXmlException("Expected cert-digest on line " + parser.getLineNumber());
            }
            String digest = parser.nextText().trim();
            if (TextUtils.isEmpty((CharSequence)digest)) {
                throw new AppAuthenticatorXmlException("The cert-digest element on line " + parser.getLineNumber() + " must have non-empty text containing the certificate digest of the signer");
            }
            allowedCertDigests.add(AppAuthenticator.normalizeCertDigest(digest));
            eventType = parser.nextTag();
        }
        return allowedCertDigests;
    }

    static String normalizeCertDigest(String certDigest) {
        return certDigest.toLowerCase(Locale.US);
    }

    private static int parseToNextStartTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        return type;
    }

    private static void assertExpectedAttribute(XmlPullParser parser, String tagName, String expectedAttribute, boolean required) throws AppAuthenticatorXmlException, XmlPullParserException {
        int attributeCount = parser.getAttributeCount();
        if (attributeCount == -1) {
            throw new AssertionError((Object)("parser#getAttributeCount called for event type " + parser.getEventType() + " on line " + parser.getLineNumber()));
        }
        if (attributeCount == 0 && expectedAttribute != null && required) {
            throw new AppAuthenticatorXmlException("The attribute " + expectedAttribute + " is required for tag " + tagName + " on line " + parser.getLineNumber());
        }
        StringBuilder unsupportedAttributes = null;
        for (int i = 0; i < attributeCount; ++i) {
            String attributeName = parser.getAttributeName(i);
            if (attributeName.equalsIgnoreCase(expectedAttribute)) continue;
            if (unsupportedAttributes == null) {
                unsupportedAttributes = new StringBuilder();
            } else {
                unsupportedAttributes.append(", ");
            }
            unsupportedAttributes.append(attributeName);
        }
        if (unsupportedAttributes != null) {
            String prefixMessage = expectedAttribute == null ? "Tag " + tagName + " does not support any attributes" : "Tag " + tagName + " only supports attribute " + expectedAttribute;
            throw new AppAuthenticatorXmlException(prefixMessage + "; found the following unsupported attributes on line " + parser.getLineNumber() + ": " + unsupportedAttributes);
        }
    }

    @AutoValue
    static abstract class AppAuthenticatorResult {
        AppAuthenticatorResult() {
        }

        abstract int getResultCode();

        @Nullable
        abstract String getResultMessage();

        static AppAuthenticatorResult create(int resultCode, String resultMessage) {
            return new AutoValue_AppAuthenticator_AppAuthenticatorResult(resultCode, resultMessage);
        }
    }

    @AutoValue
    static abstract class AppAuthenticatorConfig {
        AppAuthenticatorConfig() {
        }

        abstract Map<String, Map<String, Set<String>>> getPermissionAllowMap();

        abstract Map<String, Set<String>> getExpectedIdentities();

        abstract String getDigestAlgorithm();

        static AppAuthenticatorConfig create(Map<String, Map<String, Set<String>>> permissionAllowMap, Map<String, Set<String>> expectedIdentities, String digestAlgorithm) {
            return new AutoValue_AppAuthenticator_AppAuthenticatorConfig(permissionAllowMap, expectedIdentities, digestAlgorithm);
        }
    }
}

