/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.LiveData;
import androidx.room.AutoCloser;
import androidx.room.InvalidationLiveDataContainer;
import androidx.room.MultiInstanceInvalidationClient;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u0000 e2\u00020\u0001:\u0005efghiB#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007BV\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\t\u0012\u001d\u0010\n\u001a\u0019\u0012\u0004\u0012\u00020\u0006\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\b\f0\t\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\"H\u0017J\u0010\u0010;\u001a\u0002092\u0006\u0010:\u001a\u00020\"H\u0017J9\u0010<\u001a\b\u0012\u0004\u0012\u0002H>0=\"\u0004\b\u0000\u0010>2\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u000e\u0010?\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H>0@H\u0017\u00a2\u0006\u0002\u0010AJA\u0010<\u001a\b\u0012\u0004\u0012\u0002H>0=\"\u0004\b\u0000\u0010>2\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010B\u001a\u00020\u00192\u000e\u0010?\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H>0@H\u0017\u00a2\u0006\u0002\u0010CJ\r\u0010D\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\bEJ\u0015\u0010F\u001a\u0002092\u0006\u0010\u0002\u001a\u00020GH\u0000\u00a2\u0006\u0002\bHJ!\u0010I\u001a\u0002092\u0012\u0010J\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010KJ\b\u0010L\u001a\u000209H\u0002J\b\u0010M\u001a\u000209H\u0016J\b\u0010N\u001a\u000209H\u0017J\u0010\u0010O\u001a\u0002092\u0006\u0010:\u001a\u00020\"H\u0017J%\u0010P\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u000e\u0010Q\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010RJ\u0015\u0010S\u001a\u0002092\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\bTJ%\u0010U\u001a\u0002092\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u00062\u0006\u0010Y\u001a\u00020ZH\u0000\u00a2\u0006\u0002\b[J\u0018\u0010\\\u001a\u0002092\u0006\u0010]\u001a\u00020G2\u0006\u0010^\u001a\u000200H\u0002J\r\u0010_\u001a\u000209H\u0000\u00a2\u0006\u0002\b`J\u0018\u0010a\u001a\u0002092\u0006\u0010]\u001a\u00020G2\u0006\u0010^\u001a\u000200H\u0002J\r\u0010b\u001a\u000209H\u0000\u00a2\u0006\u0002\bcJ\u0015\u0010b\u001a\u0002092\u0006\u0010\u0002\u001a\u00020GH\u0000\u00a2\u0006\u0002\bcJ%\u0010d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010RR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020'8GX\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020+8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b,\u0010-R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002000\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u001e\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u00106\u001a\u0004\b4\u00105R\u000e\u00107\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\n\u001a\u0019\u0012\u0004\u0012\u00020\u0006\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\b\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006j"}, d2={"Landroidx/room/InvalidationTracker;", "", "database", "Landroidx/room/RoomDatabase;", "tableNames", "", "", "(Landroidx/room/RoomDatabase;[Ljava/lang/String;)V", "shadowTablesMap", "", "viewTables", "", "Lkotlin/jvm/JvmSuppressWildcards;", "(Landroidx/room/RoomDatabase;Ljava/util/Map;Ljava/util/Map;[Ljava/lang/String;)V", "autoCloser", "Landroidx/room/AutoCloser;", "cleanupStatement", "Landroidx/sqlite/db/SupportSQLiteStatement;", "getCleanupStatement$room_runtime_release", "()Landroidx/sqlite/db/SupportSQLiteStatement;", "setCleanupStatement$room_runtime_release", "(Landroidx/sqlite/db/SupportSQLiteStatement;)V", "getDatabase$room_runtime_release", "()Landroidx/room/RoomDatabase;", "initialized", "", "invalidationLiveDataContainer", "Landroidx/room/InvalidationLiveDataContainer;", "multiInstanceInvalidationClient", "Landroidx/room/MultiInstanceInvalidationClient;", "observedTableTracker", "Landroidx/room/InvalidationTracker$ObservedTableTracker;", "observerMap", "Landroidx/arch/core/internal/SafeIterableMap;", "Landroidx/room/InvalidationTracker$Observer;", "Landroidx/room/InvalidationTracker$ObserverWrapper;", "getObserverMap$room_runtime_release", "()Landroidx/arch/core/internal/SafeIterableMap;", "pendingRefresh", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getPendingRefresh", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "refreshRunnable", "Ljava/lang/Runnable;", "getRefreshRunnable$annotations", "()V", "syncTriggersLock", "tableIdLookup", "", "getTableIdLookup$room_runtime_release", "()Ljava/util/Map;", "tablesNames", "getTablesNames$room_runtime_release", "()[Ljava/lang/String;", "[Ljava/lang/String;", "trackerLock", "addObserver", "", "observer", "addWeakObserver", "createLiveData", "Landroidx/lifecycle/LiveData;", "T", "computeFunction", "Ljava/util/concurrent/Callable;", "([Ljava/lang/String;Ljava/util/concurrent/Callable;)Landroidx/lifecycle/LiveData;", "inTransaction", "([Ljava/lang/String;ZLjava/util/concurrent/Callable;)Landroidx/lifecycle/LiveData;", "ensureInitialization", "ensureInitialization$room_runtime_release", "internalInit", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "internalInit$room_runtime_release", "notifyObserversByTableNames", "tables", "([Ljava/lang/String;)V", "onAutoCloseCallback", "refreshVersionsAsync", "refreshVersionsSync", "removeObserver", "resolveViews", "names", "([Ljava/lang/String;)[Ljava/lang/String;", "setAutoCloser", "setAutoCloser$room_runtime_release", "startMultiInstanceInvalidation", "context", "Landroid/content/Context;", "name", "serviceIntent", "Landroid/content/Intent;", "startMultiInstanceInvalidation$room_runtime_release", "startTrackingTable", "db", "tableId", "stopMultiInstanceInvalidation", "stopMultiInstanceInvalidation$room_runtime_release", "stopTrackingTable", "syncTriggers", "syncTriggers$room_runtime_release", "validateAndResolveTableNames", "Companion", "ObservedTableTracker", "Observer", "ObserverWrapper", "WeakObserver", "room-runtime_release"})
@SourceDebugExtension(value={"SMAP\nInvalidationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidationTracker.kt\nandroidx/room/InvalidationTracker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,846:1\n215#2,2:847\n11335#3:849\n11670#3,3:850\n13579#3,2:853\n13579#3,2:855\n13674#3,3:861\n37#4,2:857\n1855#5,2:859\n*S KotlinDebug\n*F\n+ 1 InvalidationTracker.kt\nandroidx/room/InvalidationTracker\n*L\n102#1:847,2\n251#1:849\n251#1:850,3\n272#1:853,2\n288#1:855,2\n496#1:861,3\n295#1:857,2\n472#1:859,2\n*E\n"})
public class InvalidationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomDatabase database;
    @NotNull
    private final Map<String, String> shadowTablesMap;
    @NotNull
    private final Map<String, Set<String>> viewTables;
    @NotNull
    private final Map<String, Integer> tableIdLookup;
    @NotNull
    private final String[] tablesNames;
    @Nullable
    private AutoCloser autoCloser;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    private final AtomicBoolean pendingRefresh;
    private volatile boolean initialized;
    @Nullable
    private volatile SupportSQLiteStatement cleanupStatement;
    @NotNull
    private final ObservedTableTracker observedTableTracker;
    @NotNull
    private final InvalidationLiveDataContainer invalidationLiveDataContainer;
    @GuardedBy(value="observerMap")
    @NotNull
    private final SafeIterableMap<Observer, ObserverWrapper> observerMap;
    @Nullable
    private MultiInstanceInvalidationClient multiInstanceInvalidationClient;
    @NotNull
    private final Object syncTriggersLock;
    @NotNull
    private final Object trackerLock;
    @JvmField
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final Runnable refreshRunnable;
    @NotNull
    private static final String[] TRIGGERS;
    @NotNull
    private static final String UPDATE_TABLE_NAME = "room_table_modification_log";
    @NotNull
    private static final String TABLE_ID_COLUMN_NAME = "table_id";
    @NotNull
    private static final String INVALIDATED_COLUMN_NAME = "invalidated";
    @NotNull
    private static final String CREATE_TRACKING_TABLE_SQL = "CREATE TEMP TABLE room_table_modification_log (table_id INTEGER PRIMARY KEY, invalidated INTEGER NOT NULL DEFAULT 0)";
    @NotNull
    public static final String RESET_UPDATED_TABLES_SQL = "UPDATE room_table_modification_log SET invalidated = 0 WHERE invalidated = 1";
    @NotNull
    public static final String SELECT_UPDATED_TABLES_SQL = "SELECT * FROM room_table_modification_log WHERE invalidated = 1;";

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public InvalidationTracker(@NotNull RoomDatabase database, @NotNull Map<String, String> shadowTablesMap, @NotNull Map<String, Set<String>> viewTables, String ... tableNames) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(shadowTablesMap, (String)"shadowTablesMap");
        Intrinsics.checkNotNullParameter(viewTables, (String)"viewTables");
        Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
        this.database = database;
        this.shadowTablesMap = shadowTablesMap;
        this.viewTables = viewTables;
        this.pendingRefresh = new AtomicBoolean(false);
        this.observedTableTracker = new ObservedTableTracker(tableNames.length);
        this.invalidationLiveDataContainer = new InvalidationLiveDataContainer(this.database);
        this.observerMap = new SafeIterableMap();
        this.syncTriggersLock = new Object();
        this.trackerLock = new Object();
        this.tableIdLookup = new LinkedHashMap();
        int n = tableNames.length;
        Object object2 = new String[n];
        InvalidationTracker invalidationTracker = this;
        for (int i = 0; i < n; ++i) {
            String shadowTableName;
            String string;
            String string2;
            String tableName;
            int n2 = i;
            String string3 = tableNames[n2];
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            Intrinsics.checkNotNullExpressionValue((Object)string3.toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
            object = n2;
            this.tableIdLookup.put(tableName, (Integer)object);
            if (this.shadowTablesMap.get(tableNames[n2]) != null) {
                String string4;
                Locale locale2 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
                String string5 = string4.toLowerCase(locale2);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
            } else {
                string2 = null;
            }
            if ((string = (shadowTableName = string2)) == null) {
                string = tableName;
            }
            object2[n2] = string;
        }
        invalidationTracker.tablesNames = object2;
        Map<String, String> $this$forEach$iv = this.shadowTablesMap;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            String tableName;
            String shadowTableName;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object2.next();
            boolean bl = false;
            object = (String)entry.getValue();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            Intrinsics.checkNotNullExpressionValue((Object)((String)object).toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
            if (!this.tableIdLookup.containsKey(shadowTableName)) continue;
            String string = (String)entry.getKey();
            Locale locale3 = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"US");
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale3), (String)"this as java.lang.String).toLowerCase(locale)");
            this.tableIdLookup.put(tableName, (Integer)MapsKt.getValue(this.tableIdLookup, (Object)shadowTableName));
        }
        this.refreshRunnable = new Runnable(this){
            final /* synthetic */ InvalidationTracker this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                Lock closeLock = this.this$0.getDatabase$room_runtime_release().getCloseLock$room_runtime_release();
                closeLock.lock();
                try {
                    if (!this.this$0.ensureInitialization$room_runtime_release()) {
                        return;
                    }
                    if (!this.this$0.getPendingRefresh().compareAndSet(true, false)) {
                        return;
                    }
                    if (this.this$0.getDatabase$room_runtime_release().inTransaction()) {
                        return;
                    }
                    SupportSQLiteDatabase db = this.this$0.getDatabase$room_runtime_release().getOpenHelper().getWritableDatabase();
                    db.beginTransactionNonExclusive();
                    Set<Integer> invalidatedTableIds = null;
                    try {
                        invalidatedTableIds = this.checkUpdatedTable();
                        db.setTransactionSuccessful();
                    }
                    finally {
                        db.endTransaction();
                    }
                    object = invalidatedTableIds;
                }
                catch (IllegalStateException ex) {
                    Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)ex);
                    object = SetsKt.emptySet();
                }
                catch (SQLiteException ex) {
                    Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)ex);
                    object = SetsKt.emptySet();
                }
                finally {
                    closeLock.unlock();
                    AutoCloser autoCloser = InvalidationTracker.access$getAutoCloser$p(this.this$0);
                    if (autoCloser != null) {
                        autoCloser.decrementCountAndScheduleClose();
                    }
                }
                SafeIterableMap<Observer, ObserverWrapper> invalidatedTableIds = object;
                if (!((Collection)invalidatedTableIds).isEmpty()) {
                    object = this.this$0.getObserverMap$room_runtime_release();
                    InvalidationTracker invalidationTracker = this.this$0;
                    SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = object;
                    synchronized (safeIterableMap) {
                        boolean bl = false;
                        Iterable $this$forEach$iv = (Iterable)invalidationTracker.getObserverMap$room_runtime_release();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Map.Entry it = (Map.Entry)element$iv;
                            boolean bl2 = false;
                            ((ObserverWrapper)it.getValue()).notifyByTableInvalidStatus$room_runtime_release((Set<Integer>)invalidatedTableIds);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Set<Integer> checkUpdatedTable() {
                InvalidationTracker invalidationTracker = this.this$0;
                Object object = SetsKt.createSetBuilder();
                Set $this$checkUpdatedTable_u24lambda_u243 = object;
                boolean bl = false;
                Cursor $this$useCursor$iv = RoomDatabase.query$default(invalidationTracker.getDatabase$room_runtime_release(), (SupportSQLiteQuery)new SimpleSQLiteQuery("SELECT * FROM room_table_modification_log WHERE invalidated = 1;"), null, 2, null);
                boolean $i$f$useCursor = false;
                if (Build.VERSION.SDK_INT > 15) {
                    Closeable closeable = (Closeable)$this$useCursor$iv;
                    Throwable throwable = null;
                    try {
                        Cursor cursor = (Cursor)closeable;
                        boolean bl2 = false;
                        while (cursor.moveToNext()) {
                            $this$checkUpdatedTable_u24lambda_u243.add(cursor.getInt(0));
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                try {
                    Cursor cursor = $this$useCursor$iv;
                    boolean bl3 = false;
                    while (cursor.moveToNext()) {
                        $this$checkUpdatedTable_u24lambda_u243.add(cursor.getInt(0));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$useCursor$iv.close();
                }
                Set invalidatedTableIds = SetsKt.build((Set)object);
                if (!((Collection)invalidatedTableIds).isEmpty()) {
                    if (this.this$0.getCleanupStatement$room_runtime_release() == null) {
                        object = "Required value was null.";
                        throw new IllegalStateException(object.toString());
                    }
                    SupportSQLiteStatement statement = this.this$0.getCleanupStatement$room_runtime_release();
                    if (statement == null) {
                        object = "Required value was null.";
                        throw new IllegalArgumentException(object.toString());
                    }
                    statement.executeUpdateDelete();
                }
                return invalidatedTableIds;
            }
        };
    }

    @NotNull
    public final RoomDatabase getDatabase$room_runtime_release() {
        return this.database;
    }

    @NotNull
    public final Map<String, Integer> getTableIdLookup$room_runtime_release() {
        return this.tableIdLookup;
    }

    @NotNull
    public final String[] getTablesNames$room_runtime_release() {
        return this.tablesNames;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final AtomicBoolean getPendingRefresh() {
        return this.pendingRefresh;
    }

    @Nullable
    public final SupportSQLiteStatement getCleanupStatement$room_runtime_release() {
        return this.cleanupStatement;
    }

    public final void setCleanupStatement$room_runtime_release(@Nullable SupportSQLiteStatement supportSQLiteStatement) {
        this.cleanupStatement = supportSQLiteStatement;
    }

    @NotNull
    public final SafeIterableMap<Observer, ObserverWrapper> getObserverMap$room_runtime_release() {
        return this.observerMap;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public InvalidationTracker(@NotNull RoomDatabase database, String ... tableNames) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
        this(database, MapsKt.emptyMap(), MapsKt.emptyMap(), Arrays.copyOf(tableNames, tableNames.length));
    }

    public final void setAutoCloser$room_runtime_release(@NotNull AutoCloser autoCloser) {
        Intrinsics.checkNotNullParameter((Object)autoCloser, (String)"autoCloser");
        this.autoCloser = autoCloser;
        autoCloser.setAutoCloseCallback(this::onAutoCloseCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void internalInit$room_runtime_release(@NotNull SupportSQLiteDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Object object = this.trackerLock;
        synchronized (object) {
            boolean bl = false;
            if (this.initialized) {
                Log.e((String)"ROOM", (String)"Invalidation tracker is initialized twice :/.");
                return;
            }
            database.execSQL("PRAGMA temp_store = MEMORY;");
            database.execSQL("PRAGMA recursive_triggers='ON';");
            database.execSQL(CREATE_TRACKING_TABLE_SQL);
            this.syncTriggers$room_runtime_release(database);
            this.cleanupStatement = database.compileStatement(RESET_UPDATED_TABLES_SQL);
            this.initialized = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onAutoCloseCallback() {
        Object object = this.trackerLock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            this.initialized = false;
            this.observedTableTracker.resetTriggerState();
            SupportSQLiteStatement supportSQLiteStatement = this.cleanupStatement;
            if (supportSQLiteStatement != null) {
                supportSQLiteStatement.close();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
    }

    public final void startMultiInstanceInvalidation$room_runtime_release(@NotNull Context context, @NotNull String name, @NotNull Intent serviceIntent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)serviceIntent, (String)"serviceIntent");
        this.multiInstanceInvalidationClient = new MultiInstanceInvalidationClient(context, name, serviceIntent, this, this.database.getQueryExecutor());
    }

    public final void stopMultiInstanceInvalidation$room_runtime_release() {
        MultiInstanceInvalidationClient multiInstanceInvalidationClient = this.multiInstanceInvalidationClient;
        if (multiInstanceInvalidationClient != null) {
            multiInstanceInvalidationClient.stop();
        }
        this.multiInstanceInvalidationClient = null;
    }

    private final void stopTrackingTable(SupportSQLiteDatabase db, int tableId) {
        String tableName = this.tablesNames[tableId];
        for (String trigger : TRIGGERS) {
            String sql;
            StringBuilder stringBuilder;
            StringBuilder $this$stopTrackingTable_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$stopTrackingTable_u24lambda_u243.append("DROP TRIGGER IF EXISTS ");
            $this$stopTrackingTable_u24lambda_u243.append(Companion.getTriggerName$room_runtime_release(tableName, trigger));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            db.execSQL(sql);
        }
    }

    private final void startTrackingTable(SupportSQLiteDatabase db, int tableId) {
        db.execSQL("INSERT OR IGNORE INTO room_table_modification_log VALUES(" + tableId + ", 0)");
        String tableName = this.tablesNames[tableId];
        for (String trigger : TRIGGERS) {
            String sql;
            StringBuilder stringBuilder;
            StringBuilder $this$startTrackingTable_u24lambda_u244 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$startTrackingTable_u24lambda_u244.append("CREATE TEMP TRIGGER IF NOT EXISTS ");
            $this$startTrackingTable_u24lambda_u244.append(Companion.getTriggerName$room_runtime_release(tableName, trigger));
            $this$startTrackingTable_u24lambda_u244.append(" AFTER ");
            $this$startTrackingTable_u24lambda_u244.append(trigger);
            $this$startTrackingTable_u24lambda_u244.append(" ON `");
            $this$startTrackingTable_u24lambda_u244.append(tableName);
            $this$startTrackingTable_u24lambda_u244.append("` BEGIN UPDATE ");
            $this$startTrackingTable_u24lambda_u244.append(UPDATE_TABLE_NAME);
            $this$startTrackingTable_u24lambda_u244.append(" SET ").append(INVALIDATED_COLUMN_NAME);
            $this$startTrackingTable_u24lambda_u244.append(" = 1");
            $this$startTrackingTable_u24lambda_u244.append(" WHERE ").append(TABLE_ID_COLUMN_NAME);
            $this$startTrackingTable_u24lambda_u244.append(" = ").append(tableId);
            $this$startTrackingTable_u24lambda_u244.append(" AND ").append(INVALIDATED_COLUMN_NAME);
            $this$startTrackingTable_u24lambda_u244.append(" = 0");
            $this$startTrackingTable_u24lambda_u244.append("; END");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            db.execSQL(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressLint(value={"RestrictedApi"})
    @WorkerThread
    public void addObserver(@NotNull Observer observer2) {
        ObserverWrapper observerWrapper;
        void $this$mapTo$iv$iv;
        String[] tableNames;
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
        String[] $this$map$iv = tableNames = this.resolveViews(observer2.getTables$room_runtime_release());
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void tableName;
            void item$iv$iv;
            void var12_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var14_16 = tableName;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = var14_16.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            Integer n2 = this.tableIdLookup.get(string);
            if (n2 == null) {
                throw new IllegalArgumentException("There is no table with name " + (String)tableName);
            }
            collection.add(Integer.valueOf(n2));
        }
        int[] tableIds = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        ObserverWrapper wrapper = new ObserverWrapper(observer2, tableIds, tableNames);
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.observerMap;
        synchronized (safeIterableMap) {
            boolean bl = false;
            observerWrapper = (ObserverWrapper)this.observerMap.putIfAbsent((Object)observer2, (Object)wrapper);
        }
        ObserverWrapper currentObserver = observerWrapper;
        if (currentObserver == null && this.observedTableTracker.onAdded(Arrays.copyOf(tableIds, tableIds.length))) {
            this.syncTriggers$room_runtime_release();
        }
    }

    private final String[] validateAndResolveTableNames(String[] tableNames) {
        String[] resolved;
        String[] $this$forEach$iv = resolved = this.resolveViews(tableNames);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String tableName = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String string = tableName;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            if (this.tableIdLookup.containsKey(string2)) continue;
            boolean bl2 = false;
            String string3 = "There is no table with name " + tableName;
            throw new IllegalArgumentException(string3.toString());
        }
        return resolved;
    }

    private final String[] resolveViews(String[] names) {
        Set set;
        Set $this$resolveViews_u24lambda_u2410 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        String[] $this$forEach$iv = names;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String name = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            String string = name;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            if (this.viewTables.containsKey(string2)) {
                string = name;
                Locale locale2 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
                String string3 = string.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                Set<String> set2 = this.viewTables.get(string3);
                Intrinsics.checkNotNull(set2);
                $this$resolveViews_u24lambda_u2410.addAll((Collection)set2);
                continue;
            }
            $this$resolveViews_u24lambda_u2410.add(name);
        }
        Collection $this$toTypedArray$iv = SetsKt.build((Set)set);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void addWeakObserver(@NotNull Observer observer2) {
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
        this.addObserver(new WeakObserver(this, observer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RestrictedApi"})
    @WorkerThread
    public void removeObserver(@NotNull Observer observer2) {
        int[] nArray;
        ObserverWrapper observerWrapper;
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.observerMap;
        synchronized (safeIterableMap) {
            boolean bl = false;
            observerWrapper = (ObserverWrapper)this.observerMap.remove((Object)observer2);
        }
        ObserverWrapper wrapper = observerWrapper;
        if (wrapper != null && this.observedTableTracker.onRemoved(Arrays.copyOf(nArray = wrapper.getTableIds$room_runtime_release(), nArray.length))) {
            this.syncTriggers$room_runtime_release();
        }
    }

    public final boolean ensureInitialization$room_runtime_release() {
        if (!this.database.isOpenInternal()) {
            return false;
        }
        if (!this.initialized) {
            this.database.getOpenHelper().getWritableDatabase();
        }
        if (!this.initialized) {
            Log.e((String)"ROOM", (String)"database is not initialized even though it is open");
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public static /* synthetic */ void getRefreshRunnable$annotations() {
    }

    public void refreshVersionsAsync() {
        if (this.pendingRefresh.compareAndSet(false, true)) {
            AutoCloser autoCloser = this.autoCloser;
            if (autoCloser != null) {
                autoCloser.incrementCountAndEnsureDbIsOpen();
            }
            this.database.getQueryExecutor().execute(this.refreshRunnable);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @WorkerThread
    public void refreshVersionsSync() {
        AutoCloser autoCloser = this.autoCloser;
        if (autoCloser != null) {
            autoCloser.incrementCountAndEnsureDbIsOpen();
        }
        this.syncTriggers$room_runtime_release();
        this.refreshRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting(otherwise=3)
    public final void notifyObserversByTableNames(String ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.observerMap;
        synchronized (safeIterableMap) {
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)this.observerMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(observer, wrapper)");
                Observer observer2 = (Observer)entry.getKey();
                ObserverWrapper wrapper = (ObserverWrapper)entry.getValue();
                if (observer2.isRemote$room_runtime_release()) continue;
                wrapper.notifyByTableNames$room_runtime_release(tables);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void syncTriggers$room_runtime_release(@NotNull SupportSQLiteDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        if (database.inTransaction()) {
            return;
        }
        try {
            Lock closeLock = this.database.getCloseLock$room_runtime_release();
            closeLock.lock();
            try {
                Object object = this.syncTriggersLock;
                synchronized (object) {
                    int[] nArray;
                    block20: {
                        boolean bl = false;
                        if (this.observedTableTracker.getTablesToSync() != null) break block20;
                        return;
                    }
                    int[] tablesToSync = nArray;
                    Companion.beginTransactionInternal$room_runtime_release(database);
                    try {
                        int[] $this$forEachIndexed$iv = tablesToSync;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (int item$iv : $this$forEachIndexed$iv) {
                            void syncState;
                            int n = index$iv++;
                            int n2 = item$iv;
                            int tableId = n;
                            boolean bl = false;
                            switch (syncState) {
                                case 1: {
                                    this.startTrackingTable(database, tableId);
                                    break;
                                }
                                case 2: {
                                    this.stopTrackingTable(database, tableId);
                                }
                            }
                        }
                        database.setTransactionSuccessful();
                    }
                    finally {
                        database.endTransaction();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            finally {
                closeLock.unlock();
            }
        }
        catch (IllegalStateException ex) {
            Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)ex);
        }
        catch (SQLiteException ex) {
            Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)ex);
        }
    }

    public final void syncTriggers$room_runtime_release() {
        if (!this.database.isOpenInternal()) {
            return;
        }
        this.syncTriggers$room_runtime_release(this.database.getOpenHelper().getWritableDatabase());
    }

    @Deprecated(message="Use [createLiveData(String[], boolean, Callable)]")
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public <T> LiveData<T> createLiveData(@NotNull String[] tableNames, @NotNull Callable<T> computeFunction) {
        Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
        Intrinsics.checkNotNullParameter(computeFunction, (String)"computeFunction");
        return this.createLiveData(tableNames, false, computeFunction);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public <T> LiveData<T> createLiveData(@NotNull String[] tableNames, boolean inTransaction2, @NotNull Callable<T> computeFunction) {
        Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
        Intrinsics.checkNotNullParameter(computeFunction, (String)"computeFunction");
        return this.invalidationLiveDataContainer.create(this.validateAndResolveTableNames(tableNames), inTransaction2, computeFunction);
    }

    public static final /* synthetic */ AutoCloser access$getAutoCloser$p(InvalidationTracker $this) {
        return $this.autoCloser;
    }

    static {
        String[] stringArray = new String[]{"UPDATE", "DELETE", "INSERT"};
        TRIGGERS = stringArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0016\u0010\b\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/room/InvalidationTracker$Companion;", "", "()V", "CREATE_TRACKING_TABLE_SQL", "", "INVALIDATED_COLUMN_NAME", "RESET_UPDATED_TABLES_SQL", "getRESET_UPDATED_TABLES_SQL$room_runtime_release$annotations", "SELECT_UPDATED_TABLES_SQL", "getSELECT_UPDATED_TABLES_SQL$room_runtime_release$annotations", "TABLE_ID_COLUMN_NAME", "TRIGGERS", "", "[Ljava/lang/String;", "UPDATE_TABLE_NAME", "beginTransactionInternal", "", "database", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "beginTransactionInternal$room_runtime_release", "getTriggerName", "tableName", "triggerType", "getTriggerName$room_runtime_release", "room-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getRESET_UPDATED_TABLES_SQL$room_runtime_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSELECT_UPDATED_TABLES_SQL$room_runtime_release$annotations() {
        }

        @NotNull
        public final String getTriggerName$room_runtime_release(@NotNull String tableName, @NotNull String triggerType) {
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            Intrinsics.checkNotNullParameter((Object)triggerType, (String)"triggerType");
            return "`room_table_modification_trigger_" + tableName + '_' + triggerType + '`';
        }

        public final void beginTransactionInternal$room_runtime_release(@NotNull SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            if (Build.VERSION.SDK_INT >= 16 && database.isWriteAheadLoggingEnabled()) {
                database.beginTransactionNonExclusive();
            } else {
                database.beginTransaction();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010\u0014\u001a\u00020\u00062\n\u0010\u0015\u001a\u00020\u0010\"\u00020\u0003J\u0012\u0010\u0016\u001a\u00020\u00062\n\u0010\u0015\u001a\u00020\u0010\"\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/room/InvalidationTracker$ObservedTableTracker;", "", "tableCount", "", "(I)V", "needsSync", "", "getNeedsSync", "()Z", "setNeedsSync", "(Z)V", "tableObservers", "", "getTableObservers", "()[J", "triggerStateChanges", "", "triggerStates", "", "getTablesToSync", "onAdded", "tableIds", "onRemoved", "resetTriggerState", "", "Companion", "room-runtime_release"})
    @SourceDebugExtension(value={"SMAP\nInvalidationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidationTracker.kt\nandroidx/room/InvalidationTracker$ObservedTableTracker\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,846:1\n13600#2,2:847\n13600#2,2:849\n13684#2,3:851\n*S KotlinDebug\n*F\n+ 1 InvalidationTracker.kt\nandroidx/room/InvalidationTracker$ObservedTableTracker\n*L\n718#1:847,2\n736#1:849,2\n772#1:851,3\n*E\n"})
    public static final class ObservedTableTracker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final long[] tableObservers;
        @NotNull
        private final boolean[] triggerStates;
        @NotNull
        private final int[] triggerStateChanges;
        private boolean needsSync;
        public static final int NO_OP = 0;
        public static final int ADD = 1;
        public static final int REMOVE = 2;

        public ObservedTableTracker(int tableCount) {
            this.tableObservers = new long[tableCount];
            this.triggerStates = new boolean[tableCount];
            this.triggerStateChanges = new int[tableCount];
        }

        @NotNull
        public final long[] getTableObservers() {
            return this.tableObservers;
        }

        public final boolean getNeedsSync() {
            return this.needsSync;
        }

        public final void setNeedsSync(boolean bl) {
            this.needsSync = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean onAdded(int ... tableIds) {
            Intrinsics.checkNotNullParameter((Object)tableIds, (String)"tableIds");
            boolean needTriggerSync = false;
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                boolean bl = false;
                int[] $this$forEach$iv = tableIds;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int tableId = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    long prevObserverCount = this.tableObservers[tableId];
                    this.tableObservers[tableId] = prevObserverCount + 1L;
                    if (prevObserverCount != 0L) continue;
                    this.needsSync = true;
                    needTriggerSync = true;
                }
                Unit unit = Unit.INSTANCE;
            }
            return needTriggerSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean onRemoved(int ... tableIds) {
            Intrinsics.checkNotNullParameter((Object)tableIds, (String)"tableIds");
            boolean needTriggerSync = false;
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                boolean bl = false;
                int[] $this$forEach$iv = tableIds;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int tableId = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    long prevObserverCount = this.tableObservers[tableId];
                    this.tableObservers[tableId] = prevObserverCount - 1L;
                    if (prevObserverCount != 1L) continue;
                    this.needsSync = true;
                    needTriggerSync = true;
                }
                Unit unit = Unit.INSTANCE;
            }
            return needTriggerSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void resetTriggerState() {
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                boolean bl = false;
                Arrays.fill(this.triggerStates, false);
                this.needsSync = true;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @VisibleForTesting
        @JvmName(name="getTablesToSync")
        @Nullable
        public final int[] getTablesToSync() {
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                block5: {
                    boolean bl = false;
                    if (this.needsSync) break block5;
                    int[] nArray = null;
                    return nArray;
                }
                long[] $this$forEachIndexed$iv = this.tableObservers;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (long item$iv : $this$forEachIndexed$iv) {
                    void observerCount;
                    boolean newState;
                    int n = index$iv++;
                    long l = item$iv;
                    int i = n;
                    boolean bl = false;
                    boolean bl2 = newState = observerCount > 0L;
                    this.triggerStateChanges[i] = newState != this.triggerStates[i] ? (newState ? 1 : 2) : 0;
                    this.triggerStates[i] = newState;
                }
                this.needsSync = false;
                int[] nArray = (int[])this.triggerStateChanges.clone();
                return nArray;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/room/InvalidationTracker$ObservedTableTracker$Companion;", "", "()V", "ADD", "", "NO_OP", "REMOVE", "room-runtime_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010\"\n\u0000\b&\u0018\u00002\u00020\u0001B#\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H&R\u0014\u0010\t\u001a\u00020\n8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Landroidx/room/InvalidationTracker$Observer;", "", "firstTable", "", "rest", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "tables", "([Ljava/lang/String;)V", "isRemote", "", "isRemote$room_runtime_release", "()Z", "getTables$room_runtime_release", "()[Ljava/lang/String;", "[Ljava/lang/String;", "onInvalidated", "", "", "room-runtime_release"})
    @SourceDebugExtension(value={"SMAP\nInvalidationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidationTracker.kt\nandroidx/room/InvalidationTracker$Observer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,846:1\n37#2,2:847\n*S KotlinDebug\n*F\n+ 1 InvalidationTracker.kt\nandroidx/room/InvalidationTracker$Observer\n*L\n677#1:847,2\n*E\n"})
    public static abstract class Observer {
        @NotNull
        private final String[] tables;

        public Observer(@NotNull String[] tables) {
            Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
            this.tables = tables;
        }

        @NotNull
        public final String[] getTables$room_runtime_release() {
            return this.tables;
        }

        /*
         * WARNING - void declaration
         */
        protected Observer(@NotNull String firstTable, String ... rest) {
            void $this$_init__u24lambda_u240;
            List list;
            Intrinsics.checkNotNullParameter((Object)firstTable, (String)"firstTable");
            Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
            List list2 = list = CollectionsKt.createListBuilder();
            Observer observer2 = this;
            boolean bl = false;
            CollectionsKt.addAll((Collection)((Collection)$this$_init__u24lambda_u240), (Object[])rest);
            $this$_init__u24lambda_u240.add(firstTable);
            Collection $this$toTypedArray$iv = CollectionsKt.build((List)list);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            observer2(thisCollection$iv.toArray(new String[0]));
        }

        public abstract void onInvalidated(@NotNull Set<String> var1);

        public boolean isRemote$room_runtime_release() {
            return false;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\rH\u0000\u00a2\u0006\u0002\b\u0015J\u001f\u0010\u0016\u001a\u00020\u00122\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u001a"}, d2={"Landroidx/room/InvalidationTracker$ObserverWrapper;", "", "observer", "Landroidx/room/InvalidationTracker$Observer;", "tableIds", "", "tableNames", "", "", "(Landroidx/room/InvalidationTracker$Observer;[I[Ljava/lang/String;)V", "getObserver$room_runtime_release", "()Landroidx/room/InvalidationTracker$Observer;", "singleTableSet", "", "getTableIds$room_runtime_release", "()[I", "[Ljava/lang/String;", "notifyByTableInvalidStatus", "", "invalidatedTablesIds", "", "notifyByTableInvalidStatus$room_runtime_release", "notifyByTableNames", "tables", "notifyByTableNames$room_runtime_release", "([Ljava/lang/String;)V", "room-runtime_release"})
    @SourceDebugExtension(value={"SMAP\nInvalidationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InvalidationTracker.kt\nandroidx/room/InvalidationTracker$ObserverWrapper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,846:1\n13674#2,3:847\n12744#2,2:850\n13579#2:852\n13579#2,2:853\n13580#2:855\n*S KotlinDebug\n*F\n+ 1 InvalidationTracker.kt\nandroidx/room/InvalidationTracker$ObserverWrapper\n*L\n619#1:847,3\n641#1:850,2\n647#1:852\n648#1:853,2\n647#1:855\n*E\n"})
    public static final class ObserverWrapper {
        @NotNull
        private final Observer observer;
        @NotNull
        private final int[] tableIds;
        @NotNull
        private final String[] tableNames;
        @NotNull
        private final Set<String> singleTableSet;

        public ObserverWrapper(@NotNull Observer observer2, @NotNull int[] tableIds, @NotNull String[] tableNames) {
            Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
            Intrinsics.checkNotNullParameter((Object)tableIds, (String)"tableIds");
            Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
            this.observer = observer2;
            this.tableIds = tableIds;
            this.tableNames = tableNames;
            this.singleTableSet = !(this.tableNames.length == 0) ? SetsKt.setOf((Object)this.tableNames[0]) : SetsKt.emptySet();
            if (!(this.tableIds.length == this.tableNames.length)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }

        @NotNull
        public final Observer getObserver$room_runtime_release() {
            return this.observer;
        }

        @NotNull
        public final int[] getTableIds$room_runtime_release() {
            return this.tableIds;
        }

        /*
         * WARNING - void declaration
         */
        public final void notifyByTableInvalidStatus$room_runtime_release(@NotNull Set<Integer> invalidatedTablesIds) {
            Set invalidatedTables;
            Intrinsics.checkNotNullParameter(invalidatedTablesIds, (String)"invalidatedTablesIds");
            switch (this.tableIds.length) {
                case 0: {
                    Set set2 = SetsKt.emptySet();
                    break;
                }
                case 1: {
                    Set set2;
                    if (invalidatedTablesIds.contains(this.tableIds[0])) {
                        set2 = this.singleTableSet;
                        break;
                    }
                    set2 = SetsKt.emptySet();
                    break;
                }
                default: {
                    Set set;
                    Set $this$notifyByTableInvalidStatus_u24lambda_u241 = set = SetsKt.createSetBuilder();
                    boolean bl = false;
                    int[] $this$forEachIndexed$iv = this.tableIds;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (int item$iv : $this$forEachIndexed$iv) {
                        void tableId;
                        int n = index$iv++;
                        int n2 = item$iv;
                        int idx = n;
                        boolean bl2 = false;
                        if (!invalidatedTablesIds.contains((int)tableId)) continue;
                        $this$notifyByTableInvalidStatus_u24lambda_u241.add(this.tableNames[idx]);
                    }
                    Set set2 = invalidatedTables = SetsKt.build((Set)set);
                }
            }
            if (!((Collection)invalidatedTables).isEmpty()) {
                this.observer.onInvalidated(invalidatedTables);
            }
        }

        /*
         * Unable to fully structure code
         */
        public final void notifyByTableNames$room_runtime_release(@NotNull String[] tables) {
            Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
            switch (this.tableNames.length) {
                case 0: {
                    v0 = SetsKt.emptySet();
                    break;
                }
                case 1: {
                    $this$any$iv = tables;
                    $i$f$any = false;
                    var6_6 = $this$any$iv.length;
                    for (var5_5 = 0; var5_5 < var6_6; ++var5_5) {
                        it = element$iv = $this$any$iv[var5_5];
                        $i$a$-any-InvalidationTracker$ObserverWrapper$notifyByTableNames$invalidatedTables$1 = false;
                        if (!StringsKt.equals((String)it, (String)this.tableNames[0], (boolean)true)) continue;
                        v1 = true;
                        ** GOTO lbl17
                    }
                    v1 = false;
lbl17:
                    // 2 sources

                    if (v1) {
                        v0 = this.singleTableSet;
                        break;
                    }
                    v0 = SetsKt.emptySet();
                    break;
                }
                default: {
                    $this$notifyByTableNames_u24lambda_u245 = var3_2 = SetsKt.createSetBuilder();
                    $i$a$-buildSet-InvalidationTracker$ObserverWrapper$notifyByTableNames$invalidatedTables$2 = false;
                    $this$forEach$iv = tables;
                    $i$f$forEach = false;
                    var9_12 = $this$forEach$iv.length;
                    for (var8_11 = 0; var8_11 < var9_12; ++var8_11) {
                        table = element$iv = $this$forEach$iv[var8_11];
                        $i$a$-forEach-InvalidationTracker$ObserverWrapper$notifyByTableNames$invalidatedTables$2$1 = false;
                        $this$forEach$iv = this.tableNames;
                        $i$f$forEach = false;
                        var16_19 = $this$forEach$iv.length;
                        for (var15_18 = 0; var15_18 < var16_19; ++var15_18) {
                            ourTable = element$iv = $this$forEach$iv[var15_18];
                            $i$a$-forEach-InvalidationTracker$ObserverWrapper$notifyByTableNames$invalidatedTables$2$1$1 = false;
                            if (!StringsKt.equals((String)ourTable, (String)table, (boolean)true)) continue;
                            $this$notifyByTableNames_u24lambda_u245.add(ourTable);
                        }
                    }
                    v0 = invalidatedTables = SetsKt.build((Set)var3_2);
                }
            }
            if (((Collection)invalidatedTables).isEmpty() == false) {
                this.observer.onInvalidated(invalidatedTables);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Landroidx/room/InvalidationTracker$WeakObserver;", "Landroidx/room/InvalidationTracker$Observer;", "tracker", "Landroidx/room/InvalidationTracker;", "delegate", "(Landroidx/room/InvalidationTracker;Landroidx/room/InvalidationTracker$Observer;)V", "delegateRef", "Ljava/lang/ref/WeakReference;", "getDelegateRef", "()Ljava/lang/ref/WeakReference;", "getTracker", "()Landroidx/room/InvalidationTracker;", "onInvalidated", "", "tables", "", "", "room-runtime_release"})
    public static final class WeakObserver
    extends Observer {
        @NotNull
        private final InvalidationTracker tracker;
        @NotNull
        private final WeakReference<Observer> delegateRef;

        public WeakObserver(@NotNull InvalidationTracker tracker, @NotNull Observer delegate) {
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate.getTables$room_runtime_release());
            this.tracker = tracker;
            this.delegateRef = new WeakReference<Observer>(delegate);
        }

        @NotNull
        public final InvalidationTracker getTracker() {
            return this.tracker;
        }

        @NotNull
        public final WeakReference<Observer> getDelegateRef() {
            return this.delegateRef;
        }

        @Override
        public void onInvalidated(@NotNull Set<String> tables) {
            Intrinsics.checkNotNullParameter(tables, (String)"tables");
            Observer observer2 = (Observer)this.delegateRef.get();
            if (observer2 == null) {
                this.tracker.removeObserver(this);
            } else {
                observer2.onInvalidated(tables);
            }
        }
    }
}

