/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.database.Cursor;
import android.os.Build;
import androidx.annotation.RestrictTo;
import androidx.room.DatabaseConfiguration;
import androidx.room.RoomMasterTable;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.io.Closeable;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0003\u0019\u001a\u001bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/room/RoomOpenHelper;", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;", "configuration", "Landroidx/room/DatabaseConfiguration;", "delegate", "Landroidx/room/RoomOpenHelper$Delegate;", "legacyHash", "", "(Landroidx/room/DatabaseConfiguration;Landroidx/room/RoomOpenHelper$Delegate;Ljava/lang/String;)V", "identityHash", "(Landroidx/room/DatabaseConfiguration;Landroidx/room/RoomOpenHelper$Delegate;Ljava/lang/String;Ljava/lang/String;)V", "checkIdentity", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "createMasterTableIfNotExists", "onConfigure", "onCreate", "onDowngrade", "oldVersion", "", "newVersion", "onOpen", "onUpgrade", "updateIdentity", "Companion", "Delegate", "ValidationResult", "room-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class RoomOpenHelper
extends SupportSQLiteOpenHelper.Callback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DatabaseConfiguration configuration;
    @NotNull
    private final Delegate delegate;
    @NotNull
    private final String identityHash;
    @NotNull
    private final String legacyHash;

    public RoomOpenHelper(@NotNull DatabaseConfiguration configuration2, @NotNull Delegate delegate, @NotNull String identityHash, @NotNull String legacyHash) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)identityHash, (String)"identityHash");
        Intrinsics.checkNotNullParameter((Object)legacyHash, (String)"legacyHash");
        super(delegate.version);
        this.configuration = configuration2;
        this.delegate = delegate;
        this.identityHash = identityHash;
        this.legacyHash = legacyHash;
    }

    public RoomOpenHelper(@NotNull DatabaseConfiguration configuration2, @NotNull Delegate delegate, @NotNull String legacyHash) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)legacyHash, (String)"legacyHash");
        this(configuration2, delegate, "", legacyHash);
    }

    public void onConfigure(@NotNull SupportSQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        super.onConfigure(db);
    }

    public void onCreate(@NotNull SupportSQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        boolean isEmptyDatabase = Companion.hasEmptySchema$room_runtime_release(db);
        this.delegate.createAllTables(db);
        if (!isEmptyDatabase) {
            ValidationResult result = this.delegate.onValidateSchema(db);
            if (!result.isValid) {
                throw new IllegalStateException("Pre-packaged database has an invalid schema: " + result.expectedFoundMsg);
            }
        }
        this.updateIdentity(db);
        this.delegate.onCreate(db);
    }

    public void onUpgrade(@NotNull SupportSQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        boolean migrated = false;
        DatabaseConfiguration databaseConfiguration = this.configuration;
        if (databaseConfiguration != null) {
            DatabaseConfiguration config = databaseConfiguration;
            boolean bl = false;
            List<Migration> migrations = config.migrationContainer.findMigrationPath(oldVersion, newVersion);
            if (migrations != null) {
                this.delegate.onPreMigrate(db);
                Iterable $this$forEach$iv = migrations;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Migration it = (Migration)element$iv;
                    boolean bl2 = false;
                    it.migrate(db);
                }
                ValidationResult result = this.delegate.onValidateSchema(db);
                if (!result.isValid) {
                    throw new IllegalStateException("Migration didn't properly handle: " + result.expectedFoundMsg);
                }
                this.delegate.onPostMigrate(db);
                this.updateIdentity(db);
                migrated = true;
            }
        }
        if (!migrated) {
            DatabaseConfiguration config = this.configuration;
            if (config != null && !config.isMigrationRequired(oldVersion, newVersion)) {
                this.delegate.dropAllTables(db);
                this.delegate.createAllTables(db);
            } else {
                throw new IllegalStateException("A migration from " + oldVersion + " to " + newVersion + " was required but not found. Please provide the necessary Migration path via RoomDatabase.Builder.addMigration(Migration ...) or allow for destructive migrations via one of the RoomDatabase.Builder.fallbackToDestructiveMigration* methods.");
            }
        }
    }

    public void onDowngrade(@NotNull SupportSQLiteDatabase db, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.onUpgrade(db, oldVersion, newVersion);
    }

    public void onOpen(@NotNull SupportSQLiteDatabase db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        super.onOpen(db);
        this.checkIdentity(db);
        this.delegate.onOpen(db);
        this.configuration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkIdentity(SupportSQLiteDatabase db) {
        if (Companion.hasRoomMasterTable$room_runtime_release(db)) {
            Object object;
            Object object2;
            Cursor $this$useCursor$iv = db.query((SupportSQLiteQuery)new SimpleSQLiteQuery("SELECT identity_hash FROM room_master_table WHERE id = 42 LIMIT 1"));
            boolean $i$f$useCursor = false;
            if (Build.VERSION.SDK_INT > 15) {
                object2 = (Closeable)$this$useCursor$iv;
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)object2;
                    boolean bl = false;
                    String string = cursor.moveToFirst() ? cursor.getString(0) : (String)null;
                    object = string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
            }
            try {
                Cursor cursor = $this$useCursor$iv;
                boolean bl = false;
                object2 = cursor.moveToFirst() ? cursor.getString(0) : (String)null;
                object = object2;
            }
            finally {
                $this$useCursor$iv.close();
            }
            Object identityHash = object;
            if (!Intrinsics.areEqual((Object)this.identityHash, (Object)identityHash) && !Intrinsics.areEqual((Object)this.legacyHash, (Object)identityHash)) {
                throw new IllegalStateException("Room cannot verify the data integrity. Looks like you've changed schema but forgot to update the version number. You can simply fix this by increasing the version number. Expected identity hash: " + this.identityHash + ", found: " + (String)identityHash);
            }
        } else {
            ValidationResult result = this.delegate.onValidateSchema(db);
            if (!result.isValid) {
                throw new IllegalStateException("Pre-packaged database has an invalid schema: " + result.expectedFoundMsg);
            }
            this.delegate.onPostMigrate(db);
            this.updateIdentity(db);
        }
    }

    private final void updateIdentity(SupportSQLiteDatabase db) {
        this.createMasterTableIfNotExists(db);
        db.execSQL(RoomMasterTable.createInsertQuery((String)this.identityHash));
    }

    private final void createMasterTableIfNotExists(SupportSQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0015R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/room/RoomOpenHelper$Delegate;", "", "version", "", "(I)V", "createAllTables", "", "database", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "dropAllTables", "onCreate", "onOpen", "onPostMigrate", "onPreMigrate", "onValidateSchema", "Landroidx/room/RoomOpenHelper$ValidationResult;", "db", "validateMigration", "room-runtime_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static abstract class Delegate {
        @JvmField
        public final int version;

        public Delegate(int version2) {
            this.version = version2;
        }

        public abstract void dropAllTables(@NotNull SupportSQLiteDatabase var1);

        public abstract void createAllTables(@NotNull SupportSQLiteDatabase var1);

        public abstract void onOpen(@NotNull SupportSQLiteDatabase var1);

        public abstract void onCreate(@NotNull SupportSQLiteDatabase var1);

        @Deprecated(message="Use [onValidateSchema(SupportSQLiteDatabase)]")
        protected void validateMigration(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            throw new UnsupportedOperationException("validateMigration is deprecated");
        }

        @NotNull
        public ValidationResult onValidateSchema(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            this.validateMigration(db);
            return new ValidationResult(true, null);
        }

        public void onPreMigrate(@NotNull SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        }

        public void onPostMigrate(@NotNull SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/room/RoomOpenHelper$ValidationResult;", "", "isValid", "", "expectedFoundMsg", "", "(ZLjava/lang/String;)V", "room-runtime_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static class ValidationResult {
        @JvmField
        public final boolean isValid;
        @JvmField
        @Nullable
        public final String expectedFoundMsg;

        public ValidationResult(boolean isValid, @Nullable String expectedFoundMsg) {
            this.isValid = isValid;
            this.expectedFoundMsg = expectedFoundMsg;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Landroidx/room/RoomOpenHelper$Companion;", "", "()V", "hasEmptySchema", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "hasEmptySchema$room_runtime_release", "hasRoomMasterTable", "hasRoomMasterTable$room_runtime_release", "room-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean hasRoomMasterTable$room_runtime_release(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Cursor $this$useCursor$iv = db.query("SELECT 1 FROM sqlite_master WHERE type = 'table' AND name='room_master_table'");
            boolean $i$f$useCursor = false;
            if (Build.VERSION.SDK_INT > 15) {
                Closeable closeable = (Closeable)$this$useCursor$iv;
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)closeable;
                    boolean bl = false;
                    boolean bl2 = cursor.moveToFirst() && cursor.getInt(0) != 0;
                    return bl2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            try {
                Cursor cursor = $this$useCursor$iv;
                boolean bl = false;
                boolean bl3 = cursor.moveToFirst() && cursor.getInt(0) != 0;
                return bl3;
            }
            finally {
                $this$useCursor$iv.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean hasEmptySchema$room_runtime_release(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            Cursor $this$useCursor$iv = db.query("SELECT count(*) FROM sqlite_master WHERE name != 'android_metadata'");
            boolean $i$f$useCursor = false;
            if (Build.VERSION.SDK_INT > 15) {
                Closeable closeable = (Closeable)$this$useCursor$iv;
                Throwable throwable = null;
                try {
                    Cursor cursor = (Cursor)closeable;
                    boolean bl = false;
                    boolean bl2 = cursor.moveToFirst() && cursor.getInt(0) == 0;
                    return bl2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            try {
                Cursor cursor = $this$useCursor$iv;
                boolean bl = false;
                boolean bl3 = cursor.moveToFirst() && cursor.getInt(0) == 0;
                return bl3;
            }
            finally {
                $this$useCursor$iv.close();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

