/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.Cursor;
import android.os.Build;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a\"\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a \u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0000\u00a8\u0006\u0017"}, d2={"readColumns", "", "", "Landroidx/room/util/TableInfo$Column;", "database", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "tableName", "readForeignKeyFieldMappings", "", "Landroidx/room/util/TableInfo$ForeignKeyWithSequence;", "cursor", "Landroid/database/Cursor;", "readForeignKeys", "", "Landroidx/room/util/TableInfo$ForeignKey;", "readIndex", "Landroidx/room/util/TableInfo$Index;", "name", "unique", "", "readIndices", "readTableInfo", "Landroidx/room/util/TableInfo;", "room-runtime_release"})
public final class TableInfoKt {
    @NotNull
    public static final TableInfo readTableInfo(@NotNull SupportSQLiteDatabase database, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Map<String, TableInfo.Column> columns = TableInfoKt.readColumns(database, tableName);
        Set<TableInfo.ForeignKey> foreignKeys = TableInfoKt.readForeignKeys(database, tableName);
        Set<TableInfo.Index> indices = TableInfoKt.readIndices(database, tableName);
        return new TableInfo(tableName, columns, foreignKeys, indices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Set<TableInfo.ForeignKey> readForeignKeys(SupportSQLiteDatabase database, String tableName) {
        Cursor cursor = database.query("PRAGMA foreign_key_list(`" + tableName + "`)");
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"database.query(\"PRAGMA f\u2026_key_list(`$tableName`)\")");
        Cursor $this$useCursor$iv = cursor;
        boolean $i$f$useCursor = false;
        if (Build.VERSION.SDK_INT > 15) {
            Closeable closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                Set set;
                Cursor cursor2 = (Cursor)closeable;
                boolean bl = false;
                int idColumnIndex = cursor2.getColumnIndex("id");
                int seqColumnIndex = cursor2.getColumnIndex("seq");
                int tableColumnIndex = cursor2.getColumnIndex("table");
                int onDeleteColumnIndex = cursor2.getColumnIndex("on_delete");
                int onUpdateColumnIndex = cursor2.getColumnIndex("on_update");
                List<TableInfo.ForeignKeyWithSequence> ordered = TableInfoKt.readForeignKeyFieldMappings(cursor2);
                cursor2.moveToPosition(-1);
                Set $this$readForeignKeys_u24lambda_u2d3_u24lambda_u2d2 = set = SetsKt.createSetBuilder();
                boolean bl2 = false;
                while (cursor2.moveToNext()) {
                    void $this$forEach$iv;
                    Iterator $this$filterTo$iv$iv;
                    int seq = cursor2.getInt(seqColumnIndex);
                    if (seq != 0) continue;
                    int id = cursor2.getInt(idColumnIndex);
                    List myColumns = new ArrayList();
                    List refColumns = new ArrayList();
                    Iterable $this$filter$iv = ordered;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    Iterator iterator = $this$filterTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv$iv = iterator.next();
                        TableInfo.ForeignKeyWithSequence it = (TableInfo.ForeignKeyWithSequence)element$iv$iv;
                        boolean bl3 = false;
                        if (!(it.getId() == id)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    $this$filterTo$iv$iv = $this$forEach$iv.iterator();
                    while ($this$filterTo$iv$iv.hasNext()) {
                        Object element$iv = $this$filterTo$iv$iv.next();
                        TableInfo.ForeignKeyWithSequence key = (TableInfo.ForeignKeyWithSequence)element$iv;
                        boolean bl4 = false;
                        myColumns.add(key.getFrom());
                        refColumns.add(key.getTo());
                    }
                    String string = cursor2.getString(tableColumnIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(tableColumnIndex)");
                    String string2 = cursor2.getString(onDeleteColumnIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cursor.getString(onDeleteColumnIndex)");
                    String string3 = cursor2.getString(onUpdateColumnIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"cursor.getString(onUpdateColumnIndex)");
                    $this$readForeignKeys_u24lambda_u2d3_u24lambda_u2d2.add(new TableInfo.ForeignKey(string, string2, string3, myColumns, refColumns));
                }
                Set set2 = SetsKt.build((Set)set);
                return set2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        try {
            Set set;
            Cursor cursor3 = $this$useCursor$iv;
            boolean bl = false;
            int idColumnIndex = cursor3.getColumnIndex("id");
            int seqColumnIndex = cursor3.getColumnIndex("seq");
            int tableColumnIndex = cursor3.getColumnIndex("table");
            int onDeleteColumnIndex = cursor3.getColumnIndex("on_delete");
            int onUpdateColumnIndex = cursor3.getColumnIndex("on_update");
            List<TableInfo.ForeignKeyWithSequence> ordered = TableInfoKt.readForeignKeyFieldMappings(cursor3);
            cursor3.moveToPosition(-1);
            Set $this$readForeignKeys_u24lambda_u2d3_u24lambda_u2d2 = set = SetsKt.createSetBuilder();
            boolean bl5 = false;
            while (cursor3.moveToNext()) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                int seq = cursor3.getInt(seqColumnIndex);
                if (seq != 0) continue;
                int id = cursor3.getInt(idColumnIndex);
                List myColumns = new ArrayList();
                List refColumns = new ArrayList();
                Iterable $this$filter$iv = ordered;
                boolean $i$f$filter = false;
                Iterable element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TableInfo.ForeignKeyWithSequence it = (TableInfo.ForeignKeyWithSequence)element$iv$iv;
                    boolean bl6 = false;
                    if (!(it.getId() == id)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    TableInfo.ForeignKeyWithSequence key = (TableInfo.ForeignKeyWithSequence)element$iv2;
                    boolean bl7 = false;
                    myColumns.add(key.getFrom());
                    refColumns.add(key.getTo());
                }
                String string = cursor3.getString(tableColumnIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(tableColumnIndex)");
                String string4 = cursor3.getString(onDeleteColumnIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"cursor.getString(onDeleteColumnIndex)");
                String string5 = cursor3.getString(onUpdateColumnIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"cursor.getString(onUpdateColumnIndex)");
                $this$readForeignKeys_u24lambda_u2d3_u24lambda_u2d2.add(new TableInfo.ForeignKey(string, string4, string5, myColumns, refColumns));
            }
            Set set3 = SetsKt.build((Set)set);
            return set3;
        }
        finally {
            $this$useCursor$iv.close();
        }
    }

    private static final List<TableInfo.ForeignKeyWithSequence> readForeignKeyFieldMappings(Cursor cursor) {
        List list;
        int idColumnIndex = cursor.getColumnIndex("id");
        int seqColumnIndex = cursor.getColumnIndex("seq");
        int fromColumnIndex = cursor.getColumnIndex("from");
        int toColumnIndex = cursor.getColumnIndex("to");
        List $this$readForeignKeyFieldMappings_u24lambda_u2d4 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (cursor.moveToNext()) {
            int n = cursor.getInt(idColumnIndex);
            int n2 = cursor.getInt(seqColumnIndex);
            String string = cursor.getString(fromColumnIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cursor.getString(fromColumnIndex)");
            String string2 = cursor.getString(toColumnIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cursor.getString(toColumnIndex)");
            $this$readForeignKeyFieldMappings_u24lambda_u2d4.add(new TableInfo.ForeignKeyWithSequence(n, n2, string, string2));
        }
        return CollectionsKt.sorted((Iterable)CollectionsKt.build((List)list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map<String, TableInfo.Column> readColumns(SupportSQLiteDatabase database, String tableName) {
        Cursor cursor = database.query("PRAGMA table_info(`" + tableName + "`)");
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"database.query(\"PRAGMA table_info(`$tableName`)\")");
        Cursor $this$useCursor$iv = cursor;
        boolean $i$f$useCursor = false;
        if (Build.VERSION.SDK_INT > 15) {
            Closeable closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                Map map;
                Cursor cursor2 = (Cursor)closeable;
                boolean bl = false;
                if (cursor2.getColumnCount() <= 0) {
                    Map map2 = MapsKt.emptyMap();
                    return map2;
                }
                int nameIndex = cursor2.getColumnIndex("name");
                int typeIndex = cursor2.getColumnIndex("type");
                int notNullIndex = cursor2.getColumnIndex("notnull");
                int pkIndex = cursor2.getColumnIndex("pk");
                int defaultValueIndex = cursor2.getColumnIndex("dflt_value");
                Map $this$readColumns_u24lambda_u2d6_u24lambda_u2d5 = map = MapsKt.createMapBuilder();
                boolean bl2 = false;
                while (cursor2.moveToNext()) {
                    String name = cursor2.getString(nameIndex);
                    String type = cursor2.getString(typeIndex);
                    boolean notNull = cursor2.getInt(notNullIndex) != 0;
                    int primaryKeyPosition = cursor2.getInt(pkIndex);
                    String defaultValue = cursor2.getString(defaultValueIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
                    $this$readColumns_u24lambda_u2d6_u24lambda_u2d5.put(name, new TableInfo.Column(name, type, notNull, primaryKeyPosition, defaultValue, 2));
                }
                Map map3 = MapsKt.build((Map)map);
                return map3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        try {
            Map map;
            Cursor cursor3 = $this$useCursor$iv;
            boolean bl = false;
            if (cursor3.getColumnCount() <= 0) {
                Map map4 = MapsKt.emptyMap();
                return map4;
            }
            int nameIndex = cursor3.getColumnIndex("name");
            int typeIndex = cursor3.getColumnIndex("type");
            int notNullIndex = cursor3.getColumnIndex("notnull");
            int pkIndex = cursor3.getColumnIndex("pk");
            int defaultValueIndex = cursor3.getColumnIndex("dflt_value");
            Map $this$readColumns_u24lambda_u2d6_u24lambda_u2d5 = map = MapsKt.createMapBuilder();
            boolean bl3 = false;
            while (cursor3.moveToNext()) {
                String name = cursor3.getString(nameIndex);
                String type = cursor3.getString(typeIndex);
                boolean notNull = cursor3.getInt(notNullIndex) != 0;
                int primaryKeyPosition = cursor3.getInt(pkIndex);
                String defaultValue = cursor3.getString(defaultValueIndex);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
                $this$readColumns_u24lambda_u2d6_u24lambda_u2d5.put(name, new TableInfo.Column(name, type, notNull, primaryKeyPosition, defaultValue, 2));
            }
            Map map5 = MapsKt.build((Map)map);
            return map5;
        }
        finally {
            $this$useCursor$iv.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Set<TableInfo.Index> readIndices(SupportSQLiteDatabase database, String tableName) {
        Cursor cursor = database.query("PRAGMA index_list(`" + tableName + "`)");
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"database.query(\"PRAGMA index_list(`$tableName`)\")");
        Cursor $this$useCursor$iv = cursor;
        boolean $i$f$useCursor = false;
        if (Build.VERSION.SDK_INT > 15) {
            Closeable closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                Set set;
                Cursor cursor2 = (Cursor)closeable;
                boolean bl = false;
                int nameColumnIndex = cursor2.getColumnIndex("name");
                int originColumnIndex = cursor2.getColumnIndex("origin");
                int uniqueIndex = cursor2.getColumnIndex("unique");
                if (nameColumnIndex == -1 || originColumnIndex == -1 || uniqueIndex == -1) {
                    Set<TableInfo.Index> set2 = null;
                    return set2;
                }
                Set $this$readIndices_u24lambda_u2d8_u24lambda_u2d7 = set = SetsKt.createSetBuilder();
                boolean bl2 = false;
                while (cursor2.moveToNext()) {
                    TableInfo.Index index;
                    String origin = cursor2.getString(originColumnIndex);
                    if (!Intrinsics.areEqual((Object)"c", (Object)origin)) continue;
                    String name = cursor2.getString(nameColumnIndex);
                    boolean unique = cursor2.getInt(uniqueIndex) == 1;
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    if (TableInfoKt.readIndex(database, name, unique) == null) {
                        Set<TableInfo.Index> set3 = null;
                        return set3;
                    }
                    TableInfo.Index index2 = index;
                    $this$readIndices_u24lambda_u2d8_u24lambda_u2d7.add(index2);
                }
                Set set4 = SetsKt.build((Set)set);
                return set4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        try {
            Set set;
            Cursor cursor3 = $this$useCursor$iv;
            boolean bl = false;
            int nameColumnIndex = cursor3.getColumnIndex("name");
            int originColumnIndex = cursor3.getColumnIndex("origin");
            int uniqueIndex = cursor3.getColumnIndex("unique");
            if (nameColumnIndex == -1 || originColumnIndex == -1 || uniqueIndex == -1) {
                Set<TableInfo.Index> set5 = null;
                return set5;
            }
            Set $this$readIndices_u24lambda_u2d8_u24lambda_u2d7 = set = SetsKt.createSetBuilder();
            boolean bl3 = false;
            while (cursor3.moveToNext()) {
                TableInfo.Index index;
                String origin = cursor3.getString(originColumnIndex);
                if (!Intrinsics.areEqual((Object)"c", (Object)origin)) continue;
                String name = cursor3.getString(nameColumnIndex);
                boolean unique = cursor3.getInt(uniqueIndex) == 1;
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                if (TableInfoKt.readIndex(database, name, unique) == null) {
                    Set<TableInfo.Index> set6 = null;
                    return set6;
                }
                TableInfo.Index index3 = index;
                $this$readIndices_u24lambda_u2d8_u24lambda_u2d7.add(index3);
            }
            Set set7 = SetsKt.build((Set)set);
            return set7;
        }
        finally {
            $this$useCursor$iv.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TableInfo.Index readIndex(SupportSQLiteDatabase database, String name, boolean unique) {
        TableInfo.Index index;
        Cursor cursor = database.query("PRAGMA index_xinfo(`" + name + "`)");
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"database.query(\"PRAGMA index_xinfo(`$name`)\")");
        Cursor $this$useCursor$iv = cursor;
        boolean $i$f$useCursor = false;
        if (Build.VERSION.SDK_INT > 15) {
            Closeable closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                Cursor cursor2 = (Cursor)closeable;
                boolean bl = false;
                int seqnoColumnIndex = cursor2.getColumnIndex("seqno");
                int cidColumnIndex = cursor2.getColumnIndex("cid");
                int nameColumnIndex = cursor2.getColumnIndex("name");
                int descColumnIndex = cursor2.getColumnIndex("desc");
                if (seqnoColumnIndex == -1 || cidColumnIndex == -1 || nameColumnIndex == -1 || descColumnIndex == -1) {
                    TableInfo.Index index2 = null;
                    return index2;
                }
                TreeMap columnsMap = new TreeMap();
                TreeMap ordersMap = new TreeMap();
                while (cursor2.moveToNext()) {
                    int cid = cursor2.getInt(cidColumnIndex);
                    if (cid < 0) continue;
                    int seq = cursor2.getInt(seqnoColumnIndex);
                    String columnName = cursor2.getString(nameColumnIndex);
                    String order = cursor2.getInt(descColumnIndex) > 0 ? "DESC" : "ASC";
                    Integer n = seq;
                    Map map = columnsMap;
                    Intrinsics.checkNotNullExpressionValue((Object)columnName, (String)"columnName");
                    map.put(n, columnName);
                    n = seq;
                    ((Map)ordersMap).put(n, order);
                }
                Collection collection = columnsMap.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"columnsMap.values");
                List columns = CollectionsKt.toList((Iterable)collection);
                Collection collection2 = ordersMap.values();
                Intrinsics.checkNotNullExpressionValue(collection2, (String)"ordersMap.values");
                List orders = CollectionsKt.toList((Iterable)collection2);
                TableInfo.Index index3 = new TableInfo.Index(name, unique, columns, orders);
                index = index3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        try {
            Cursor cursor3 = $this$useCursor$iv;
            boolean bl = false;
            int seqnoColumnIndex = cursor3.getColumnIndex("seqno");
            int cidColumnIndex = cursor3.getColumnIndex("cid");
            int nameColumnIndex = cursor3.getColumnIndex("name");
            int descColumnIndex = cursor3.getColumnIndex("desc");
            if (seqnoColumnIndex == -1 || cidColumnIndex == -1 || nameColumnIndex == -1 || descColumnIndex == -1) {
                TableInfo.Index index4 = null;
                return index4;
            }
            TreeMap columnsMap = new TreeMap();
            TreeMap ordersMap = new TreeMap();
            while (cursor3.moveToNext()) {
                int cid = cursor3.getInt(cidColumnIndex);
                if (cid < 0) continue;
                int seq = cursor3.getInt(seqnoColumnIndex);
                String columnName = cursor3.getString(nameColumnIndex);
                String order = cursor3.getInt(descColumnIndex) > 0 ? "DESC" : "ASC";
                Integer n = seq;
                Map map = columnsMap;
                Intrinsics.checkNotNullExpressionValue((Object)columnName, (String)"columnName");
                map.put(n, columnName);
                n = seq;
                ((Map)ordersMap).put(n, order);
            }
            Collection collection = columnsMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"columnsMap.values");
            List columns = CollectionsKt.toList((Iterable)collection);
            Collection collection3 = ordersMap.values();
            Intrinsics.checkNotNullExpressionValue(collection3, (String)"ordersMap.values");
            List orders = CollectionsKt.toList((Iterable)collection3);
            TableInfo.Index index5 = new TableInfo.Index(name, unique, columns, orders);
            index = index5;
        }
        finally {
            $this$useCursor$iv.close();
        }
        return index;
    }
}

