/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.AbstractWindowedCursor;
import android.database.Cursor;
import android.os.Build;
import android.os.CancellationSignal;
import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;
import androidx.room.util.CursorUtil;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a \u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u001a(\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0017"}, d2={"createCancellationSignal", "Landroid/os/CancellationSignal;", "dropFtsSyncTriggers", "", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "foreignKeyCheck", "tableName", "", "processForeignKeyCheckFailure", "cursor", "Landroid/database/Cursor;", "query", "Landroidx/room/RoomDatabase;", "sqLiteQuery", "Landroidx/sqlite/db/SupportSQLiteQuery;", "maybeCopy", "", "signal", "readVersion", "", "databaseFile", "Ljava/io/File;", "room-runtime_release"})
@JvmName(name="DBUtil")
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class DBUtil {
    @Deprecated(message="This is only used in the generated code and shouldn't be called directly.")
    @NotNull
    public static final Cursor query(@NotNull RoomDatabase db, @NotNull SupportSQLiteQuery sqLiteQuery, boolean maybeCopy) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)sqLiteQuery, (String)"sqLiteQuery");
        return DBUtil.query(db, sqLiteQuery, maybeCopy, null);
    }

    @NotNull
    public static final Cursor query(@NotNull RoomDatabase db, @NotNull SupportSQLiteQuery sqLiteQuery, boolean maybeCopy, @Nullable CancellationSignal signal) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)sqLiteQuery, (String)"sqLiteQuery");
        Cursor cursor = db.query(sqLiteQuery, signal);
        if (maybeCopy && cursor instanceof AbstractWindowedCursor) {
            int rowsInWindow;
            int rowsInCursor = ((AbstractWindowedCursor)cursor).getCount();
            int n = rowsInWindow = ((AbstractWindowedCursor)cursor).hasWindow() ? ((AbstractWindowedCursor)cursor).getWindow().getNumRows() : rowsInCursor;
            if (Build.VERSION.SDK_INT < 23 || rowsInWindow < rowsInCursor) {
                return CursorUtil.copyAndClose(cursor);
            }
        }
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void dropFtsSyncTriggers(@NotNull SupportSQLiteDatabase db) {
        Closeable closeable;
        List list;
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        List $this$dropFtsSyncTriggers_u24lambda_u2d1 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Cursor cursor = db.query("SELECT name FROM sqlite_master WHERE type = 'trigger'");
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"db.query(\"SELECT name FR\u2026 WHERE type = 'trigger'\")");
        Cursor $this$useCursor$iv = cursor;
        boolean $i$f$useCursor = false;
        if (Build.VERSION.SDK_INT > 15) {
            closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                Cursor cursor2 = (Cursor)closeable;
                boolean bl2 = false;
                while (cursor2.moveToNext()) {
                    $this$dropFtsSyncTriggers_u24lambda_u2d1.add(cursor2.getString(0));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        try {
            Cursor cursor3 = $this$useCursor$iv;
            boolean bl3 = false;
            while (cursor3.moveToNext()) {
                $this$dropFtsSyncTriggers_u24lambda_u2d1.add(cursor3.getString(0));
            }
            closeable = Unit.INSTANCE;
        }
        finally {
            $this$useCursor$iv.close();
        }
        List existingTriggers = CollectionsKt.build((List)list);
        Iterable $this$forEach$iv = existingTriggers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String triggerName = (String)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)triggerName, (String)"triggerName");
            if (!StringsKt.startsWith$default((String)triggerName, (String)"room_fts_content_sync_", (boolean)false, (int)2, null)) continue;
            db.execSQL("DROP TRIGGER IF EXISTS " + triggerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void foreignKeyCheck(@NotNull SupportSQLiteDatabase db, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Cursor cursor = db.query("PRAGMA foreign_key_check(`" + tableName + "`)");
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"db.query(\"PRAGMA foreign_key_check(`$tableName`)\")");
        Cursor $this$useCursor$iv = cursor;
        boolean $i$f$useCursor = false;
        if (Build.VERSION.SDK_INT > 15) {
            Closeable closeable = (Closeable)$this$useCursor$iv;
            Throwable throwable = null;
            try {
                Cursor cursor2 = (Cursor)closeable;
                boolean bl = false;
                if (cursor2.getCount() > 0) {
                    String errorMsg = DBUtil.processForeignKeyCheckFailure(cursor2);
                    throw new IllegalStateException(errorMsg);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        try {
            Cursor cursor3 = $this$useCursor$iv;
            boolean bl = false;
            if (cursor3.getCount() > 0) {
                String errorMsg = DBUtil.processForeignKeyCheckFailure(cursor3);
                throw new IllegalStateException(errorMsg);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$useCursor$iv.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int readVersion(@NotNull File databaseFile) throws IOException {
        Intrinsics.checkNotNullParameter((Object)databaseFile, (String)"databaseFile");
        Closeable closeable = new FileInputStream(databaseFile).getChannel();
        Throwable throwable = null;
        try {
            FileChannel input = (FileChannel)closeable;
            boolean bl = false;
            ByteBuffer buffer = ByteBuffer.allocate(4);
            input.tryLock(60L, 4L, true);
            input.position(60L);
            int read = input.read(buffer);
            if (read != 4) {
                throw new IOException("Bad database header, unable to read 4 bytes at offset 60");
            }
            buffer.rewind();
            int n = buffer.getInt();
            return n;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public static final CancellationSignal createCancellationSignal() {
        return Build.VERSION.SDK_INT >= 16 ? SupportSQLiteCompat.Api16Impl.createCancellationSignal() : (CancellationSignal)null;
    }

    private static final String processForeignKeyCheckFailure(Cursor cursor) {
        StringBuilder stringBuilder;
        StringBuilder $this$processForeignKeyCheckFailure_u24lambda_u2d5 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int rowCount = cursor.getCount();
        Map fkParentTables = new LinkedHashMap();
        while (cursor.moveToNext()) {
            String string;
            String constraintIndex;
            if (cursor.isFirst()) {
                $this$processForeignKeyCheckFailure_u24lambda_u2d5.append("Foreign key violation(s) detected in '");
                $this$processForeignKeyCheckFailure_u24lambda_u2d5.append(cursor.getString(0)).append("'.\n");
            }
            if (fkParentTables.containsKey(constraintIndex = cursor.getString(3))) continue;
            Map object = fkParentTables;
            Intrinsics.checkNotNullExpressionValue((Object)constraintIndex, (String)"constraintIndex");
            String string2 = constraintIndex;
            Intrinsics.checkNotNullExpressionValue((Object)cursor.getString(2), (String)"cursor.getString(2)");
            object.put(string2, string);
        }
        $this$processForeignKeyCheckFailure_u24lambda_u2d5.append("Number of different violations discovered: ");
        $this$processForeignKeyCheckFailure_u24lambda_u2d5.append(fkParentTables.keySet().size()).append("\n");
        $this$processForeignKeyCheckFailure_u24lambda_u2d5.append("Number of rows in violation: ");
        $this$processForeignKeyCheckFailure_u24lambda_u2d5.append(rowCount).append("\n");
        $this$processForeignKeyCheckFailure_u24lambda_u2d5.append("Violation(s) detected in the following constraint(s):\n");
        for (Map.Entry entry : fkParentTables.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            $this$processForeignKeyCheckFailure_u24lambda_u2d5.append("\tParent Table = ");
            $this$processForeignKeyCheckFailure_u24lambda_u2d5.append(value);
            $this$processForeignKeyCheckFailure_u24lambda_u2d5.append(", Foreign Key Constraint Index = ");
            $this$processForeignKeyCheckFailure_u24lambda_u2d5.append(key).append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

