/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\u0012H$J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Landroidx/room/SharedSQLiteStatement;", "", "database", "Landroidx/room/RoomDatabase;", "(Landroidx/room/RoomDatabase;)V", "lock", "Ljava/util/concurrent/atomic/AtomicBoolean;", "stmt", "Landroidx/sqlite/db/SupportSQLiteStatement;", "getStmt", "()Landroidx/sqlite/db/SupportSQLiteStatement;", "stmt$delegate", "Lkotlin/Lazy;", "acquire", "assertNotMainThread", "", "createNewStatement", "createQuery", "", "canUseCached", "", "release", "statement", "room-runtime_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public abstract class SharedSQLiteStatement {
    @NotNull
    private final RoomDatabase database;
    @NotNull
    private final AtomicBoolean lock;
    @NotNull
    private final Lazy stmt$delegate;

    public SharedSQLiteStatement(@NotNull RoomDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
        this.lock = new AtomicBoolean(false);
        this.stmt$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SupportSQLiteStatement>(this){
            final /* synthetic */ SharedSQLiteStatement this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final SupportSQLiteStatement invoke() {
                return SharedSQLiteStatement.access$createNewStatement(this.this$0);
            }
        }));
    }

    private final SupportSQLiteStatement getStmt() {
        Lazy lazy = this.stmt$delegate;
        return (SupportSQLiteStatement)lazy.getValue();
    }

    @NotNull
    protected abstract String createQuery();

    protected void assertNotMainThread() {
        this.database.assertNotMainThread();
    }

    private final SupportSQLiteStatement createNewStatement() {
        String query = this.createQuery();
        return this.database.compileStatement(query);
    }

    private final SupportSQLiteStatement getStmt(boolean canUseCached) {
        SupportSQLiteStatement stmt2 = canUseCached ? this.getStmt() : this.createNewStatement();
        return stmt2;
    }

    @NotNull
    public SupportSQLiteStatement acquire() {
        this.assertNotMainThread();
        return this.getStmt(this.lock.compareAndSet(false, true));
    }

    public void release(@NotNull SupportSQLiteStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        if (statement == this.getStmt()) {
            this.lock.set(false);
        }
    }

    public static final /* synthetic */ SupportSQLiteStatement access$createNewStatement(SharedSQLiteStatement $this) {
        return $this.createNewStatement();
    }
}

