/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.LiveData;
import androidx.room.AutoCloser;
import androidx.room.InvalidationLiveDataContainer;
import androidx.room.MultiInstanceInvalidationClient;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0016\u0018\u0000 ]2\u00020\u0001:\u0005]^_`aB#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007BV\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\t\u0012\u001d\u0010\n\u001a\u0019\u0012\u0004\u0012\u00020\u0006\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\b\f0\t\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020#H\u0017J\u0010\u00104\u001a\u0002022\u0006\u00103\u001a\u00020#H\u0017J5\u00105\u001a\b\u0012\u0004\u0012\u0002H706\"\u0004\b\u0000\u001072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u00108\u001a\b\u0012\u0004\u0012\u0002H709H\u0017\u00a2\u0006\u0002\u0010:J=\u00105\u001a\b\u0012\u0004\u0012\u0002H706\"\u0004\b\u0000\u001072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010;\u001a\u00020\u001a2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H709H\u0017\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020\u001aH\u0005J\u0010\u0010>\u001a\u0002022\u0006\u0010\u0002\u001a\u00020?H\u0007J!\u0010@\u001a\u0002022\u0012\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010BJ\r\u0010C\u001a\u000202H\u0000\u00a2\u0006\u0002\bDJ\b\u0010E\u001a\u000202H\u0016J\b\u0010F\u001a\u000202H\u0017J\u0010\u0010G\u001a\u0002022\u0006\u00103\u001a\u00020#H\u0017J!\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010JJ\u0015\u0010K\u001a\u0002022\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\bLJ%\u0010M\u001a\u0002022\u0006\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u00062\u0006\u0010Q\u001a\u00020RH\u0001\u00a2\u0006\u0002\bSJ\u0018\u0010T\u001a\u0002022\u0006\u0010U\u001a\u00020?2\u0006\u0010V\u001a\u00020-H\u0002J\r\u0010W\u001a\u000202H\u0001\u00a2\u0006\u0002\bXJ\u0018\u0010Y\u001a\u0002022\u0006\u0010U\u001a\u00020?2\u0006\u0010V\u001a\u00020-H\u0002J\b\u0010Z\u001a\u000202H\u0007J\u0015\u0010Z\u001a\u0002022\u0006\u0010\u0002\u001a\u00020?H\u0001\u00a2\u0006\u0002\b[J!\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010JR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00118G@GX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"8\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020&8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010'\u001a\u00020(8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b)\u0010*R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020-0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010/R\u000e\u00100\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\n\u001a\u0019\u0012\u0004\u0012\u00020\u0006\u0012\u000f\u0012\r\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\b\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Landroidx/room/InvalidationTracker;", "", "database", "Landroidx/room/RoomDatabase;", "tableNames", "", "", "(Landroidx/room/RoomDatabase;[Ljava/lang/String;)V", "shadowTablesMap", "", "viewTables", "", "Lkotlin/jvm/JvmSuppressWildcards;", "(Landroidx/room/RoomDatabase;Ljava/util/Map;Ljava/util/Map;[Ljava/lang/String;)V", "autoCloser", "Landroidx/room/AutoCloser;", "<set-?>", "Landroidx/sqlite/db/SupportSQLiteStatement;", "cleanupStatement", "getCleanupStatement", "()Landroidx/sqlite/db/SupportSQLiteStatement;", "setCleanupStatement", "(Landroidx/sqlite/db/SupportSQLiteStatement;)V", "getDatabase", "()Landroidx/room/RoomDatabase;", "initialized", "", "invalidationLiveDataContainer", "Landroidx/room/InvalidationLiveDataContainer;", "multiInstanceInvalidationClient", "Landroidx/room/MultiInstanceInvalidationClient;", "observedTableTracker", "Landroidx/room/InvalidationTracker$ObservedTableTracker;", "observerMap", "Landroidx/arch/core/internal/SafeIterableMap;", "Landroidx/room/InvalidationTracker$Observer;", "Landroidx/room/InvalidationTracker$ObserverWrapper;", "pendingRefresh", "Ljava/util/concurrent/atomic/AtomicBoolean;", "refreshRunnable", "Ljava/lang/Runnable;", "getRefreshRunnable$annotations", "()V", "syncTriggersLock", "tableIdLookup", "", "tablesNames", "[Ljava/lang/String;", "trackerLock", "addObserver", "", "observer", "addWeakObserver", "createLiveData", "Landroidx/lifecycle/LiveData;", "T", "computeFunction", "Ljava/util/concurrent/Callable;", "([Ljava/lang/String;Ljava/util/concurrent/Callable;)Landroidx/lifecycle/LiveData;", "inTransaction", "([Ljava/lang/String;ZLjava/util/concurrent/Callable;)Landroidx/lifecycle/LiveData;", "ensureInitialization", "internalInit", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "notifyObserversByTableNames", "tables", "([Ljava/lang/String;)V", "onAutoCloseCallback", "onAutoCloseCallback$room_runtime_release", "refreshVersionsAsync", "refreshVersionsSync", "removeObserver", "resolveViews", "names", "([Ljava/lang/String;)[Ljava/lang/String;", "setAutoCloser", "setAutoCloser$room_runtime_release", "startMultiInstanceInvalidation", "context", "Landroid/content/Context;", "name", "serviceIntent", "Landroid/content/Intent;", "startMultiInstanceInvalidation$room_runtime_release", "startTrackingTable", "db", "tableId", "stopMultiInstanceInvalidation", "stopMultiInstanceInvalidation$room_runtime_release", "stopTrackingTable", "syncTriggers", "syncTriggers$room_runtime_release", "validateAndResolveTableNames", "Companion", "ObservedTableTracker", "Observer", "ObserverWrapper", "WeakObserver", "room-runtime_release"})
public class InvalidationTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    private final RoomDatabase database;
    @NotNull
    private final Map<String, String> shadowTablesMap;
    @NotNull
    private final Map<String, Set<String>> viewTables;
    @JvmField
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final Map<String, Integer> tableIdLookup;
    @JvmField
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final String[] tablesNames;
    @Nullable
    private AutoCloser autoCloser;
    @JvmField
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final AtomicBoolean pendingRefresh;
    private volatile boolean initialized;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    private volatile SupportSQLiteStatement cleanupStatement;
    @NotNull
    private final ObservedTableTracker observedTableTracker;
    @NotNull
    private final InvalidationLiveDataContainer invalidationLiveDataContainer;
    @GuardedBy(value="observerMap")
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @JvmField
    @NotNull
    protected final SafeIterableMap<Observer, ObserverWrapper> observerMap;
    @Nullable
    private MultiInstanceInvalidationClient multiInstanceInvalidationClient;
    @NotNull
    private final Object syncTriggersLock;
    @NotNull
    private final Object trackerLock;
    @JvmField
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final Runnable refreshRunnable;
    @NotNull
    private static final String[] TRIGGERS;
    @NotNull
    private static final String UPDATE_TABLE_NAME = "room_table_modification_log";
    @NotNull
    private static final String TABLE_ID_COLUMN_NAME = "table_id";
    @NotNull
    private static final String INVALIDATED_COLUMN_NAME = "invalidated";
    @NotNull
    private static final String CREATE_TRACKING_TABLE_SQL = "CREATE TEMP TABLE room_table_modification_log (table_id INTEGER PRIMARY KEY, invalidated INTEGER NOT NULL DEFAULT 0)";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public static final String RESET_UPDATED_TABLES_SQL = "UPDATE room_table_modification_log SET invalidated = 0 WHERE invalidated = 1";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public static final String SELECT_UPDATED_TABLES_SQL = "SELECT * FROM room_table_modification_log WHERE invalidated = 1;";

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public InvalidationTracker(@NotNull RoomDatabase database, @NotNull Map<String, String> shadowTablesMap, @NotNull Map<String, Set<String>> viewTables, String ... tableNames) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter(shadowTablesMap, (String)"shadowTablesMap");
        Intrinsics.checkNotNullParameter(viewTables, (String)"viewTables");
        Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
        this.database = database;
        this.shadowTablesMap = shadowTablesMap;
        this.viewTables = viewTables;
        this.pendingRefresh = new AtomicBoolean(false);
        this.observedTableTracker = new ObservedTableTracker(tableNames.length);
        this.invalidationLiveDataContainer = new InvalidationLiveDataContainer(this.database);
        this.observerMap = new SafeIterableMap();
        this.syncTriggersLock = new Object();
        this.trackerLock = new Object();
        this.tableIdLookup = new LinkedHashMap();
        int n = tableNames.length;
        Object object2 = new String[n];
        InvalidationTracker invalidationTracker = this;
        for (int i = 0; i < n; ++i) {
            String shadowTableName;
            String string;
            String string2;
            String tableName;
            int n2 = i;
            String string3 = tableNames[n2];
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            Intrinsics.checkNotNullExpressionValue((Object)string3.toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
            object = n2;
            this.tableIdLookup.put(tableName, (Integer)object);
            if (this.shadowTablesMap.get(tableNames[n2]) != null) {
                String string4;
                Locale locale2 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
                String string5 = string4.toLowerCase(locale2);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(locale)");
            } else {
                string2 = null;
            }
            if ((string = (shadowTableName = string2)) == null) {
                string = tableName;
            }
            object2[n2] = string;
        }
        invalidationTracker.tablesNames = object2;
        Map<String, String> $this$forEach$iv = this.shadowTablesMap;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            String tableName;
            String shadowTableName;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object2.next();
            boolean bl = false;
            object = (String)entry.getValue();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            Intrinsics.checkNotNullExpressionValue((Object)((String)object).toLowerCase(locale), (String)"this as java.lang.String).toLowerCase(locale)");
            if (!this.tableIdLookup.containsKey(shadowTableName)) continue;
            String string = (String)entry.getKey();
            Locale locale3 = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"US");
            Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale3), (String)"this as java.lang.String).toLowerCase(locale)");
            this.tableIdLookup.put(tableName, (Integer)MapsKt.getValue(this.tableIdLookup, (Object)shadowTableName));
        }
        this.refreshRunnable = new Runnable(this){
            final /* synthetic */ InvalidationTracker this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                Lock closeLock = this.this$0.getDatabase().getCloseLock();
                closeLock.lock();
                try {
                    if (!this.this$0.ensureInitialization()) {
                        return;
                    }
                    if (!this.this$0.pendingRefresh.compareAndSet(true, false)) {
                        return;
                    }
                    if (this.this$0.getDatabase().inTransaction()) {
                        return;
                    }
                    SupportSQLiteDatabase db = this.this$0.getDatabase().getOpenHelper().getWritableDatabase();
                    db.beginTransactionNonExclusive();
                    Set<Integer> invalidatedTableIds = null;
                    try {
                        invalidatedTableIds = this.checkUpdatedTable();
                        db.setTransactionSuccessful();
                    }
                    finally {
                        db.endTransaction();
                    }
                    object = invalidatedTableIds;
                }
                catch (IllegalStateException ex) {
                    Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)ex);
                    object = SetsKt.emptySet();
                }
                catch (SQLiteException ex) {
                    Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)ex);
                    object = SetsKt.emptySet();
                }
                finally {
                    closeLock.unlock();
                    AutoCloser autoCloser = InvalidationTracker.access$getAutoCloser$p(this.this$0);
                    if (autoCloser != null) {
                        autoCloser.decrementCountAndScheduleClose();
                    }
                }
                SafeIterableMap<Observer, ObserverWrapper> invalidatedTableIds = object;
                if (!((Collection)invalidatedTableIds).isEmpty()) {
                    object = this.this$0.observerMap;
                    InvalidationTracker invalidationTracker = this.this$0;
                    SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = object;
                    synchronized (safeIterableMap) {
                        boolean bl = false;
                        Iterable $this$forEach$iv = (Iterable)invalidationTracker.observerMap;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Map.Entry it = (Map.Entry)element$iv;
                            boolean bl2 = false;
                            ((ObserverWrapper)it.getValue()).notifyByTableInvalidStatus((Set<Integer>)invalidatedTableIds);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Set<Integer> checkUpdatedTable() {
                InvalidationTracker invalidationTracker = this.this$0;
                Object object = SetsKt.createSetBuilder();
                Set $this$checkUpdatedTable_u24lambda_u2d3 = object;
                boolean bl = false;
                Cursor $this$useCursor$iv = RoomDatabase.query$default(invalidationTracker.getDatabase(), (SupportSQLiteQuery)new SimpleSQLiteQuery("SELECT * FROM room_table_modification_log WHERE invalidated = 1;"), null, 2, null);
                boolean $i$f$useCursor = false;
                if (Build.VERSION.SDK_INT > 15) {
                    Closeable closeable = (Closeable)$this$useCursor$iv;
                    Throwable throwable = null;
                    try {
                        Cursor cursor = (Cursor)closeable;
                        boolean bl2 = false;
                        while (cursor.moveToNext()) {
                            $this$checkUpdatedTable_u24lambda_u2d3.add(cursor.getInt(0));
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                try {
                    Cursor cursor = $this$useCursor$iv;
                    boolean bl3 = false;
                    while (cursor.moveToNext()) {
                        $this$checkUpdatedTable_u24lambda_u2d3.add(cursor.getInt(0));
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    $this$useCursor$iv.close();
                }
                Set invalidatedTableIds = SetsKt.build((Set)object);
                if (!((Collection)invalidatedTableIds).isEmpty()) {
                    if (this.this$0.getCleanupStatement() == null) {
                        object = "Required value was null.";
                        throw new IllegalStateException(object.toString());
                    }
                    SupportSQLiteStatement statement = this.this$0.getCleanupStatement();
                    if (statement == null) {
                        object = "Required value was null.";
                        throw new IllegalArgumentException(object.toString());
                    }
                    statement.executeUpdateDelete();
                }
                return invalidatedTableIds;
            }
        };
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    protected final RoomDatabase getDatabase() {
        return this.database;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public final SupportSQLiteStatement getCleanupStatement() {
        return this.cleanupStatement;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void setCleanupStatement(@Nullable SupportSQLiteStatement supportSQLiteStatement) {
        this.cleanupStatement = supportSQLiteStatement;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public InvalidationTracker(@NotNull RoomDatabase database, String ... tableNames) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
        this(database, MapsKt.emptyMap(), MapsKt.emptyMap(), Arrays.copyOf(tableNames, tableNames.length));
    }

    public final void setAutoCloser$room_runtime_release(@NotNull AutoCloser autoCloser) {
        Intrinsics.checkNotNullParameter((Object)autoCloser, (String)"autoCloser");
        this.autoCloser = autoCloser;
        autoCloser.setAutoCloseCallback(this::onAutoCloseCallback$room_runtime_release);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void internalInit(@NotNull SupportSQLiteDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Object object = this.trackerLock;
        synchronized (object) {
            boolean bl = false;
            if (this.initialized) {
                Log.e((String)"ROOM", (String)"Invalidation tracker is initialized twice :/.");
                return;
            }
            database.execSQL("PRAGMA temp_store = MEMORY;");
            database.execSQL("PRAGMA recursive_triggers='ON';");
            database.execSQL(CREATE_TRACKING_TABLE_SQL);
            this.syncTriggers$room_runtime_release(database);
            this.cleanupStatement = database.compileStatement(RESET_UPDATED_TABLES_SQL);
            this.initialized = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onAutoCloseCallback$room_runtime_release() {
        Object object = this.trackerLock;
        synchronized (object) {
            boolean bl = false;
            this.initialized = false;
            this.observedTableTracker.resetTriggerState();
            Unit unit = Unit.INSTANCE;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void startMultiInstanceInvalidation$room_runtime_release(@NotNull Context context, @NotNull String name, @NotNull Intent serviceIntent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)serviceIntent, (String)"serviceIntent");
        this.multiInstanceInvalidationClient = new MultiInstanceInvalidationClient(context, name, serviceIntent, this, this.database.getQueryExecutor());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void stopMultiInstanceInvalidation$room_runtime_release() {
        MultiInstanceInvalidationClient multiInstanceInvalidationClient = this.multiInstanceInvalidationClient;
        if (multiInstanceInvalidationClient != null) {
            multiInstanceInvalidationClient.stop();
        }
        this.multiInstanceInvalidationClient = null;
    }

    private final void stopTrackingTable(SupportSQLiteDatabase db, int tableId) {
        String tableName = this.tablesNames[tableId];
        for (String trigger : TRIGGERS) {
            String sql;
            StringBuilder stringBuilder;
            StringBuilder $this$stopTrackingTable_u24lambda_u2d3 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$stopTrackingTable_u24lambda_u2d3.append("DROP TRIGGER IF EXISTS ");
            $this$stopTrackingTable_u24lambda_u2d3.append(Companion.getTriggerName$room_runtime_release(tableName, trigger));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            db.execSQL(sql);
        }
    }

    private final void startTrackingTable(SupportSQLiteDatabase db, int tableId) {
        db.execSQL("INSERT OR IGNORE INTO room_table_modification_log VALUES(" + tableId + ", 0)");
        String tableName = this.tablesNames[tableId];
        for (String trigger : TRIGGERS) {
            String sql;
            StringBuilder stringBuilder;
            StringBuilder $this$startTrackingTable_u24lambda_u2d4 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$startTrackingTable_u24lambda_u2d4.append("CREATE TEMP TRIGGER IF NOT EXISTS ");
            $this$startTrackingTable_u24lambda_u2d4.append(Companion.getTriggerName$room_runtime_release(tableName, trigger));
            $this$startTrackingTable_u24lambda_u2d4.append(" AFTER ");
            $this$startTrackingTable_u24lambda_u2d4.append(trigger);
            $this$startTrackingTable_u24lambda_u2d4.append(" ON `");
            $this$startTrackingTable_u24lambda_u2d4.append(tableName);
            $this$startTrackingTable_u24lambda_u2d4.append("` BEGIN UPDATE ");
            $this$startTrackingTable_u24lambda_u2d4.append(UPDATE_TABLE_NAME);
            $this$startTrackingTable_u24lambda_u2d4.append(" SET ").append(INVALIDATED_COLUMN_NAME);
            $this$startTrackingTable_u24lambda_u2d4.append(" = 1");
            $this$startTrackingTable_u24lambda_u2d4.append(" WHERE ").append(TABLE_ID_COLUMN_NAME);
            $this$startTrackingTable_u24lambda_u2d4.append(" = ").append(tableId);
            $this$startTrackingTable_u24lambda_u2d4.append(" AND ").append(INVALIDATED_COLUMN_NAME);
            $this$startTrackingTable_u24lambda_u2d4.append(" = 0");
            $this$startTrackingTable_u24lambda_u2d4.append("; END");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"StringBuilder().apply(builderAction).toString()");
            db.execSQL(sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @SuppressLint(value={"RestrictedApi"})
    @WorkerThread
    public void addObserver(@NotNull Observer observer2) {
        ObserverWrapper observerWrapper;
        void $this$mapTo$iv$iv;
        String[] tableNames;
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
        String[] $this$map$iv = tableNames = this.resolveViews(observer2.getTables());
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void tableName;
            void item$iv$iv;
            void var12_14 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var14_16 = tableName;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string = var14_16.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            Integer n2 = this.tableIdLookup.get(string);
            if (n2 == null) {
                throw new IllegalArgumentException("There is no table with name " + (String)tableName);
            }
            collection.add(Integer.valueOf(n2));
        }
        int[] tableIds = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        ObserverWrapper wrapper = new ObserverWrapper(observer2, tableIds, tableNames);
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.observerMap;
        synchronized (safeIterableMap) {
            boolean bl = false;
            observerWrapper = (ObserverWrapper)this.observerMap.putIfAbsent((Object)observer2, (Object)wrapper);
        }
        ObserverWrapper currentObserver = observerWrapper;
        if (currentObserver == null && this.observedTableTracker.onAdded(Arrays.copyOf(tableIds, tableIds.length))) {
            this.syncTriggers();
        }
    }

    private final String[] validateAndResolveTableNames(String[] tableNames) {
        String[] resolved;
        String[] $this$forEach$iv = resolved = this.resolveViews(tableNames);
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String tableName = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String string = tableName;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            if (this.tableIdLookup.containsKey(string2)) continue;
            boolean bl2 = false;
            String string3 = "There is no table with name " + tableName;
            throw new IllegalArgumentException(string3.toString());
        }
        return resolved;
    }

    private final String[] resolveViews(String[] names) {
        Set set;
        Set $this$resolveViews_u24lambda_u2d10 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        String[] $this$forEach$iv = names;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String name = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            String string = name;
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            if (this.viewTables.containsKey(string2)) {
                string = name;
                Locale locale2 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"US");
                String string3 = string.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                Set<String> set2 = this.viewTables.get(string3);
                Intrinsics.checkNotNull(set2);
                $this$resolveViews_u24lambda_u2d10.addAll((Collection)set2);
                continue;
            }
            $this$resolveViews_u24lambda_u2d10.add(name);
        }
        Collection $this$toTypedArray$iv = SetsKt.build((Set)set);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return stringArray;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void addWeakObserver(@NotNull Observer observer2) {
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
        this.addObserver(new WeakObserver(this, observer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RestrictedApi"})
    @WorkerThread
    public void removeObserver(@NotNull Observer observer2) {
        int[] nArray;
        ObserverWrapper observerWrapper;
        Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.observerMap;
        synchronized (safeIterableMap) {
            boolean bl = false;
            observerWrapper = (ObserverWrapper)this.observerMap.remove((Object)observer2);
        }
        ObserverWrapper wrapper = observerWrapper;
        if (wrapper != null && this.observedTableTracker.onRemoved(Arrays.copyOf(nArray = wrapper.getTableIds(), nArray.length))) {
            this.syncTriggers();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected final boolean ensureInitialization() {
        if (!this.database.isOpen()) {
            return false;
        }
        if (!this.initialized) {
            this.database.getOpenHelper().getWritableDatabase();
        }
        if (!this.initialized) {
            Log.e((String)"ROOM", (String)"database is not initialized even though it is open");
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public static /* synthetic */ void getRefreshRunnable$annotations() {
    }

    public void refreshVersionsAsync() {
        if (this.pendingRefresh.compareAndSet(false, true)) {
            AutoCloser autoCloser = this.autoCloser;
            if (autoCloser != null) {
                autoCloser.incrementCountAndEnsureDbIsOpen();
            }
            this.database.getQueryExecutor().execute(this.refreshRunnable);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @WorkerThread
    public void refreshVersionsSync() {
        AutoCloser autoCloser = this.autoCloser;
        if (autoCloser != null) {
            autoCloser.incrementCountAndEnsureDbIsOpen();
        }
        this.syncTriggers();
        this.refreshRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting(otherwise=3)
    public final void notifyObserversByTableNames(String ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.observerMap;
        synchronized (safeIterableMap) {
            boolean bl = false;
            Iterable $this$forEach$iv = (Iterable)this.observerMap;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(observer, wrapper)");
                Observer observer2 = (Observer)entry.getKey();
                ObserverWrapper wrapper = (ObserverWrapper)entry.getValue();
                if (observer2.isRemote()) continue;
                wrapper.notifyByTableNames(tables);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void syncTriggers$room_runtime_release(@NotNull SupportSQLiteDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        if (database.inTransaction()) {
            return;
        }
        try {
            Lock closeLock = this.database.getCloseLock();
            closeLock.lock();
            try {
                Object object = this.syncTriggersLock;
                synchronized (object) {
                    int[] nArray;
                    block20: {
                        boolean bl = false;
                        if (this.observedTableTracker.getTablesToSync() != null) break block20;
                        return;
                    }
                    int[] tablesToSync = nArray;
                    Companion.beginTransactionInternal$room_runtime_release(database);
                    try {
                        int[] $this$forEachIndexed$iv = tablesToSync;
                        boolean $i$f$forEachIndexed = false;
                        int index$iv = 0;
                        for (int item$iv : $this$forEachIndexed$iv) {
                            void syncState;
                            int n = index$iv++;
                            int n2 = item$iv;
                            int tableId = n;
                            boolean bl = false;
                            switch (syncState) {
                                case 1: {
                                    this.startTrackingTable(database, tableId);
                                    break;
                                }
                                case 2: {
                                    this.stopTrackingTable(database, tableId);
                                }
                            }
                        }
                        database.setTransactionSuccessful();
                    }
                    finally {
                        database.endTransaction();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            finally {
                closeLock.unlock();
            }
        }
        catch (IllegalStateException ex) {
            Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)ex);
        }
        catch (SQLiteException ex) {
            Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)ex);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void syncTriggers() {
        if (!this.database.isOpen()) {
            return;
        }
        SupportSQLiteDatabase supportSQLiteDatabase = this.database.getOpenHelper().getWritableDatabase();
        Intrinsics.checkNotNullExpressionValue((Object)supportSQLiteDatabase, (String)"database.getOpenHelper().writableDatabase");
        this.syncTriggers$room_runtime_release(supportSQLiteDatabase);
    }

    @Deprecated(message="Use [createLiveData(String[], boolean, Callable)]")
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public <T> LiveData<T> createLiveData(@NotNull String[] tableNames, @NotNull Callable<T> computeFunction) {
        Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
        Intrinsics.checkNotNullParameter(computeFunction, (String)"computeFunction");
        return this.createLiveData(tableNames, false, computeFunction);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public <T> LiveData<T> createLiveData(@NotNull String[] tableNames, boolean inTransaction2, @NotNull Callable<T> computeFunction) {
        Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
        Intrinsics.checkNotNullParameter(computeFunction, (String)"computeFunction");
        return this.invalidationLiveDataContainer.create(this.validateAndResolveTableNames(tableNames), inTransaction2, computeFunction);
    }

    public static final /* synthetic */ AutoCloser access$getAutoCloser$p(InvalidationTracker $this) {
        return $this.autoCloser;
    }

    static {
        String[] stringArray = new String[]{"UPDATE", "DELETE", "INSERT"};
        TRIGGERS = stringArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0005\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\rH\u0007J\u001d\u0010\u0015\u001a\u00020\u00122\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0007\u00a2\u0006\u0002\u0010\u0017R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0018"}, d2={"Landroidx/room/InvalidationTracker$ObserverWrapper;", "", "observer", "Landroidx/room/InvalidationTracker$Observer;", "tableIds", "", "tableNames", "", "", "(Landroidx/room/InvalidationTracker$Observer;[I[Ljava/lang/String;)V", "getObserver", "()Landroidx/room/InvalidationTracker$Observer;", "singleTableSet", "", "getTableIds", "()[I", "[Ljava/lang/String;", "notifyByTableInvalidStatus", "", "invalidatedTablesIds", "", "notifyByTableNames", "tables", "([Ljava/lang/String;)V", "room-runtime_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    protected static final class ObserverWrapper {
        @NotNull
        private final Observer observer;
        @NotNull
        private final int[] tableIds;
        @NotNull
        private final String[] tableNames;
        @NotNull
        private final Set<String> singleTableSet;

        public ObserverWrapper(@NotNull Observer observer2, @NotNull int[] tableIds, @NotNull String[] tableNames) {
            Intrinsics.checkNotNullParameter((Object)observer2, (String)"observer");
            Intrinsics.checkNotNullParameter((Object)tableIds, (String)"tableIds");
            Intrinsics.checkNotNullParameter((Object)tableNames, (String)"tableNames");
            this.observer = observer2;
            this.tableIds = tableIds;
            this.tableNames = tableNames;
            this.singleTableSet = !(this.tableNames.length == 0) ? SetsKt.setOf((Object)this.tableNames[0]) : SetsKt.emptySet();
            if (!(this.tableIds.length == this.tableNames.length)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NotNull
        public final Observer getObserver() {
            return this.observer;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NotNull
        public final int[] getTableIds() {
            return this.tableIds;
        }

        /*
         * WARNING - void declaration
         */
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public final void notifyByTableInvalidStatus(@NotNull Set<Integer> invalidatedTablesIds) {
            Set invalidatedTables;
            Intrinsics.checkNotNullParameter(invalidatedTablesIds, (String)"invalidatedTablesIds");
            switch (this.tableIds.length) {
                case 0: {
                    Set set2 = SetsKt.emptySet();
                    break;
                }
                case 1: {
                    Set set2;
                    if (invalidatedTablesIds.contains(this.tableIds[0])) {
                        set2 = this.singleTableSet;
                        break;
                    }
                    set2 = SetsKt.emptySet();
                    break;
                }
                default: {
                    Set set;
                    Set $this$notifyByTableInvalidStatus_u24lambda_u2d1 = set = SetsKt.createSetBuilder();
                    boolean bl = false;
                    int[] $this$forEachIndexed$iv = this.tableIds;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (int item$iv : $this$forEachIndexed$iv) {
                        void tableId;
                        int n = index$iv++;
                        int n2 = item$iv;
                        int idx = n;
                        boolean bl2 = false;
                        if (!invalidatedTablesIds.contains((int)tableId)) continue;
                        $this$notifyByTableInvalidStatus_u24lambda_u2d1.add(this.tableNames[idx]);
                    }
                    Set set2 = invalidatedTables = SetsKt.build((Set)set);
                }
            }
            if (!((Collection)invalidatedTables).isEmpty()) {
                this.observer.onInvalidated(invalidatedTables);
            }
        }

        /*
         * Unable to fully structure code
         */
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public final void notifyByTableNames(@NotNull String[] tables) {
            Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
            switch (this.tableNames.length) {
                case 0: {
                    v0 = SetsKt.emptySet();
                    break;
                }
                case 1: {
                    $this$any$iv = tables;
                    $i$f$any = false;
                    var6_6 = $this$any$iv.length;
                    for (var5_5 = 0; var5_5 < var6_6; ++var5_5) {
                        it = element$iv = $this$any$iv[var5_5];
                        $i$a$-any-InvalidationTracker$ObserverWrapper$notifyByTableNames$invalidatedTables$1 = false;
                        if (!StringsKt.equals((String)it, (String)this.tableNames[0], (boolean)true)) continue;
                        v1 = true;
                        ** GOTO lbl17
                    }
                    v1 = false;
lbl17:
                    // 2 sources

                    if (v1) {
                        v0 = this.singleTableSet;
                        break;
                    }
                    v0 = SetsKt.emptySet();
                    break;
                }
                default: {
                    $this$notifyByTableNames_u24lambda_u2d5 = var3_2 = SetsKt.createSetBuilder();
                    $i$a$-buildSet-InvalidationTracker$ObserverWrapper$notifyByTableNames$invalidatedTables$2 = false;
                    $this$forEach$iv = tables;
                    $i$f$forEach = false;
                    var9_12 = $this$forEach$iv.length;
                    for (var8_11 = 0; var8_11 < var9_12; ++var8_11) {
                        table = element$iv = $this$forEach$iv[var8_11];
                        $i$a$-forEach-InvalidationTracker$ObserverWrapper$notifyByTableNames$invalidatedTables$2$1 = false;
                        $this$forEach$iv = this.tableNames;
                        $i$f$forEach = false;
                        var16_19 = $this$forEach$iv.length;
                        for (var15_18 = 0; var15_18 < var16_19; ++var15_18) {
                            ourTable = element$iv = $this$forEach$iv[var15_18];
                            $i$a$-forEach-InvalidationTracker$ObserverWrapper$notifyByTableNames$invalidatedTables$2$1$1 = false;
                            if (!StringsKt.equals((String)ourTable, (String)table, (boolean)true)) continue;
                            $this$notifyByTableNames_u24lambda_u2d5.add(ourTable);
                        }
                    }
                    v0 = invalidatedTables = SetsKt.build((Set)var3_2);
                }
            }
            if (((Collection)invalidatedTables).isEmpty() == false) {
                this.observer.onInvalidated(invalidatedTables);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0010\"\n\u0000\b&\u0018\u00002\u00020\u0001B#\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H&R\u0014\u0010\t\u001a\u00020\n8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u001b\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0007\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Landroidx/room/InvalidationTracker$Observer;", "", "firstTable", "", "rest", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "tables", "([Ljava/lang/String;)V", "isRemote", "", "()Z", "getTables", "()[Ljava/lang/String;", "[Ljava/lang/String;", "onInvalidated", "", "", "room-runtime_release"})
    public static abstract class Observer {
        @NotNull
        private final String[] tables;

        public Observer(@NotNull String[] tables) {
            Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
            this.tables = tables;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NotNull
        public final String[] getTables() {
            return this.tables;
        }

        /*
         * WARNING - void declaration
         */
        protected Observer(@NotNull String firstTable, String ... rest) {
            void $this$_init__u24lambda_u2d0;
            List list;
            Intrinsics.checkNotNullParameter((Object)firstTable, (String)"firstTable");
            Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
            List list2 = list = CollectionsKt.createListBuilder();
            Observer observer2 = this;
            boolean bl = false;
            CollectionsKt.addAll((Collection)((Collection)$this$_init__u24lambda_u2d0), (Object[])rest);
            $this$_init__u24lambda_u2d0.add(firstTable);
            Collection $this$toTypedArray$iv = CollectionsKt.build((List)list);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            observer2(stringArray);
        }

        public abstract void onInvalidated(@NotNull Set<String> var1);

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean isRemote() {
            return false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0007J\u0012\u0010\u0014\u001a\u00020\u00062\n\u0010\u0015\u001a\u00020\u0010\"\u00020\u0003J\u0012\u0010\u0016\u001a\u00020\u00062\n\u0010\u0015\u001a\u00020\u0010\"\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0018R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/room/InvalidationTracker$ObservedTableTracker;", "", "tableCount", "", "(I)V", "needsSync", "", "getNeedsSync", "()Z", "setNeedsSync", "(Z)V", "tableObservers", "", "getTableObservers", "()[J", "triggerStateChanges", "", "triggerStates", "", "getTablesToSync", "onAdded", "tableIds", "onRemoved", "resetTriggerState", "", "Companion", "room-runtime_release"})
    public static final class ObservedTableTracker {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final long[] tableObservers;
        @NotNull
        private final boolean[] triggerStates;
        @NotNull
        private final int[] triggerStateChanges;
        private boolean needsSync;
        public static final int NO_OP = 0;
        public static final int ADD = 1;
        public static final int REMOVE = 2;

        public ObservedTableTracker(int tableCount) {
            this.tableObservers = new long[tableCount];
            this.triggerStates = new boolean[tableCount];
            this.triggerStateChanges = new int[tableCount];
        }

        @NotNull
        public final long[] getTableObservers() {
            return this.tableObservers;
        }

        public final boolean getNeedsSync() {
            return this.needsSync;
        }

        public final void setNeedsSync(boolean bl) {
            this.needsSync = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean onAdded(int ... tableIds) {
            Intrinsics.checkNotNullParameter((Object)tableIds, (String)"tableIds");
            boolean needTriggerSync = false;
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                boolean bl = false;
                int[] $this$forEach$iv = tableIds;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int tableId = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    long prevObserverCount = this.tableObservers[tableId];
                    this.tableObservers[tableId] = prevObserverCount + 1L;
                    if (prevObserverCount != 0L) continue;
                    this.needsSync = true;
                    needTriggerSync = true;
                }
                Unit unit = Unit.INSTANCE;
            }
            return needTriggerSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean onRemoved(int ... tableIds) {
            Intrinsics.checkNotNullParameter((Object)tableIds, (String)"tableIds");
            boolean needTriggerSync = false;
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                boolean bl = false;
                int[] $this$forEach$iv = tableIds;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int tableId = element$iv = $this$forEach$iv[i];
                    boolean bl2 = false;
                    long prevObserverCount = this.tableObservers[tableId];
                    this.tableObservers[tableId] = prevObserverCount - 1L;
                    if (prevObserverCount != 1L) continue;
                    this.needsSync = true;
                    needTriggerSync = true;
                }
                Unit unit = Unit.INSTANCE;
            }
            return needTriggerSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void resetTriggerState() {
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                boolean bl = false;
                Arrays.fill(this.triggerStates, false);
                this.needsSync = true;
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @VisibleForTesting
        @JvmName(name="getTablesToSync")
        @Nullable
        public final int[] getTablesToSync() {
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                block5: {
                    boolean bl = false;
                    if (this.needsSync) break block5;
                    int[] nArray = null;
                    return nArray;
                }
                long[] $this$forEachIndexed$iv = this.tableObservers;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (long item$iv : $this$forEachIndexed$iv) {
                    void observerCount;
                    boolean newState;
                    int n = index$iv++;
                    long l = item$iv;
                    int i = n;
                    boolean bl = false;
                    boolean bl2 = newState = observerCount > 0L;
                    this.triggerStateChanges[i] = newState != this.triggerStates[i] ? (newState ? 1 : 2) : 0;
                    this.triggerStates[i] = newState;
                }
                this.needsSync = false;
                int[] nArray = (int[])this.triggerStateChanges.clone();
                return nArray;
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/room/InvalidationTracker$ObservedTableTracker$Companion;", "", "()V", "ADD", "", "NO_OP", "REMOVE", "room-runtime_release"})
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Landroidx/room/InvalidationTracker$WeakObserver;", "Landroidx/room/InvalidationTracker$Observer;", "tracker", "Landroidx/room/InvalidationTracker;", "delegate", "(Landroidx/room/InvalidationTracker;Landroidx/room/InvalidationTracker$Observer;)V", "delegateRef", "Ljava/lang/ref/WeakReference;", "getDelegateRef", "()Ljava/lang/ref/WeakReference;", "getTracker", "()Landroidx/room/InvalidationTracker;", "onInvalidated", "", "tables", "", "", "room-runtime_release"})
    public static final class WeakObserver
    extends Observer {
        @NotNull
        private final InvalidationTracker tracker;
        @NotNull
        private final WeakReference<Observer> delegateRef;

        public WeakObserver(@NotNull InvalidationTracker tracker, @NotNull Observer delegate) {
            Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            super(delegate.getTables());
            this.tracker = tracker;
            this.delegateRef = new WeakReference<Observer>(delegate);
        }

        @NotNull
        public final InvalidationTracker getTracker() {
            return this.tracker;
        }

        @NotNull
        public final WeakReference<Observer> getDelegateRef() {
            return this.delegateRef;
        }

        @Override
        public void onInvalidated(@NotNull Set<String> tables) {
            Intrinsics.checkNotNullParameter(tables, (String)"tables");
            Observer observer2 = (Observer)this.delegateRef.get();
            if (observer2 == null) {
                this.tracker.removeObserver(this);
            } else {
                observer2.onInvalidated(tables);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0016\u0010\b\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/room/InvalidationTracker$Companion;", "", "()V", "CREATE_TRACKING_TABLE_SQL", "", "INVALIDATED_COLUMN_NAME", "RESET_UPDATED_TABLES_SQL", "getRESET_UPDATED_TABLES_SQL$annotations", "SELECT_UPDATED_TABLES_SQL", "getSELECT_UPDATED_TABLES_SQL$annotations", "TABLE_ID_COLUMN_NAME", "TRIGGERS", "", "[Ljava/lang/String;", "UPDATE_TABLE_NAME", "beginTransactionInternal", "", "database", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "beginTransactionInternal$room_runtime_release", "getTriggerName", "tableName", "triggerType", "getTriggerName$room_runtime_release", "room-runtime_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getRESET_UPDATED_TABLES_SQL$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getSELECT_UPDATED_TABLES_SQL$annotations() {
        }

        @NotNull
        public final String getTriggerName$room_runtime_release(@NotNull String tableName, @NotNull String triggerType) {
            Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
            Intrinsics.checkNotNullParameter((Object)triggerType, (String)"triggerType");
            return "`room_table_modification_trigger_" + tableName + '_' + triggerType + '`';
        }

        public final void beginTransactionInternal$room_runtime_release(@NotNull SupportSQLiteDatabase database) {
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            if (Build.VERSION.SDK_INT >= 16 && database.isWriteAheadLoggingEnabled()) {
                database.beginTransactionNonExclusive();
            } else {
                database.beginTransaction();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

