/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.CharArrayBuffer;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.database.SQLException;
import android.database.sqlite.SQLiteTransactionListener;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.arch.core.util.Function;
import androidx.room.AutoCloser;
import androidx.room.DelegatingOpenHelper;
import androidx.room.util.SneakyThrow;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class AutoClosingRoomOpenHelper
implements SupportSQLiteOpenHelper,
DelegatingOpenHelper {
    @NonNull
    private final SupportSQLiteOpenHelper mDelegateOpenHelper;
    @NonNull
    private final AutoClosingSupportSQLiteDatabase mAutoClosingDb;
    @NonNull
    private final AutoCloser mAutoCloser;

    AutoClosingRoomOpenHelper(@NonNull SupportSQLiteOpenHelper supportSQLiteOpenHelper, @NonNull AutoCloser autoCloser) {
        this.mDelegateOpenHelper = supportSQLiteOpenHelper;
        this.mAutoCloser = autoCloser;
        autoCloser.init(this.mDelegateOpenHelper);
        this.mAutoClosingDb = new AutoClosingSupportSQLiteDatabase(this.mAutoCloser);
    }

    @Nullable
    public String getDatabaseName() {
        return this.mDelegateOpenHelper.getDatabaseName();
    }

    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean enabled) {
        this.mDelegateOpenHelper.setWriteAheadLoggingEnabled(enabled);
    }

    @NonNull
    @RequiresApi(api=24)
    public SupportSQLiteDatabase getWritableDatabase() {
        this.mAutoClosingDb.pokeOpen();
        return this.mAutoClosingDb;
    }

    @NonNull
    @RequiresApi(api=24)
    public SupportSQLiteDatabase getReadableDatabase() {
        this.mAutoClosingDb.pokeOpen();
        return this.mAutoClosingDb;
    }

    public void close() {
        try {
            this.mAutoClosingDb.close();
        }
        catch (IOException e) {
            SneakyThrow.reThrow(e);
        }
    }

    @NonNull
    AutoCloser getAutoCloser() {
        return this.mAutoCloser;
    }

    @NonNull
    SupportSQLiteDatabase getAutoClosingDb() {
        return this.mAutoClosingDb;
    }

    @Override
    @NonNull
    public SupportSQLiteOpenHelper getDelegate() {
        return this.mDelegateOpenHelper;
    }

    private static class AutoClosingSupportSqliteStatement
    implements SupportSQLiteStatement {
        private final String mSql;
        private final ArrayList<Object> mBinds = new ArrayList();
        private final AutoCloser mAutoCloser;

        AutoClosingSupportSqliteStatement(String sql, AutoCloser autoCloser) {
            this.mSql = sql;
            this.mAutoCloser = autoCloser;
        }

        private <T> T executeSqliteStatementWithRefCount(Function<SupportSQLiteStatement, T> func) {
            return (T)this.mAutoCloser.executeRefCountingFunction(db -> {
                SupportSQLiteStatement statement = db.compileStatement(this.mSql);
                this.doBinds(statement);
                return func.apply((Object)statement);
            });
        }

        private void doBinds(SupportSQLiteStatement supportSQLiteStatement) {
            for (int i = 0; i < this.mBinds.size(); ++i) {
                int bindIndex = i + 1;
                Object bind = this.mBinds.get(i);
                if (bind == null) {
                    supportSQLiteStatement.bindNull(bindIndex);
                    continue;
                }
                if (bind instanceof Long) {
                    supportSQLiteStatement.bindLong(bindIndex, ((Long)bind).longValue());
                    continue;
                }
                if (bind instanceof Double) {
                    supportSQLiteStatement.bindDouble(bindIndex, ((Double)bind).doubleValue());
                    continue;
                }
                if (bind instanceof String) {
                    supportSQLiteStatement.bindString(bindIndex, (String)bind);
                    continue;
                }
                if (!(bind instanceof byte[])) continue;
                supportSQLiteStatement.bindBlob(bindIndex, (byte[])bind);
            }
        }

        private void saveBinds(int bindIndex, Object value) {
            int index = bindIndex - 1;
            if (index >= this.mBinds.size()) {
                for (int i = this.mBinds.size(); i <= index; ++i) {
                    this.mBinds.add(null);
                }
            }
            this.mBinds.set(index, value);
        }

        public void close() throws IOException {
        }

        public void execute() {
            this.executeSqliteStatementWithRefCount(statement -> {
                statement.execute();
                return null;
            });
        }

        public int executeUpdateDelete() {
            return (Integer)this.executeSqliteStatementWithRefCount(SupportSQLiteStatement::executeUpdateDelete);
        }

        public long executeInsert() {
            return (Long)this.executeSqliteStatementWithRefCount(SupportSQLiteStatement::executeInsert);
        }

        public long simpleQueryForLong() {
            return (Long)this.executeSqliteStatementWithRefCount(SupportSQLiteStatement::simpleQueryForLong);
        }

        public String simpleQueryForString() {
            return (String)this.executeSqliteStatementWithRefCount(SupportSQLiteStatement::simpleQueryForString);
        }

        public void bindNull(int index) {
            this.saveBinds(index, null);
        }

        public void bindLong(int index, long value) {
            this.saveBinds(index, value);
        }

        public void bindDouble(int index, double value) {
            this.saveBinds(index, value);
        }

        public void bindString(int index, String value) {
            this.saveBinds(index, value);
        }

        public void bindBlob(int index, byte[] value) {
            this.saveBinds(index, value);
        }

        public void clearBindings() {
            this.mBinds.clear();
        }
    }

    private static final class KeepAliveCursor
    implements Cursor {
        private final Cursor mDelegate;
        private final AutoCloser mAutoCloser;

        KeepAliveCursor(Cursor delegate, AutoCloser autoCloser) {
            this.mDelegate = delegate;
            this.mAutoCloser = autoCloser;
        }

        public void close() {
            this.mDelegate.close();
            this.mAutoCloser.decrementCountAndScheduleClose();
        }

        public boolean isClosed() {
            return this.mDelegate.isClosed();
        }

        public int getCount() {
            return this.mDelegate.getCount();
        }

        public int getPosition() {
            return this.mDelegate.getPosition();
        }

        public boolean move(int offset) {
            return this.mDelegate.move(offset);
        }

        public boolean moveToPosition(int position) {
            return this.mDelegate.moveToPosition(position);
        }

        public boolean moveToFirst() {
            return this.mDelegate.moveToFirst();
        }

        public boolean moveToLast() {
            return this.mDelegate.moveToLast();
        }

        public boolean moveToNext() {
            return this.mDelegate.moveToNext();
        }

        public boolean moveToPrevious() {
            return this.mDelegate.moveToPrevious();
        }

        public boolean isFirst() {
            return this.mDelegate.isFirst();
        }

        public boolean isLast() {
            return this.mDelegate.isLast();
        }

        public boolean isBeforeFirst() {
            return this.mDelegate.isBeforeFirst();
        }

        public boolean isAfterLast() {
            return this.mDelegate.isAfterLast();
        }

        public int getColumnIndex(String columnName) {
            return this.mDelegate.getColumnIndex(columnName);
        }

        public int getColumnIndexOrThrow(String columnName) throws IllegalArgumentException {
            return this.mDelegate.getColumnIndexOrThrow(columnName);
        }

        public String getColumnName(int columnIndex) {
            return this.mDelegate.getColumnName(columnIndex);
        }

        public String[] getColumnNames() {
            return this.mDelegate.getColumnNames();
        }

        public int getColumnCount() {
            return this.mDelegate.getColumnCount();
        }

        public byte[] getBlob(int columnIndex) {
            return this.mDelegate.getBlob(columnIndex);
        }

        public String getString(int columnIndex) {
            return this.mDelegate.getString(columnIndex);
        }

        public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
            this.mDelegate.copyStringToBuffer(columnIndex, buffer);
        }

        public short getShort(int columnIndex) {
            return this.mDelegate.getShort(columnIndex);
        }

        public int getInt(int columnIndex) {
            return this.mDelegate.getInt(columnIndex);
        }

        public long getLong(int columnIndex) {
            return this.mDelegate.getLong(columnIndex);
        }

        public float getFloat(int columnIndex) {
            return this.mDelegate.getFloat(columnIndex);
        }

        public double getDouble(int columnIndex) {
            return this.mDelegate.getDouble(columnIndex);
        }

        public int getType(int columnIndex) {
            return this.mDelegate.getType(columnIndex);
        }

        public boolean isNull(int columnIndex) {
            return this.mDelegate.isNull(columnIndex);
        }

        @Deprecated
        public void deactivate() {
            this.mDelegate.deactivate();
        }

        @Deprecated
        public boolean requery() {
            return this.mDelegate.requery();
        }

        public void registerContentObserver(ContentObserver observer) {
            this.mDelegate.registerContentObserver(observer);
        }

        public void unregisterContentObserver(ContentObserver observer) {
            this.mDelegate.unregisterContentObserver(observer);
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            this.mDelegate.registerDataSetObserver(observer);
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            this.mDelegate.unregisterDataSetObserver(observer);
        }

        public void setNotificationUri(ContentResolver cr, Uri uri) {
            this.mDelegate.setNotificationUri(cr, uri);
        }

        @SuppressLint(value={"UnsafeNewApiCall"})
        @RequiresApi(api=29)
        public void setNotificationUris(@NonNull ContentResolver cr, @NonNull List<Uri> uris) {
            this.mDelegate.setNotificationUris(cr, uris);
        }

        @SuppressLint(value={"UnsafeNewApiCall"})
        @RequiresApi(api=19)
        public Uri getNotificationUri() {
            return this.mDelegate.getNotificationUri();
        }

        @SuppressLint(value={"UnsafeNewApiCall"})
        @RequiresApi(api=29)
        @Nullable
        public List<Uri> getNotificationUris() {
            return this.mDelegate.getNotificationUris();
        }

        public boolean getWantsAllOnMoveCalls() {
            return this.mDelegate.getWantsAllOnMoveCalls();
        }

        @SuppressLint(value={"UnsafeNewApiCall"})
        @RequiresApi(api=23)
        public void setExtras(Bundle extras) {
            this.mDelegate.setExtras(extras);
        }

        public Bundle getExtras() {
            return this.mDelegate.getExtras();
        }

        public Bundle respond(Bundle extras) {
            return this.mDelegate.respond(extras);
        }
    }

    static final class AutoClosingSupportSQLiteDatabase
    implements SupportSQLiteDatabase {
        @NonNull
        private final AutoCloser mAutoCloser;

        AutoClosingSupportSQLiteDatabase(@NonNull AutoCloser autoCloser) {
            this.mAutoCloser = autoCloser;
        }

        void pokeOpen() {
            this.mAutoCloser.executeRefCountingFunction(db -> null);
        }

        public SupportSQLiteStatement compileStatement(String sql) {
            return new AutoClosingSupportSqliteStatement(sql, this.mAutoCloser);
        }

        public void beginTransaction() {
            SupportSQLiteDatabase db = this.mAutoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransaction();
            }
            catch (Throwable t) {
                this.mAutoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        public void beginTransactionNonExclusive() {
            SupportSQLiteDatabase db = this.mAutoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransactionNonExclusive();
            }
            catch (Throwable t) {
                this.mAutoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        public void beginTransactionWithListener(SQLiteTransactionListener transactionListener) {
            SupportSQLiteDatabase db = this.mAutoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransactionWithListener(transactionListener);
            }
            catch (Throwable t) {
                this.mAutoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        public void beginTransactionWithListenerNonExclusive(SQLiteTransactionListener transactionListener) {
            SupportSQLiteDatabase db = this.mAutoCloser.incrementCountAndEnsureDbIsOpen();
            try {
                db.beginTransactionWithListenerNonExclusive(transactionListener);
            }
            catch (Throwable t) {
                this.mAutoCloser.decrementCountAndScheduleClose();
                throw t;
            }
        }

        public void endTransaction() {
            if (this.mAutoCloser.getDelegateDatabase() == null) {
                throw new IllegalStateException("End transaction called but delegateDb is null");
            }
            try {
                this.mAutoCloser.getDelegateDatabase().endTransaction();
            }
            finally {
                this.mAutoCloser.decrementCountAndScheduleClose();
            }
        }

        public void setTransactionSuccessful() {
            SupportSQLiteDatabase delegate = this.mAutoCloser.getDelegateDatabase();
            if (delegate == null) {
                throw new IllegalStateException("setTransactionSuccessful called but delegateDb is null");
            }
            delegate.setTransactionSuccessful();
        }

        public boolean inTransaction() {
            if (this.mAutoCloser.getDelegateDatabase() == null) {
                return false;
            }
            return (Boolean)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::inTransaction);
        }

        public boolean isDbLockedByCurrentThread() {
            if (this.mAutoCloser.getDelegateDatabase() == null) {
                return false;
            }
            return (Boolean)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::isDbLockedByCurrentThread);
        }

        public boolean yieldIfContendedSafely() {
            return (Boolean)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::yieldIfContendedSafely);
        }

        public boolean yieldIfContendedSafely(long sleepAfterYieldDelay) {
            return (Boolean)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::yieldIfContendedSafely);
        }

        public int getVersion() {
            return (Integer)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::getVersion);
        }

        public void setVersion(int version) {
            this.mAutoCloser.executeRefCountingFunction(db -> {
                db.setVersion(version);
                return null;
            });
        }

        public long getMaximumSize() {
            return (Long)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::getMaximumSize);
        }

        public long setMaximumSize(long numBytes) {
            return (Long)this.mAutoCloser.executeRefCountingFunction(db -> db.setMaximumSize(numBytes));
        }

        public long getPageSize() {
            return (Long)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::getPageSize);
        }

        public void setPageSize(long numBytes) {
            this.mAutoCloser.executeRefCountingFunction(db -> {
                db.setPageSize(numBytes);
                return null;
            });
        }

        public Cursor query(String query) {
            Cursor result;
            try {
                SupportSQLiteDatabase db = this.mAutoCloser.incrementCountAndEnsureDbIsOpen();
                result = db.query(query);
            }
            catch (Throwable throwable) {
                this.mAutoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            return new KeepAliveCursor(result, this.mAutoCloser);
        }

        public Cursor query(String query, Object[] bindArgs) {
            Cursor result;
            try {
                SupportSQLiteDatabase db = this.mAutoCloser.incrementCountAndEnsureDbIsOpen();
                result = db.query(query, bindArgs);
            }
            catch (Throwable throwable) {
                this.mAutoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            return new KeepAliveCursor(result, this.mAutoCloser);
        }

        public Cursor query(SupportSQLiteQuery query) {
            Cursor result;
            try {
                SupportSQLiteDatabase db = this.mAutoCloser.incrementCountAndEnsureDbIsOpen();
                result = db.query(query);
            }
            catch (Throwable throwable) {
                this.mAutoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            return new KeepAliveCursor(result, this.mAutoCloser);
        }

        @RequiresApi(api=24)
        public Cursor query(SupportSQLiteQuery query, CancellationSignal cancellationSignal) {
            Cursor result;
            try {
                SupportSQLiteDatabase db = this.mAutoCloser.incrementCountAndEnsureDbIsOpen();
                result = db.query(query, cancellationSignal);
            }
            catch (Throwable throwable) {
                this.mAutoCloser.decrementCountAndScheduleClose();
                throw throwable;
            }
            return new KeepAliveCursor(result, this.mAutoCloser);
        }

        public long insert(String table, int conflictAlgorithm, ContentValues values) throws SQLException {
            return (Long)this.mAutoCloser.executeRefCountingFunction(db -> db.insert(table, conflictAlgorithm, values));
        }

        public int delete(String table, String whereClause, Object[] whereArgs) {
            return (Integer)this.mAutoCloser.executeRefCountingFunction(db -> db.delete(table, whereClause, whereArgs));
        }

        public int update(String table, int conflictAlgorithm, ContentValues values, String whereClause, Object[] whereArgs) {
            return (Integer)this.mAutoCloser.executeRefCountingFunction(db -> db.update(table, conflictAlgorithm, values, whereClause, whereArgs));
        }

        public void execSQL(String sql) throws SQLException {
            this.mAutoCloser.executeRefCountingFunction(db -> {
                db.execSQL(sql);
                return null;
            });
        }

        public void execSQL(String sql, Object[] bindArgs) throws SQLException {
            this.mAutoCloser.executeRefCountingFunction(db -> {
                db.execSQL(sql, bindArgs);
                return null;
            });
        }

        public boolean isReadOnly() {
            return (Boolean)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::isReadOnly);
        }

        public boolean isOpen() {
            SupportSQLiteDatabase localDelegate = this.mAutoCloser.getDelegateDatabase();
            if (localDelegate == null) {
                return false;
            }
            return localDelegate.isOpen();
        }

        public boolean needUpgrade(int newVersion) {
            return (Boolean)this.mAutoCloser.executeRefCountingFunction(db -> db.needUpgrade(newVersion));
        }

        public String getPath() {
            return (String)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::getPath);
        }

        public void setLocale(Locale locale) {
            this.mAutoCloser.executeRefCountingFunction(db -> {
                db.setLocale(locale);
                return null;
            });
        }

        public void setMaxSqlCacheSize(int cacheSize) {
            this.mAutoCloser.executeRefCountingFunction(db -> {
                db.setMaxSqlCacheSize(cacheSize);
                return null;
            });
        }

        @SuppressLint(value={"UnsafeNewApiCall"})
        @RequiresApi(api=16)
        public void setForeignKeyConstraintsEnabled(boolean enable) {
            this.mAutoCloser.executeRefCountingFunction(db -> {
                if (Build.VERSION.SDK_INT >= 16) {
                    db.setForeignKeyConstraintsEnabled(enable);
                }
                return null;
            });
        }

        public boolean enableWriteAheadLogging() {
            throw new UnsupportedOperationException("Enable/disable write ahead logging on the OpenHelper instead of on the database directly.");
        }

        public void disableWriteAheadLogging() {
            throw new UnsupportedOperationException("Enable/disable write ahead logging on the OpenHelper instead of on the database directly.");
        }

        @SuppressLint(value={"UnsafeNewApiCall"})
        @RequiresApi(api=16)
        public boolean isWriteAheadLoggingEnabled() {
            return (Boolean)this.mAutoCloser.executeRefCountingFunction(db -> {
                if (Build.VERSION.SDK_INT >= 16) {
                    return db.isWriteAheadLoggingEnabled();
                }
                return false;
            });
        }

        public List<Pair<String, String>> getAttachedDbs() {
            return (List)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::getAttachedDbs);
        }

        public boolean isDatabaseIntegrityOk() {
            return (Boolean)this.mAutoCloser.executeRefCountingFunction(SupportSQLiteDatabase::isDatabaseIntegrityOk);
        }

        public void close() throws IOException {
            this.mAutoCloser.closeDatabaseIfOpen();
        }
    }
}

