/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.database.Cursor;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.Room;
import androidx.room.SQLiteCopyOpenHelper;
import androidx.room.SQLiteCopyOpenHelperFactory;
import androidx.room.TransactionExecutor;
import androidx.room.migration.Migration;
import androidx.room.util.SneakyThrow;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import androidx.sqlite.db.framework.FrameworkSQLiteOpenHelperFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class RoomDatabase {
    private static final String DB_IMPL_SUFFIX = "_Impl";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final int MAX_BIND_PARAMETER_CNT = 999;
    @Deprecated
    protected volatile SupportSQLiteDatabase mDatabase;
    private Executor mQueryExecutor;
    private Executor mTransactionExecutor;
    private SupportSQLiteOpenHelper mOpenHelper;
    private final InvalidationTracker mInvalidationTracker;
    private boolean mAllowMainThreadQueries;
    boolean mWriteAheadLoggingEnabled;
    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Nullable
    protected List<Callback> mCallbacks;
    private final ReentrantReadWriteLock mCloseLock = new ReentrantReadWriteLock();
    private final ThreadLocal<Integer> mSuspendingTransactionId = new ThreadLocal();
    private final Map<String, Object> mBackingFieldMap = Collections.synchronizedMap(new HashMap());
    private final Map<Class<?>, Object> mTypeConverters;

    Lock getCloseLock() {
        return this.mCloseLock.readLock();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    ThreadLocal<Integer> getSuspendingTransactionId() {
        return this.mSuspendingTransactionId;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    Map<String, Object> getBackingFieldMap() {
        return this.mBackingFieldMap;
    }

    @Nullable
    public <T> T getTypeConverter(@NonNull Class<T> klass) {
        return (T)this.mTypeConverters.get(klass);
    }

    public RoomDatabase() {
        this.mInvalidationTracker = this.createInvalidationTracker();
        this.mTypeConverters = new HashMap();
    }

    @CallSuper
    public void init(@NonNull DatabaseConfiguration configuration) {
        this.mOpenHelper = this.createOpenHelper(configuration);
        if (this.mOpenHelper instanceof SQLiteCopyOpenHelper) {
            SQLiteCopyOpenHelper copyOpenHelper = (SQLiteCopyOpenHelper)this.mOpenHelper;
            copyOpenHelper.setDatabaseConfiguration(configuration);
        }
        boolean wal = false;
        if (Build.VERSION.SDK_INT >= 16) {
            wal = configuration.journalMode == JournalMode.WRITE_AHEAD_LOGGING;
            this.mOpenHelper.setWriteAheadLoggingEnabled(wal);
        }
        this.mCallbacks = configuration.callbacks;
        this.mQueryExecutor = configuration.queryExecutor;
        this.mTransactionExecutor = new TransactionExecutor(configuration.transactionExecutor);
        this.mAllowMainThreadQueries = configuration.allowMainThreadQueries;
        this.mWriteAheadLoggingEnabled = wal;
        if (configuration.multiInstanceInvalidation) {
            this.mInvalidationTracker.startMultiInstanceInvalidation(configuration.context, configuration.name);
        }
        Map<Class<?>, List<Class<?>>> requiredFactories = this.getRequiredTypeConverters();
        BitSet used = new BitSet();
        for (Map.Entry<Class<?>, List<Class<?>>> entry : requiredFactories.entrySet()) {
            Class<?> daoName = entry.getKey();
            for (Class<?> converter : entry.getValue()) {
                int foundIndex = -1;
                for (int providedIndex = configuration.typeConverters.size() - 1; providedIndex >= 0; --providedIndex) {
                    Object provided = configuration.typeConverters.get(providedIndex);
                    if (!converter.isAssignableFrom(provided.getClass())) continue;
                    foundIndex = providedIndex;
                    used.set(foundIndex);
                    break;
                }
                if (foundIndex < 0) {
                    throw new IllegalArgumentException("A required type converter (" + converter + ") for " + daoName.getCanonicalName() + " is missing in the database configuration.");
                }
                this.mTypeConverters.put(converter, configuration.typeConverters.get(foundIndex));
            }
        }
        for (int providedIndex = configuration.typeConverters.size() - 1; providedIndex >= 0; --providedIndex) {
            if (used.get(providedIndex)) continue;
            Object converter = configuration.typeConverters.get(providedIndex);
            throw new IllegalArgumentException("Unexpected type converter " + converter + ". Annotate TypeConverter class with @ProvidedTypeConverter annotation or remove this converter from the builder.");
        }
    }

    @NonNull
    public SupportSQLiteOpenHelper getOpenHelper() {
        return this.mOpenHelper;
    }

    @NonNull
    protected abstract SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration var1);

    @NonNull
    protected abstract InvalidationTracker createInvalidationTracker();

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        return Collections.emptyMap();
    }

    @WorkerThread
    public abstract void clearAllTables();

    public boolean isOpen() {
        SupportSQLiteDatabase db = this.mDatabase;
        return db != null && db.isOpen();
    }

    public void close() {
        if (this.isOpen()) {
            ReentrantReadWriteLock.WriteLock closeLock = this.mCloseLock.writeLock();
            closeLock.lock();
            try {
                this.mInvalidationTracker.stopMultiInstanceInvalidation();
                this.mOpenHelper.close();
            }
            finally {
                closeLock.unlock();
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void assertNotMainThread() {
        if (this.mAllowMainThreadQueries) {
            return;
        }
        if (RoomDatabase.isMainThread()) {
            throw new IllegalStateException("Cannot access database on the main thread since it may potentially lock the UI for a long period of time.");
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void assertNotSuspendingTransaction() {
        if (!this.inTransaction() && this.mSuspendingTransactionId.get() != null) {
            throw new IllegalStateException("Cannot access database on a different coroutine context inherited from a suspending transaction.");
        }
    }

    @NonNull
    public Cursor query(@NonNull String query, @Nullable Object[] args) {
        return this.mOpenHelper.getWritableDatabase().query((SupportSQLiteQuery)new SimpleSQLiteQuery(query, args));
    }

    @NonNull
    public Cursor query(@NonNull SupportSQLiteQuery query) {
        return this.query(query, null);
    }

    @NonNull
    public Cursor query(@NonNull SupportSQLiteQuery query, @Nullable CancellationSignal signal) {
        this.assertNotMainThread();
        this.assertNotSuspendingTransaction();
        if (signal != null && Build.VERSION.SDK_INT >= 16) {
            return this.mOpenHelper.getWritableDatabase().query(query, signal);
        }
        return this.mOpenHelper.getWritableDatabase().query(query);
    }

    public SupportSQLiteStatement compileStatement(@NonNull String sql) {
        this.assertNotMainThread();
        this.assertNotSuspendingTransaction();
        return this.mOpenHelper.getWritableDatabase().compileStatement(sql);
    }

    @Deprecated
    public void beginTransaction() {
        this.assertNotMainThread();
        SupportSQLiteDatabase database = this.mOpenHelper.getWritableDatabase();
        this.mInvalidationTracker.syncTriggers(database);
        database.beginTransaction();
    }

    @Deprecated
    public void endTransaction() {
        this.mOpenHelper.getWritableDatabase().endTransaction();
        if (!this.inTransaction()) {
            this.mInvalidationTracker.refreshVersionsAsync();
        }
    }

    @NonNull
    public Executor getQueryExecutor() {
        return this.mQueryExecutor;
    }

    @NonNull
    public Executor getTransactionExecutor() {
        return this.mTransactionExecutor;
    }

    @Deprecated
    public void setTransactionSuccessful() {
        this.mOpenHelper.getWritableDatabase().setTransactionSuccessful();
    }

    public void runInTransaction(@NonNull Runnable body) {
        this.beginTransaction();
        try {
            body.run();
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V runInTransaction(@NonNull Callable<V> body) {
        this.beginTransaction();
        try {
            V result = body.call();
            this.setTransactionSuccessful();
            V v = result;
            return v;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            SneakyThrow.reThrow(e);
            V v = null;
            return v;
        }
        finally {
            this.endTransaction();
        }
    }

    protected void internalInitInvalidationTracker(@NonNull SupportSQLiteDatabase db) {
        this.mInvalidationTracker.internalInit(db);
    }

    @NonNull
    public InvalidationTracker getInvalidationTracker() {
        return this.mInvalidationTracker;
    }

    public boolean inTransaction() {
        return this.mOpenHelper.getWritableDatabase().inTransaction();
    }

    private static boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static abstract class PrepackagedDatabaseCallback {
        public void onOpenPrepackagedDatabase(@NonNull SupportSQLiteDatabase db) {
        }
    }

    public static abstract class Callback {
        public void onCreate(@NonNull SupportSQLiteDatabase db) {
        }

        public void onOpen(@NonNull SupportSQLiteDatabase db) {
        }

        public void onDestructiveMigration(@NonNull SupportSQLiteDatabase db) {
        }
    }

    public static class MigrationContainer {
        private HashMap<Integer, TreeMap<Integer, Migration>> mMigrations = new HashMap();

        public void addMigrations(Migration ... migrations) {
            for (Migration migration : migrations) {
                this.addMigration(migration);
            }
        }

        private void addMigration(Migration migration) {
            Migration existing;
            int start = migration.startVersion;
            int end = migration.endVersion;
            TreeMap<Integer, Migration> targetMap = this.mMigrations.get(start);
            if (targetMap == null) {
                targetMap = new TreeMap();
                this.mMigrations.put(start, targetMap);
            }
            if ((existing = targetMap.get(end)) != null) {
                Log.w((String)"ROOM", (String)("Overriding migration " + existing + " with " + migration));
            }
            targetMap.put(end, migration);
        }

        @Nullable
        public List<Migration> findMigrationPath(int start, int end) {
            if (start == end) {
                return Collections.emptyList();
            }
            boolean migrateUp = end > start;
            ArrayList<Migration> result = new ArrayList<Migration>();
            return this.findUpMigrationPath(result, migrateUp, start, end);
        }

        private List<Migration> findUpMigrationPath(List<Migration> result, boolean upgrade, int start, int end) {
            while (upgrade ? start < end : start > end) {
                TreeMap<Integer, Migration> targetNodes = this.mMigrations.get(start);
                if (targetNodes == null) {
                    return null;
                }
                Set<Integer> keySet = upgrade ? targetNodes.descendingKeySet() : targetNodes.keySet();
                boolean found = false;
                for (int targetVersion : keySet) {
                    boolean shouldAddToPath;
                    if (upgrade) {
                        shouldAddToPath = targetVersion <= end && targetVersion > start;
                    } else {
                        boolean bl = shouldAddToPath = targetVersion >= end && targetVersion < start;
                    }
                    if (!shouldAddToPath) continue;
                    result.add(targetNodes.get(targetVersion));
                    start = targetVersion;
                    found = true;
                    break;
                }
                if (found) continue;
                return null;
            }
            return result;
        }
    }

    public static class Builder<T extends RoomDatabase> {
        private final Class<T> mDatabaseClass;
        private final String mName;
        private final Context mContext;
        private ArrayList<Callback> mCallbacks;
        private PrepackagedDatabaseCallback mPrepackagedDatabaseCallback;
        private List<Object> mTypeConverters;
        private Executor mQueryExecutor;
        private Executor mTransactionExecutor;
        private SupportSQLiteOpenHelper.Factory mFactory;
        private boolean mAllowMainThreadQueries;
        private JournalMode mJournalMode;
        private boolean mMultiInstanceInvalidation;
        private boolean mRequireMigration;
        private boolean mAllowDestructiveMigrationOnDowngrade;
        private final MigrationContainer mMigrationContainer;
        private Set<Integer> mMigrationsNotRequiredFrom;
        private Set<Integer> mMigrationStartAndEndVersions;
        private String mCopyFromAssetPath;
        private File mCopyFromFile;
        private Callable<InputStream> mCopyFromInputStream;

        Builder(@NonNull Context context, @NonNull Class<T> klass, @Nullable String name) {
            this.mContext = context;
            this.mDatabaseClass = klass;
            this.mName = name;
            this.mJournalMode = JournalMode.AUTOMATIC;
            this.mRequireMigration = true;
            this.mMigrationContainer = new MigrationContainer();
        }

        @NonNull
        public Builder<T> createFromAsset(@NonNull String databaseFilePath) {
            this.mCopyFromAssetPath = databaseFilePath;
            return this;
        }

        @NonNull
        @SuppressLint(value={"BuilderSetStyle"})
        public Builder<T> createFromAsset(@NonNull String databaseFilePath, @NonNull PrepackagedDatabaseCallback callback) {
            this.mPrepackagedDatabaseCallback = callback;
            this.mCopyFromAssetPath = databaseFilePath;
            return this;
        }

        @NonNull
        public Builder<T> createFromFile(@NonNull File databaseFile) {
            this.mCopyFromFile = databaseFile;
            return this;
        }

        @NonNull
        @SuppressLint(value={"BuilderSetStyle", "StreamFiles"})
        public Builder<T> createFromFile(@NonNull File databaseFile, @NonNull PrepackagedDatabaseCallback callback) {
            this.mPrepackagedDatabaseCallback = callback;
            this.mCopyFromFile = databaseFile;
            return this;
        }

        @NonNull
        @SuppressLint(value={"BuilderSetStyle"})
        public Builder<T> createFromInputStream(@NonNull Callable<InputStream> inputStreamCallable) {
            this.mCopyFromInputStream = inputStreamCallable;
            return this;
        }

        @NonNull
        @SuppressLint(value={"BuilderSetStyle", "LambdaLast"})
        public Builder<T> createFromInputStream(@NonNull Callable<InputStream> inputStreamCallable, @NonNull PrepackagedDatabaseCallback callback) {
            this.mPrepackagedDatabaseCallback = callback;
            this.mCopyFromInputStream = inputStreamCallable;
            return this;
        }

        @NonNull
        public Builder<T> openHelperFactory(@Nullable SupportSQLiteOpenHelper.Factory factory) {
            this.mFactory = factory;
            return this;
        }

        @NonNull
        public Builder<T> addMigrations(Migration ... migrations) {
            if (this.mMigrationStartAndEndVersions == null) {
                this.mMigrationStartAndEndVersions = new HashSet<Integer>();
            }
            for (Migration migration : migrations) {
                this.mMigrationStartAndEndVersions.add(migration.startVersion);
                this.mMigrationStartAndEndVersions.add(migration.endVersion);
            }
            this.mMigrationContainer.addMigrations(migrations);
            return this;
        }

        @NonNull
        public Builder<T> allowMainThreadQueries() {
            this.mAllowMainThreadQueries = true;
            return this;
        }

        @NonNull
        public Builder<T> setJournalMode(@NonNull JournalMode journalMode) {
            this.mJournalMode = journalMode;
            return this;
        }

        @NonNull
        public Builder<T> setQueryExecutor(@NonNull Executor executor) {
            this.mQueryExecutor = executor;
            return this;
        }

        @NonNull
        public Builder<T> setTransactionExecutor(@NonNull Executor executor) {
            this.mTransactionExecutor = executor;
            return this;
        }

        @NonNull
        public Builder<T> enableMultiInstanceInvalidation() {
            this.mMultiInstanceInvalidation = this.mName != null;
            return this;
        }

        @NonNull
        public Builder<T> fallbackToDestructiveMigration() {
            this.mRequireMigration = false;
            this.mAllowDestructiveMigrationOnDowngrade = true;
            return this;
        }

        @NonNull
        public Builder<T> fallbackToDestructiveMigrationOnDowngrade() {
            this.mRequireMigration = true;
            this.mAllowDestructiveMigrationOnDowngrade = true;
            return this;
        }

        @NonNull
        public Builder<T> fallbackToDestructiveMigrationFrom(int ... startVersions) {
            if (this.mMigrationsNotRequiredFrom == null) {
                this.mMigrationsNotRequiredFrom = new HashSet<Integer>(startVersions.length);
            }
            for (int startVersion : startVersions) {
                this.mMigrationsNotRequiredFrom.add(startVersion);
            }
            return this;
        }

        @NonNull
        public Builder<T> addCallback(@NonNull Callback callback) {
            if (this.mCallbacks == null) {
                this.mCallbacks = new ArrayList();
            }
            this.mCallbacks.add(callback);
            return this;
        }

        @NonNull
        public Builder<T> addTypeConverter(@NonNull Object typeConverter) {
            if (this.mTypeConverters == null) {
                this.mTypeConverters = new ArrayList<Object>();
            }
            this.mTypeConverters.add(typeConverter);
            return this;
        }

        @SuppressLint(value={"RestrictedApi"})
        @NonNull
        public T build() {
            if (this.mContext == null) {
                throw new IllegalArgumentException("Cannot provide null context for the database.");
            }
            if (this.mDatabaseClass == null) {
                throw new IllegalArgumentException("Must provide an abstract class that extends RoomDatabase");
            }
            if (this.mQueryExecutor == null && this.mTransactionExecutor == null) {
                this.mQueryExecutor = this.mTransactionExecutor = ArchTaskExecutor.getIOThreadExecutor();
            } else if (this.mQueryExecutor != null && this.mTransactionExecutor == null) {
                this.mTransactionExecutor = this.mQueryExecutor;
            } else if (this.mQueryExecutor == null && this.mTransactionExecutor != null) {
                this.mQueryExecutor = this.mTransactionExecutor;
            }
            if (this.mMigrationStartAndEndVersions != null && this.mMigrationsNotRequiredFrom != null) {
                for (Integer version : this.mMigrationStartAndEndVersions) {
                    if (!this.mMigrationsNotRequiredFrom.contains(version)) continue;
                    throw new IllegalArgumentException("Inconsistency detected. A Migration was supplied to addMigration(Migration... migrations) that has a start or end version equal to a start version supplied to fallbackToDestructiveMigrationFrom(int... startVersions). Start version: " + version);
                }
            }
            if (this.mFactory == null) {
                this.mFactory = new FrameworkSQLiteOpenHelperFactory();
            }
            if (this.mCopyFromAssetPath != null || this.mCopyFromFile != null || this.mCopyFromInputStream != null) {
                if (this.mName == null) {
                    throw new IllegalArgumentException("Cannot create from asset or file for an in-memory database.");
                }
                int copyConfigurations = (this.mCopyFromAssetPath == null ? 0 : 1) + (this.mCopyFromFile == null ? 0 : 1) + (this.mCopyFromInputStream == null ? 0 : 1);
                if (copyConfigurations != 1) {
                    throw new IllegalArgumentException("More than one of createFromAsset(), createFromInputStream(), and createFromFile() were called on this Builder, but the database can only be created using one of the three configurations.");
                }
                this.mFactory = new SQLiteCopyOpenHelperFactory(this.mCopyFromAssetPath, this.mCopyFromFile, this.mCopyFromInputStream, this.mFactory);
            }
            DatabaseConfiguration configuration = new DatabaseConfiguration(this.mContext, this.mName, this.mFactory, this.mMigrationContainer, this.mCallbacks, this.mAllowMainThreadQueries, this.mJournalMode.resolve(this.mContext), this.mQueryExecutor, this.mTransactionExecutor, this.mMultiInstanceInvalidation, this.mRequireMigration, this.mAllowDestructiveMigrationOnDowngrade, this.mMigrationsNotRequiredFrom, this.mCopyFromAssetPath, this.mCopyFromFile, this.mCopyFromInputStream, this.mPrepackagedDatabaseCallback, this.mTypeConverters);
            RoomDatabase db = (RoomDatabase)Room.getGeneratedImplementation(this.mDatabaseClass, RoomDatabase.DB_IMPL_SUFFIX);
            db.init(configuration);
            return (T)db;
        }
    }

    public static enum JournalMode {
        AUTOMATIC,
        TRUNCATE,
        WRITE_AHEAD_LOGGING;


        @SuppressLint(value={"NewApi"})
        JournalMode resolve(Context context) {
            ActivityManager manager;
            if (this != AUTOMATIC) {
                return this;
            }
            if (Build.VERSION.SDK_INT >= 16 && (manager = (ActivityManager)context.getSystemService("activity")) != null && !JournalMode.isLowRamDevice(manager)) {
                return WRITE_AHEAD_LOGGING;
            }
            return TRUNCATE;
        }

        private static boolean isLowRamDevice(@NonNull ActivityManager activityManager) {
            if (Build.VERSION.SDK_INT >= 19) {
                return activityManager.isLowRamDevice();
            }
            return false;
        }
    }
}

