/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.annotation.SuppressLint;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.lifecycle.LiveData;
import androidx.room.InvalidationLiveDataContainer;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

class RoomTrackingLiveData<T>
extends LiveData<T> {
    final RoomDatabase mDatabase;
    final Callable<T> mComputeFunction;
    private final InvalidationLiveDataContainer mContainer;
    final InvalidationTracker.Observer mObserver;
    final AtomicBoolean mInvalid = new AtomicBoolean(true);
    final AtomicBoolean mComputing = new AtomicBoolean(false);
    final AtomicBoolean mRegisteredObserver = new AtomicBoolean(false);
    final Runnable mRefreshRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @WorkerThread
        public void run() {
            boolean computed;
            if (RoomTrackingLiveData.this.mRegisteredObserver.compareAndSet(false, true)) {
                RoomTrackingLiveData.this.mDatabase.getInvalidationTracker().addWeakObserver(RoomTrackingLiveData.this.mObserver);
            }
            do {
                computed = false;
                if (!RoomTrackingLiveData.this.mComputing.compareAndSet(false, true)) continue;
                try {
                    Object value = null;
                    while (RoomTrackingLiveData.this.mInvalid.compareAndSet(true, false)) {
                        computed = true;
                        try {
                            value = RoomTrackingLiveData.this.mComputeFunction.call();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Exception while computing database live data.", e);
                        }
                    }
                    if (!computed) continue;
                    RoomTrackingLiveData.this.postValue(value);
                }
                finally {
                    RoomTrackingLiveData.this.mComputing.set(false);
                }
            } while (computed && RoomTrackingLiveData.this.mInvalid.get());
        }
    };
    final Runnable mInvalidationRunnable = new Runnable(){

        @Override
        @MainThread
        public void run() {
            boolean isActive = RoomTrackingLiveData.this.hasActiveObservers();
            if (RoomTrackingLiveData.this.mInvalid.compareAndSet(false, true) && isActive) {
                RoomTrackingLiveData.this.mDatabase.getQueryExecutor().execute(RoomTrackingLiveData.this.mRefreshRunnable);
            }
        }
    };

    @SuppressLint(value={"RestrictedApi"})
    RoomTrackingLiveData(RoomDatabase database, InvalidationLiveDataContainer container, Callable<T> computeFunction, String[] tableNames) {
        this.mDatabase = database;
        this.mComputeFunction = computeFunction;
        this.mContainer = container;
        this.mObserver = new InvalidationTracker.Observer(tableNames){

            @Override
            public void onInvalidated(@NonNull Set<String> tables) {
                ArchTaskExecutor.getInstance().executeOnMainThread(RoomTrackingLiveData.this.mInvalidationRunnable);
            }
        };
    }

    protected void onActive() {
        super.onActive();
        this.mContainer.onActive(this);
        this.mDatabase.getQueryExecutor().execute(this.mRefreshRunnable);
    }

    protected void onInactive() {
        super.onInactive();
        this.mContainer.onInactive(this);
    }
}

