/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.coroutines;

import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.selects.SelectClause2;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\u0012\u0010\u0014\u001a\u00020\u00132\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017J\u0011\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000fH\u0096\u0001J\u001a\u0010\u0004\u001a\u00020\u00132\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0096A\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0007J\u0006\u0010\u001d\u001a\u00020\u0000J\u0011\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0096\u0001J\b\u0010\"\u001a\u00020!H\u0016J\u0015\u0010#\u001a\u00020\u000b2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0096\u0001J\u0015\u0010$\u001a\u00020\u00132\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0096\u0001R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0004\u0012\u00020\u00020\u000e8\u0016X\u0097\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Landroidx/room/coroutines/ConnectionWithLock;", "Landroidx/sqlite/SQLiteConnection;", "Lkotlinx/coroutines/sync/Mutex;", "delegate", "lock", "(Landroidx/sqlite/SQLiteConnection;Lkotlinx/coroutines/sync/Mutex;)V", "acquireCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "acquireThrowable", "", "isLocked", "", "()Z", "onLock", "Lkotlinx/coroutines/selects/SelectClause2;", "", "getOnLock", "()Lkotlinx/coroutines/selects/SelectClause2;", "close", "", "dump", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "holdsLock", "owner", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "markAcquired", "context", "markReleased", "prepare", "Landroidx/sqlite/SQLiteStatement;", "sql", "", "toString", "tryLock", "unlock", "room-runtime"})
@SourceDebugExtension(value={"SMAP\nConnectionPoolImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionPoolImpl.kt\nandroidx/room/coroutines/ConnectionWithLock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,530:1\n1#2:531\n1855#3,2:532\n*S KotlinDebug\n*F\n+ 1 ConnectionPoolImpl.kt\nandroidx/room/coroutines/ConnectionWithLock\n*L\n291#1:532,2\n*E\n"})
final class ConnectionWithLock
implements SQLiteConnection,
Mutex {
    @NotNull
    private final SQLiteConnection delegate;
    @NotNull
    private final Mutex lock;
    @Nullable
    private CoroutineContext acquireCoroutineContext;
    @Nullable
    private Throwable acquireThrowable;

    public ConnectionWithLock(@NotNull SQLiteConnection delegate, @NotNull Mutex lock) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
        this.delegate = delegate;
        this.lock = lock;
    }

    public /* synthetic */ ConnectionWithLock(SQLiteConnection sQLiteConnection, Mutex mutex, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        }
        this(sQLiteConnection, mutex);
    }

    public void close() {
        this.delegate.close();
    }

    @NotNull
    public SQLiteStatement prepare(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        return this.delegate.prepare(sql);
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @NotNull
    public SelectClause2<Object, Mutex> getOnLock() {
        return this.lock.getOnLock();
    }

    public boolean holdsLock(@NotNull Object owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        return this.lock.holdsLock(owner);
    }

    @Nullable
    public Object lock(@Nullable Object owner, @NotNull Continuation<? super Unit> $completion) {
        return this.lock.lock(owner, $completion);
    }

    public boolean tryLock(@Nullable Object owner) {
        return this.lock.tryLock(owner);
    }

    public void unlock(@Nullable Object owner) {
        this.lock.unlock(owner);
    }

    @NotNull
    public final ConnectionWithLock markAcquired(@NotNull CoroutineContext context) {
        ConnectionWithLock connectionWithLock;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ConnectionWithLock $this$markAcquired_u24lambda_u240 = connectionWithLock = this;
        boolean bl = false;
        $this$markAcquired_u24lambda_u240.acquireCoroutineContext = context;
        $this$markAcquired_u24lambda_u240.acquireThrowable = new Throwable();
        return connectionWithLock;
    }

    @NotNull
    public final ConnectionWithLock markReleased() {
        ConnectionWithLock connectionWithLock;
        ConnectionWithLock $this$markReleased_u24lambda_u241 = connectionWithLock = this;
        boolean bl = false;
        $this$markReleased_u24lambda_u241.acquireCoroutineContext = null;
        $this$markReleased_u24lambda_u241.acquireThrowable = null;
        return connectionWithLock;
    }

    public final void dump(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (this.acquireCoroutineContext != null || this.acquireThrowable != null) {
            StringBuilder stringBuilder;
            Object it;
            StringBuilder stringBuilder2 = builder.append("\t\tStatus: Acquired connection");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            CoroutineContext coroutineContext = this.acquireCoroutineContext;
            if (coroutineContext != null) {
                it = coroutineContext;
                boolean bl = false;
                StringBuilder stringBuilder3 = builder.append("\t\tCoroutine: " + it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                StringBuilder stringBuilder4 = stringBuilder3.append('\n');
                stringBuilder = stringBuilder4;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append('\\n')");
            } else {
                stringBuilder = null;
            }
            Throwable throwable = this.acquireThrowable;
            if (throwable != null) {
                it = throwable;
                boolean bl = false;
                StringBuilder stringBuilder5 = builder.append("\t\tAcquired:");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
                Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)StringsKt.lines((CharSequence)ExceptionsKt.stackTraceToString((Throwable)it)), (int)1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String line = (String)element$iv;
                    boolean bl2 = false;
                    StringBuilder stringBuilder6 = builder.append("\t\t" + line);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
                }
            }
        } else {
            StringBuilder stringBuilder = builder.append("\t\tStatus: Free connection");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
    }

    @NotNull
    public String toString() {
        return this.delegate.toString();
    }
}

