/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.coroutines;

import androidx.room.coroutines.ConnectionWithLock;
import androidx.sqlite.SQLiteConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.atomicfu.AtomicFU;
import kotlinx.atomicfu.AtomicInt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0012\u0010\u0018\u001a\u00020\u00172\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bJ\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\fJ\b\u0010\u001e\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Landroidx/room/coroutines/Pool;", "", "capacity", "", "connectionFactory", "Lkotlin/Function0;", "Landroidx/sqlite/SQLiteConnection;", "(ILkotlin/jvm/functions/Function0;)V", "getCapacity", "()I", "channel", "Lkotlinx/coroutines/channels/Channel;", "Landroidx/room/coroutines/ConnectionWithLock;", "getConnectionFactory", "()Lkotlin/jvm/functions/Function0;", "connections", "", "[Landroidx/room/coroutines/ConnectionWithLock;", "size", "Lkotlinx/atomicfu/AtomicInt;", "acquire", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "", "dump", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recycle", "connection", "tryOpenNewConnection", "room-runtime"})
@SourceDebugExtension(value={"SMAP\nConnectionPoolImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionPoolImpl.kt\nandroidx/room/coroutines/Pool\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,530:1\n13579#2,2:531\n13644#2,3:533\n*S KotlinDebug\n*F\n+ 1 ConnectionPoolImpl.kt\nandroidx/room/coroutines/Pool\n*L\n253#1:531,2\n259#1:533,3\n*E\n"})
final class Pool {
    private final int capacity;
    @NotNull
    private final Function0<SQLiteConnection> connectionFactory;
    @NotNull
    private final AtomicInt size;
    @NotNull
    private final ConnectionWithLock[] connections;
    @NotNull
    private final Channel<ConnectionWithLock> channel;

    public Pool(int capacity, @NotNull Function0<? extends SQLiteConnection> connectionFactory) {
        Intrinsics.checkNotNullParameter(connectionFactory, (String)"connectionFactory");
        this.capacity = capacity;
        this.connectionFactory = connectionFactory;
        this.size = AtomicFU.atomic((int)0);
        this.connections = new ConnectionWithLock[this.capacity];
        this.channel = ChannelKt.Channel$default((int)this.capacity, null, (Function1)((Function1)new Function1<ConnectionWithLock, Unit>(this){
            final /* synthetic */ Pool this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ConnectionWithLock it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.recycle(it);
            }
        }), (int)2, null);
    }

    public final int getCapacity() {
        return this.capacity;
    }

    @NotNull
    public final Function0<SQLiteConnection> getConnectionFactory() {
        return this.connectionFactory;
    }

    @Nullable
    public final Object acquire(@NotNull Continuation<? super ConnectionWithLock> $completion) {
        Object receiveResult = this.channel.tryReceive-PtdJZtk();
        if (!ChannelResult.isSuccess-impl((Object)receiveResult)) {
            this.tryOpenNewConnection();
            return this.channel.receive($completion);
        }
        return (ConnectionWithLock)ChannelResult.getOrThrow-impl((Object)receiveResult);
    }

    private final void tryOpenNewConnection() {
        int currentSize = this.size.getValue();
        if (currentSize >= this.capacity) {
            return;
        }
        if (this.size.compareAndSet(currentSize, currentSize + 1)) {
            ConnectionWithLock newConnection = new ConnectionWithLock((SQLiteConnection)this.connectionFactory.invoke(), null, 2, null);
            Object sendResult = this.channel.trySend-JP2dKIU((Object)newConnection);
            if (ChannelResult.isSuccess-impl((Object)sendResult)) {
                this.connections[currentSize] = newConnection;
            } else {
                newConnection.close();
                if (!ChannelResult.isClosed-impl((Object)sendResult)) {
                    throw new IllegalStateException("Couldn't send a new connection for acquisition".toString());
                }
            }
        } else {
            this.tryOpenNewConnection();
        }
    }

    public final void recycle(@NotNull ConnectionWithLock connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Object sendResult = this.channel.trySend-JP2dKIU((Object)connection);
        if (!ChannelResult.isSuccess-impl((Object)sendResult)) {
            connection.close();
            if (!ChannelResult.isClosed-impl((Object)sendResult)) {
                throw new IllegalStateException("Couldn't recycle connection".toString());
            }
        }
    }

    public final void close() {
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.channel), null, (int)1, null);
        ConnectionWithLock[] $this$forEach$iv = this.connections;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            ConnectionWithLock element$iv;
            ConnectionWithLock it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            ConnectionWithLock connectionWithLock = it;
            if (connectionWithLock == null) continue;
            connectionWithLock.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dump(@NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        StringBuilder stringBuilder = builder.append('\t' + super.toString() + " (capacity=" + this.capacity + ')');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        ConnectionWithLock[] $this$forEachIndexed$iv = this.connections;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (ConnectionWithLock item$iv : $this$forEachIndexed$iv) {
            void connection;
            int n = index$iv++;
            ConnectionWithLock connectionWithLock = item$iv;
            int index = n;
            boolean bl = false;
            void v2 = connection;
            StringBuilder stringBuilder2 = builder.append("\t\t[" + (index + 1) + "] - " + (v2 != null ? v2.toString() : null));
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
            void v4 = connection;
            if (v4 == null) continue;
            v4.dump(builder);
        }
    }
}

