/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.concurrent;

import androidx.room.concurrent.FileLock;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f\u00a2\u0006\u0002\u0010\u0010R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Landroidx/room/concurrent/ExclusiveLock;", "", "filename", "", "useFileLock", "", "(Ljava/lang/String;Z)V", "fileLock", "Landroidx/room/concurrent/FileLock;", "threadLock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/atomicfu/locks/ReentrantLock;", "withLock", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "room-runtime"})
public final class ExclusiveLock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReentrantLock threadLock;
    @Nullable
    private final FileLock fileLock;
    @NotNull
    private static final Map<String, ReentrantLock> threadLocksMap = new LinkedHashMap();

    public ExclusiveLock(@NotNull String filename, boolean useFileLock) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.threadLock = ExclusiveLock.Companion.getThreadLock(filename);
        this.fileLock = useFileLock ? ExclusiveLock.Companion.getFileLock(filename) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withLock(@NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.threadLock.lock();
        try {
            FileLock fileLock;
            Object object;
            FileLock fileLock2 = this.fileLock;
            if (fileLock2 != null) {
                fileLock2.lock();
            }
            try {
                object = block.invoke();
                fileLock = this.fileLock;
            }
            catch (Throwable throwable) {
                FileLock fileLock3 = this.fileLock;
                if (fileLock3 != null) {
                    fileLock3.unlock();
                }
                throw throwable;
            }
            if (fileLock != null) {
                fileLock.unlock();
            }
            return (T)object;
        }
        finally {
            this.threadLock.unlock();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0014\u0010\f\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/room/concurrent/ExclusiveLock$Companion;", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "()V", "threadLocksMap", "", "", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/atomicfu/locks/ReentrantLock;", "getFileLock", "Landroidx/room/concurrent/FileLock;", "key", "getThreadLock", "room-runtime"})
    @SourceDebugExtension(value={"SMAP\nExclusiveLock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExclusiveLock.kt\nandroidx/room/concurrent/ExclusiveLock$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,68:1\n361#2,7:69\n*S KotlinDebug\n*F\n+ 1 ExclusiveLock.kt\nandroidx/room/concurrent/ExclusiveLock$Companion\n*L\n62#1:69,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final ReentrantLock getThreadLock(String key) {
            synchronized (this) {
                Object object;
                boolean bl = false;
                Map $this$getOrPut$iv = threadLocksMap;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key);
                if (value$iv == null) {
                    boolean bl2 = false;
                    ReentrantLock answer$iv = new ReentrantLock();
                    $this$getOrPut$iv.put(key, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ReentrantLock reentrantLock = (ReentrantLock)object;
                return reentrantLock;
            }
        }

        private final FileLock getFileLock(String key) {
            return new FileLock(key);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

