/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.RestrictTo;
import androidx.room.DatabaseConfiguration;
import androidx.room.RoomDatabase;
import androidx.room.RoomMasterTable;
import androidx.room.RoomOpenDelegate;
import androidx.room.Transactor;
import androidx.room.concurrent.ExclusiveLock;
import androidx.room.migration.Migration;
import androidx.room.util.MigrationUtil;
import androidx.sqlite.SQLite;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteDriver;
import androidx.sqlite.SQLiteStatement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000 52\u00020\u0001:\u000256B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J \u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0004J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J@\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0006\u0010,\u001a\u00020\r2\"\u0010-\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u0002H+00\u0012\u0006\u0012\u0004\u0018\u00010\u00010.H\u00a6@\u00a2\u0006\u0002\u00101J\f\u00102\u001a\u00020&*\u000203H\u0004J\f\u00104\u001a\u00020&*\u000203H\u0004R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00067"}, d2={"Landroidx/room/BaseRoomConnectionManager;", "", "()V", "callbacks", "", "Landroidx/room/RoomDatabase$Callback;", "getCallbacks", "()Ljava/util/List;", "configuration", "Landroidx/room/DatabaseConfiguration;", "getConfiguration", "()Landroidx/room/DatabaseConfiguration;", "isConfigured", "", "isInitializing", "openDelegate", "Landroidx/room/RoomOpenDelegate;", "getOpenDelegate", "()Landroidx/room/RoomOpenDelegate;", "checkIdentity", "", "connection", "Landroidx/sqlite/SQLiteConnection;", "configurationConnection", "configureBusyTimeout", "configureDatabase", "configureJournalMode", "configureSynchronousFlag", "createMasterTableIfNotExists", "dropAllTables", "hasEmptySchema", "hasRoomMasterTable", "invokeCreateCallback", "invokeDestructiveMigrationCallback", "invokeOpenCallback", "onCreate", "onMigrate", "oldVersion", "", "newVersion", "onOpen", "updateIdentity", "useConnection", "R", "isReadOnly", "block", "Lkotlin/Function2;", "Landroidx/room/Transactor;", "Lkotlin/coroutines/Continuation;", "(ZLkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMaxNumberOfReaders", "Landroidx/room/RoomDatabase$JournalMode;", "getMaxNumberOfWriters", "Companion", "DriverWrapper", "room-runtime"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SourceDebugExtension(value={"SMAP\nRoomConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomConnectionManager.kt\nandroidx/room/BaseRoomConnectionManager\n+ 2 SQLite.kt\nandroidx/sqlite/SQLite\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,336:1\n65#2,4:337\n65#2,4:342\n65#2,4:346\n65#2,4:352\n65#2,4:358\n65#2,4:362\n1#3:341\n1855#4,2:350\n1855#4,2:356\n1855#4,2:366\n1855#4,2:368\n1855#4,2:370\n*S KotlinDebug\n*F\n+ 1 RoomConnectionManager.kt\nandroidx/room/BaseRoomConnectionManager\n*L\n90#1:337,4\n147#1:342,4\n176#1:346,4\n222#1:352,4\n250#1:358,4\n297#1:362,4\n192#1:350,2\n233#1:356,2\n316#1:366,2\n320#1:368,2\n324#1:370,2\n*E\n"})
public abstract class BaseRoomConnectionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isConfigured;
    private boolean isInitializing;
    public static final int BUSY_TIMEOUT_MS = 3000;

    @NotNull
    protected abstract DatabaseConfiguration getConfiguration();

    @NotNull
    protected abstract RoomOpenDelegate getOpenDelegate();

    @NotNull
    protected abstract List<RoomDatabase.Callback> getCallbacks();

    @Nullable
    public abstract <R> Object useConnection(boolean var1, @NotNull Function2<? super Transactor, ? super Continuation<? super R>, ? extends Object> var2, @NotNull Continuation<? super R> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void configureDatabase(SQLiteConnection connection) {
        int statement22;
        this.configureJournalMode(connection);
        this.configureSynchronousFlag(connection);
        boolean $i$f$use = false;
        try (SQLiteStatement $this$use$iv = connection.prepare("PRAGMA user_version");){
            SQLiteStatement statement22 = $this$use$iv;
            boolean bl = false;
            statement22.step();
            statement22 = (int)statement22.getLong(0);
        }
        int version = statement22;
        if (version != this.getOpenDelegate().getVersion()) {
            Object $this$configureDatabase_u24lambda_u241;
            SQLite.execSQL((SQLiteConnection)connection, (String)"BEGIN EXCLUSIVE TRANSACTION");
            Object object = this;
            try {
                $this$configureDatabase_u24lambda_u241 = object;
                boolean bl = false;
                if (version == 0) {
                    ((BaseRoomConnectionManager)$this$configureDatabase_u24lambda_u241).onCreate(connection);
                } else {
                    ((BaseRoomConnectionManager)$this$configureDatabase_u24lambda_u241).onMigrate(connection, version, ((BaseRoomConnectionManager)$this$configureDatabase_u24lambda_u241).getOpenDelegate().getVersion());
                }
                SQLite.execSQL((SQLiteConnection)connection, (String)("PRAGMA user_version = " + ((BaseRoomConnectionManager)$this$configureDatabase_u24lambda_u241).getOpenDelegate().getVersion()));
                $this$configureDatabase_u24lambda_u241 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$configureDatabase_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$configureDatabase_u24lambda_u241;
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                SQLite.execSQL((SQLiteConnection)connection, (String)"END TRANSACTION");
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                SQLite.execSQL((SQLiteConnection)connection, (String)"ROLLBACK TRANSACTION");
                throw it;
            }
        }
        this.onOpen(connection);
    }

    private final void configurationConnection(SQLiteConnection connection) {
        this.configureSynchronousFlag(connection);
        this.configureBusyTimeout(connection);
        this.getOpenDelegate().onOpen(connection);
    }

    private final void configureJournalMode(SQLiteConnection connection) {
        boolean wal;
        boolean bl = wal = this.getConfiguration().getJournalMode() == RoomDatabase.JournalMode.WRITE_AHEAD_LOGGING;
        if (wal) {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA journal_mode = WAL");
        } else {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA journal_mode = TRUNCATE");
        }
    }

    private final void configureSynchronousFlag(SQLiteConnection connection) {
        boolean wal;
        boolean bl = wal = this.getConfiguration().getJournalMode() == RoomDatabase.JournalMode.WRITE_AHEAD_LOGGING;
        if (wal) {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA synchronous = NORMAL");
        } else {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA synchronous = FULL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void configureBusyTimeout(SQLiteConnection connection) {
        long l;
        boolean $i$f$use = false;
        try (SQLiteStatement $this$use$iv = connection.prepare("PRAGMA busy_timeout");){
            SQLiteStatement it = $this$use$iv;
            boolean bl = false;
            it.step();
            l = it.getLong(0);
        }
        long currentBusyTimeout = l;
        if (currentBusyTimeout < 3000L) {
            SQLite.execSQL((SQLiteConnection)connection, (String)"PRAGMA busy_timeout = 3000");
        }
    }

    protected final void onCreate(@NotNull SQLiteConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        boolean isEmptyDatabase = this.hasEmptySchema(connection);
        this.getOpenDelegate().createAllTables(connection);
        if (!isEmptyDatabase) {
            RoomOpenDelegate.ValidationResult result2 = this.getOpenDelegate().onValidateSchema(connection);
            if (!result2.isValid) {
                throw new IllegalStateException(("Pre-packaged database has an invalid schema: " + result2.expectedFoundMsg).toString());
            }
        }
        this.updateIdentity(connection);
        this.getOpenDelegate().onCreate(connection);
        this.invokeCreateCallback(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasEmptySchema(SQLiteConnection connection) {
        boolean bl;
        SQLiteStatement $this$use$iv = connection.prepare("SELECT count(*) FROM sqlite_master WHERE name != 'android_metadata'");
        boolean $i$f$use = false;
        try {
            SQLiteStatement it = $this$use$iv;
            boolean bl2 = false;
            bl = it.step() && it.getLong(0) == 0L;
        }
        finally {
            $this$use$iv.close();
        }
        return bl;
    }

    private final void updateIdentity(SQLiteConnection connection) {
        this.createMasterTableIfNotExists(connection);
        SQLite.execSQL((SQLiteConnection)connection, (String)RoomMasterTable.createInsertQuery((String)this.getOpenDelegate().getIdentityHash()));
    }

    private final void createMasterTableIfNotExists(SQLiteConnection connection) {
        SQLite.execSQL((SQLiteConnection)connection, (String)"CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
    }

    protected final void onMigrate(@NotNull SQLiteConnection connection, int oldVersion, int newVersion) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        boolean migrated = false;
        List<Migration> migrations = MigrationUtil.findMigrationPath(this.getConfiguration().getMigrationContainer(), oldVersion, newVersion);
        if (migrations != null) {
            this.getOpenDelegate().onPreMigrate(connection);
            Iterable $this$forEach$iv = migrations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Migration it = (Migration)element$iv;
                boolean bl = false;
                it.migrate(connection);
            }
            RoomOpenDelegate.ValidationResult result2 = this.getOpenDelegate().onValidateSchema(connection);
            if (!result2.isValid) {
                throw new IllegalStateException(("Migration didn't properly handle: " + result2.expectedFoundMsg).toString());
            }
            this.getOpenDelegate().onPostMigrate(connection);
            this.updateIdentity(connection);
            migrated = true;
        }
        if (!migrated) {
            if (MigrationUtil.isMigrationRequired(this.getConfiguration(), oldVersion, newVersion)) {
                throw new IllegalStateException(("A migration from " + oldVersion + " to " + newVersion + " was required but not found. Please provide the necessary Migration path via RoomDatabase.Builder.addMigration(...) or allow for destructive migrations via one of the RoomDatabase.Builder.fallbackToDestructiveMigration* methods.").toString());
            }
            this.dropAllTables(connection);
            this.invokeDestructiveMigrationCallback(connection);
            this.getOpenDelegate().createAllTables(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dropAllTables(SQLiteConnection connection) {
        if (this.getConfiguration().getAllowDestructiveMigrationForAllTables()) {
            List list;
            SQLiteStatement $this$use$iv = connection.prepare("SELECT name FROM sqlite_master WHERE type = 'table'");
            boolean $i$f$use = false;
            try {
                List list2;
                SQLiteStatement statement = $this$use$iv;
                boolean bl = false;
                List $this$dropAllTables_u24lambda_u248_u24lambda_u247 = list2 = CollectionsKt.createListBuilder();
                boolean bl2 = false;
                while (statement.step()) {
                    String name = statement.getText(0);
                    if (StringsKt.startsWith$default((String)name, (String)"sqlite_", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"android_metadata")) continue;
                    $this$dropAllTables_u24lambda_u248_u24lambda_u247.add(name);
                }
                list = CollectionsKt.build((List)list2);
            }
            finally {
                $this$use$iv.close();
            }
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String table = (String)element$iv;
                boolean bl = false;
                SQLite.execSQL((SQLiteConnection)connection, (String)("DROP TABLE IF EXISTS " + table));
            }
        } else {
            this.getOpenDelegate().dropAllTables(connection);
        }
    }

    protected final void onOpen(@NotNull SQLiteConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.checkIdentity(connection);
        this.getOpenDelegate().onOpen(connection);
        this.invokeOpenCallback(connection);
        this.isConfigured = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkIdentity(SQLiteConnection connection) {
        if (this.hasRoomMasterTable(connection)) {
            Object it;
            boolean $i$f$use = false;
            try (SQLiteStatement $this$use$iv = connection.prepare("SELECT identity_hash FROM room_master_table WHERE id = 42 LIMIT 1");){
                it = $this$use$iv;
                boolean bl = false;
                it = it.step() ? it.getText(0) : null;
            }
            Object identityHash = it;
            if (!Intrinsics.areEqual((Object)this.getOpenDelegate().getIdentityHash(), (Object)identityHash) && !Intrinsics.areEqual((Object)this.getOpenDelegate().getLegacyIdentityHash(), (Object)identityHash)) {
                throw new IllegalStateException(("Room cannot verify the data integrity. Looks like you've changed schema but forgot to update the version number. You can simply fix this by increasing the version number. Expected identity hash: " + this.getOpenDelegate().getIdentityHash() + ", found: " + (String)identityHash).toString());
            }
        } else {
            Object $this$checkIdentity_u24lambda_u2411;
            SQLite.execSQL((SQLiteConnection)connection, (String)"BEGIN EXCLUSIVE TRANSACTION");
            Object object = this;
            try {
                $this$checkIdentity_u24lambda_u2411 = object;
                boolean bl = false;
                RoomOpenDelegate.ValidationResult result2 = ((BaseRoomConnectionManager)$this$checkIdentity_u24lambda_u2411).getOpenDelegate().onValidateSchema(connection);
                if (!result2.isValid) {
                    throw new IllegalStateException(("Pre-packaged database has an invalid schema: " + result2.expectedFoundMsg).toString());
                }
                ((BaseRoomConnectionManager)$this$checkIdentity_u24lambda_u2411).getOpenDelegate().onPostMigrate(connection);
                super.updateIdentity(connection);
                $this$checkIdentity_u24lambda_u2411 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$checkIdentity_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$checkIdentity_u24lambda_u2411;
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                SQLite.execSQL((SQLiteConnection)connection, (String)"END TRANSACTION");
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it = throwable2 = throwable;
                boolean bl = false;
                SQLite.execSQL((SQLiteConnection)connection, (String)"ROLLBACK TRANSACTION");
                throw it;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean hasRoomMasterTable(SQLiteConnection connection) {
        boolean bl;
        SQLiteStatement $this$use$iv = connection.prepare("SELECT 1 FROM sqlite_master WHERE type = 'table' AND name = 'room_master_table'");
        boolean $i$f$use = false;
        try {
            SQLiteStatement it = $this$use$iv;
            boolean bl2 = false;
            bl = it.step() && it.getLong(0) != 0L;
        }
        finally {
            $this$use$iv.close();
        }
        return bl;
    }

    protected final int getMaxNumberOfReaders(@NotNull RoomDatabase.JournalMode $this$getMaxNumberOfReaders) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getMaxNumberOfReaders), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getMaxNumberOfReaders.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 4;
                break;
            }
            default: {
                throw new IllegalStateException(("Can't get max number of reader for journal mode '" + (Object)((Object)$this$getMaxNumberOfReaders) + '\'').toString());
            }
        }
        return n;
    }

    protected final int getMaxNumberOfWriters(@NotNull RoomDatabase.JournalMode $this$getMaxNumberOfWriters) {
        int n;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getMaxNumberOfWriters), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getMaxNumberOfWriters.ordinal()]) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                throw new IllegalStateException(("Can't get max number of writers for journal mode '" + (Object)((Object)$this$getMaxNumberOfWriters) + '\'').toString());
            }
        }
        return n;
    }

    private final void invokeCreateCallback(SQLiteConnection connection) {
        Iterable $this$forEach$iv = this.getCallbacks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoomDatabase.Callback it = (RoomDatabase.Callback)element$iv;
            boolean bl = false;
            it.onCreate(connection);
        }
    }

    private final void invokeDestructiveMigrationCallback(SQLiteConnection connection) {
        Iterable $this$forEach$iv = this.getCallbacks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoomDatabase.Callback it = (RoomDatabase.Callback)element$iv;
            boolean bl = false;
            it.onDestructiveMigration(connection);
        }
    }

    private final void invokeOpenCallback(SQLiteConnection connection) {
        Iterable $this$forEach$iv = this.getCallbacks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RoomDatabase.Callback it = (RoomDatabase.Callback)element$iv;
            boolean bl = false;
            it.onOpen(connection);
        }
    }

    public static final /* synthetic */ void access$setInitializing$p(BaseRoomConnectionManager $this, boolean bl) {
        $this.isInitializing = bl;
    }

    public static final /* synthetic */ void access$configureDatabase(BaseRoomConnectionManager $this, SQLiteConnection connection) {
        $this.configureDatabase(connection);
    }

    public static final /* synthetic */ void access$configurationConnection(BaseRoomConnectionManager $this, SQLiteConnection connection) {
        $this.configurationConnection(connection);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/room/BaseRoomConnectionManager$Companion;", "", "()V", "BUSY_TIMEOUT_MS", "", "room-runtime"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/room/BaseRoomConnectionManager$DriverWrapper;", "Landroidx/sqlite/SQLiteDriver;", "actual", "(Landroidx/room/BaseRoomConnectionManager;Landroidx/sqlite/SQLiteDriver;)V", "open", "Landroidx/sqlite/SQLiteConnection;", "fileName", "", "room-runtime"})
    protected final class DriverWrapper
    implements SQLiteDriver {
        @NotNull
        private final SQLiteDriver actual;

        public DriverWrapper(SQLiteDriver actual) {
            Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
            this.actual = actual;
        }

        @NotNull
        public SQLiteConnection open(@NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return (SQLiteConnection)new ExclusiveLock(fileName, !BaseRoomConnectionManager.this.isConfigured && !BaseRoomConnectionManager.this.isInitializing && !Intrinsics.areEqual((Object)fileName, (Object)":memory:")).withLock((Function0)new Function0<SQLiteConnection>(BaseRoomConnectionManager.this, this, fileName){
                final /* synthetic */ BaseRoomConnectionManager this$0;
                final /* synthetic */ DriverWrapper this$1;
                final /* synthetic */ String $fileName;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$fileName = $fileName;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final SQLiteConnection invoke() {
                    if (!(!BaseRoomConnectionManager.access$isInitializing$p(this.this$0))) {
                        boolean bl = false;
                        String string = "Recursive database initialization detected. Did you try to use the database instance during initialization? Maybe in one of the callbacks?";
                        throw new IllegalStateException(string.toString());
                    }
                    SQLiteConnection connection = DriverWrapper.access$getActual$p(this.this$1).open(this.$fileName);
                    if (!BaseRoomConnectionManager.access$isConfigured$p(this.this$0)) {
                        try {
                            BaseRoomConnectionManager.access$setInitializing$p(this.this$0, true);
                            BaseRoomConnectionManager.access$configureDatabase(this.this$0, connection);
                        }
                        finally {
                            BaseRoomConnectionManager.access$setInitializing$p(this.this$0, false);
                        }
                    } else {
                        BaseRoomConnectionManager.access$configurationConnection(this.this$0, connection);
                    }
                    return connection;
                }
            });
        }

        public static final /* synthetic */ SQLiteDriver access$getActual$p(DriverWrapper $this) {
            return $this.actual;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RoomDatabase.JournalMode.values().length];
            try {
                nArray[RoomDatabase.JournalMode.TRUNCATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RoomDatabase.JournalMode.WRITE_AHEAD_LOGGING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

