/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.paging.util;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.annotation.RestrictTo;
import androidx.paging.PagingSource;
import androidx.paging.PagingState;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0007\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u0001\u001a$\u0010\u000b\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001\u001ah\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u000f0\u000e\"\b\b\u0000\u0010\u000f*\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u00012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\u00190\u0017\u001a\u0016\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a'\u0010\u001b\u001a\u0004\u0018\u00010\u0001\"\b\b\u0000\u0010\u000f*\u00020\u0004*\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u000f0\u001c\u00a2\u0006\u0002\u0010\u001d\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"INITIAL_ITEM_COUNT", "", "INVALID", "Landroidx/paging/PagingSource$LoadResult$Invalid;", "", "getINVALID", "()Landroidx/paging/PagingSource$LoadResult$Invalid;", "getLimit", "params", "Landroidx/paging/PagingSource$LoadParams;", "key", "getOffset", "itemCount", "queryDatabase", "Landroidx/paging/PagingSource$LoadResult;", "Value", "sourceQuery", "Landroidx/room/RoomSQLiteQuery;", "db", "Landroidx/room/RoomDatabase;", "cancellationSignal", "Landroid/os/CancellationSignal;", "convertRows", "Lkotlin/Function1;", "Landroid/database/Cursor;", "", "queryItemCount", "getClippedRefreshKey", "Landroidx/paging/PagingState;", "(Landroidx/paging/PagingState;)Ljava/lang/Integer;", "room-paging_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RoomPagingUtilKt {
    @NotNull
    private static final PagingSource.LoadResult.Invalid<Object, Object> INVALID = new PagingSource.LoadResult.Invalid();
    public static final int INITIAL_ITEM_COUNT = -1;

    @NotNull
    public static final PagingSource.LoadResult.Invalid<Object, Object> getINVALID() {
        return INVALID;
    }

    public static final int getLimit(@NotNull PagingSource.LoadParams<Integer> params, int key) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        return params instanceof PagingSource.LoadParams.Prepend ? (key < params.getLoadSize() ? key : params.getLoadSize()) : params.getLoadSize();
    }

    public static final int getOffset(@NotNull PagingSource.LoadParams<Integer> params, int key, int itemCount) {
        int n;
        Intrinsics.checkNotNullParameter(params, (String)"params");
        PagingSource.LoadParams<Integer> loadParams = params;
        if (loadParams instanceof PagingSource.LoadParams.Prepend) {
            n = key < params.getLoadSize() ? 0 : key - params.getLoadSize();
        } else if (loadParams instanceof PagingSource.LoadParams.Append) {
            n = key;
        } else if (loadParams instanceof PagingSource.LoadParams.Refresh) {
            n = key >= itemCount ? Math.max(0, itemCount - params.getLoadSize()) : key;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final <Value> PagingSource.LoadResult<Integer, Value> queryDatabase(@NotNull PagingSource.LoadParams<Integer> params, @NotNull RoomSQLiteQuery sourceQuery, @NotNull RoomDatabase db, int itemCount, @Nullable CancellationSignal cancellationSignal, @NotNull Function1<? super Cursor, ? extends List<? extends Value>> convertRows) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)sourceQuery, (String)"sourceQuery");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter(convertRows, (String)"convertRows");
        Integer n = (Integer)params.getKey();
        int key = n != null ? n : 0;
        int limit = RoomPagingUtilKt.getLimit(params, key);
        int offset = RoomPagingUtilKt.getOffset(params, key, itemCount);
        String limitOffsetQuery = "SELECT * FROM ( " + sourceQuery.getSql() + " ) LIMIT " + limit + " OFFSET " + offset;
        RoomSQLiteQuery sqLiteQuery = RoomSQLiteQuery.Companion.acquire(limitOffsetQuery, sourceQuery.getArgCount());
        sqLiteQuery.copyArgumentsFrom(sourceQuery);
        Cursor cursor = db.query((SupportSQLiteQuery)sqLiteQuery, cancellationSignal);
        List data = null;
        try {
            data = (List)convertRows.invoke((Object)cursor);
        }
        finally {
            cursor.close();
            sqLiteQuery.release();
        }
        int nextPosToLoad = offset + data.size();
        Integer nextKey = data.isEmpty() || data.size() < limit || nextPosToLoad >= itemCount ? null : Integer.valueOf(nextPosToLoad);
        Integer prevKey = offset <= 0 || data.isEmpty() ? null : Integer.valueOf(offset);
        return (PagingSource.LoadResult)new PagingSource.LoadResult.Page(data, (Object)prevKey, (Object)nextKey, offset, Math.max(0, itemCount - nextPosToLoad));
    }

    public static /* synthetic */ PagingSource.LoadResult queryDatabase$default(PagingSource.LoadParams loadParams, RoomSQLiteQuery roomSQLiteQuery, RoomDatabase roomDatabase, int n, CancellationSignal cancellationSignal, Function1 function1, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            cancellationSignal = null;
        }
        return RoomPagingUtilKt.queryDatabase((PagingSource.LoadParams<Integer>)loadParams, roomSQLiteQuery, roomDatabase, n, cancellationSignal, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int queryItemCount(@NotNull RoomSQLiteQuery sourceQuery, @NotNull RoomDatabase db) {
        Intrinsics.checkNotNullParameter((Object)sourceQuery, (String)"sourceQuery");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        String countQuery = "SELECT COUNT(*) FROM ( " + sourceQuery.getSql() + " )";
        RoomSQLiteQuery sqLiteQuery = RoomSQLiteQuery.Companion.acquire(countQuery, sourceQuery.getArgCount());
        sqLiteQuery.copyArgumentsFrom(sourceQuery);
        Cursor cursor = RoomDatabase.query$default((RoomDatabase)db, (SupportSQLiteQuery)((SupportSQLiteQuery)sqLiteQuery), null, (int)2, null);
        try {
            if (cursor.moveToFirst()) {
                int n = cursor.getInt(0);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            cursor.close();
            sqLiteQuery.release();
        }
    }

    @Nullable
    public static final <Value> Integer getClippedRefreshKey(@NotNull PagingState<Integer, Value> $this$getClippedRefreshKey) {
        Intrinsics.checkNotNullParameter($this$getClippedRefreshKey, (String)"<this>");
        Integer anchorPosition = $this$getClippedRefreshKey.getAnchorPosition();
        return anchorPosition != null ? Integer.valueOf(Math.max(0, anchorPosition - $this$getClippedRefreshKey.getConfig().initialLoadSize / 2)) : null;
    }
}

