/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.migration.bundle;

import androidx.annotation.RestrictTo;
import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.SchemaEquality;
import androidx.room.migration.bundle.SchemaEqualityUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u000e\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0016R\u0016\u0010\u0004\u001a\u00020\u00058\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u00020\u00038\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Landroidx/room/migration/bundle/SchemaBundle;", "Landroidx/room/migration/bundle/SchemaEquality;", "formatVersion", "", "database", "Landroidx/room/migration/bundle/DatabaseBundle;", "(ILandroidx/room/migration/bundle/DatabaseBundle;)V", "getDatabase", "()Landroidx/room/migration/bundle/DatabaseBundle;", "getFormatVersion", "()I", "isSchemaEqual", "", "other", "Companion", "EntityTypeAdapterFactory", "room-migration"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class SchemaBundle
implements SchemaEquality<SchemaBundle> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @SerializedName(value="formatVersion")
    private final int formatVersion;
    @SerializedName(value="database")
    @NotNull
    private final DatabaseBundle database;
    @NotNull
    private static final String CHARSET = "UTF-8";
    public static final int LATEST_FORMAT = 1;
    @NotNull
    private static final Gson GSON;

    public SchemaBundle(int formatVersion, @NotNull DatabaseBundle database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.formatVersion = formatVersion;
        this.database = database;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    @NotNull
    public DatabaseBundle getDatabase() {
        return this.database;
    }

    @Override
    public boolean isSchemaEqual(@NotNull SchemaBundle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return SchemaEqualityUtil.INSTANCE.checkSchemaEquality((SchemaEquality)this.getDatabase(), (SchemaEquality)other.getDatabase()) && this.getFormatVersion() == other.getFormatVersion();
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NotNull
    public static final SchemaBundle deserialize(@NotNull InputStream fis) throws UnsupportedEncodingException {
        return Companion.deserialize(fis);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final void serialize(@NotNull SchemaBundle bundle, @NotNull File file) throws IOException {
        Companion.serialize(bundle, file);
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final void serialize(@NotNull SchemaBundle bundle, @NotNull OutputStream outputStream) throws IOException {
        Companion.serialize(bundle, outputStream);
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapterFactory((TypeAdapterFactory)new EntityTypeAdapterFactory()).create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n          \u2026  )\n            .create()");
        GSON = gson;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/room/migration/bundle/SchemaBundle$Companion;", "", "()V", "CHARSET", "", "GSON", "Lcom/google/gson/Gson;", "LATEST_FORMAT", "", "deserialize", "Landroidx/room/migration/bundle/SchemaBundle;", "fis", "Ljava/io/InputStream;", "serialize", "", "bundle", "file", "Ljava/io/File;", "outputStream", "Ljava/io/OutputStream;", "room-migration"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        @NotNull
        public final SchemaBundle deserialize(@NotNull InputStream fis) throws UnsupportedEncodingException {
            Intrinsics.checkNotNullParameter((Object)fis, (String)"fis");
            Closeable closeable = new InputStreamReader(fis, SchemaBundle.CHARSET);
            Throwable throwable = null;
            try {
                InputStreamReader inputStream = (InputStreamReader)closeable;
                boolean bl = false;
                SchemaBundle schemaBundle = (SchemaBundle)GSON.fromJson((Reader)inputStream, SchemaBundle.class);
                if (schemaBundle == null) {
                    throw new IllegalStateException("Empty schema file");
                }
                SchemaBundle schemaBundle2 = schemaBundle;
                return schemaBundle2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public final void serialize(@NotNull SchemaBundle bundle, @NotNull File file) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.serialize(bundle, new FileOutputStream(file, false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public final void serialize(@NotNull SchemaBundle bundle, @NotNull OutputStream outputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Closeable closeable = new OutputStreamWriter(outputStream, SchemaBundle.CHARSET);
            Throwable throwable = null;
            try {
                OutputStreamWriter outputStreamWriter = (OutputStreamWriter)closeable;
                boolean bl = false;
                GSON.toJson((Object)bundle, (Appendable)outputStreamWriter);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\tH\u0016\u00a8\u0006\u000b"}, d2={"Landroidx/room/migration/bundle/SchemaBundle$EntityTypeAdapterFactory;", "Lcom/google/gson/TypeAdapterFactory;", "()V", "create", "Lcom/google/gson/TypeAdapter;", "T", "gson", "Lcom/google/gson/Gson;", "type", "Lcom/google/gson/reflect/TypeToken;", "EntityTypeAdapter", "room-migration"})
    private static class EntityTypeAdapterFactory
    implements TypeAdapterFactory {
        @Nullable
        public <T> TypeAdapter<T> create(@NotNull Gson gson, @NotNull TypeToken<T> type) {
            Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
            Intrinsics.checkNotNullParameter(type, (String)"type");
            if (!EntityBundle.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            TypeAdapter jsonElementAdapter = gson.getAdapter(JsonElement.class);
            TypeAdapter entityBundleAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EntityBundle.class));
            TypeAdapter ftsEntityBundleAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FtsEntityBundle.class));
            Intrinsics.checkNotNullExpressionValue((Object)jsonElementAdapter, (String)"jsonElementAdapter");
            Intrinsics.checkNotNullExpressionValue((Object)entityBundleAdapter, (String)"entityBundleAdapter");
            Intrinsics.checkNotNullExpressionValue((Object)ftsEntityBundleAdapter, (String)"ftsEntityBundleAdapter");
            return new EntityTypeAdapter((TypeAdapter<JsonElement>)jsonElementAdapter, (TypeAdapter<EntityBundle>)entityBundleAdapter, (TypeAdapter<FtsEntityBundle>)ftsEntityBundleAdapter);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0015"}, d2={"Landroidx/room/migration/bundle/SchemaBundle$EntityTypeAdapterFactory$EntityTypeAdapter;", "Lcom/google/gson/TypeAdapter;", "Landroidx/room/migration/bundle/EntityBundle;", "jsonElementAdapter", "Lcom/google/gson/JsonElement;", "entityBundleAdapter", "ftsEntityBundleAdapter", "Landroidx/room/migration/bundle/FtsEntityBundle;", "(Lcom/google/gson/TypeAdapter;Lcom/google/gson/TypeAdapter;Lcom/google/gson/TypeAdapter;)V", "getEntityBundleAdapter", "()Lcom/google/gson/TypeAdapter;", "getFtsEntityBundleAdapter", "getJsonElementAdapter", "read", "input", "Lcom/google/gson/stream/JsonReader;", "write", "", "out", "Lcom/google/gson/stream/JsonWriter;", "value", "room-migration"})
        private static final class EntityTypeAdapter
        extends TypeAdapter<EntityBundle> {
            @NotNull
            private final TypeAdapter<JsonElement> jsonElementAdapter;
            @NotNull
            private final TypeAdapter<EntityBundle> entityBundleAdapter;
            @NotNull
            private final TypeAdapter<FtsEntityBundle> ftsEntityBundleAdapter;

            public EntityTypeAdapter(@NotNull TypeAdapter<JsonElement> jsonElementAdapter, @NotNull TypeAdapter<EntityBundle> entityBundleAdapter, @NotNull TypeAdapter<FtsEntityBundle> ftsEntityBundleAdapter) {
                Intrinsics.checkNotNullParameter(jsonElementAdapter, (String)"jsonElementAdapter");
                Intrinsics.checkNotNullParameter(entityBundleAdapter, (String)"entityBundleAdapter");
                Intrinsics.checkNotNullParameter(ftsEntityBundleAdapter, (String)"ftsEntityBundleAdapter");
                this.jsonElementAdapter = jsonElementAdapter;
                this.entityBundleAdapter = entityBundleAdapter;
                this.ftsEntityBundleAdapter = ftsEntityBundleAdapter;
            }

            @NotNull
            public final TypeAdapter<JsonElement> getJsonElementAdapter() {
                return this.jsonElementAdapter;
            }

            @NotNull
            public final TypeAdapter<EntityBundle> getEntityBundleAdapter() {
                return this.entityBundleAdapter;
            }

            @NotNull
            public final TypeAdapter<FtsEntityBundle> getFtsEntityBundleAdapter() {
                return this.ftsEntityBundleAdapter;
            }

            public void write(@Nullable JsonWriter out, @Nullable EntityBundle value) throws IOException {
                if (value instanceof FtsEntityBundle) {
                    this.ftsEntityBundleAdapter.write(out, (Object)value);
                } else {
                    this.entityBundleAdapter.write(out, (Object)value);
                }
            }

            @NotNull
            public EntityBundle read(@Nullable JsonReader input) {
                EntityBundle entityBundle;
                JsonObject jsonObject = ((JsonElement)this.jsonElementAdapter.read(input)).getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"jsonElementAdapter.read(input).asJsonObject");
                JsonObject jsonObject2 = jsonObject;
                if (jsonObject2.has("ftsVersion")) {
                    Object object = this.ftsEntityBundleAdapter.fromJsonTree((JsonElement)jsonObject2);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                    ft\u2026Object)\n                }");
                    entityBundle = (EntityBundle)object;
                } else {
                    Object object = this.entityBundleAdapter.fromJsonTree((JsonElement)jsonObject2);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                    en\u2026Object)\n                }");
                    entityBundle = (EntityBundle)object;
                }
                return entityBundle;
            }
        }
    }
}

