/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.migration.bundle;

import androidx.annotation.RestrictTo;
import androidx.room.migration.bundle.BundleUtil;
import androidx.room.migration.bundle.FieldBundle;
import androidx.room.migration.bundle.ForeignKeyBundle;
import androidx.room.migration.bundle.IndexBundle;
import androidx.room.migration.bundle.PrimaryKeyBundle;
import androidx.room.migration.bundle.SchemaEquality;
import androidx.room.migration.bundle.SchemaEqualityUtil;
import com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001)B\u0007\b\u0013\u00a2\u0006\u0002\u0010\u0002BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\"H\u0016J\b\u0010#\u001a\u00020\u0004H\u0016J\b\u0010$\u001a\u00020\u0004H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0000H\u0016J\b\u0010(\u001a\u00020\u0004H\u0016R\u0016\u0010\u0005\u001a\u00020\u00048\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R'\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u00158VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00078\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00078\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0014\u0010\u001c\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0016\u0010\t\u001a\u00020\n8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010\u0003\u001a\u00020\u00048\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0011\u00a8\u0006*"}, d2={"Landroidx/room/migration/bundle/EntityBundle;", "Landroidx/room/migration/bundle/SchemaEquality;", "()V", "tableName", "", "createSql", "fields", "", "Landroidx/room/migration/bundle/FieldBundle;", "primaryKey", "Landroidx/room/migration/bundle/PrimaryKeyBundle;", "indices", "Landroidx/room/migration/bundle/IndexBundle;", "foreignKeys", "Landroidx/room/migration/bundle/ForeignKeyBundle;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Landroidx/room/migration/bundle/PrimaryKeyBundle;Ljava/util/List;Ljava/util/List;)V", "getCreateSql", "()Ljava/lang/String;", "getFields", "()Ljava/util/List;", "fieldsByColumnName", "", "getFieldsByColumnName", "()Ljava/util/Map;", "fieldsByColumnName$delegate", "Lkotlin/Lazy;", "getForeignKeys", "getIndices", "newTableName", "getNewTableName", "getPrimaryKey", "()Landroidx/room/migration/bundle/PrimaryKeyBundle;", "getTableName", "buildCreateQueries", "", "createNewTable", "createTable", "isSchemaEqual", "", "other", "renameToOriginal", "Companion", "room-migration"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class EntityBundle
implements SchemaEquality<EntityBundle> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @SerializedName(value="tableName")
    @NotNull
    private final String tableName;
    @SerializedName(value="createSql")
    @NotNull
    private final String createSql;
    @SerializedName(value="fields")
    @NotNull
    private final List<FieldBundle> fields;
    @SerializedName(value="primaryKey")
    @NotNull
    private final PrimaryKeyBundle primaryKey;
    @SerializedName(value="indices")
    @NotNull
    private final List<IndexBundle> indices;
    @SerializedName(value="foreignKeys")
    @NotNull
    private final List<ForeignKeyBundle> foreignKeys;
    @NotNull
    private final transient Lazy fieldsByColumnName$delegate;
    @NotNull
    public static final String NEW_TABLE_PREFIX = "_new_";

    public EntityBundle(@NotNull String tableName, @NotNull String createSql, @NotNull List<? extends FieldBundle> fields, @NotNull PrimaryKeyBundle primaryKey, @NotNull List<? extends IndexBundle> indices, @NotNull List<? extends ForeignKeyBundle> foreignKeys) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)createSql, (String)"createSql");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Intrinsics.checkNotNullParameter(foreignKeys, (String)"foreignKeys");
        this.tableName = tableName;
        this.createSql = createSql;
        this.fields = fields;
        this.primaryKey = primaryKey;
        this.indices = indices;
        this.foreignKeys = foreignKeys;
        this.fieldsByColumnName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends FieldBundle>>(this){
            final /* synthetic */ EntityBundle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<String, FieldBundle> invoke() {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = this.this$0.getFields();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (T element$iv$iv : $this$associateByTo$iv$iv) {
                    void it;
                    FieldBundle fieldBundle = (FieldBundle)element$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    map.put(it.getColumnName(), element$iv$iv);
                }
                return destination$iv$iv;
            }
        }));
    }

    @NotNull
    public String getTableName() {
        return this.tableName;
    }

    @NotNull
    public String getCreateSql() {
        return this.createSql;
    }

    @NotNull
    public List<FieldBundle> getFields() {
        return this.fields;
    }

    @NotNull
    public PrimaryKeyBundle getPrimaryKey() {
        return this.primaryKey;
    }

    @NotNull
    public List<IndexBundle> getIndices() {
        return this.indices;
    }

    @NotNull
    public List<ForeignKeyBundle> getForeignKeys() {
        return this.foreignKeys;
    }

    @Deprecated(message="Marked deprecated to avoid usage in the codebase")
    private EntityBundle() {
        this("", "", CollectionsKt.emptyList(), new PrimaryKeyBundle(false, CollectionsKt.emptyList()), CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    @NotNull
    public String getNewTableName() {
        return NEW_TABLE_PREFIX + this.getTableName();
    }

    @NotNull
    public Map<String, FieldBundle> getFieldsByColumnName() {
        Lazy lazy = this.fieldsByColumnName$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public String createTable() {
        return BundleUtil.replaceTableName(this.getCreateSql(), this.getTableName());
    }

    @NotNull
    public String createNewTable() {
        return BundleUtil.replaceTableName(this.getCreateSql(), this.getNewTableName());
    }

    @NotNull
    public String renameToOriginal() {
        return "ALTER TABLE " + this.getNewTableName() + " RENAME TO " + this.getTableName();
    }

    @NotNull
    public Collection<String> buildCreateQueries() {
        List list;
        List $this$buildCreateQueries_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$buildCreateQueries_u24lambda_u241.add(this.createTable());
        Iterable $this$forEach$iv = this.getIndices();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexBundle indexBundle = (IndexBundle)element$iv;
            boolean bl2 = false;
            $this$buildCreateQueries_u24lambda_u241.add(indexBundle.create(this.getTableName()));
        }
        return CollectionsKt.build((List)list);
    }

    @Override
    public boolean isSchemaEqual(@NotNull EntityBundle other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!Intrinsics.areEqual((Object)this.getTableName(), (Object)other.getTableName())) {
            return false;
        }
        return SchemaEqualityUtil.INSTANCE.checkSchemaEquality(this.getFieldsByColumnName(), other.getFieldsByColumnName()) && SchemaEqualityUtil.INSTANCE.checkSchemaEquality((SchemaEquality)this.getPrimaryKey(), (SchemaEquality)other.getPrimaryKey()) && SchemaEqualityUtil.INSTANCE.checkSchemaEquality(this.getIndices(), other.getIndices()) && SchemaEqualityUtil.INSTANCE.checkSchemaEquality(this.getForeignKeys(), other.getForeignKeys());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/room/migration/bundle/EntityBundle$Companion;", "", "()V", "NEW_TABLE_PREFIX", "", "room-migration"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

