/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.migration.bundle;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.room.Index;
import androidx.room.migration.bundle.BundleUtil;
import androidx.room.migration.bundle.SchemaEquality;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class IndexBundle
implements SchemaEquality<IndexBundle> {
    public static final String DEFAULT_PREFIX = "index_";
    @SerializedName(value="name")
    private String mName;
    @SerializedName(value="unique")
    private boolean mUnique;
    @SerializedName(value="columnNames")
    private List<String> mColumnNames;
    @SerializedName(value="orders")
    private List<String> mOrders;
    @SerializedName(value="createSql")
    private String mCreateSql;

    @Deprecated
    public IndexBundle(String name, boolean unique, List<String> columnNames, String createSql) {
        this(name, unique, columnNames, null, createSql);
    }

    public IndexBundle(String name, boolean unique, List<String> columnNames, List<String> orders, String createSql) {
        this.mName = name;
        this.mUnique = unique;
        this.mColumnNames = columnNames;
        this.mOrders = orders;
        this.mCreateSql = createSql;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isUnique() {
        return this.mUnique;
    }

    public List<String> getColumnNames() {
        return this.mColumnNames;
    }

    public List<String> getOrders() {
        return this.mOrders;
    }

    public String getCreateSql(String tableName) {
        return BundleUtil.replaceTableName(this.mCreateSql, tableName);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public String create(@NonNull String tableName) {
        return BundleUtil.replaceTableName(this.mCreateSql, tableName);
    }

    @Override
    public boolean isSchemaEqual(@NonNull IndexBundle other) {
        List<String> otherOrders;
        if (this.mUnique != other.mUnique) {
            return false;
        }
        if (this.mName.startsWith(DEFAULT_PREFIX)) {
            if (!other.mName.startsWith(DEFAULT_PREFIX)) {
                return false;
            }
        } else {
            if (other.mName.startsWith(DEFAULT_PREFIX)) {
                return false;
            }
            if (!this.mName.equals(other.mName)) {
                return false;
            }
        }
        if (this.mColumnNames != null ? !this.mColumnNames.equals(other.mColumnNames) : other.mColumnNames != null) {
            return false;
        }
        int columnsSize = this.mColumnNames != null ? this.mColumnNames.size() : 0;
        List<String> orders = this.mOrders == null || this.mOrders.isEmpty() ? Collections.nCopies(columnsSize, Index.Order.ASC.name()) : this.mOrders;
        List<String> list = otherOrders = other.mOrders == null || other.mOrders.isEmpty() ? Collections.nCopies(columnsSize, Index.Order.ASC.name()) : other.mOrders;
        return orders.equals(otherOrders);
    }
}

