/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.gradle.integration;

import androidx.room.gradle.RoomArgumentProvider;
import androidx.room.gradle.RoomArgumentProviderKt;
import androidx.room.gradle.RoomExtension;
import androidx.room.gradle.RoomGradlePlugin;
import androidx.room.gradle.integration.CommonIntegration;
import androidx.room.gradle.integration.KotlinMultiplatformPluginIntegration;
import com.google.devtools.ksp.gradle.KspTask;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinCommonOptions;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinSingleTargetExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinCompilation;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlatformType;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J,\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J\u0016\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/room/gradle/integration/KotlinMultiplatformPluginIntegration;", "", "common", "Landroidx/room/gradle/integration/CommonIntegration;", "(Landroidx/room/gradle/integration/CommonIntegration;)V", "configuredTargets", "", "", "Landroidx/room/gradle/RoomExtension$SchemaConfiguration;", "kgpPluginIds", "", "configureKspTasks", "", "project", "Lorg/gradle/api/Project;", "kotlinCompilationTaskNames", "Landroidx/room/gradle/integration/KotlinMultiplatformPluginIntegration$KotlinCompilationTaskNames;", "argumentProviderFactory", "Lkotlin/Function1;", "Lorg/gradle/api/Task;", "Landroidx/room/gradle/RoomArgumentProvider;", "configureRoomForKotlin", "roomExtension", "Landroidx/room/gradle/RoomExtension;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinTarget;", "forSchemaConfiguration", "block", "withKotlin", "KotlinCompilationTaskNames", "room-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinMultiplatformPluginIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMultiplatformPluginIntegration.kt\nandroidx/room/gradle/integration/KotlinMultiplatformPluginIntegration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1863#2,2:153\n*S KotlinDebug\n*F\n+ 1 KotlinMultiplatformPluginIntegration.kt\nandroidx/room/gradle/integration/KotlinMultiplatformPluginIntegration\n*L\n47#1:153,2\n*E\n"})
public final class KotlinMultiplatformPluginIntegration {
    @NotNull
    private final CommonIntegration common;
    @NotNull
    private final List<String> kgpPluginIds;
    @NotNull
    private final Map<String, RoomExtension.SchemaConfiguration> configuredTargets;

    public KotlinMultiplatformPluginIntegration(@NotNull CommonIntegration common) {
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        this.common = common;
        Object[] objectArray = new String[]{"org.jetbrains.kotlin.jvm", "org.jetbrains.kotlin.android", "org.jetbrains.kotlin.multiplatform"};
        this.kgpPluginIds = CollectionsKt.listOf((Object[])objectArray);
        this.configuredTargets = new LinkedHashMap();
    }

    public final void withKotlin(@NotNull Project project, @NotNull RoomExtension roomExtension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)roomExtension, (String)"roomExtension");
        Iterable $this$forEach$iv = this.kgpPluginIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String kgpPluginId = (String)element$iv;
            boolean bl = false;
            project.getPlugins().withId(kgpPluginId, arg_0 -> KotlinMultiplatformPluginIntegration.withKotlin$lambda$1$lambda$0((Function1)new Function1<Plugin<?>, Unit>(project, this, roomExtension){
                final /* synthetic */ Project $project;
                final /* synthetic */ KotlinMultiplatformPluginIntegration this$0;
                final /* synthetic */ RoomExtension $roomExtension;
                {
                    this.$project = $project;
                    this.this$0 = $receiver;
                    this.$roomExtension = $roomExtension;
                    super(1);
                }

                public final void invoke(Plugin<?> it) {
                    KotlinProjectExtension kotlin;
                    Object object = this.$project.getExtensions().getByName("kotlin");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension");
                    KotlinProjectExtension kotlinProjectExtension = kotlin = (KotlinProjectExtension)object;
                    if (kotlinProjectExtension instanceof KotlinSingleTargetExtension) {
                        KotlinMultiplatformPluginIntegration.access$configureRoomForKotlin(this.this$0, this.$project, this.$roomExtension, ((KotlinSingleTargetExtension)kotlin).getTarget());
                    } else if (kotlinProjectExtension instanceof KotlinMultiplatformExtension) {
                        ((KotlinMultiplatformExtension)kotlin).getTargets().configureEach(arg_0 -> withKotlin.1.1.invoke$lambda$0((Function1)new Function1<KotlinTarget, Unit>(this.this$0, this.$project, this.$roomExtension){
                            final /* synthetic */ KotlinMultiplatformPluginIntegration this$0;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ RoomExtension $roomExtension;
                            {
                                this.this$0 = $receiver;
                                this.$project = $project;
                                this.$roomExtension = $roomExtension;
                                super(1);
                            }

                            public final void invoke(KotlinTarget it) {
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                KotlinMultiplatformPluginIntegration.access$configureRoomForKotlin(this.this$0, this.$project, this.$roomExtension, it);
                            }
                        }, arg_0));
                    }
                }

                private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                    $tmp0.invoke(p0);
                }
            }, arg_0));
        }
    }

    private final void configureRoomForKotlin(Project project, RoomExtension roomExtension, KotlinTarget target) {
        if (target.getPlatformType() == KotlinPlatformType.androidJvm) {
            return;
        }
        this.forSchemaConfiguration(roomExtension, target, (Function1<? super RoomExtension.SchemaConfiguration, Unit>)((Function1)new Function1<RoomExtension.SchemaConfiguration, Unit>(this, target){
            final /* synthetic */ KotlinMultiplatformPluginIntegration this$0;
            final /* synthetic */ KotlinTarget $target;
            {
                this.this$0 = $receiver;
                this.$target = $target;
                super(1);
            }

            public final void invoke(RoomExtension.SchemaConfiguration newConfig) {
                Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
                RoomExtension.SchemaConfiguration oldConfig = KotlinMultiplatformPluginIntegration.access$getConfiguredTargets$p(this.this$0).put(this.$target.getName(), newConfig);
                this.$target.getCompilations().configureEach(arg_0 -> configureRoomForKotlin.1.invoke$lambda$0((Function1)new Function1<KotlinCompilation<? extends KotlinCommonOptions>, Unit>(this.this$0, oldConfig, newConfig){
                    final /* synthetic */ KotlinMultiplatformPluginIntegration this$0;
                    final /* synthetic */ RoomExtension.SchemaConfiguration $oldConfig;
                    final /* synthetic */ RoomExtension.SchemaConfiguration $newConfig;
                    {
                        this.this$0 = $receiver;
                        this.$oldConfig = $oldConfig;
                        this.$newConfig = $newConfig;
                        super(1);
                    }

                    public final void invoke(KotlinCompilation<? extends KotlinCommonOptions> kotlinCompilation) {
                        Intrinsics.checkNotNullExpressionValue(kotlinCompilation, (String)"kotlinCompilation");
                        KotlinCompilationTaskNames kotlinCompilationTaskNames = new KotlinCompilationTaskNames(kotlinCompilation);
                        KotlinMultiplatformPluginIntegration.access$getCommon$p(this.this$0).configureSchemaCopyTask(kotlinCompilationTaskNames.getTaskNames(), this.$oldConfig, this.$newConfig);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }));
        target.getCompilations().configureEach(arg_0 -> KotlinMultiplatformPluginIntegration.configureRoomForKotlin$lambda$2((Function1)new Function1<KotlinCompilation<? extends KotlinCommonOptions>, Unit>(this, project, target, roomExtension){
            final /* synthetic */ KotlinMultiplatformPluginIntegration this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinTarget $target;
            final /* synthetic */ RoomExtension $roomExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$target = $target;
                this.$roomExtension = $roomExtension;
                super(1);
            }

            public final void invoke(KotlinCompilation<? extends KotlinCommonOptions> kotlinCompilation) {
                Intrinsics.checkNotNullExpressionValue(kotlinCompilation, (String)"kotlinCompilation");
                KotlinCompilationTaskNames kotlinCompilationTaskNames = new KotlinCompilationTaskNames(kotlinCompilation);
                Function1 argProviderFactory2 = (Function1)new Function1<Task, RoomArgumentProvider>(this.this$0, this.$target, this.$project, this.$roomExtension){
                    final /* synthetic */ KotlinMultiplatformPluginIntegration this$0;
                    final /* synthetic */ KotlinTarget $target;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ RoomExtension $roomExtension;
                    {
                        this.this$0 = $receiver;
                        this.$target = $target;
                        this.$project = $project;
                        this.$roomExtension = $roomExtension;
                        super(1);
                    }

                    public final RoomArgumentProvider invoke(Task apTask) {
                        Intrinsics.checkNotNullParameter((Object)apTask, (String)"apTask");
                        RoomExtension.SchemaConfiguration config2 = (RoomExtension.SchemaConfiguration)KotlinMultiplatformPluginIntegration.access$getConfiguredTargets$p(this.this$0).get(this.$target.getName());
                        RoomGradlePlugin.Companion.check$room_gradle_plugin(this.$project, config2 != null, true, (Function0<String>)((Function0)new Function0<String>(this.$target){
                            final /* synthetic */ KotlinTarget $target;
                            {
                                this.$target = $target;
                                super(0);
                            }

                            public final String invoke() {
                                return "No matching Room schema directory for the KSP target '" + this.$target.getTargetName() + "'.";
                            }
                        }));
                        Object[] objectArray = new Object[]{config2.getCopyTask()};
                        apTask.finalizedBy(objectArray);
                        return KotlinMultiplatformPluginIntegration.access$getCommon$p(this.this$0).createArgumentProvider(config2, RoomArgumentProviderKt.toOptions(this.$roomExtension), apTask);
                    }
                };
                KotlinMultiplatformPluginIntegration.access$configureKspTasks(this.this$0, this.$project, kotlinCompilationTaskNames, argProviderFactory2);
            }
        }, arg_0));
    }

    private final void forSchemaConfiguration(RoomExtension roomExtension, KotlinTarget target, Function1<? super RoomExtension.SchemaConfiguration, Unit> block) {
        Ref.IntRef currentPriority = new Ref.IntRef();
        currentPriority.element = Integer.MAX_VALUE;
        roomExtension.getSchemaConfigurations$room_gradle_plugin().configureEach(arg_0 -> KotlinMultiplatformPluginIntegration.forSchemaConfiguration$lambda$3((Function1)new Function1<RoomExtension.SchemaConfiguration, Unit>(target, currentPriority, block){
            final /* synthetic */ KotlinTarget $target;
            final /* synthetic */ Ref.IntRef $currentPriority;
            final /* synthetic */ Function1<RoomExtension.SchemaConfiguration, Unit> $block;
            {
                this.$target = $target;
                this.$currentPriority = $currentPriority;
                this.$block = $block;
                super(1);
            }

            public final void invoke(RoomExtension.SchemaConfiguration config2) {
                int n;
                if (config2.matches(this.$target.getTargetName())) {
                    n = 0;
                } else if (config2.matches-m0K3wWM(RoomExtension.Companion.getALL_MATCH-tmqeDYI$room_gradle_plugin())) {
                    n = 1;
                } else {
                    return;
                }
                int newPriority = n;
                if (this.$currentPriority.element < newPriority) {
                    return;
                }
                this.$currentPriority.element = newPriority;
                Intrinsics.checkNotNullExpressionValue((Object)config2, (String)"config");
                this.$block.invoke((Object)config2);
            }
        }, arg_0));
    }

    private final void configureKspTasks(Project project, KotlinCompilationTaskNames kotlinCompilationTaskNames, Function1<? super Task, RoomArgumentProvider> argumentProviderFactory) {
        project.getPlugins().withId("com.google.devtools.ksp", arg_0 -> KotlinMultiplatformPluginIntegration.configureKspTasks$lambda$4((Function1)new Function1<Plugin<?>, Unit>(project, kotlinCompilationTaskNames, argumentProviderFactory){
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinCompilationTaskNames $kotlinCompilationTaskNames;
            final /* synthetic */ Function1<Task, RoomArgumentProvider> $argumentProviderFactory;
            {
                this.$project = $project;
                this.$kotlinCompilationTaskNames = $kotlinCompilationTaskNames;
                this.$argumentProviderFactory = $argumentProviderFactory;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                this.$project.getTasks().withType(KspTask.class).configureEach(arg_0 -> configureKspTasks.1.invoke$lambda$0((Function1)new Function1<KspTask, Unit>(this.$kotlinCompilationTaskNames, this.$argumentProviderFactory){
                    final /* synthetic */ KotlinCompilationTaskNames $kotlinCompilationTaskNames;
                    final /* synthetic */ Function1<Task, RoomArgumentProvider> $argumentProviderFactory;
                    {
                        this.$kotlinCompilationTaskNames = $kotlinCompilationTaskNames;
                        this.$argumentProviderFactory = $argumentProviderFactory;
                        super(1);
                    }

                    public final void invoke(KspTask task) {
                        String string = task.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
                        if (this.$kotlinCompilationTaskNames.isKspTask(string)) {
                            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                            RoomArgumentProvider argProvider = (RoomArgumentProvider)this.$argumentProviderFactory.invoke((Object)task);
                            task.getCommandLineArgumentProviders().add((Object)argProvider);
                        }
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private static final void withKotlin$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void configureRoomForKotlin$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void forSchemaConfiguration$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void configureKspTasks$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getConfiguredTargets$p(KotlinMultiplatformPluginIntegration $this) {
        return $this.configuredTargets;
    }

    public static final /* synthetic */ CommonIntegration access$getCommon$p(KotlinMultiplatformPluginIntegration $this) {
        return $this.common;
    }

    public static final /* synthetic */ void access$configureKspTasks(KotlinMultiplatformPluginIntegration $this, Project project, KotlinCompilationTaskNames kotlinCompilationTaskNames, Function1 argumentProviderFactory) {
        $this.configureKspTasks(project, kotlinCompilationTaskNames, (Function1<? super Task, RoomArgumentProvider>)argumentProviderFactory);
    }

    public static final /* synthetic */ void access$configureRoomForKotlin(KotlinMultiplatformPluginIntegration $this, Project project, RoomExtension roomExtension, KotlinTarget target) {
        $this.configureRoomForKotlin(project, roomExtension, target);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Landroidx/room/gradle/integration/KotlinMultiplatformPluginIntegration$KotlinCompilationTaskNames;", "", "kotlinCompilation", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;", "(Lorg/jetbrains/kotlin/gradle/plugin/KotlinCompilation;)V", "kspTaskName", "", "taskNames", "", "getTaskNames", "()Ljava/util/Set;", "isKspTask", "", "taskName", "room-gradle-plugin"})
    private static final class KotlinCompilationTaskNames {
        @NotNull
        private final String kspTaskName;
        @NotNull
        private final Set<String> taskNames;

        public KotlinCompilationTaskNames(@NotNull KotlinCompilation<?> kotlinCompilation) {
            Intrinsics.checkNotNullParameter(kotlinCompilation, (String)"kotlinCompilation");
            this.kspTaskName = StringsKt.replace$default((String)kotlinCompilation.getCompileKotlinTaskName(), (String)"compile", (String)"ksp", (boolean)false, (int)4, null);
            this.taskNames = SetsKt.setOf((Object)this.kspTaskName);
        }

        @NotNull
        public final Set<String> getTaskNames() {
            return this.taskNames;
        }

        public final boolean isKspTask(@NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return Intrinsics.areEqual((Object)taskName, (Object)this.kspTaskName);
        }
    }
}

