/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.gradle.integration;

import androidx.room.gradle.RoomArgumentProvider;
import androidx.room.gradle.RoomArgumentProviderKt;
import androidx.room.gradle.RoomExtension;
import androidx.room.gradle.RoomGradlePlugin;
import androidx.room.gradle.RoomSimpleCopyTask;
import androidx.room.gradle.integration.AndroidPluginIntegration;
import androidx.room.gradle.integration.CommonIntegration;
import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.AndroidTest;
import com.android.build.api.variant.ComponentIdentity;
import com.android.build.api.variant.HasAndroidTest;
import com.android.build.api.variant.HasUnitTest;
import com.android.build.api.variant.SourceDirectories;
import com.android.build.api.variant.Variant;
import com.google.devtools.ksp.gradle.KspTask;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.KaptTask;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J,\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J,\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0\u0016H\u0002J\u0016\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Landroidx/room/gradle/integration/AndroidPluginIntegration;", "", "common", "Landroidx/room/gradle/integration/CommonIntegration;", "(Landroidx/room/gradle/integration/CommonIntegration;)V", "agpBasePluginId", "", "configuredVariants", "", "Landroidx/room/gradle/RoomExtension$SchemaConfiguration;", "configureAndroidVariant", "", "project", "Lorg/gradle/api/Project;", "roomExtension", "Landroidx/room/gradle/RoomExtension;", "variant", "Lcom/android/build/api/variant/ComponentIdentity;", "configureJavaTasks", "androidVariantsTaskNames", "Landroidx/room/gradle/integration/AndroidPluginIntegration$AndroidVariantsTaskNames;", "argumentProviderFactory", "Lkotlin/Function1;", "Lorg/gradle/api/Task;", "Landroidx/room/gradle/RoomArgumentProvider;", "configureKaptTasks", "configureKspTasks", "configureRoomForAndroid", "forSchemaConfiguration", "block", "withAndroid", "AndroidVariantsTaskNames", "room-gradle-plugin"})
public final class AndroidPluginIntegration {
    @NotNull
    private final CommonIntegration common;
    @NotNull
    private final String agpBasePluginId;
    @NotNull
    private final Map<String, RoomExtension.SchemaConfiguration> configuredVariants;

    public AndroidPluginIntegration(@NotNull CommonIntegration common) {
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        this.common = common;
        this.agpBasePluginId = "com.android.base";
        this.configuredVariants = new LinkedHashMap();
    }

    public final void withAndroid(@NotNull Project project, @NotNull RoomExtension roomExtension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)roomExtension, (String)"roomExtension");
        project.getPlugins().withId(this.agpBasePluginId, arg_0 -> AndroidPluginIntegration.withAndroid$lambda$0((Function1)new Function1<Plugin<?>, Unit>(this, project, roomExtension){
            final /* synthetic */ AndroidPluginIntegration this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ RoomExtension $roomExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$roomExtension = $roomExtension;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                AndroidPluginIntegration.access$configureRoomForAndroid(this.this$0, this.$project, this.$roomExtension);
            }
        }, arg_0));
    }

    private final void configureRoomForAndroid(Project project, RoomExtension roomExtension) {
        AndroidComponentsExtension componentsExtension = (AndroidComponentsExtension)project.getExtensions().findByType(AndroidComponentsExtension.class);
        RoomGradlePlugin.Companion.check$room_gradle_plugin(project, componentsExtension != null, true, (Function0<String>)((Function0)configureRoomForAndroid.1.INSTANCE));
        RoomGradlePlugin.Companion.check$room_gradle_plugin$default(RoomGradlePlugin.Companion, project, componentsExtension.getPluginVersion().compareTo(new AndroidPluginVersion(8, 1)) >= 0, false, (Function0)new Function0<String>(componentsExtension){
            final /* synthetic */ AndroidComponentsExtension<?, ?, ?> $componentsExtension;
            {
                this.$componentsExtension = $componentsExtension;
                super(0);
            }

            public final String invoke() {
                return "The Room Gradle plugin is only compatible with Android Gradle plugin (AGP) version 8.1.0 or higher (found " + this.$componentsExtension.getPluginVersion() + ").";
            }
        }, 2, null);
        AndroidComponentsExtension.onVariants$default((AndroidComponentsExtension)componentsExtension, null, (Function1)((Function1)new Function1<Variant, Unit>(this, project, roomExtension){
            final /* synthetic */ AndroidPluginIntegration this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ RoomExtension $roomExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$roomExtension = $roomExtension;
                super(1);
            }

            public final void invoke(Variant variant) {
                block1: {
                    HasAndroidTest hasAndroidTest;
                    HasUnitTest it;
                    RoomExtension roomExtension;
                    Project project;
                    AndroidPluginIntegration androidPluginIntegration;
                    HasUnitTest hasUnitTest;
                    Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                    AndroidPluginIntegration.access$configureAndroidVariant(this.this$0, this.$project, this.$roomExtension, (ComponentIdentity)variant);
                    HasUnitTest hasUnitTest2 = variant instanceof HasUnitTest ? (HasUnitTest)variant : null;
                    if (hasUnitTest2 != null && (hasUnitTest2 = hasUnitTest2.getUnitTest()) != null) {
                        hasUnitTest = hasUnitTest2;
                        androidPluginIntegration = this.this$0;
                        project = this.$project;
                        roomExtension = this.$roomExtension;
                        it = hasUnitTest;
                        boolean bl = false;
                        AndroidPluginIntegration.access$configureAndroidVariant(androidPluginIntegration, project, roomExtension, (ComponentIdentity)it);
                    }
                    if ((hasAndroidTest = variant instanceof HasAndroidTest ? (HasAndroidTest)variant : null) == null || (hasAndroidTest = hasAndroidTest.getAndroidTest()) == null) break block1;
                    hasUnitTest = hasAndroidTest;
                    androidPluginIntegration = this.this$0;
                    project = this.$project;
                    roomExtension = this.$roomExtension;
                    it = hasUnitTest;
                    boolean bl = false;
                    AndroidPluginIntegration.access$configureAndroidVariant(androidPluginIntegration, project, roomExtension, (ComponentIdentity)it);
                }
            }
        }), (int)1, null);
        project.afterEvaluate(arg_0 -> AndroidPluginIntegration.configureRoomForAndroid$lambda$1((Function1)new Function1<Project, Unit>(project, roomExtension){
            final /* synthetic */ Project $project;
            final /* synthetic */ RoomExtension $roomExtension;
            {
                this.$project = $project;
                this.$roomExtension = $roomExtension;
                super(1);
            }

            public final void invoke(Project it) {
                DomainObjectSet<RoomExtension.SchemaConfiguration> domainObjectSet = this.$roomExtension.getSchemaConfigurations$room_gradle_plugin();
                Intrinsics.checkNotNullExpressionValue(domainObjectSet, (String)"roomExtension.schemaConfigurations");
                RoomGradlePlugin.Companion.check$room_gradle_plugin(this.$project, !((Collection)domainObjectSet).isEmpty(), true, (Function0<String>)((Function0)configureRoomForAndroid.1.INSTANCE));
            }
        }, arg_0));
    }

    private final void configureAndroidVariant(Project project, RoomExtension roomExtension, ComponentIdentity variant) {
        block1: {
            AndroidVariantsTaskNames androidVariantTaskNames = new AndroidVariantsTaskNames(variant.getName());
            this.forSchemaConfiguration(roomExtension, variant, (Function1<? super RoomExtension.SchemaConfiguration, Unit>)((Function1)new Function1<RoomExtension.SchemaConfiguration, Unit>(this, variant, androidVariantTaskNames){
                final /* synthetic */ AndroidPluginIntegration this$0;
                final /* synthetic */ ComponentIdentity $variant;
                final /* synthetic */ AndroidVariantsTaskNames $androidVariantTaskNames;
                {
                    this.this$0 = $receiver;
                    this.$variant = $variant;
                    this.$androidVariantTaskNames = $androidVariantTaskNames;
                    super(1);
                }

                public final void invoke(RoomExtension.SchemaConfiguration newConfig) {
                    Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
                    RoomExtension.SchemaConfiguration oldConfig = AndroidPluginIntegration.access$getConfiguredVariants$p(this.this$0).put(this.$variant.getName(), newConfig);
                    AndroidPluginIntegration.access$getCommon$p(this.this$0).configureSchemaCopyTask(this.$androidVariantTaskNames.getTaskNames(), oldConfig, newConfig);
                }
            }));
            Function1 argProviderFactory2 = (Function1)new Function1<Task, RoomArgumentProvider>(this, variant, project, roomExtension){
                final /* synthetic */ AndroidPluginIntegration this$0;
                final /* synthetic */ ComponentIdentity $variant;
                final /* synthetic */ Project $project;
                final /* synthetic */ RoomExtension $roomExtension;
                {
                    this.this$0 = $receiver;
                    this.$variant = $variant;
                    this.$project = $project;
                    this.$roomExtension = $roomExtension;
                    super(1);
                }

                public final RoomArgumentProvider invoke(Task apTask) {
                    Intrinsics.checkNotNullParameter((Object)apTask, (String)"apTask");
                    RoomExtension.SchemaConfiguration config2 = (RoomExtension.SchemaConfiguration)AndroidPluginIntegration.access$getConfiguredVariants$p(this.this$0).get(this.$variant.getName());
                    RoomGradlePlugin.Companion.check$room_gradle_plugin(this.$project, config2 != null, true, (Function0<String>)((Function0)new Function0<String>(this.$variant){
                        final /* synthetic */ ComponentIdentity $variant;
                        {
                            this.$variant = $variant;
                            super(0);
                        }

                        public final String invoke() {
                            return "No matching Room schema directory for Android variant '" + this.$variant.getName() + "'.";
                        }
                    }));
                    Object[] objectArray = new Object[]{config2.getCopyTask()};
                    apTask.finalizedBy(objectArray);
                    return AndroidPluginIntegration.access$getCommon$p(this.this$0).createArgumentProvider(config2, RoomArgumentProviderKt.toOptions(this.$roomExtension), apTask);
                }
            };
            this.configureJavaTasks(project, androidVariantTaskNames, (Function1<? super Task, RoomArgumentProvider>)argProviderFactory2);
            this.configureKaptTasks(project, androidVariantTaskNames, (Function1<? super Task, RoomArgumentProvider>)argProviderFactory2);
            this.configureKspTasks(project, androidVariantTaskNames, (Function1<? super Task, RoomArgumentProvider>)argProviderFactory2);
            if (!(variant instanceof AndroidTest)) break block1;
            SourceDirectories.Layered layered = ((AndroidTest)variant).getSources().getAssets();
            if (layered != null) {
                TaskProvider taskProvider = project.getTasks().register("copyRoomSchemasToAndroidTestAssets" + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(variant.getName()), RoomSimpleCopyTask.class);
                Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"project.tasks.register(\n\u2026ss.java\n                )");
                layered.addGeneratedSourceDirectory(taskProvider, (Function1)new Function1<RoomSimpleCopyTask, DirectoryProperty>(this, variant, project){
                    final /* synthetic */ AndroidPluginIntegration this$0;
                    final /* synthetic */ ComponentIdentity $variant;
                    final /* synthetic */ Project $project;
                    {
                        this.this$0 = $receiver;
                        this.$variant = $variant;
                        this.$project = $project;
                        super(1);
                    }

                    public final DirectoryProperty invoke(RoomSimpleCopyTask it) {
                        RoomExtension.SchemaConfiguration config2 = (RoomExtension.SchemaConfiguration)AndroidPluginIntegration.access$getConfiguredVariants$p(this.this$0).get(this.$variant.getName());
                        RoomGradlePlugin.Companion.check$room_gradle_plugin(this.$project, config2 != null, true, (Function0<String>)((Function0)new Function0<String>(this.$variant){
                            final /* synthetic */ ComponentIdentity $variant;
                            {
                                this.$variant = $variant;
                                super(0);
                            }

                            public final String invoke() {
                                return "No matching Room schema directory for Android variant '" + this.$variant.getName() + "'.";
                            }
                        }));
                        it.getInputDirectory().set(config2.getCopyTask().flatMap(arg_0 -> configureAndroidVariant.2.invoke$lambda$0(configureAndroidVariant.2.INSTANCE, arg_0)));
                        return it.getOutputDirectory();
                    }

                    private static final Provider invoke$lambda$0(Function1 $tmp0, Object in) {
                        return (Provider)$tmp0.invoke(in);
                    }
                });
            }
        }
    }

    private final void forSchemaConfiguration(RoomExtension roomExtension, ComponentIdentity variant, Function1<? super RoomExtension.SchemaConfiguration, Unit> block) {
        Ref.IntRef currentPriority = new Ref.IntRef();
        currentPriority.element = Integer.MAX_VALUE;
        roomExtension.getSchemaConfigurations$room_gradle_plugin().configureEach(arg_0 -> AndroidPluginIntegration.forSchemaConfiguration$lambda$2((Function1)new Function1<RoomExtension.SchemaConfiguration, Unit>(variant, currentPriority, block){
            final /* synthetic */ ComponentIdentity $variant;
            final /* synthetic */ Ref.IntRef $currentPriority;
            final /* synthetic */ Function1<RoomExtension.SchemaConfiguration, Unit> $block;
            {
                this.$variant = $variant;
                this.$currentPriority = $currentPriority;
                this.$block = $block;
                super(1);
            }

            public final void invoke(RoomExtension.SchemaConfiguration config2) {
                int n;
                String kmpPrefix = "android";
                if (config2.matches(this.$variant.getName())) {
                    n = 0;
                } else if (config2.matches(kmpPrefix + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(this.$variant.getName()))) {
                    n = 1;
                } else if (config2.matches(this.$variant.getFlavorName())) {
                    n = 2;
                } else {
                    String string;
                    String it;
                    RoomExtension.SchemaConfiguration schemaConfiguration;
                    RoomExtension.SchemaConfiguration schemaConfiguration2 = config2;
                    String string2 = this.$variant.getFlavorName();
                    if (string2 != null) {
                        String string3 = string2;
                        schemaConfiguration = schemaConfiguration2;
                        boolean bl = false;
                        string = kmpPrefix + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(it);
                        schemaConfiguration2 = schemaConfiguration;
                    } else {
                        string = null;
                    }
                    if (schemaConfiguration2.matches(string)) {
                        n = 3;
                    } else if (config2.matches(this.$variant.getBuildType())) {
                        n = 4;
                    } else {
                        String string4;
                        RoomExtension.SchemaConfiguration schemaConfiguration3 = config2;
                        String string5 = this.$variant.getBuildType();
                        if (string5 != null) {
                            it = string5;
                            schemaConfiguration = schemaConfiguration3;
                            boolean bl = false;
                            string4 = kmpPrefix + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(it);
                            schemaConfiguration3 = schemaConfiguration;
                        } else {
                            string4 = null;
                        }
                        if (schemaConfiguration3.matches(string4)) {
                            n = 5;
                        } else if (config2.matches(kmpPrefix)) {
                            n = 6;
                        } else if (config2.matches-m0K3wWM(RoomExtension.Companion.getALL_MATCH-tmqeDYI$room_gradle_plugin())) {
                            n = 7;
                        } else {
                            return;
                        }
                    }
                }
                int newPriority = n;
                if (this.$currentPriority.element < newPriority) {
                    return;
                }
                this.$currentPriority.element = newPriority;
                Intrinsics.checkNotNullExpressionValue((Object)config2, (String)"config");
                this.$block.invoke((Object)config2);
            }
        }, arg_0));
    }

    private final void configureJavaTasks(Project project, AndroidVariantsTaskNames androidVariantsTaskNames, Function1<? super Task, RoomArgumentProvider> argumentProviderFactory) {
        project.getTasks().withType(JavaCompile.class).configureEach(arg_0 -> AndroidPluginIntegration.configureJavaTasks$lambda$3((Function1)new Function1<JavaCompile, Unit>(androidVariantsTaskNames, argumentProviderFactory){
            final /* synthetic */ AndroidVariantsTaskNames $androidVariantsTaskNames;
            final /* synthetic */ Function1<Task, RoomArgumentProvider> $argumentProviderFactory;
            {
                this.$androidVariantsTaskNames = $androidVariantsTaskNames;
                this.$argumentProviderFactory = $argumentProviderFactory;
                super(1);
            }

            public final void invoke(JavaCompile task) {
                String string = task.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
                if (this.$androidVariantsTaskNames.isJavaCompile(string)) {
                    Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                    RoomArgumentProvider argProvider = (RoomArgumentProvider)this.$argumentProviderFactory.invoke((Object)task);
                    task.getOptions().getCompilerArgumentProviders().add(argProvider);
                }
            }
        }, arg_0));
    }

    private final void configureKaptTasks(Project project, AndroidVariantsTaskNames androidVariantsTaskNames, Function1<? super Task, RoomArgumentProvider> argumentProviderFactory) {
        project.getPlugins().withId("kotlin-kapt", arg_0 -> AndroidPluginIntegration.configureKaptTasks$lambda$4((Function1)new Function1<Plugin<?>, Unit>(project, androidVariantsTaskNames, argumentProviderFactory){
            final /* synthetic */ Project $project;
            final /* synthetic */ AndroidVariantsTaskNames $androidVariantsTaskNames;
            final /* synthetic */ Function1<Task, RoomArgumentProvider> $argumentProviderFactory;
            {
                this.$project = $project;
                this.$androidVariantsTaskNames = $androidVariantsTaskNames;
                this.$argumentProviderFactory = $argumentProviderFactory;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                this.$project.getTasks().withType(KaptTask.class).configureEach(arg_0 -> configureKaptTasks.1.invoke$lambda$0((Function1)new Function1<KaptTask, Unit>(this.$androidVariantsTaskNames, this.$argumentProviderFactory){
                    final /* synthetic */ AndroidVariantsTaskNames $androidVariantsTaskNames;
                    final /* synthetic */ Function1<Task, RoomArgumentProvider> $argumentProviderFactory;
                    {
                        this.$androidVariantsTaskNames = $androidVariantsTaskNames;
                        this.$argumentProviderFactory = $argumentProviderFactory;
                        super(1);
                    }

                    public final void invoke(KaptTask task) {
                        String string = task.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
                        if (this.$androidVariantsTaskNames.isKaptTask(string)) {
                            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                            RoomArgumentProvider argProvider = (RoomArgumentProvider)this.$argumentProviderFactory.invoke((Object)task);
                            try {
                                task.getAnnotationProcessorOptionProviders().add(CollectionsKt.listOf((Object)argProvider));
                            }
                            catch (Throwable e) {
                                task.getAnnotationProcessorOptionProviders().add(argProvider);
                            }
                        }
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private final void configureKspTasks(Project project, AndroidVariantsTaskNames androidVariantsTaskNames, Function1<? super Task, RoomArgumentProvider> argumentProviderFactory) {
        project.getPlugins().withId("com.google.devtools.ksp", arg_0 -> AndroidPluginIntegration.configureKspTasks$lambda$5((Function1)new Function1<Plugin<?>, Unit>(project, androidVariantsTaskNames, argumentProviderFactory){
            final /* synthetic */ Project $project;
            final /* synthetic */ AndroidVariantsTaskNames $androidVariantsTaskNames;
            final /* synthetic */ Function1<Task, RoomArgumentProvider> $argumentProviderFactory;
            {
                this.$project = $project;
                this.$androidVariantsTaskNames = $androidVariantsTaskNames;
                this.$argumentProviderFactory = $argumentProviderFactory;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                this.$project.getTasks().withType(KspTask.class).configureEach(arg_0 -> configureKspTasks.1.invoke$lambda$0((Function1)new Function1<KspTask, Unit>(this.$androidVariantsTaskNames, this.$argumentProviderFactory){
                    final /* synthetic */ AndroidVariantsTaskNames $androidVariantsTaskNames;
                    final /* synthetic */ Function1<Task, RoomArgumentProvider> $argumentProviderFactory;
                    {
                        this.$androidVariantsTaskNames = $androidVariantsTaskNames;
                        this.$argumentProviderFactory = $argumentProviderFactory;
                        super(1);
                    }

                    public final void invoke(KspTask task) {
                        String string = task.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
                        if (this.$androidVariantsTaskNames.isKspTaskJvm(string)) {
                            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                            RoomArgumentProvider argProvider = (RoomArgumentProvider)this.$argumentProviderFactory.invoke((Object)task);
                            task.getCommandLineArgumentProviders().add((Object)argProvider);
                        }
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private static final void withAndroid$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void configureRoomForAndroid$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void forSchemaConfiguration$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void configureJavaTasks$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void configureKaptTasks$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void configureKspTasks$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$configureRoomForAndroid(AndroidPluginIntegration $this, Project project, RoomExtension roomExtension) {
        $this.configureRoomForAndroid(project, roomExtension);
    }

    public static final /* synthetic */ void access$configureAndroidVariant(AndroidPluginIntegration $this, Project project, RoomExtension roomExtension, ComponentIdentity variant) {
        $this.configureAndroidVariant(project, roomExtension, variant);
    }

    public static final /* synthetic */ Map access$getConfiguredVariants$p(AndroidPluginIntegration $this) {
        return $this.configuredVariants;
    }

    public static final /* synthetic */ CommonIntegration access$getCommon$p(AndroidPluginIntegration $this) {
        return $this.common;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Landroidx/room/gradle/integration/AndroidPluginIntegration$AndroidVariantsTaskNames;", "", "variantName", "", "(Ljava/lang/String;)V", "javaCompileName", "kaptTaskName", "kspTaskAndroidName", "kspTaskJvmName", "taskNames", "", "getTaskNames", "()Ljava/util/Set;", "isJavaCompile", "", "taskName", "isKaptTask", "isKspTaskJvm", "room-gradle-plugin"})
    private static final class AndroidVariantsTaskNames {
        @NotNull
        private final String javaCompileName;
        @NotNull
        private final String kaptTaskName;
        @NotNull
        private final String kspTaskJvmName;
        @NotNull
        private final String kspTaskAndroidName;
        @NotNull
        private final Set<String> taskNames;

        public AndroidVariantsTaskNames(@NotNull String variantName) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            this.javaCompileName = "compile" + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(variantName) + "JavaWithJavac";
            this.kaptTaskName = "kapt" + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(variantName) + "Kotlin";
            this.kspTaskJvmName = "ksp" + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(variantName) + "Kotlin";
            this.kspTaskAndroidName = "ksp" + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(variantName) + "KotlinAndroid";
            Object[] objectArray = new String[]{this.javaCompileName, this.kaptTaskName, this.kspTaskJvmName, this.kspTaskAndroidName};
            this.taskNames = SetsKt.setOf((Object[])objectArray);
        }

        @NotNull
        public final Set<String> getTaskNames() {
            return this.taskNames;
        }

        public final boolean isJavaCompile(@NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return Intrinsics.areEqual((Object)taskName, (Object)this.javaCompileName);
        }

        public final boolean isKaptTask(@NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return Intrinsics.areEqual((Object)taskName, (Object)this.kaptTaskName);
        }

        public final boolean isKspTaskJvm(@NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return Intrinsics.areEqual((Object)taskName, (Object)this.kspTaskJvmName) || Intrinsics.areEqual((Object)taskName, (Object)this.kspTaskAndroidName);
        }
    }
}

