/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.gradle;

import androidx.room.gradle.RoomSchemaCopyTask;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Simple disk bound task.")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\rH\u0007J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Landroidx/room/gradle/RoomSchemaCopyTask;", "Lorg/gradle/api/DefaultTask;", "()V", "apTaskSchemaOutputDirectories", "Lorg/gradle/api/provider/ListProperty;", "Lorg/gradle/api/file/Directory;", "getApTaskSchemaOutputDirectories", "()Lorg/gradle/api/provider/ListProperty;", "schemaDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getSchemaDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "copySchemas", "", "sha256", "", "Ljava/io/File;", "room-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nRoomSchemaCopyTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomSchemaCopyTask.kt\nandroidx/room/gradle/RoomSchemaCopyTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,121:1\n1557#2:122\n1628#2,3:123\n774#2:126\n865#2,2:127\n1863#2:129\n1864#2:139\n1863#2,2:148\n1317#3:130\n1318#3:138\n381#4,7:131\n503#4,7:140\n216#5:147\n217#5:150\n*S KotlinDebug\n*F\n+ 1 RoomSchemaCopyTask.kt\nandroidx/room/gradle/RoomSchemaCopyTask\n*L\n74#1:122\n74#1:123,3\n75#1:126\n75#1:127,2\n76#1:129\n76#1:139\n104#1:148,2\n80#1:130\n80#1:138\n89#1:131,7\n98#1:140,7\n99#1:147\n99#1:150\n*E\n"})
public abstract class RoomSchemaCopyTask
extends DefaultTask {
    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public abstract ListProperty<Directory> getApTaskSchemaOutputDirectories();

    @Internal
    @NotNull
    public abstract DirectoryProperty getSchemaDirectory();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void copySchemas() {
        Object element$iv;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv;
        File it;
        Iterable $this$mapTo$iv$iv;
        Map copiedHashes = new LinkedHashMap();
        Object object = this.getApTaskSchemaOutputDirectories().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apTaskSchemaOutputDirectories\n            .get()");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Directory directory = (Directory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getAsFile());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Object $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            void $this$forEach$iv2;
            element$iv = $this$filterTo$iv$iv.next();
            File outputDir = (File)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
            element$iv$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)outputDir)), (Function1)copySchemas.3.1.INSTANCE);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object2;
                void $this$getOrPut$iv;
                CopyOption[] copyOptionArray;
                File schemaFile = (File)element$iv2;
                boolean bl2 = false;
                Path schemaPath = schemaFile.toPath();
                Path basePath = outputDir.toPath().relativize(schemaPath);
                Object object3 = ((Directory)this.getSchemaDirectory().get()).getAsFile().toPath().resolve(basePath);
                Path $this$copySchemas_u24lambda_u245_u24lambda_u244_u24lambda_u242 = object3;
                boolean bl3 = false;
                if (copyOptionArray != null) {
                    copyOptionArray = $this$copySchemas_u24lambda_u245_u24lambda_u244_u24lambda_u242.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)copyOptionArray, (String)"parent");
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Path path = Files.createDirectories((Path)copyOptionArray, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                    v3 = path;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createDirectories(...)");
                } else {
                    v3 = null;
                }
                Path target = object3;
                Intrinsics.checkNotNullExpressionValue((Object)schemaPath, (String)"schemaPath");
                object3 = schemaPath;
                Intrinsics.checkNotNullExpressionValue((Object)target, (String)"target");
                $this$copySchemas_u24lambda_u245_u24lambda_u244_u24lambda_u242 = target;
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                CopyOption[] copyOptionArray2 = copyOptionArray;
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object3, $this$copySchemas_u24lambda_u245_u24lambda_u244_u24lambda_u242, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
                object3 = copiedHashes;
                String key$iv = ((Object)basePath).toString();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl4 = false;
                    Map answer$iv = new LinkedHashMap();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((Map)object2).put(this.sha256(schemaFile), ((Object)schemaPath).toString());
            }
        }
        Map $this$filterValues$iv = copiedHashes;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        element$iv = $this$filterValues$iv.entrySet().iterator();
        while (element$iv.hasNext()) {
            Map.Entry entry$iv = (Map.Entry)element$iv.next();
            Map it2 = (Map)entry$iv.getValue();
            boolean bl = false;
            if (!(it2.size() > 1)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$forEach$iv = result$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        if (iterator.hasNext()) {
            StringBuilder stringBuilder;
            Object object4 = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            Map hashes = (Map)object4.getValue();
            StringBuilder $this$copySchemas_u24lambda_u249_u24lambda_u248 = stringBuilder = new StringBuilder();
            boolean bl5 = false;
            StringBuilder stringBuilder2 = $this$copySchemas_u24lambda_u249_u24lambda_u248.append("Inconsistency detected exporting Room schema files (checksum - source):");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            Iterable $this$forEach$iv3 = hashes.entrySet();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                Map.Entry it3 = (Map.Entry)element$iv3;
                boolean bl6 = false;
                StringBuilder stringBuilder3 = $this$copySchemas_u24lambda_u249_u24lambda_u248.append("  " + it3.getKey() + " - " + it3.getValue());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
            }
            StringBuilder stringBuilder4 = $this$copySchemas_u24lambda_u249_u24lambda_u248.append("The listed files differ in content but were copied into the same schema directory '" + this.getSchemaDirectory().get() + "'. A possible indicator that per-variant / per-target schema locations must be provided.");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String errorMsg = string;
            throw new GradleException(errorMsg);
        }
    }

    private final String sha256(File $this$sha256) {
        byte[] byArray = MessageDigest.getInstance("SHA-256").digest(FilesKt.readBytes((File)$this$sha256));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"SHA-256\").digest(this.readBytes())");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)sha256.1.INSTANCE, (int)30, null);
    }
}

