/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.gradle;

import androidx.room.gradle.RoomExtension;
import androidx.room.gradle.RoomGradlePlugin;
import androidx.room.gradle.integration.AndroidPluginIntegration;
import androidx.room.gradle.integration.CommonIntegration;
import androidx.room.gradle.integration.KotlinMultiplatformPluginIntegration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0002H\u0016R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\r\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Landroidx/room/gradle/RoomGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/file/ProjectLayout;Lorg/gradle/api/provider/ProviderFactory;)V", "androidIntegration", "Landroidx/room/gradle/integration/AndroidPluginIntegration;", "getAndroidIntegration", "()Landroidx/room/gradle/integration/AndroidPluginIntegration;", "androidIntegration$delegate", "Lkotlin/Lazy;", "commonIntegration", "Landroidx/room/gradle/integration/CommonIntegration;", "kmpIntegration", "Landroidx/room/gradle/integration/KotlinMultiplatformPluginIntegration;", "getKmpIntegration", "()Landroidx/room/gradle/integration/KotlinMultiplatformPluginIntegration;", "kmpIntegration$delegate", "apply", "", "project", "Companion", "room-gradle-plugin"})
public final class RoomGradlePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonIntegration commonIntegration;
    @NotNull
    private final Lazy androidIntegration$delegate;
    @NotNull
    private final Lazy kmpIntegration$delegate;
    @NotNull
    private static final Lazy<List<String>> gradleSyncProps$delegate = LazyKt.lazy((Function0)Companion.gradleSyncProps.2.INSTANCE);

    @Inject
    public RoomGradlePlugin(@NotNull ProjectLayout projectLayout, @NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        this.commonIntegration = new CommonIntegration(projectLayout, providerFactory);
        this.androidIntegration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<AndroidPluginIntegration>(this){
            final /* synthetic */ RoomGradlePlugin this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final AndroidPluginIntegration invoke() {
                return new AndroidPluginIntegration(RoomGradlePlugin.access$getCommonIntegration$p(this.this$0));
            }
        }));
        this.kmpIntegration$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KotlinMultiplatformPluginIntegration>(this){
            final /* synthetic */ RoomGradlePlugin this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final KotlinMultiplatformPluginIntegration invoke() {
                return new KotlinMultiplatformPluginIntegration(RoomGradlePlugin.access$getCommonIntegration$p(this.this$0));
            }
        }));
    }

    private final AndroidPluginIntegration getAndroidIntegration() {
        Lazy lazy = this.androidIntegration$delegate;
        return (AndroidPluginIntegration)lazy.getValue();
    }

    private final KotlinMultiplatformPluginIntegration getKmpIntegration() {
        Lazy lazy = this.kmpIntegration$delegate;
        return (KotlinMultiplatformPluginIntegration)lazy.getValue();
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RoomExtension roomExtension = (RoomExtension)project.getExtensions().create("room", RoomExtension.class, new Object[0]);
        AndroidPluginIntegration androidPluginIntegration = this.getAndroidIntegration();
        Intrinsics.checkNotNullExpressionValue((Object)roomExtension, (String)"roomExtension");
        androidPluginIntegration.withAndroid(project, roomExtension);
        this.getKmpIntegration().withKotlin(project, roomExtension);
    }

    public static final /* synthetic */ CommonIntegration access$getCommonIntegration$p(RoomGradlePlugin $this) {
        return $this.commonIntegration;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\n\u001a\u00020\u0005*\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000bJ<\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0000\u0082\u0002\b\n\u0006\b\u0000\u001a\u0002\u0010\u0001\u00a2\u0006\u0002\b\u0014J\f\u0010\u0015\u001a\u00020\u0010*\u00020\u000eH\u0002J\u0011\u0010\u0016\u001a\u00020\u0010*\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Landroidx/room/gradle/RoomGradlePlugin$Companion;", "", "()V", "gradleSyncProps", "", "", "getGradleSyncProps", "()Ljava/util/List;", "gradleSyncProps$delegate", "Lkotlin/Lazy;", "capitalize", "capitalize$room_gradle_plugin", "check", "", "Lorg/gradle/api/Project;", "value", "", "isFatal", "lazyMessage", "Lkotlin/Function0;", "check$room_gradle_plugin", "isGradleSyncRunning", "isKspTask", "Lorg/gradle/api/Task;", "isKspTask$room_gradle_plugin", "room-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nRoomGradlePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomGradlePlugin.kt\nandroidx/room/gradle/RoomGradlePlugin$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1755#2,3:92\n*S KotlinDebug\n*F\n+ 1 RoomGradlePlugin.kt\nandroidx/room/gradle/RoomGradlePlugin$Companion\n*L\n78#1:92,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String capitalize$room_gradle_plugin(@NotNull String $this$capitalize) {
            String string;
            Intrinsics.checkNotNullParameter((Object)$this$capitalize, (String)"<this>");
            String string2 = $this$capitalize;
            if (((CharSequence)string2).length() > 0) {
                String string3;
                void it;
                char c = string2.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                if (Character.isLowerCase((char)it)) {
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    string3 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string3 = String.valueOf((char)it);
                }
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
                String string4 = string2;
                int n = 1;
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                string = stringBuilder2.append(string5).toString();
            } else {
                string = string2;
            }
            return string;
        }

        public final boolean isKspTask$room_gradle_plugin(@NotNull Task $this$isKspTask) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$isKspTask, (String)"<this>");
            try {
                Class<?> kspTaskClass = Class.forName("com.google.devtools.ksp.gradle.KspTask");
                bl = kspTaskClass.isAssignableFrom($this$isKspTask.getClass());
            }
            catch (ClassNotFoundException ex) {
                bl = false;
            }
            return bl;
        }

        public final void check$room_gradle_plugin(@NotNull Project $this$check, boolean value, boolean isFatal, @NotNull Function0<String> lazyMessage) {
            Intrinsics.checkNotNullParameter((Object)$this$check, (String)"<this>");
            Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
            if (this.isGradleSyncRunning($this$check) && !isFatal) {
                return;
            }
            if (!value) {
                throw new GradleException((String)lazyMessage.invoke());
            }
        }

        public static /* synthetic */ void check$room_gradle_plugin$default(Companion companion, Project project, boolean bl, boolean bl2, Function0 function0, int n, Object object) {
            if ((n & 2) != 0) {
                bl2 = false;
            }
            companion.check$room_gradle_plugin(project, bl, bl2, (Function0<String>)function0);
        }

        private final boolean isGradleSyncRunning(Project $this$isGradleSyncRunning) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.getGradleSyncProps();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String property = (String)element$iv;
                        boolean bl2 = false;
                        Object object = $this$isGradleSyncRunning.getProviders().gradleProperty(property).map(arg_0 -> Companion.isGradleSyncRunning$lambda$3$lambda$2(isGradleSyncRunning.1.1.INSTANCE, arg_0)).orElse((Object)false).get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"providers.gradleProperty\u2026n() }.orElse(false).get()");
                        if (!((Boolean)object).booleanValue()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final List<String> getGradleSyncProps() {
            Lazy lazy = gradleSyncProps$delegate;
            return (List)lazy.getValue();
        }

        private static final Boolean isGradleSyncRunning$lambda$3$lambda$2(Function1 $tmp0, Object in) {
            return (Boolean)$tmp0.invoke(in);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

