/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.gradle;

import androidx.room.gradle.RoomExtension;
import androidx.room.gradle.RoomGradlePlugin;
import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.component.UnitTest;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.AndroidTest;
import com.android.build.api.variant.ComponentIdentity;
import com.android.build.api.variant.HasAndroidTest;
import com.android.build.api.variant.Variant;
import com.android.build.gradle.api.AndroidBasePlugin;
import com.google.devtools.ksp.gradle.KspTaskJvm;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.internal.KaptTask;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0004\u001d\u001e\u001f B\u0017\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016JV\u0010\u000b\u001a&\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\f0\f2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0012H\u0002J2\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0012H\u0002J2\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J \u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/room/gradle/RoomGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/file/ProjectLayout;Lorg/gradle/api/model/ObjectFactory;)V", "apply", "", "project", "configureJavaTasks", "Lorg/gradle/api/DomainObjectCollection;", "Lorg/gradle/api/tasks/compile/JavaCompile;", "kotlin.jvm.PlatformType", "androidVariantsTaskNames", "Landroidx/room/gradle/RoomGradlePlugin$AndroidVariantsTaskNames;", "configureBlock", "Lkotlin/Function2;", "Lorg/gradle/api/Task;", "Lcom/android/build/api/variant/ComponentIdentity;", "Landroidx/room/gradle/RoomGradlePlugin$RoomSchemaDirectoryArgumentProvider;", "configureKaptTasks", "configureKspTasks", "configureRoom", "configureVariant", "roomExtension", "Landroidx/room/gradle/RoomExtension;", "variant", "AndroidVariantsTaskNames", "Companion", "RoomSchemaCopyTask", "RoomSchemaDirectoryArgumentProvider", "room-gradle-plugin"})
public final class RoomGradlePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectLayout projectLayout;
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private static final Lazy<List<String>> gradleSyncProps$delegate = LazyKt.lazy((Function0)Companion.gradleSyncProps.2.INSTANCE);

    @Inject
    public RoomGradlePlugin(@NotNull ProjectLayout projectLayout, @NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this.projectLayout = projectLayout;
        this.objectFactory = objectFactory;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.BooleanRef configured = new Ref.BooleanRef();
        project.getPlugins().withType(AndroidBasePlugin.class, arg_0 -> RoomGradlePlugin.apply$lambda$0((Function1)new Function1<AndroidBasePlugin, Unit>(configured, this, project){
            final /* synthetic */ Ref.BooleanRef $configured;
            final /* synthetic */ RoomGradlePlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.$configured = $configured;
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(AndroidBasePlugin it) {
                this.$configured.element = true;
                RoomGradlePlugin.access$configureRoom(this.this$0, this.$project);
            }
        }, arg_0));
        project.afterEvaluate(arg_0 -> RoomGradlePlugin.apply$lambda$1((Function1)new Function1<Project, Unit>(project, configured){
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.BooleanRef $configured;
            {
                this.$project = $project;
                this.$configured = $configured;
                super(1);
            }

            public final void invoke(Project it) {
                androidx.room.gradle.RoomGradlePlugin$Companion.check$room_gradle_plugin$default(RoomGradlePlugin.Companion, this.$project, this.$configured.element, false, apply.1.INSTANCE, 2, null);
            }
        }, arg_0));
    }

    private final void configureRoom(Project project) {
        RoomExtension roomExtension = (RoomExtension)project.getExtensions().create("room", RoomExtension.class, new Object[0]);
        AndroidComponentsExtension componentsExtension = (AndroidComponentsExtension)project.getExtensions().findByType(AndroidComponentsExtension.class);
        Companion.check$room_gradle_plugin(project, componentsExtension != null, true, (Function0<String>)((Function0)configureRoom.1.INSTANCE));
        androidx.room.gradle.RoomGradlePlugin$Companion.check$room_gradle_plugin$default(Companion, project, componentsExtension.getPluginVersion().compareTo(new AndroidPluginVersion(7, 3)) >= 0, false, (Function0)new Function0<String>(componentsExtension){
            final /* synthetic */ AndroidComponentsExtension<?, ?, ?> $componentsExtension;
            {
                this.$componentsExtension = $componentsExtension;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "The Room Gradle plugin is only compatible with Android Gradle plugin (AGP) version 7.3.0 or higher (found " + this.$componentsExtension.getPluginVersion() + ").";
            }
        }, 2, null);
        AndroidComponentsExtension.DefaultImpls.onVariants$default((AndroidComponentsExtension)componentsExtension, null, (Function1)((Function1)new Function1<Variant, Unit>(project, roomExtension, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ RoomExtension $roomExtension;
            final /* synthetic */ RoomGradlePlugin this$0;
            {
                this.$project = $project;
                this.$roomExtension = $roomExtension;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Variant variant) {
                block2: {
                    UnitTest it;
                    RoomExtension roomExtension;
                    Project project;
                    RoomGradlePlugin roomGradlePlugin;
                    UnitTest unitTest;
                    Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                    RoomGradlePlugin.Companion.check$room_gradle_plugin(this.$project, !this.$roomExtension.getSchemaDirectories$room_gradle_plugin().isEmpty(), true, (Function0<String>)((Function0)configureRoom.1.INSTANCE));
                    RoomExtension roomExtension2 = this.$roomExtension;
                    Intrinsics.checkNotNullExpressionValue((Object)roomExtension2, (String)"roomExtension");
                    RoomGradlePlugin.access$configureVariant(this.this$0, this.$project, roomExtension2, (ComponentIdentity)variant);
                    UnitTest unitTest2 = variant.getUnitTest();
                    if (unitTest2 != null) {
                        unitTest = unitTest2;
                        roomGradlePlugin = this.this$0;
                        project = this.$project;
                        roomExtension = this.$roomExtension;
                        it = unitTest;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)roomExtension, (String)"roomExtension");
                        RoomGradlePlugin.access$configureVariant(roomGradlePlugin, project, roomExtension, (ComponentIdentity)it);
                    }
                    if (!(variant instanceof HasAndroidTest)) break block2;
                    AndroidTest androidTest = ((HasAndroidTest)variant).getAndroidTest();
                    if (androidTest != null) {
                        unitTest = androidTest;
                        roomGradlePlugin = this.this$0;
                        project = this.$project;
                        roomExtension = this.$roomExtension;
                        it = unitTest;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)roomExtension, (String)"roomExtension");
                        RoomGradlePlugin.access$configureVariant(roomGradlePlugin, project, roomExtension, (ComponentIdentity)it);
                    }
                }
            }
        }), (int)1, null);
    }

    private final void configureVariant(Project project, RoomExtension roomExtension, ComponentIdentity variant) {
        Function2 configureTask2 = (Function2)new Function2<Task, ComponentIdentity, RoomSchemaDirectoryArgumentProvider>(roomExtension, project, this){
            final /* synthetic */ RoomExtension $roomExtension;
            final /* synthetic */ Project $project;
            final /* synthetic */ RoomGradlePlugin this$0;
            {
                this.$roomExtension = $roomExtension;
                this.$project = $project;
                this.this$0 = $receiver;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final RoomSchemaDirectoryArgumentProvider invoke(@NotNull Task task, @NotNull ComponentIdentity variantIdentity) {
                Object object;
                void key$iv;
                void $this$getOrPut$iv;
                Pair<RoomExtension.VariantMatchName, Provider<String>> matchedPair;
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Intrinsics.checkNotNullParameter((Object)variantIdentity, (String)"variantIdentity");
                Map<RoomExtension.VariantMatchName, Provider<String>> schemaDirectories = this.$roomExtension.getSchemaDirectories$room_gradle_plugin();
                Pair<RoomExtension.VariantMatchName, Provider<String>> pair = configureVariant.configureTask.1.invoke$findPair(schemaDirectories, variantIdentity.getName());
                if (pair == null) {
                    Pair<RoomExtension.VariantMatchName, Provider<String>> pair2;
                    String string = variantIdentity.getFlavorName();
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        pair2 = configureVariant.configureTask.1.invoke$findPair(schemaDirectories, it);
                    } else {
                        pair2 = pair = null;
                    }
                    if (pair2 == null) {
                        Pair<RoomExtension.VariantMatchName, Provider<String>> pair3;
                        String string2 = variantIdentity.getBuildType();
                        if (string2 != null) {
                            String it = string2;
                            boolean bl = false;
                            pair3 = configureVariant.configureTask.1.invoke$findPair(schemaDirectories, it);
                        } else {
                            pair3 = pair = null;
                        }
                        if (pair3 == null) {
                            pair = configureVariant.configureTask.1.invoke$findPair(schemaDirectories, RoomExtension.Companion.getALL_VARIANTS---SQqeY$room_gradle_plugin());
                        }
                    }
                }
                RoomGradlePlugin.Companion.check$room_gradle_plugin(this.$project, (matchedPair = pair) != null, true, (Function0<String>)((Function0)new Function0<String>(variantIdentity){
                    final /* synthetic */ ComponentIdentity $variantIdentity;
                    {
                        this.$variantIdentity = $variantIdentity;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "No matching schema directory for variant '" + this.$variantIdentity.getName() + "'.";
                    }
                }));
                String matchedName = ((RoomExtension.VariantMatchName)matchedPair.component1()).unbox-impl();
                Provider schemaDirectoryProvider = (Provider)matchedPair.component2();
                String schemaDirectory = (String)schemaDirectoryProvider.get();
                Intrinsics.checkNotNullExpressionValue((Object)schemaDirectory, (String)"schemaDirectory");
                androidx.room.gradle.RoomGradlePlugin$Companion.check$room_gradle_plugin$default(RoomGradlePlugin.Companion, this.$project, ((CharSequence)schemaDirectory).length() > 0, false, (Function0)new Function0<String>(variantIdentity){
                    final /* synthetic */ ComponentIdentity $variantIdentity;
                    {
                        this.$variantIdentity = $variantIdentity;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "The schema directory path for variant '" + this.$variantIdentity.getName() + "' must not be empty.";
                    }
                }, 2, null);
                Path path = Paths.get(schemaDirectory, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(path)");
                Path schemaDirectoryPath = path;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.notExists(schemaDirectoryPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    androidx.room.gradle.RoomGradlePlugin$Companion.check$room_gradle_plugin$default(RoomGradlePlugin.Companion, this.$project, schemaDirectoryPath.toFile().mkdirs(), false, (Function0)new Function0<String>(schemaDirectoryPath){
                        final /* synthetic */ Path $schemaDirectoryPath;
                        {
                            this.$schemaDirectoryPath = $schemaDirectoryPath;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Unable to create directory: " + this.$schemaDirectoryPath;
                        }
                    }, 2, null);
                }
                DirectoryProperty it = RoomGradlePlugin.access$getObjectFactory$p(this.this$0).directoryProperty();
                Project bl = this.$project;
                Object $this$invoke_u24lambda_u243 = it;
                boolean $i$a$-apply-RoomGradlePlugin$configureVariant$configureTask$1$schemaInputDir$22 = false;
                $this$invoke_u24lambda_u243.set(bl.file((Object)schemaDirectoryPath));
                DirectoryProperty schemaInputDir = it;
                Provider schemaOutputDir = RoomGradlePlugin.access$getProjectLayout$p(this.this$0).getBuildDirectory().dir("intermediates/room/schemas/" + task.getName());
                $this$invoke_u24lambda_u243 = this.$roomExtension.getCopyTasks$room_gradle_plugin();
                RoomExtension.VariantMatchName $i$a$-apply-RoomGradlePlugin$configureVariant$configureTask$1$schemaInputDir$22 = RoomExtension.VariantMatchName.box-impl(matchedName);
                Project project = this.$project;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    TaskProvider taskProvider = project.getTasks().register("copyRoomSchemas" + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(matchedName), RoomSchemaCopyTask.class, arg_0 -> configureVariant.configureTask.1.invoke$lambda$5$lambda$4((Function1)new Function1<RoomSchemaCopyTask, Unit>(schemaInputDir){
                        final /* synthetic */ DirectoryProperty $schemaInputDir;
                        {
                            this.$schemaInputDir = $schemaInputDir;
                            super(1);
                        }

                        public final void invoke(RoomSchemaCopyTask it) {
                            it.getSchemaDirectory().set((Provider)this.$schemaInputDir);
                        }
                    }, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"schemaInputDir = objectF\u2026putDir)\n                }");
                    TaskProvider answer$iv = taskProvider;
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                TaskProvider copyTask2 = (TaskProvider)object;
                copyTask2.configure(arg_0 -> configureVariant.configureTask.1.invoke$lambda$6((Function1)new Function1<RoomSchemaCopyTask, Unit>((Provider<Directory>)schemaOutputDir){
                    final /* synthetic */ Provider<Directory> $schemaOutputDir;
                    {
                        this.$schemaOutputDir = $schemaOutputDir;
                        super(1);
                    }

                    public final void invoke(RoomSchemaCopyTask it) {
                        Object[] objectArray = new Object[]{this.$schemaOutputDir};
                        it.getVariantSchemaOutputDirectories().from(objectArray);
                    }
                }, arg_0));
                Object[] objectArray = new Object[]{copyTask2};
                task.finalizedBy(objectArray);
                boolean bl3 = RoomGradlePlugin.Companion.isKspTask$room_gradle_plugin(task);
                Intrinsics.checkNotNullExpressionValue((Object)schemaInputDir, (String)"schemaInputDir");
                Provider provider = (Provider)schemaInputDir;
                Intrinsics.checkNotNullExpressionValue((Object)schemaOutputDir, (String)"schemaOutputDir");
                return new RoomSchemaDirectoryArgumentProvider(bl3, (Provider<Directory>)provider, (Provider<Directory>)schemaOutputDir);
            }

            private static final <V> Pair<RoomExtension.VariantMatchName, V> invoke$findPair(Map<RoomExtension.VariantMatchName, ? extends V> $this$invoke_u24findPair, String key) {
                String it = RoomExtension.VariantMatchName.constructor-impl(key);
                boolean bl = false;
                return $this$invoke_u24findPair.containsKey(RoomExtension.VariantMatchName.box-impl(it)) ? TuplesKt.to((Object)RoomExtension.VariantMatchName.box-impl(it), (Object)MapsKt.getValue($this$invoke_u24findPair, (Object)RoomExtension.VariantMatchName.box-impl(it))) : null;
            }

            private static final void invoke$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$6(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        };
        AndroidVariantsTaskNames androidVariantTaskNames = new AndroidVariantsTaskNames(variant.getName(), variant);
        this.configureJavaTasks(project, androidVariantTaskNames, (Function2<? super Task, ? super ComponentIdentity, RoomSchemaDirectoryArgumentProvider>)configureTask2);
        this.configureKaptTasks(project, androidVariantTaskNames, (Function2<? super Task, ? super ComponentIdentity, RoomSchemaDirectoryArgumentProvider>)configureTask2);
        this.configureKspTasks(project, androidVariantTaskNames, (Function2<? super Task, ? super ComponentIdentity, RoomSchemaDirectoryArgumentProvider>)configureTask2);
    }

    private final DomainObjectCollection<JavaCompile> configureJavaTasks(Project project, AndroidVariantsTaskNames androidVariantsTaskNames, Function2<? super Task, ? super ComponentIdentity, RoomSchemaDirectoryArgumentProvider> configureBlock) {
        return project.getTasks().withType(JavaCompile.class, arg_0 -> RoomGradlePlugin.configureJavaTasks$lambda$2((Function1)new Function1<JavaCompile, Unit>(androidVariantsTaskNames, configureBlock){
            final /* synthetic */ AndroidVariantsTaskNames $androidVariantsTaskNames;
            final /* synthetic */ Function2<Task, ComponentIdentity, RoomSchemaDirectoryArgumentProvider> $configureBlock;
            {
                this.$androidVariantsTaskNames = $androidVariantsTaskNames;
                this.$configureBlock = $configureBlock;
                super(1);
            }

            public final void invoke(JavaCompile task) {
                block0: {
                    String string = task.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
                    ComponentIdentity componentIdentity = this.$androidVariantsTaskNames.withJavaCompile(string);
                    if (componentIdentity == null) break block0;
                    ComponentIdentity componentIdentity2 = componentIdentity;
                    Function2<Task, ComponentIdentity, RoomSchemaDirectoryArgumentProvider> function2 = this.$configureBlock;
                    ComponentIdentity variantIdentity = componentIdentity2;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                    RoomSchemaDirectoryArgumentProvider argProvider = (RoomSchemaDirectoryArgumentProvider)function2.invoke((Object)task, (Object)variantIdentity);
                    task.getOptions().getCompilerArgumentProviders().add(argProvider);
                }
            }
        }, arg_0));
    }

    private final void configureKaptTasks(Project project, AndroidVariantsTaskNames androidVariantsTaskNames, Function2<? super Task, ? super ComponentIdentity, RoomSchemaDirectoryArgumentProvider> configureBlock) {
        project.getPlugins().withId("kotlin-kapt", arg_0 -> RoomGradlePlugin.configureKaptTasks$lambda$3((Function1)new Function1<Plugin<?>, Unit>(project, androidVariantsTaskNames, configureBlock){
            final /* synthetic */ Project $project;
            final /* synthetic */ AndroidVariantsTaskNames $androidVariantsTaskNames;
            final /* synthetic */ Function2<Task, ComponentIdentity, RoomSchemaDirectoryArgumentProvider> $configureBlock;
            {
                this.$project = $project;
                this.$androidVariantsTaskNames = $androidVariantsTaskNames;
                this.$configureBlock = $configureBlock;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                this.$project.getTasks().withType(KaptTask.class, arg_0 -> configureKaptTasks.1.invoke$lambda$0((Function1)new Function1<KaptTask, Unit>(this.$androidVariantsTaskNames, this.$configureBlock){
                    final /* synthetic */ AndroidVariantsTaskNames $androidVariantsTaskNames;
                    final /* synthetic */ Function2<Task, ComponentIdentity, RoomSchemaDirectoryArgumentProvider> $configureBlock;
                    {
                        this.$androidVariantsTaskNames = $androidVariantsTaskNames;
                        this.$configureBlock = $configureBlock;
                        super(1);
                    }

                    public final void invoke(KaptTask task) {
                        block2: {
                            String string = task.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
                            ComponentIdentity componentIdentity = this.$androidVariantsTaskNames.withKaptTask(string);
                            if (componentIdentity == null) break block2;
                            ComponentIdentity componentIdentity2 = componentIdentity;
                            Function2<Task, ComponentIdentity, RoomSchemaDirectoryArgumentProvider> function2 = this.$configureBlock;
                            ComponentIdentity variantIdentity = componentIdentity2;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                            RoomSchemaDirectoryArgumentProvider argProvider = (RoomSchemaDirectoryArgumentProvider)function2.invoke((Object)task, (Object)variantIdentity);
                            try {
                                task.getAnnotationProcessorOptionProviders().add(CollectionsKt.listOf((Object)argProvider));
                            }
                            catch (Throwable e) {
                                task.getAnnotationProcessorOptionProviders().add(argProvider);
                            }
                        }
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private final void configureKspTasks(Project project, AndroidVariantsTaskNames androidVariantsTaskNames, Function2<? super Task, ? super ComponentIdentity, RoomSchemaDirectoryArgumentProvider> configureBlock) {
        project.getPlugins().withId("com.google.devtools.ksp", arg_0 -> RoomGradlePlugin.configureKspTasks$lambda$4((Function1)new Function1<Plugin<?>, Unit>(project, androidVariantsTaskNames, configureBlock){
            final /* synthetic */ Project $project;
            final /* synthetic */ AndroidVariantsTaskNames $androidVariantsTaskNames;
            final /* synthetic */ Function2<Task, ComponentIdentity, RoomSchemaDirectoryArgumentProvider> $configureBlock;
            {
                this.$project = $project;
                this.$androidVariantsTaskNames = $androidVariantsTaskNames;
                this.$configureBlock = $configureBlock;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                this.$project.getTasks().withType(KspTaskJvm.class, arg_0 -> configureKspTasks.1.invoke$lambda$0((Function1)new Function1<KspTaskJvm, Unit>(this.$androidVariantsTaskNames, this.$configureBlock){
                    final /* synthetic */ AndroidVariantsTaskNames $androidVariantsTaskNames;
                    final /* synthetic */ Function2<Task, ComponentIdentity, RoomSchemaDirectoryArgumentProvider> $configureBlock;
                    {
                        this.$androidVariantsTaskNames = $androidVariantsTaskNames;
                        this.$configureBlock = $configureBlock;
                        super(1);
                    }

                    public final void invoke(KspTaskJvm task) {
                        block0: {
                            String string = task.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"task.name");
                            ComponentIdentity componentIdentity = this.$androidVariantsTaskNames.withKspTaskJvm(string);
                            if (componentIdentity == null) break block0;
                            ComponentIdentity componentIdentity2 = componentIdentity;
                            Function2<Task, ComponentIdentity, RoomSchemaDirectoryArgumentProvider> function2 = this.$configureBlock;
                            ComponentIdentity variantIdentity = componentIdentity2;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"task");
                            RoomSchemaDirectoryArgumentProvider argProvider = (RoomSchemaDirectoryArgumentProvider)function2.invoke((Object)task, (Object)variantIdentity);
                            task.getCommandLineArgumentProviders().add((Object)argProvider);
                        }
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureJavaTasks$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureKaptTasks$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureKspTasks$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$configureRoom(RoomGradlePlugin $this, Project project) {
        $this.configureRoom(project);
    }

    public static final /* synthetic */ void access$configureVariant(RoomGradlePlugin $this, Project project, RoomExtension roomExtension, ComponentIdentity variant) {
        $this.configureVariant(project, roomExtension, variant);
    }

    public static final /* synthetic */ ObjectFactory access$getObjectFactory$p(RoomGradlePlugin $this) {
        return $this.objectFactory;
    }

    public static final /* synthetic */ ProjectLayout access$getProjectLayout$p(RoomGradlePlugin $this) {
        return $this.projectLayout;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u0003R\u001b\u0010\u0007\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\tR\u001b\u0010\u000f\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u0010\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/room/gradle/RoomGradlePlugin$AndroidVariantsTaskNames;", "", "variantName", "", "variantIdentity", "Lcom/android/build/api/variant/ComponentIdentity;", "(Ljava/lang/String;Lcom/android/build/api/variant/ComponentIdentity;)V", "javaCompileName", "getJavaCompileName", "()Ljava/lang/String;", "javaCompileName$delegate", "Lkotlin/Lazy;", "kaptTaskName", "getKaptTaskName", "kaptTaskName$delegate", "kspTaskJvm", "getKspTaskJvm", "kspTaskJvm$delegate", "withJavaCompile", "taskName", "withKaptTask", "withKspTaskJvm", "room-gradle-plugin"})
    public static final class AndroidVariantsTaskNames {
        @NotNull
        private final String variantName;
        @NotNull
        private final ComponentIdentity variantIdentity;
        @NotNull
        private final Lazy javaCompileName$delegate;
        @NotNull
        private final Lazy kaptTaskName$delegate;
        @NotNull
        private final Lazy kspTaskJvm$delegate;

        public AndroidVariantsTaskNames(@NotNull String variantName, @NotNull ComponentIdentity variantIdentity) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter((Object)variantIdentity, (String)"variantIdentity");
            this.variantName = variantName;
            this.variantIdentity = variantIdentity;
            this.javaCompileName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ AndroidVariantsTaskNames this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "compile" + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(AndroidVariantsTaskNames.access$getVariantName$p(this.this$0)) + "JavaWithJavac";
                }
            }));
            this.kaptTaskName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ AndroidVariantsTaskNames this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "kapt" + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(AndroidVariantsTaskNames.access$getVariantName$p(this.this$0)) + "Kotlin";
                }
            }));
            this.kspTaskJvm$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ AndroidVariantsTaskNames this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "ksp" + RoomGradlePlugin.Companion.capitalize$room_gradle_plugin(AndroidVariantsTaskNames.access$getVariantName$p(this.this$0)) + "Kotlin";
                }
            }));
        }

        private final String getJavaCompileName() {
            Lazy lazy = this.javaCompileName$delegate;
            return (String)lazy.getValue();
        }

        private final String getKaptTaskName() {
            Lazy lazy = this.kaptTaskName$delegate;
            return (String)lazy.getValue();
        }

        private final String getKspTaskJvm() {
            Lazy lazy = this.kspTaskJvm$delegate;
            return (String)lazy.getValue();
        }

        @Nullable
        public final ComponentIdentity withJavaCompile(@NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return Intrinsics.areEqual((Object)taskName, (Object)this.getJavaCompileName()) ? this.variantIdentity : null;
        }

        @Nullable
        public final ComponentIdentity withKaptTask(@NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return Intrinsics.areEqual((Object)taskName, (Object)this.getKaptTaskName()) ? this.variantIdentity : null;
        }

        @Nullable
        public final ComponentIdentity withKspTaskJvm(@NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return Intrinsics.areEqual((Object)taskName, (Object)this.getKspTaskJvm()) ? this.variantIdentity : null;
        }

        public static final /* synthetic */ String access$getVariantName$p(AndroidVariantsTaskNames $this) {
            return $this.variantName;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\n\u001a\u00020\u0005*\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000bJ<\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0000\u0082\u0002\b\n\u0006\b\u0000\u001a\u0002\u0010\u0001\u00a2\u0006\u0002\b\u0014J\f\u0010\u0015\u001a\u00020\u0010*\u00020\u000eH\u0002J\u0011\u0010\u0016\u001a\u00020\u0010*\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Landroidx/room/gradle/RoomGradlePlugin$Companion;", "", "()V", "gradleSyncProps", "", "", "getGradleSyncProps", "()Ljava/util/List;", "gradleSyncProps$delegate", "Lkotlin/Lazy;", "capitalize", "capitalize$room_gradle_plugin", "check", "", "Lorg/gradle/api/Project;", "value", "", "isFatal", "lazyMessage", "Lkotlin/Function0;", "check$room_gradle_plugin", "isGradleSyncRunning", "isKspTask", "Lorg/gradle/api/Task;", "isKspTask$room_gradle_plugin", "room-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nRoomGradlePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomGradlePlugin.kt\nandroidx/room/gradle/RoomGradlePlugin$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1747#2,3:360\n*S KotlinDebug\n*F\n+ 1 RoomGradlePlugin.kt\nandroidx/room/gradle/RoomGradlePlugin$Companion\n*L\n346#1:360,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String capitalize$room_gradle_plugin(@NotNull String $this$capitalize) {
            String string;
            Intrinsics.checkNotNullParameter((Object)$this$capitalize, (String)"<this>");
            String string2 = $this$capitalize;
            if (((CharSequence)string2).length() > 0) {
                String string3;
                void it;
                char c = string2.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = false;
                if (Character.isLowerCase((char)it)) {
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    string3 = CharsKt.titlecase((char)it, (Locale)locale);
                } else {
                    string3 = String.valueOf((char)it);
                }
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string3);
                String string4 = string2;
                int n = 1;
                String string5 = string4.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                string = stringBuilder2.append(string5).toString();
            } else {
                string = string2;
            }
            return string;
        }

        public final boolean isKspTask$room_gradle_plugin(@NotNull Task $this$isKspTask) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)$this$isKspTask, (String)"<this>");
            try {
                Class<?> kspTaskClass = Class.forName("com.google.devtools.ksp.gradle.KspTask");
                bl = kspTaskClass.isAssignableFrom($this$isKspTask.getClass());
            }
            catch (ClassNotFoundException ex) {
                bl = false;
            }
            return bl;
        }

        public final void check$room_gradle_plugin(@NotNull Project $this$check, boolean value, boolean isFatal, @NotNull Function0<String> lazyMessage) {
            Intrinsics.checkNotNullParameter((Object)$this$check, (String)"<this>");
            Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
            if (this.isGradleSyncRunning($this$check) && !isFatal) {
                return;
            }
            if (!value) {
                throw new GradleException((String)lazyMessage.invoke());
            }
        }

        public static /* synthetic */ void check$room_gradle_plugin$default(Companion companion, Project project, boolean bl, boolean bl2, Function0 function0, int n, Object object) {
            if ((n & 2) != 0) {
                bl2 = false;
            }
            companion.check$room_gradle_plugin(project, bl, bl2, (Function0<String>)function0);
        }

        private final boolean isGradleSyncRunning(Project $this$isGradleSyncRunning) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.getGradleSyncProps();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        Map map = $this$isGradleSyncRunning.getProperties();
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"this.properties");
                        boolean bl3 = map.containsKey(it) && Boolean.parseBoolean(String.valueOf($this$isGradleSyncRunning.getProperties().get(it)));
                        if (!bl3) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final List<String> getGradleSyncProps() {
            Lazy lazy = gradleSyncProps$delegate;
            return (List)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @DisableCachingByDefault(because="Simple disk bound task.")
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Landroidx/room/gradle/RoomGradlePlugin$RoomSchemaCopyTask;", "Lorg/gradle/api/DefaultTask;", "()V", "schemaDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getSchemaDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "variantSchemaOutputDirectories", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getVariantSchemaOutputDirectories", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "copySchemas", "", "sha256", "", "Ljava/io/File;", "room-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nRoomGradlePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomGradlePlugin.kt\nandroidx/room/gradle/RoomGradlePlugin$RoomSchemaCopyTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,359:1\n766#2:360\n857#2,2:361\n1855#2:363\n1856#2:374\n1855#2,2:383\n1313#3:364\n1314#3:373\n1#4:365\n372#5,7:366\n494#5,7:375\n215#6:382\n216#6:385\n*S KotlinDebug\n*F\n+ 1 RoomGradlePlugin.kt\nandroidx/room/gradle/RoomGradlePlugin$RoomSchemaCopyTask\n*L\n261#1:360\n261#1:361,2\n262#1:363\n262#1:374\n284#1:383,2\n263#1:364\n263#1:373\n271#1:366,7\n279#1:375,7\n279#1:382\n279#1:385\n*E\n"})
    public static abstract class RoomSchemaCopyTask
    extends DefaultTask {
        @InputFiles
        @SkipWhenEmpty
        @IgnoreEmptyDirectories
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @NotNull
        public abstract ConfigurableFileCollection getVariantSchemaOutputDirectories();

        @Internal
        @NotNull
        public abstract DirectoryProperty getSchemaDirectory();

        /*
         * WARNING - void declaration
         */
        @TaskAction
        public final void copySchemas() {
            Object element$iv;
            Iterator $this$filterTo$iv$iv;
            Map copiedHashes = new LinkedHashMap();
            Set set = this.getVariantSchemaOutputDirectories().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"variantSchemaOutputDirectories.files");
            Iterable $this$filter$iv = set;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!it.exists()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                element$iv = $this$filterTo$iv$iv.next();
                File outputDir = (File)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)outputDir)), (Function1)copySchemas.2.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Object object;
                    void $this$getOrPut$iv;
                    Path path;
                    CopyOption[] copyOptionArray;
                    File schemaFile = (File)element$iv2;
                    boolean bl2 = false;
                    Path schemaPath = schemaFile.toPath();
                    Path basePath = outputDir.toPath().relativize(schemaPath);
                    Intrinsics.checkNotNullExpressionValue((Object)schemaPath, (String)"schemaPath");
                    Object object2 = schemaPath;
                    CopyOption[] $this$copySchemas_u24lambda_u244_u24lambda_u243_u24lambda_u241 = copyOptionArray = ((Directory)this.getSchemaDirectory().get()).getAsFile().toPath().resolve(basePath);
                    boolean $i$a$-apply-RoomGradlePlugin$RoomSchemaCopyTask$copySchemas$2$2$22 = false;
                    Path path2 = path = $this$copySchemas_u24lambda_u244_u24lambda_u243_u24lambda_u241.getParent();
                    if (path2 != null) {
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"parent");
                        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                        Path path3 = Files.createDirectories(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                        v4 = path3;
                        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(this, *attributes)");
                    } else {
                        v4 = null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)copyOptionArray, (String)"schemaDirectory.get().as\u2026nt?.createDirectories() }");
                    CopyOption[] copyOptionArray2 = copyOptionArray;
                    $this$copySchemas_u24lambda_u244_u24lambda_u243_u24lambda_u241 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    CopyOption[] $i$a$-apply-RoomGradlePlugin$RoomSchemaCopyTask$copySchemas$2$2$22 = $this$copySchemas_u24lambda_u244_u24lambda_u243_u24lambda_u241;
                    Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object2, (Path)copyOptionArray2, Arrays.copyOf($i$a$-apply-RoomGradlePlugin$RoomSchemaCopyTask$copySchemas$2$2$22, $i$a$-apply-RoomGradlePlugin$RoomSchemaCopyTask$copySchemas$2$2$22.length)), (String)"copy(this, target, *options)");
                    object2 = copiedHashes;
                    String key$iv = ((Object)basePath).toString();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl3 = false;
                        Map answer$iv = new LinkedHashMap();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Map)object).put(this.sha256(schemaFile), ((Object)schemaPath).toString());
                }
            }
            Map $this$filterValues$iv = copiedHashes;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            element$iv = $this$filterValues$iv.entrySet().iterator();
            while (element$iv.hasNext()) {
                Map.Entry entry$iv = (Map.Entry)element$iv.next();
                Map it = (Map)entry$iv.getValue();
                boolean bl = false;
                if (!(it.size() > 1)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$forEach$iv = result$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            if (iterator.hasNext()) {
                StringBuilder stringBuilder;
                Object object = element$iv = (Map.Entry)iterator.next();
                boolean bl = false;
                String schemaDir = (String)object.getKey();
                Map hashes = (Map)object.getValue();
                StringBuilder $this$copySchemas_u24lambda_u248_u24lambda_u247 = stringBuilder = new StringBuilder();
                boolean bl4 = false;
                StringBuilder stringBuilder2 = $this$copySchemas_u24lambda_u248_u24lambda_u247.append("Inconsistency detected exporting schema files (checksum - source):");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
                Iterable $this$forEach$iv3 = hashes.entrySet();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Map.Entry it = (Map.Entry)element$iv3;
                    boolean bl5 = false;
                    StringBuilder stringBuilder3 = $this$copySchemas_u24lambda_u248_u24lambda_u247.append("  " + it.getKey() + " - " + it.getValue());
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
                }
                StringBuilder stringBuilder4 = $this$copySchemas_u24lambda_u248_u24lambda_u247.append("The listed files differ in content but were copied into the same schema directory '" + schemaDir + "'. A possible indicator that per-variant schema locations must be provided.");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                String errorMsg = string;
                throw new GradleException(errorMsg);
            }
        }

        private final String sha256(File $this$sha256) {
            byte[] byArray = MessageDigest.getInstance("SHA-256").digest(FilesKt.readBytes((File)$this$sha256));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getInstance(\"SHA-256\").digest(this.readBytes())");
            return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, (Function1)sha256.1.INSTANCE, (int)30, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0011"}, d2={"Landroidx/room/gradle/RoomGradlePlugin$RoomSchemaDirectoryArgumentProvider;", "Lorg/gradle/process/CommandLineArgumentProvider;", "forKsp", "", "schemaInputDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "schemaOutputDir", "(ZLorg/gradle/api/provider/Provider;Lorg/gradle/api/provider/Provider;)V", "getForKsp", "()Z", "getSchemaInputDir", "()Lorg/gradle/api/provider/Provider;", "getSchemaOutputDir", "asArguments", "", "", "room-gradle-plugin"})
    public static final class RoomSchemaDirectoryArgumentProvider
    implements CommandLineArgumentProvider {
        private final boolean forKsp;
        @NotNull
        private final Provider<Directory> schemaInputDir;
        @NotNull
        private final Provider<Directory> schemaOutputDir;

        public RoomSchemaDirectoryArgumentProvider(boolean forKsp, @NotNull Provider<Directory> schemaInputDir, @NotNull Provider<Directory> schemaOutputDir) {
            Intrinsics.checkNotNullParameter(schemaInputDir, (String)"schemaInputDir");
            Intrinsics.checkNotNullParameter(schemaOutputDir, (String)"schemaOutputDir");
            this.forKsp = forKsp;
            this.schemaInputDir = schemaInputDir;
            this.schemaOutputDir = schemaOutputDir;
        }

        @Input
        public final boolean getForKsp() {
            return this.forKsp;
        }

        @InputFiles
        @PathSensitive(value=PathSensitivity.RELATIVE)
        @NotNull
        public final Provider<Directory> getSchemaInputDir() {
            return this.schemaInputDir;
        }

        @OutputDirectory
        @NotNull
        public final Provider<Directory> getSchemaOutputDir() {
            return this.schemaOutputDir;
        }

        @NotNull
        public List<String> asArguments() {
            List list;
            List $this$asArguments_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            String prefix = this.forKsp ? "" : "-A";
            $this$asArguments_u24lambda_u240.add(prefix + "room.internal.schemaInput=" + ((Directory)this.schemaInputDir.get()).getAsFile().getPath());
            $this$asArguments_u24lambda_u240.add(prefix + "room.internal.schemaOutput=" + ((Directory)this.schemaOutputDir.get()).getAsFile().getPath());
            return CollectionsKt.build((List)list);
        }
    }
}

