/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.verifier;

import java.sql.SQLException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Landroidx/room/verifier/DatabaseVerificationErrors;", "", "()V", "CANNOT_CREATE_SQLITE_CONNECTION", "", "CANNOT_VERIFY_QUERY", "cannotCreateConnection", "exception", "", "cannotVerifyQuery", "Ljava/sql/SQLException;", "room-compiler"})
public final class DatabaseVerificationErrors {
    @NotNull
    public static final DatabaseVerificationErrors INSTANCE = new DatabaseVerificationErrors();
    @NotNull
    private static final String CANNOT_VERIFY_QUERY = "There is a problem with the query: %s";
    @NotNull
    private static final String CANNOT_CREATE_SQLITE_CONNECTION = "Room cannot create an SQLite connection to verify the queries. Query verification will be disabled. Error: %s";

    private DatabaseVerificationErrors() {
    }

    @NotNull
    public final String cannotVerifyQuery(@NotNull SQLException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String string = CANNOT_VERIFY_QUERY;
        Object[] objectArray = new Object[]{exception.getMessage()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public final String cannotCreateConnection(@NotNull Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        String string = CANNOT_CREATE_SQLITE_CONNECTION;
        Object[] objectArray = new Object[]{exception.getMessage()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }
}

