/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.AutoMigration;
import androidx.room.ConstructedBy;
import androidx.room.Database;
import androidx.room.SkipQueryVerification;
import androidx.room.compiler.codegen.XClassName;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.RoomTypeNames;
import androidx.room.log.RLog;
import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.migration.bundle.SchemaBundle;
import androidx.room.parser.Table;
import androidx.room.processor.AutoMigrationProcessor;
import androidx.room.processor.Context;
import androidx.room.processor.DaoProcessor;
import androidx.room.processor.DatabaseProcessor;
import androidx.room.processor.DatabaseViewProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.SchemaFileResolver;
import androidx.room.verifier.DatabaseVerificationErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.DatabaseConstructor;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.DeleteOrUpdateShortcutMethod;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Index;
import androidx.room.vo.InsertOrUpsertShortcutMethod;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.Warning;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0011J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\"\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J$\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020!0\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0\u001aJ\u001e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020&0\u001aH\u0002J\u001e\u0010-\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020&0\u001aH\u0002J,\u0010.\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001a2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020&0\u001aH\u0002J\u001e\u00101\u001a\u00020*2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020&0\u001aH\u0002J,\u00102\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020&0\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020!0\u001aH\u0002J$\u00103\u001a\u00020*2\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020!0 2\u0006\u00105\u001a\u000206H\u0002R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\u000b\u00a8\u00067"}, d2={"Landroidx/room/processor/DatabaseProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;)V", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "roomDatabaseTypeElement", "getRoomDatabaseTypeElement", "roomDatabaseTypeElement$delegate", "Lkotlin/Lazy;", "doProcess", "Landroidx/room/vo/Database;", "getSchemaBundle", "Landroidx/room/migration/bundle/DatabaseBundle;", "version", "", "schemaFolderPath", "Ljava/nio/file/Path;", "process", "processAutoMigrations", "", "Landroidx/room/vo/AutoMigration;", "latestDbSchema", "processConstructorObject", "Landroidx/room/vo/DatabaseConstructor;", "processDatabaseViews", "", "Landroidx/room/vo/DatabaseView;", "dbAnnotation", "Landroidx/room/compiler/processing/XAnnotationBox;", "Landroidx/room/Database;", "processEntities", "Landroidx/room/vo/Entity;", "resolveDatabaseViews", "views", "validateExternalContentFts", "", "dbElement", "entities", "validateForeignKeys", "validateUniqueDaoClasses", "daoMethods", "Landroidx/room/vo/DaoMethod;", "validateUniqueIndices", "validateUniqueTableAndViewNames", "verifyDatabaseViews", "map", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nDatabaseProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseProcessor.kt\nandroidx/room/processor/DatabaseProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,621:1\n1747#2,3:622\n1747#2,3:625\n1194#2,2:642\n1222#2,4:644\n1855#2:648\n1855#2:649\n1603#2,9:650\n1855#2:659\n1856#2:661\n1612#2:662\n1549#2:663\n1620#2,3:664\n1856#2:667\n1856#2:668\n1360#2:669\n1446#2,2:670\n1549#2:672\n1620#2,3:673\n1448#2,3:676\n1477#2:679\n1502#2,3:680\n1505#2,3:690\n1655#2,8:701\n1549#2:709\n1620#2,3:710\n1549#2:714\n1620#2,3:715\n1477#2:718\n1502#2,3:719\n1505#2,3:729\n1549#2:733\n1620#2,3:734\n1855#2,2:737\n1855#2:740\n1855#2:741\n1856#2:744\n1855#2:745\n1856#2:748\n1856#2:749\n1549#2:750\n1620#2,3:751\n1549#2:754\n1620#2,3:755\n1477#2:758\n1502#2,3:759\n1505#2,3:769\n1549#2:780\n1620#2,3:781\n1855#2,2:784\n819#2:787\n847#2,2:788\n1855#2,2:790\n1603#2,9:792\n1855#2:801\n1856#2:803\n1612#2:804\n1603#2,9:805\n1855#2:814\n1856#2:816\n1612#2:817\n1549#2:818\n1620#2,3:819\n1549#2:822\n1620#2,3:823\n766#2:826\n857#2:827\n1726#2,3:828\n858#2:831\n1855#2,2:832\n1549#2:834\n1620#2,3:835\n1747#2,3:838\n2624#2,3:841\n11383#3,9:628\n13309#3:637\n13310#3:639\n11392#3:640\n1#4:638\n1#4:641\n1#4:660\n1#4:802\n1#4:815\n372#5,7:683\n526#5:693\n511#5,6:694\n372#5,7:722\n372#5,7:762\n526#5:772\n511#5,6:773\n215#6:700\n216#6:713\n215#6:732\n216#6:739\n215#6,2:742\n215#6,2:746\n215#6:779\n216#6:786\n*S KotlinDebug\n*F\n+ 1 DatabaseProcessor.kt\nandroidx/room/processor/DatabaseProcessor\n*L\n128#1:622,3\n131#1:625,3\n243#1:642,2\n243#1:644,4\n244#1:648\n245#1:649\n258#1:650,9\n258#1:659\n258#1:661\n258#1:662\n283#1:663\n283#1:664,3\n245#1:667\n244#1:668\n294#1:669\n294#1:670,2\n296#1:672\n296#1:673,3\n294#1:676,3\n298#1:679\n298#1:680,3\n298#1:690,3\n302#1:701,8\n307#1:709\n307#1:710,3\n321#1:714\n321#1:715,3\n323#1:718\n323#1:719,3\n323#1:729,3\n329#1:733\n329#1:734,3\n331#1:737,2\n356#1:740\n357#1:741\n357#1:744\n362#1:745\n362#1:748\n356#1:749\n376#1:750\n376#1:751,3\n384#1:754\n384#1:755,3\n392#1:758\n392#1:759,3\n392#1:769,3\n398#1:780\n398#1:781,3\n402#1:784,2\n411#1:787\n411#1:788,2\n415#1:790,2\n436#1:792,9\n436#1:801\n436#1:803\n436#1:804\n457#1:805,9\n457#1:814\n457#1:816\n457#1:817\n503#1:818\n503#1:819,3\n507#1:822\n507#1:823,3\n525#1:826\n525#1:827\n525#1:828,3\n525#1:831\n526#1:832,2\n537#1:834\n537#1:835,3\n614#1:838,3\n504#1:841,3\n180#1:628,9\n180#1:637\n180#1:639\n180#1:640\n180#1:638\n258#1:660\n436#1:802\n457#1:815\n298#1:683,7\n299#1:693\n299#1:694,6\n323#1:722,7\n392#1:762,7\n393#1:772\n393#1:773,6\n300#1:700\n300#1:713\n324#1:732\n324#1:739\n358#1:742,2\n363#1:746,2\n394#1:779\n394#1:786\n*E\n"})
public final class DatabaseProcessor {
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy roomDatabaseTypeElement$delegate;

    public DatabaseProcessor(@NotNull Context baseContext, @NotNull XTypeElement element) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, null, 6, null);
        this.roomDatabaseTypeElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XTypeElement>(this){
            final /* synthetic */ DatabaseProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final XTypeElement invoke() {
                return this.this$0.getContext().getProcessingEnv().requireTypeElement((XTypeName)RoomTypeNames.INSTANCE.getROOM_DB());
            }
        }));
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    private final XTypeElement getRoomDatabaseTypeElement() {
        Lazy lazy = this.roomDatabaseTypeElement$delegate;
        return (XTypeElement)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final androidx.room.vo.Database process() {
        try {
            androidx.room.vo.Database database = this.doProcess();
            return database;
        }
        finally {
            block3: {
                DatabaseVerifier databaseVerifier = this.context.getDatabaseVerifier();
                if (databaseVerifier == null) break block3;
                databaseVerifier.closeConnection(this.context);
            }
        }
    }

    private final androidx.room.vo.Database doProcess() {
        boolean bl;
        boolean hasForeignKeys;
        List daoMethods2;
        List<DatabaseView> views;
        List<Entity> entities;
        XAnnotationBox dbAnnotation;
        block8: {
            boolean bl2;
            block7: {
                DatabaseVerifier dbVerifier;
                XAnnotationBox xAnnotationBox = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(Database.class));
                Intrinsics.checkNotNull((Object)xAnnotationBox);
                dbAnnotation = xAnnotationBox;
                entities = this.processEntities((XAnnotationBox<Database>)dbAnnotation, this.element);
                Map<XTypeElement, DatabaseView> viewsMap = this.processDatabaseViews((XAnnotationBox<Database>)dbAnnotation);
                this.validateForeignKeys(this.element, entities);
                this.validateExternalContentFts(this.element, entities);
                boolean extendsRoomDb = this.getRoomDatabaseTypeElement().getType().isAssignableFrom(this.element.getType());
                this.context.getChecker().check(extendsRoomDb, (XElement)this.element, ProcessorErrors.INSTANCE.getDB_MUST_EXTEND_ROOM_DB(), new Object[0]);
                views = this.resolveDatabaseViews(CollectionsKt.toList((Iterable)viewsMap.values()));
                DatabaseVerifier databaseVerifier = dbVerifier = this.element.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class)) ? null : DatabaseVerifier.Companion.create(this.context, (XElement)this.element, entities, views);
                if (dbVerifier != null) {
                    this.context.attachDatabaseVerifier(dbVerifier);
                    this.verifyDatabaseViews(viewsMap, dbVerifier);
                }
                this.validateUniqueTableAndViewNames(this.element, entities, views);
                XType declaredType = this.element.getType();
                daoMethods2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)this.element.getAllMethods(), (Function1)doProcess.daoMethods.1.INSTANCE), (Function1)doProcess.daoMethods.2.INSTANCE), (Function1)((Function1)new Function1<XMethodElement, DaoMethod>(this, declaredType, dbVerifier){
                    final /* synthetic */ DatabaseProcessor this$0;
                    final /* synthetic */ XType $declaredType;
                    final /* synthetic */ DatabaseVerifier $dbVerifier;
                    {
                        this.this$0 = $receiver;
                        this.$declaredType = $declaredType;
                        this.$dbVerifier = $dbVerifier;
                        super(1);
                    }

                    public final DaoMethod invoke(XMethodElement executable) {
                        DaoMethod daoMethod;
                        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
                        XType daoType = executable.getReturnType();
                        XTypeElement daoElement = daoType.getTypeElement();
                        if (daoElement == null) {
                            this.this$0.getContext().getLogger().e((XElement)executable, ProcessorErrors.INSTANCE.getDATABASE_INVALID_DAO_METHOD_RETURN_TYPE(), new Object[0]);
                            daoMethod = null;
                        } else {
                            if (executable.hasAnnotation(Reflection.getOrCreateKotlinClass(JvmName.class))) {
                                this.this$0.getContext().getLogger().w(Warning.JVM_NAME_ON_OVERRIDDEN_METHOD, (XElement)executable, ProcessorErrors.INSTANCE.getJVM_NAME_ON_OVERRIDDEN_METHOD(), new Object[0]);
                            }
                            Dao dao = new DaoProcessor(this.this$0.getContext(), daoElement, this.$declaredType, this.$dbVerifier).process();
                            daoMethod = new DaoMethod(executable, dao);
                        }
                        return daoMethod;
                    }
                })));
                this.validateUniqueDaoClasses(this.element, daoMethods2, entities);
                this.validateUniqueIndices(this.element, entities);
                Iterable $this$any$iv = entities;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Entity it = (Entity)element$iv;
                        boolean bl3 = false;
                        boolean bl4 = !((Collection)it.getForeignKeys()).isEmpty();
                        if (!bl4) continue;
                        bl2 = true;
                        break block7;
                    }
                    bl2 = false;
                }
            }
            hasForeignKeys = bl2;
            Iterable $this$any$iv = this.getRoomDatabaseTypeElement().getDeclaredMethods();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    XMethodElement it = (XMethodElement)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"clearAllTables")) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean hasClearAllTables = bl;
        this.context.getChecker().check(((Database)dbAnnotation.getValue()).version() > 0, (XElement)this.element, ProcessorErrors.INSTANCE.getINVALID_DATABASE_VERSION(), new Object[0]);
        DatabaseConstructor constructorObject = this.processConstructorObject(this.element);
        int n = ((Database)dbAnnotation.getValue()).version();
        XTypeElement xTypeElement = this.element;
        XType xType = this.element.getType();
        boolean bl6 = ((Database)dbAnnotation.getValue()).exportSchema();
        androidx.room.vo.Database database = new androidx.room.vo.Database(xTypeElement, xType, entities, views, daoMethods2, n, bl6, hasForeignKeys, hasClearAllTables, constructorObject);
        database.setAutoMigrations(this.processAutoMigrations(this.element, database.getBundle()));
        return database;
    }

    /*
     * Unable to fully structure code
     */
    private final List<androidx.room.vo.AutoMigration> processAutoMigrations(XTypeElement element, DatabaseBundle latestDbSchema) {
        v0 = element.getAnnotation(Reflection.getOrCreateKotlinClass(Database.class));
        Intrinsics.checkNotNull((Object)v0);
        dbAnnotation = v0;
        autoMigrationList = dbAnnotation.getAsAnnotationBoxArray("autoMigrations");
        if (autoMigrationList.length == 0) {
            return CollectionsKt.emptyList();
        }
        if (!((Database)dbAnnotation.getValue()).exportSchema()) {
            this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.getAUTO_MIGRATION_FOUND_BUT_EXPORT_SCHEMA_OFF(), new Object[0]);
            return CollectionsKt.emptyList();
        }
        schemaInFolderPath = this.context.getSchemaInFolderPath();
        if (schemaInFolderPath == null) {
            this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.getAUTO_MIGRATION_SCHEMA_IN_FOLDER_NULL(), new Object[0]);
            return CollectionsKt.emptyList();
        }
        $this$mapNotNull$iv = autoMigrationList;
        $i$f$mapNotNull = false;
        var8_8 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var14_14 = ((void)$this$forEach$iv$iv$iv).length;
        for (var13_13 = 0; var13_13 < var14_14; ++var13_13) {
            block7: {
                block8: {
                    block6: {
                        element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[var13_13];
                        $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                        annotationBox = element$iv$iv;
                        $i$a$-mapNotNull-DatabaseProcessor$processAutoMigrations$1 = false;
                        var20_20 = new String[]{element.asClassName().getCanonicalName()};
                        databaseSchemaInFolderPath = Path.of(schemaInFolderPath, var20_20);
                        autoMigration = (AutoMigration)annotationBox.getValue();
                        v1 = autoMigration.from();
                        Intrinsics.checkNotNull((Object)databaseSchemaInFolderPath);
                        if (this.getSchemaBundle(v1, databaseSchemaInFolderPath) != null) break block6;
                        v2 = null;
                        break block7;
                    }
                    if (autoMigration.to() != latestDbSchema.getVersion()) break block8;
                    v3 = latestDbSchema;
                    ** GOTO lbl-1000
                }
                v3 = this.getSchemaBundle(autoMigration.to(), databaseSchemaInFolderPath);
                if (v3 == null) {
                    v2 = null;
                } else lbl-1000:
                // 2 sources

                {
                    toSchemaBundle = v3;
                    v2 = new AutoMigrationProcessor(this.context, annotationBox.getAsType("spec"), fromSchemaBundle, toSchemaBundle).process();
                }
            }
            if (v2 == null) continue;
            it$iv$iv = v2;
            $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DatabaseBundle getSchemaBundle(int version, Path schemaFolderPath) {
        Closeable bundle2;
        Closeable closeable;
        InputStream inputStream;
        try {
            SchemaFileResolver schemaFileResolver = SchemaFileResolver.Companion.getRESOLVER();
            Path path = schemaFolderPath.resolve(version + ".json");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            inputStream = schemaFileResolver.readPath(path);
        }
        catch (IOException e) {
            inputStream = null;
        }
        InputStream schemaStream = inputStream;
        if (schemaStream == null) {
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.autoMigrationSchemasNotFound(version, ((Object)schemaFolderPath).toString()), new Object[0]);
            return null;
        }
        try {
            SchemaBundle schemaBundle;
            closeable = schemaStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                schemaBundle = SchemaBundle.Companion.deserialize(schemaStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            closeable = schemaBundle;
        }
        catch (FileNotFoundException ex) {
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.autoMigrationSchemasNotFound(version, ((Object)schemaFolderPath).toString()), new Object[0]);
            closeable = null;
        }
        catch (Throwable th) {
            RLog rLog = this.context.getLogger();
            String string = th.getMessage();
            if (string == null) {
                string = "";
            }
            rLog.e("Unable to read schema file: " + string, new Object[0]);
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.invalidAutoMigrationSchema(version, ((Object)schemaFolderPath).toString()), new Object[0]);
            closeable = null;
        }
        Closeable closeable2 = bundle2 = closeable;
        return closeable2 != null ? closeable2.getDatabase() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateForeignKeys(XTypeElement element, List<? extends Entity> entities) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = entities;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Entity entity = (Entity)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getTableName(), element$iv$iv);
        }
        Map byTableName = destination$iv$iv;
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = entity.getForeignKeys();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                ForeignKey foreignKey = (ForeignKey)element$iv2;
                boolean bl2 = false;
                Entity parent = (Entity)byTableName.get(foreignKey.getParentTable());
                if (parent == null) {
                    this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.foreignKeyMissingParentEntityInDatabase(foreignKey.getParentTable(), entity.getElement().getQualifiedName()), new Object[0]);
                    continue;
                }
                Iterable $this$mapNotNull$iv = foreignKey.getParentColumns();
                boolean $i$f$mapNotNull = false;
                Object object = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach3 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Field it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    String columnName = (String)element$iv$iv;
                    boolean bl4 = false;
                    Field parentField = HasFieldsKt.findFieldByColumnName(parent, columnName);
                    if (parentField == null) {
                        this.context.getLogger().e((XElement)entity.getElement(), ProcessorErrors.INSTANCE.foreignKeyParentColumnDoesNotExist(parent.getElement().getQualifiedName(), columnName, HasFieldsKt.getColumnNames(parent)), new Object[0]);
                    }
                    if (parentField == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List parentFields = (List)destination$iv$iv2;
                if (parentFields.size() != foreignKey.getParentColumns().size() || parent.isUnique(foreignKey.getParentColumns())) continue;
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                String string = parent.getElement().getQualifiedName();
                object = entity.getElement().getQualifiedName();
                List<String> list = foreignKey.getParentColumns();
                $this$forEach$iv$iv$iv = foreignKey.getChildFields();
                XElement xElement = (XElement)parent.getElement();
                RLog rLog = this.context.getLogger();
                boolean $i$f$map = false;
                iterator = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Field bl4 = (Field)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl6 = false;
                    collection.add(it.getColumnName());
                }
                collection = (List)destination$iv$iv3;
                List list2 = collection;
                rLog.e(xElement, processorErrors.foreignKeyMissingIndexInParent(string, list, (String)object, list2), new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueIndices(XTypeElement element, List<? extends Entity> entities) {
        void $this$filterTo$iv$iv;
        Object it;
        Object $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Object object;
        Index index;
        Object element$iv$iv2;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = entities;
        boolean $i$f$flatMap = false;
        Object object2 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Entity entity = (Entity)element$iv$iv2;
            boolean bl = false;
            Iterable $this$map$iv = entity.getIndices();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                index = (Index)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(new Pair((Object)it2.getName(), (Object)entity));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object3;
            element$iv$iv2 = iterator.next();
            it = (Pair)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = (String)it.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv2);
        }
        Object $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv2 = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Collection<CallSite> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry element$iv;
            Map.Entry it3 = element$iv = (Map.Entry)object2.next();
            boolean bl = false;
            Iterable $this$distinctBy$iv = (Iterable)it3.getValue();
            boolean $i$f$distinctBy = false;
            HashSet<XTypeName> set$iv = new HashSet<XTypeName>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Pair it4 = (Pair)e$iv;
                boolean bl4 = false;
                XTypeName key$iv = ((Entity)it4.getSecond()).getTypeName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            if (((List)list$iv).size() <= 1) continue;
            $this$distinctBy$iv = (Iterable)it3.getValue();
            String string = (String)it3.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            index = (XElement)element;
            object = this.context.getLogger();
            boolean $i$f$map = false;
            set$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                Pair bl4 = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl5 = false;
                collection.add((CallSite)((Object)(((Entity)it5.getSecond()).getTypeName().toString(this.context.getCodeLanguage()) + " > " + it5.getFirst())));
            }
            collection = (List)destination$iv$iv3;
            ((RLog)object).e((XElement)index, processorErrors.duplicateIndexInDatabase(string, (List<String>)collection), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueDaoClasses(XTypeElement dbElement, List<DaoMethod> daoMethods2, List<? extends Entity> entities) {
        Iterator<Map.Entry<String, ShortcutEntity>> iterator;
        void $this$forEach$iv;
        Object list$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object element$iv$iv;
        Iterator $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        DaoMethod it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Pojo)((Object)it)).getTypeName());
        }
        Set entityTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        $this$map$iv = daoMethods2;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            element$iv$iv = iterator2.next();
            it = (DaoMethod)element$iv$iv;
            boolean bl3 = false;
            XClassName key$iv$iv = it.getDao().getTypeName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Collection<String> collection;
            Iterator $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            if (((List)it2.getValue()).size() <= 1) continue;
            element$iv$iv = (Iterable)it2.getValue();
            list$iv$iv = ((XClassName)it2.getKey()).toString(this.context.getCodeLanguage());
            ProcessorErrors bl3 = ProcessorErrors.INSTANCE;
            boolean $i$f$map2 = false;
            $this$getOrPut$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator answer$iv$iv$iv = $this$mapTo$iv$iv2.iterator();
            while (answer$iv$iv$iv.hasNext()) {
                void it3;
                Object item$iv$iv = answer$iv$iv$iv.next();
                iterator = (DaoMethod)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it3.getElement().getName());
            }
            collection = (List)destination$iv$iv2;
            String error = bl3.duplicateDao((String)list$iv$iv, (List<String>)collection);
            Iterable $this$forEach$iv2 = (Iterable)it2.getValue();
            boolean $i$f$forEach2 = false;
            $this$mapTo$iv$iv2 = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv2.hasNext()) {
                Object element$iv2 = $this$mapTo$iv$iv2.next();
                DaoMethod daoMethod = (DaoMethod)element$iv2;
                boolean bl5 = false;
                this.context.getLogger().e((XElement)daoMethod.getElement(), ProcessorErrors.INSTANCE.getDAO_METHOD_CONFLICTS_WITH_OTHERS(), new Object[0]);
            }
            this.context.getLogger().e((XElement)dbElement, error, new Object[0]);
        }
        Function3 check2 = (Function3)new Function3<XElement, Dao, XTypeName, Unit>((Set<? extends XTypeName>)entityTypeNames, this, dbElement){
            final /* synthetic */ Set<XTypeName> $entityTypeNames;
            final /* synthetic */ DatabaseProcessor this$0;
            final /* synthetic */ XTypeElement $dbElement;
            {
                this.$entityTypeNames = $entityTypeNames;
                this.this$0 = $receiver;
                this.$dbElement = $dbElement;
                super(3);
            }

            public final void invoke(XElement element, Dao dao, XTypeName typeName2) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
                    XTypeName xTypeName = typeName2;
                    if (xTypeName == null) break block1;
                    XTypeName xTypeName2 = xTypeName;
                    Set<XTypeName> set = this.$entityTypeNames;
                    DatabaseProcessor databaseProcessor = this.this$0;
                    XTypeElement xTypeElement = this.$dbElement;
                    XTypeName it = xTypeName2;
                    boolean bl = false;
                    if (!set.contains(typeName2)) {
                        databaseProcessor.getContext().getLogger().e(element, ProcessorErrors.INSTANCE.shortcutEntityIsNotInDatabase(xTypeElement.getQualifiedName(), dao.getTypeName().toString(databaseProcessor.getContext().getCodeLanguage()), typeName2.toString(databaseProcessor.getContext().getCodeLanguage())), new Object[0]);
                    }
                }
            }
        };
        Iterable $this$forEach$iv3 = daoMethods2;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Map.Entry<String, ShortcutEntity> it4;
            Map.Entry<String, ShortcutEntity> element$iv3;
            boolean $i$f$forEach4;
            Map<String, ShortcutEntity> $this$forEach$iv4;
            Object method;
            DaoMethod daoMethod = (DaoMethod)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv5 = daoMethod.getDao().getDeleteOrUpdateShortcutMethods();
            boolean $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv5) {
                method = (DeleteOrUpdateShortcutMethod)element$iv4;
                boolean bl6 = false;
                $this$forEach$iv4 = ((DeleteOrUpdateShortcutMethod)method).getEntities();
                $i$f$forEach4 = false;
                iterator = $this$forEach$iv4.entrySet().iterator();
                while (iterator.hasNext()) {
                    it4 = element$iv3 = (Map.Entry<String, ShortcutEntity>)iterator.next();
                    boolean bl7 = false;
                    check2.invoke((Object)((DeleteOrUpdateShortcutMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)((ShortcutEntity)it4.getValue()).getEntityTypeName());
                }
            }
            $this$forEach$iv5 = daoMethod.getDao().getInsertOrUpsertShortcutMethods();
            $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv5) {
                method = (InsertOrUpsertShortcutMethod)element$iv4;
                boolean bl8 = false;
                $this$forEach$iv4 = ((InsertOrUpsertShortcutMethod)method).getEntities();
                $i$f$forEach4 = false;
                iterator = $this$forEach$iv4.entrySet().iterator();
                while (iterator.hasNext()) {
                    it4 = element$iv3 = iterator.next();
                    boolean bl9 = false;
                    check2.invoke((Object)((InsertOrUpsertShortcutMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)it4.getValue().getEntityTypeName());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueTableAndViewNames(XTypeElement dbElement, List<? extends Entity> entities, List<DatabaseView> views) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv;
        String key$iv$iv;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$mapTo$iv$iv;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            Entity entity = (Entity)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getTableName();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(new Triple((Object)string2, (Object)it.getTypeName().toString(this.context.getCodeLanguage()), (Object)it.getElement()));
        }
        List entitiesInfo = (List)destination$iv$iv;
        Iterable $this$map$iv2 = views;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            DatabaseView bl = (DatabaseView)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = it.getViewName();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            collection.add(new Triple((Object)string3, (Object)it.getTypeName().toString(this.context.getCodeLanguage()), (Object)it.getElement()));
        }
        List viewsInfo = (List)destination$iv$iv2;
        $this$map$iv2 = CollectionsKt.plus((Collection)entitiesInfo, (Iterable)viewsInfo);
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object;
            String name;
            Triple it = (Triple)element$iv$iv2;
            boolean bl = false;
            key$iv$iv = name = (String)it.component1();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv2);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        item$iv$iv2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (item$iv$iv2.hasNext()) {
            Object it = element$iv$iv2 = (Map.Entry)item$iv$iv2.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        $this$filter$iv = destination$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Map.Entry element$iv;
            Map.Entry byName = element$iv = iterator.next();
            boolean bl = false;
            element$iv$iv2 = (Iterable)byName.getValue();
            String string = (String)byName.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            boolean $i$f$map3 = false;
            key$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                Triple triple = (Triple)item$iv$iv4;
                collection2 = destination$iv$iv3;
                boolean bl4 = false;
                String typeName2 = (String)triple.component2();
                collection2.add(typeName2);
            }
            collection2 = (List)destination$iv$iv3;
            String error = processorErrors.duplicateTableNames(string, (List<String>)collection2);
            Iterable $this$forEach$iv2 = (Iterable)byName.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Triple triple = (Triple)element$iv2;
                boolean bl5 = false;
                XTypeElement element = (XTypeElement)triple.component3();
                this.context.getLogger().e((XElement)element, error, new Object[0]);
            }
            this.context.getLogger().e((XElement)dbElement, error, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateExternalContentFts(XTypeElement dbElement, List<? extends Entity> entities) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = CollectionsKt.filterIsInstance((Iterable)entities, FtsEntity.class);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FtsEntity it = (FtsEntity)element$iv$iv;
            boolean bl = false;
            if (it.getFtsOptions().getContentEntity() == null || entities.contains(it.getFtsOptions().getContentEntity())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FtsEntity it = (FtsEntity)element$iv;
            boolean bl = false;
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)dbElement;
            String string = it.getElement().getQualifiedName();
            Entity entity = it.getFtsOptions().getContentEntity();
            Intrinsics.checkNotNull((Object)entity);
            rLog.e(xElement, ProcessorErrors.INSTANCE.missingExternalContentEntity(string, entity.getElement().getQualifiedName()), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> processEntities(XAnnotationBox<Database> dbAnnotation, XTypeElement element) {
        void $this$mapNotNullTo$iv$iv;
        List entityList = dbAnnotation.getAsTypeList("entities");
        this.context.getChecker().check(!((Collection)entityList).isEmpty(), (XElement)element, ProcessorErrors.INSTANCE.getDATABASE_ANNOTATION_MUST_HAVE_LIST_OF_ENTITIES(), new Object[0]);
        Iterable $this$mapNotNull$iv = entityList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Entity entity;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            XType it = (XType)element$iv$iv;
            boolean bl2 = false;
            XTypeElement typeElement = it.getTypeElement();
            if (typeElement == null) {
                this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.invalidEntityTypeInDatabaseAnnotation(it.asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                entity = null;
            } else {
                entity = EntityProcessorKt.EntityProcessor$default(this.context, typeElement, null, 4, null).process();
            }
            if (entity == null) continue;
            Entity it$iv$iv = entity;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<XTypeElement, DatabaseView> processDatabaseViews(XAnnotationBox<Database> dbAnnotation) {
        void $this$mapNotNullTo$iv$iv;
        List viewList = dbAnnotation.getAsTypeList("views");
        Iterable $this$mapNotNull$iv = viewList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            XType it = (XType)element$iv$iv;
            boolean bl2 = false;
            XTypeElement viewElement = it.getTypeElement();
            if (viewElement == null) {
                this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.invalidViewTypeInDatabaseAnnotation(it.asTypeName().toString(this.context.getCodeLanguage())), new Object[0]);
                pair = null;
            } else {
                pair = TuplesKt.to((Object)viewElement, (Object)new DatabaseViewProcessor(this.context, viewElement, null, 4, null).process());
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final void verifyDatabaseViews(Map<XTypeElement, DatabaseView> map, DatabaseVerifier dbVerifier) {
        for (Map.Entry<XTypeElement, DatabaseView> entry : map.entrySet()) {
            XTypeElement viewElement = entry.getKey();
            DatabaseView view = entry.getValue();
            if (viewElement.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class))) continue;
            view.getQuery().setResultInfo(dbVerifier.analyze(view.getQuery().getOriginal()));
            QueryResultInfo queryResultInfo = view.getQuery().getResultInfo();
            if ((queryResultInfo != null ? queryResultInfo.getError() : null) == null) continue;
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)viewElement;
            QueryResultInfo queryResultInfo2 = view.getQuery().getResultInfo();
            Intrinsics.checkNotNull((Object)queryResultInfo2);
            SQLException sQLException = queryResultInfo2.getError();
            Intrinsics.checkNotNull((Object)sQLException);
            rLog.e(xElement, DatabaseVerificationErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DatabaseView> resolveDatabaseViews(@NotNull List<DatabaseView> views) {
        Collection collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(views, (String)"views");
        if (views.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = views;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Set<String> destination$iv$iv = (Set<String>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator<Object> it;
            DatabaseView databaseView = (DatabaseView)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((DatabaseView)((Object)it)).getViewName());
        }
        List viewNames = (List)((Object)destination$iv$iv);
        for (DatabaseView view : views) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            $this$mapTo$iv$iv = view.getQuery().getTables();
            object = view.getTables();
            boolean $i$f$map2 = false;
            void $i$f$mapTo2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Table table = (Table)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                String name = table.component1();
                collection.add(name);
            }
            object.addAll((List)destination$iv$iv2);
        }
        List unresolvedViews = CollectionsKt.toMutableList((Collection)views);
        Map resolvedViews = new LinkedHashMap();
        List result = new ArrayList();
        do {
            Collection<String> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Iterable $this$forEach$iv;
            DatabaseView view;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Set tables;
            for (Map.Entry $this$mapTo$iv$iv2 : resolvedViews.entrySet()) {
                String viewName = (String)$this$mapTo$iv$iv2.getKey();
                tables = (Set)$this$mapTo$iv$iv2.getValue();
                for (DatabaseView view2 : unresolvedViews) {
                    if (!view2.getTables().removeIf(arg_0 -> DatabaseProcessor.resolveDatabaseViews$lambda$40((Function1)new Function1<String, Boolean>(viewName){
                        final /* synthetic */ String $viewName;
                        {
                            this.$viewName = $viewName;
                            super(1);
                        }

                        public final Boolean invoke(String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return StringsKt.equals((String)it, (String)this.$viewName, (boolean)true);
                        }
                    }, arg_0))) continue;
                    view2.getTables().addAll(tables);
                }
            }
            int countNewlyResolved = 0;
            Iterable $this$mapTo$iv$iv2 = unresolvedViews;
            boolean $i$f$filter = false;
            tables = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                Object element$iv$iv;
                block13: {
                    element$iv$iv = iterator.next();
                    view = (DatabaseView)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$all$iv = view.getTables();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (DatabaseProcessor.resolveDatabaseViews$isTable(viewNames, it)) continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                DatabaseView view3 = (DatabaseView)element$iv;
                boolean bl = false;
                resolvedViews.put(view3.getViewName(), view3.getTables());
                unresolvedViews.remove(view3);
                result.add(view3);
                ++countNewlyResolved;
            }
            if (countNewlyResolved != 0) continue;
            $this$forEach$iv = unresolvedViews;
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            collection = (XElement)this.element;
            object = this.context.getLogger();
            boolean $i$f$map3 = false;
            $this$filterTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                view = (DatabaseView)item$iv$iv;
                collection2 = destination$iv$iv3;
                boolean bl = false;
                collection2.add(it.getViewName());
            }
            collection2 = (List)destination$iv$iv3;
            ((RLog)object).e((XElement)collection, processorErrors.viewCircularReferenceDetected((List<String>)collection2), new Object[0]);
            break;
        } while (!((Collection)unresolvedViews).isEmpty());
        return result;
    }

    private final DatabaseConstructor processConstructorObject(XTypeElement element) {
        boolean bl;
        XTypeElement typeElement;
        block8: {
            XAnnotationBox annotation = element.getAnnotation(Reflection.getOrCreateKotlinClass(ConstructedBy.class));
            if (annotation == null) {
                this.context.getChecker().check(this.context.isJvmOnlyTarget(), (XElement)element, ProcessorErrors.INSTANCE.getMISSING_CONSTRUCTED_BY_ANNOTATION(), new Object[0]);
                return null;
            }
            XType xType = annotation.getAsType("value");
            if (xType == null) {
                return null;
            }
            XType type = xType;
            typeElement = type.getTypeElement();
            if (typeElement == null) {
                this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.getINVALID_CONSTRUCTED_BY_CLASS(), new Object[0]);
                return null;
            }
            this.context.getChecker().check(typeElement.isKotlinObject(), (XElement)typeElement, ProcessorErrors.INSTANCE.getINVALID_CONSTRUCTED_BY_NOT_OBJECT(), new Object[0]);
            this.context.getChecker().check(typeElement.isExpect(), (XElement)typeElement, ProcessorErrors.INSTANCE.getINVALID_CONSTRUCTED_BY_NOT_EXPECT(), new Object[0]);
            XTypeName[] xTypeNameArray = new XTypeName[]{element.asClassName()};
            XTypeName expectedSuperInterfaceTypeName = RoomTypeNames.INSTANCE.getROOM_DB_CONSTRUCTOR().parametrizedBy(xTypeNameArray);
            XType superInterface = (XType)CollectionsKt.singleOrNull((List)typeElement.getSuperInterfaces());
            if (superInterface == null || !Intrinsics.areEqual((Object)superInterface.asTypeName().getRawTypeName(), (Object)RoomTypeNames.INSTANCE.getROOM_DB_CONSTRUCTOR())) {
                this.context.getLogger().e((XElement)typeElement, ProcessorErrors.INSTANCE.invalidConstructedBySuperInterface(expectedSuperInterfaceTypeName.toString(this.context.getCodeLanguage())), new Object[0]);
                return null;
            }
            XType typeArg = (XType)CollectionsKt.singleOrNull((List)superInterface.getTypeArguments());
            if (typeArg == null || !Intrinsics.areEqual((Object)typeArg.asTypeName().getRawTypeName(), (Object)element.asClassName())) {
                this.context.getLogger().e((XElement)typeElement, ProcessorErrors.INSTANCE.invalidConstructedBySuperInterface(expectedSuperInterfaceTypeName.toString(this.context.getCodeLanguage())), new Object[0]);
                return null;
            }
            XMethodElement initializeExecutableElement = (XMethodElement)CollectionsKt.single((List)this.context.getProcessingEnv().requireTypeElement((XTypeName)RoomTypeNames.INSTANCE.getROOM_DB_CONSTRUCTOR()).getDeclaredMethods());
            Iterable $this$any$iv = typeElement.getDeclaredMethods();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    XMethodElement it = (XMethodElement)element$iv;
                    boolean bl2 = false;
                    if (!it.overrides(initializeExecutableElement, typeElement)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        boolean isInitOverridden = bl;
        return new DatabaseConstructor(typeElement, isInitOverridden);
    }

    private static final boolean resolveDatabaseViews$isTable(List<String> viewNames, String name) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = viewNames;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)it, (String)name, (boolean)true)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean resolveDatabaseViews$lambda$40(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

