/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.room.compiler.codegen.CodeLanguage;
import androidx.room.compiler.codegen.VisibilityModifier;
import androidx.room.compiler.codegen.XClassName;
import androidx.room.compiler.codegen.XCodeBlock;
import androidx.room.compiler.codegen.XFunSpec;
import androidx.room.compiler.codegen.XTypeName;
import androidx.room.compiler.codegen.XTypeSpec;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.RoomMemberNames;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SQLiteDriverMemberNames;
import androidx.room.ext.SQLiteDriverTypeNames;
import androidx.room.migration.bundle.BaseEntityBundle;
import androidx.room.migration.bundle.DatabaseViewBundle;
import androidx.room.migration.bundle.EntityBundle;
import androidx.room.migration.bundle.FtsEntityBundle;
import androidx.room.migration.bundle.IndexBundle;
import androidx.room.vo.AutoMigration;
import androidx.room.writer.AutoMigrationWriter;
import androidx.room.writer.TypeWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JN\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110*2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020,H\u0002J\u0018\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010/\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00112\u0006\u00100\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J4\u00101\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00102\u001a\u00020'2\u0006\u0010.\u001a\u00020'2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110*H\u0002J\u0018\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u0002052\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u000207H\u0002J\b\u00109\u001a\u00020:H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Landroidx/room/writer/AutoMigrationWriter;", "Landroidx/room/writer/TypeWriter;", "autoMigration", "Landroidx/room/vo/AutoMigration;", "dbElement", "Landroidx/room/compiler/processing/XTypeElement;", "writerContext", "Landroidx/room/writer/TypeWriter$WriterContext;", "(Landroidx/room/vo/AutoMigration;Landroidx/room/compiler/processing/XTypeElement;Landroidx/room/writer/TypeWriter$WriterContext;)V", "addedColumns", "", "Landroidx/room/vo/AutoMigration$AddedColumn;", "addedTables", "", "Landroidx/room/vo/AutoMigration$AddedTable;", "complexChangedTables", "", "", "Landroidx/room/vo/AutoMigration$ComplexChangedTable;", "deletedTables", "renamedTables", "addComplexChangeStatements", "", "migrateBuilder", "Landroidx/room/compiler/codegen/XFunSpec$Builder;", "addDatabaseExecuteSqlStatement", "sql", "addDeleteTableStatements", "addDropViewStatements", "addMigrationStatements", "addNewColumnStatements", "addNewTableStatements", "addRecreateViewStatements", "addRenameTableStatements", "addSimpleChangeStatements", "addStatementsToContentTransfer", "oldTableName", "tableNameWithNewPrefix", "oldEntityBundle", "Landroidx/room/migration/bundle/BaseEntityBundle;", "newEntityBundle", "renamedColumnsMap", "", "isFtsTableContentTransfer", "", "addStatementsToCreateNewTable", "newTable", "addStatementsToDropTableAndRenameTempTable", "newTableName", "addStatementsToMigrateFtsTable", "oldTable", "addStatementsToRecreateIndexes", "table", "Landroidx/room/migration/bundle/EntityBundle;", "createConstructor", "Landroidx/room/compiler/codegen/XFunSpec;", "createMigrateMethod", "createTypeSpecBuilder", "Landroidx/room/compiler/codegen/XTypeSpec$Builder;", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nAutoMigrationWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoMigrationWriter.kt\nandroidx/room/writer/AutoMigrationWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,457:1\n1855#2,2:458\n1855#2,2:460\n1045#2:462\n1855#2,2:463\n1855#2,2:465\n766#2:467\n857#2,2:468\n1855#2,2:470\n1855#2,2:472\n1855#2:474\n1856#2:476\n1855#2,2:479\n1855#2,2:481\n1#3:475\n215#4,2:477\n*S KotlinDebug\n*F\n+ 1 AutoMigrationWriter.kt\nandroidx/room/writer/AutoMigrationWriter\n*L\n145#1:458,2\n156#1:460,2\n172#1:462\n173#1:463,2\n210#1:465,2\n301#1:467\n301#1:468,2\n315#1:470,2\n365#1:472,2\n376#1:474\n376#1:476\n402#1:479,2\n430#1:481,2\n388#1:477,2\n*E\n"})
public final class AutoMigrationWriter
extends TypeWriter {
    @NotNull
    private final AutoMigration autoMigration;
    @NotNull
    private final XTypeElement dbElement;
    @NotNull
    private final List<AutoMigration.AddedColumn> addedColumns;
    @NotNull
    private final Set<AutoMigration.AddedTable> addedTables;
    @NotNull
    private final Map<String, String> renamedTables;
    @NotNull
    private final Map<String, AutoMigration.ComplexChangedTable> complexChangedTables;
    @NotNull
    private final List<String> deletedTables;

    public AutoMigrationWriter(@NotNull AutoMigration autoMigration, @NotNull XTypeElement dbElement, @NotNull TypeWriter.WriterContext writerContext) {
        Intrinsics.checkNotNullParameter((Object)autoMigration, (String)"autoMigration");
        Intrinsics.checkNotNullParameter((Object)dbElement, (String)"dbElement");
        Intrinsics.checkNotNullParameter((Object)writerContext, (String)"writerContext");
        super(writerContext);
        this.autoMigration = autoMigration;
        this.dbElement = dbElement;
        this.addedColumns = this.autoMigration.getSchemaDiff().getAddedColumns();
        this.addedTables = this.autoMigration.getSchemaDiff().getAddedTables();
        this.renamedTables = this.autoMigration.getSchemaDiff().getRenamedTables();
        this.complexChangedTables = this.autoMigration.getSchemaDiff().getComplexChangedTables();
        this.deletedTables = this.autoMigration.getSchemaDiff().getDeletedTables();
    }

    @Override
    @NotNull
    public XTypeSpec.Builder createTypeSpecBuilder() {
        XTypeSpec.Builder builder2;
        XTypeSpec.Builder builder3;
        XTypeSpec.Builder $this$createTypeSpecBuilder_u24lambda_u240 = builder3 = (builder2 = XTypeSpec.Companion.classBuilder$default((XTypeSpec.Companion)XTypeSpec.Companion, (CodeLanguage)this.getCodeLanguage(), (XClassName)this.autoMigration.getImplTypeName(this.dbElement.asClassName()), (boolean)false, (int)4, null));
        boolean bl = false;
        XTypeSpec.Builder.Companion.addOriginatingElement($this$createTypeSpecBuilder_u24lambda_u240, (XElement)this.dbElement);
        $this$createTypeSpecBuilder_u24lambda_u240.superclass((XTypeName)RoomTypeNames.INSTANCE.getMIGRATION());
        if ($this$createTypeSpecBuilder_u24lambda_u240.getLanguage() == CodeLanguage.KOTLIN) {
            $this$createTypeSpecBuilder_u24lambda_u240.setVisibility(VisibilityModifier.INTERNAL);
        }
        if (this.autoMigration.getSpecClassName() != null) {
            XTypeSpec.Builder.Companion.addProperty$default((XTypeSpec.Builder.Companion)XTypeSpec.Builder.Companion, (XTypeSpec.Builder)builder2, (String)"callback", (XTypeName)((XTypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()), (VisibilityModifier)VisibilityModifier.PRIVATE, (boolean)false, !this.autoMigration.isSpecProvided() ? XCodeBlock.Companion.ofNewInstance$default((XCodeBlock.Companion)XCodeBlock.Companion, (CodeLanguage)this.getCodeLanguage(), (XTypeName)((XTypeName)this.autoMigration.getSpecClassName()), null, (Object[])new Object[0], (int)4, null) : null, (int)8, null);
        }
        $this$createTypeSpecBuilder_u24lambda_u240.addFunction(this.createConstructor());
        $this$createTypeSpecBuilder_u24lambda_u240.addFunction(this.createMigrateMethod());
        return builder2;
    }

    private final XFunSpec createConstructor() {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createConstructor_u24lambda_u241 = builder2 = XFunSpec.Companion.constructorBuilder(this.getCodeLanguage(), VisibilityModifier.PUBLIC);
        boolean bl = false;
        XCodeBlock[] xCodeBlockArray = new XCodeBlock[2];
        Object[] objectArray = new Object[]{this.autoMigration.getFrom()};
        xCodeBlockArray[0] = XCodeBlock.Companion.of(this.getCodeLanguage(), "%L", objectArray);
        objectArray = new Object[]{this.autoMigration.getTo()};
        xCodeBlockArray[1] = XCodeBlock.Companion.of(this.getCodeLanguage(), "%L", objectArray);
        $this$createConstructor_u24lambda_u241.callSuperConstructor(xCodeBlockArray);
        if (this.autoMigration.isSpecProvided()) {
            XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createConstructor_u24lambda_u241, (XTypeName)((XTypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_SPEC()), (String)"callback", null, (int)4, null);
            XFunSpec.Builder.Companion.addStatement($this$createConstructor_u24lambda_u241, "this.callback = callback", new Object[0]);
        }
        return builder2.build();
    }

    private final XFunSpec createMigrateMethod() {
        XFunSpec.Builder builder2;
        XFunSpec.Builder $this$createMigrateMethod_u24lambda_u242 = builder2 = XFunSpec.Companion.builder$default((XFunSpec.Companion)XFunSpec.Companion, (CodeLanguage)this.getCodeLanguage(), (String)"migrate", (VisibilityModifier)VisibilityModifier.PUBLIC, (boolean)false, (boolean)true, (int)8, null);
        boolean bl = false;
        XFunSpec.Builder.addParameter$default((XFunSpec.Builder)$this$createMigrateMethod_u24lambda_u242, (XTypeName)((XTypeName)SQLiteDriverTypeNames.INSTANCE.getCONNECTION()), (String)"connection", null, (int)4, null);
        this.addMigrationStatements($this$createMigrateMethod_u24lambda_u242);
        if (this.autoMigration.getSpecClassName() != null) {
            XFunSpec.Builder.Companion.addStatement($this$createMigrateMethod_u24lambda_u242, "callback.onPostMigrate(connection)", new Object[0]);
        }
        XFunSpec.Builder migrateFunctionBuilder = builder2;
        return migrateFunctionBuilder.build();
    }

    private final void addMigrationStatements(XFunSpec.Builder migrateBuilder) {
        this.addDropViewStatements(migrateBuilder);
        this.addSimpleChangeStatements(migrateBuilder);
        this.addComplexChangeStatements(migrateBuilder);
        this.addRecreateViewStatements(migrateBuilder);
    }

    private final void addDropViewStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.autoMigration.getSchemaDiff().getFromViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP VIEW " + view.getViewName());
        }
    }

    private final void addRecreateViewStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.autoMigration.getSchemaDiff().getToViews();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DatabaseViewBundle view = (DatabaseViewBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, view.createView());
        }
    }

    private final void addComplexChangeStatements(XFunSpec.Builder migrateBuilder) {
        List tablesToCheckForeignKeys = new ArrayList();
        Iterable $this$sortedBy$iv = this.complexChangedTables.values();
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                AutoMigration.ComplexChangedTable it = (AutoMigration.ComplexChangedTable)a;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.getNewVersionEntityBundle() instanceof FtsEntityBundle);
                it = (AutoMigration.ComplexChangedTable)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getNewVersionEntityBundle() instanceof FtsEntityBundle));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoMigration.ComplexChangedTable complexChangedTable = (AutoMigration.ComplexChangedTable)element$iv;
            boolean bl = false;
            String tableNameWithNewPrefix = complexChangedTable.component2();
            BaseEntityBundle oldEntityBundle = complexChangedTable.component3();
            BaseEntityBundle newEntityBundle = complexChangedTable.component4();
            Map<String, String> renamedColumnsMap = complexChangedTable.component5();
            if (oldEntityBundle instanceof FtsEntityBundle && !StringsKt.isBlank((CharSequence)((FtsEntityBundle)oldEntityBundle).getFtsOptions().getContentTable())) {
                this.addStatementsToMigrateFtsTable(migrateBuilder, oldEntityBundle, newEntityBundle, renamedColumnsMap);
                continue;
            }
            this.addStatementsToCreateNewTable(newEntityBundle, migrateBuilder);
            AutoMigrationWriter.addStatementsToContentTransfer$default(this, oldEntityBundle.getTableName(), tableNameWithNewPrefix, oldEntityBundle, newEntityBundle, renamedColumnsMap, migrateBuilder, false, 64, null);
            this.addStatementsToDropTableAndRenameTempTable(oldEntityBundle.getTableName(), newEntityBundle.getTableName(), tableNameWithNewPrefix, migrateBuilder);
            if (!(newEntityBundle instanceof EntityBundle)) continue;
            this.addStatementsToRecreateIndexes((EntityBundle)newEntityBundle, migrateBuilder);
            if (!(!((Collection)newEntityBundle.getForeignKeys()).isEmpty())) continue;
            tablesToCheckForeignKeys.add(newEntityBundle.getTableName());
        }
        $this$forEach$iv = tablesToCheckForeignKeys;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String tableName = (String)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{RoomMemberNames.INSTANCE.getDB_UTIL_FOREIGN_KEY_CHECK(), tableName};
            XFunSpec.Builder.Companion.addStatement(migrateBuilder, "%M(connection, %S)", objectArray);
        }
    }

    private final void addStatementsToMigrateFtsTable(XFunSpec.Builder migrateBuilder, BaseEntityBundle oldTable, BaseEntityBundle newTable, Map<String, String> renamedColumnsMap) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP TABLE `" + oldTable.getTableName() + "`");
        this.addDatabaseExecuteSqlStatement(migrateBuilder, newTable.createTable());
        Intrinsics.checkNotNull((Object)newTable, (String)"null cannot be cast to non-null type androidx.room.migration.bundle.FtsEntityBundle");
        String contentTable = ((FtsEntityBundle)newTable).getFtsOptions().getContentTable();
        String selectFromTable = ((CharSequence)contentTable).length() == 0 ? oldTable.getTableName() : contentTable;
        this.addStatementsToContentTransfer(selectFromTable, newTable.getTableName(), oldTable, newTable, renamedColumnsMap, migrateBuilder, true);
    }

    private final void addSimpleChangeStatements(XFunSpec.Builder migrateBuilder) {
        this.addDeleteTableStatements(migrateBuilder);
        this.addRenameTableStatements(migrateBuilder);
        this.addNewColumnStatements(migrateBuilder);
        this.addNewTableStatements(migrateBuilder);
    }

    private final void addStatementsToCreateNewTable(BaseEntityBundle newTable, XFunSpec.Builder migrateBuilder) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, newTable.createNewTable());
    }

    /*
     * WARNING - void declaration
     */
    private final void addStatementsToContentTransfer(String oldTableName, String tableNameWithNewPrefix, BaseEntityBundle oldEntityBundle, BaseEntityBundle newEntityBundle, Map<String, String> renamedColumnsMap, XFunSpec.Builder migrateBuilder, boolean isFtsTableContentTransfer) {
        void $this$addStatementsToContentTransfer_u24lambda_u2410;
        StringBuilder stringBuilder;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable = newEntityBundle.getFieldsByColumnName().keySet();
        boolean $i$f$filter = false;
        void var11_12 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(oldEntityBundle.getFieldsByColumnName().keySet().contains(it) || renamedColumnsMap.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List newColumnSequence = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        List selectColumnSequence = new ArrayList();
        if (isFtsTableContentTransfer) {
            selectColumnSequence.addAll(newColumnSequence);
            selectColumnSequence.add("rowId");
            newColumnSequence.add("docid");
        } else {
            Iterable $this$forEach$iv = newColumnSequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String column = (String)element$iv;
                boolean bl = false;
                String string = renamedColumnsMap.get(column);
                if (string == null) {
                    string = column;
                }
                selectColumnSequence.add(string);
            }
        }
        StringBuilder $i$f$forEach = stringBuilder = new StringBuilder();
        XFunSpec.Builder builder2 = migrateBuilder;
        AutoMigrationWriter autoMigrationWriter = this;
        boolean bl = false;
        $this$addStatementsToContentTransfer_u24lambda_u2410.append("INSERT INTO `" + tableNameWithNewPrefix + "` (" + CollectionsKt.joinToString$default((Iterable)newColumnSequence, (CharSequence)",", null, null, (int)0, null, (Function1)addStatementsToContentTransfer.2.1.INSTANCE, (int)30, null) + ") SELECT " + CollectionsKt.joinToString$default((Iterable)selectColumnSequence, (CharSequence)",", null, null, (int)0, null, (Function1)addStatementsToContentTransfer.2.2.INSTANCE, (int)30, null) + " FROM `" + oldTableName + "`");
        Unit unit = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        autoMigrationWriter.addDatabaseExecuteSqlStatement(builder2, string);
    }

    static /* synthetic */ void addStatementsToContentTransfer$default(AutoMigrationWriter autoMigrationWriter, String string, String string2, BaseEntityBundle baseEntityBundle, BaseEntityBundle baseEntityBundle2, Map map, XFunSpec.Builder builder2, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        autoMigrationWriter.addStatementsToContentTransfer(string, string2, baseEntityBundle, baseEntityBundle2, map, builder2, bl);
    }

    private final void addStatementsToDropTableAndRenameTempTable(String oldTableName, String newTableName, String tableNameWithNewPrefix, XFunSpec.Builder migrateBuilder) {
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "DROP TABLE `" + oldTableName + "`");
        this.addDatabaseExecuteSqlStatement(migrateBuilder, "ALTER TABLE `" + tableNameWithNewPrefix + "` RENAME TO `" + newTableName + "`");
    }

    private final void addStatementsToRecreateIndexes(EntityBundle table, XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = table.getIndices();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexBundle index = (IndexBundle)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, index.getCreateSql(table.getTableName()));
        }
    }

    private final void addDeleteTableStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.deletedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String deleteTableSql;
            StringBuilder stringBuilder;
            String tableName = (String)element$iv;
            boolean bl = false;
            StringBuilder $this$addDeleteTableStatements_u24lambda_u2413_u24lambda_u2412 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addDeleteTableStatements_u24lambda_u2413_u24lambda_u2412.append("DROP TABLE `" + tableName + "`");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"toString(...)");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, deleteTableSql);
        }
    }

    private final void addRenameTableStatements(XFunSpec.Builder migrateBuilder) {
        Map<String, String> $this$forEach$iv = this.renamedTables;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            String renameTableSql;
            StringBuilder stringBuilder;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String oldName = entry.getKey();
            String newName = entry.getValue();
            StringBuilder $this$addRenameTableStatements_u24lambda_u2415_u24lambda_u2414 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addRenameTableStatements_u24lambda_u2415_u24lambda_u2414.append("ALTER TABLE `" + oldName + "` RENAME TO `" + newName + "`");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"toString(...)");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, renameTableSql);
        }
    }

    private final void addNewColumnStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.addedColumns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String addNewColumnSql;
            StringBuilder stringBuilder;
            AutoMigration.AddedColumn it = (AutoMigration.AddedColumn)element$iv;
            boolean bl = false;
            StringBuilder $this$addNewColumnStatements_u24lambda_u2418_u24lambda_u2417 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$addNewColumnStatements_u24lambda_u2418_u24lambda_u2417.append("ALTER TABLE `" + it.getTableName() + "` ADD COLUMN `" + it.getFieldBundle().getColumnName() + "` " + it.getFieldBundle().getAffinity());
            if (it.getFieldBundle().isNonNull()) {
                $this$addNewColumnStatements_u24lambda_u2418_u24lambda_u2417.append(" NOT NULL");
            }
            String string = it.getFieldBundle().getDefaultValue();
            boolean bl3 = string != null ? ((CharSequence)string).length() > 0 : false;
            if (bl3) {
                $this$addNewColumnStatements_u24lambda_u2418_u24lambda_u2417.append(" DEFAULT " + it.getFieldBundle().getDefaultValue());
            } else {
                if (!(!it.getFieldBundle().isNonNull())) {
                    boolean bl4 = false;
                    String string2 = "A Non-Null field should always have a default value.";
                    throw new IllegalStateException(string2.toString());
                }
                $this$addNewColumnStatements_u24lambda_u2418_u24lambda_u2417.append(" DEFAULT NULL");
            }
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.toString(), (String)"toString(...)");
            this.addDatabaseExecuteSqlStatement(migrateBuilder, addNewColumnSql);
        }
    }

    private final void addNewTableStatements(XFunSpec.Builder migrateBuilder) {
        Iterable $this$forEach$iv = this.addedTables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AutoMigration.AddedTable addedTable = (AutoMigration.AddedTable)element$iv;
            boolean bl = false;
            this.addDatabaseExecuteSqlStatement(migrateBuilder, addedTable.getEntityBundle().createTable());
            if (!(addedTable.getEntityBundle() instanceof EntityBundle)) continue;
            this.addStatementsToRecreateIndexes((EntityBundle)addedTable.getEntityBundle(), migrateBuilder);
        }
    }

    private final void addDatabaseExecuteSqlStatement(XFunSpec.Builder migrateBuilder, String sql) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[]{sql};
        objectArray[0] = XCodeBlock.Companion.ofExtensionCall(this.getCodeLanguage(), SQLiteDriverMemberNames.INSTANCE.getCONNECTION_EXEC_SQL(), "connection", XCodeBlock.Companion.of(this.getCodeLanguage(), "%S", objectArray2));
        XFunSpec.Builder.Companion.addStatement(migrateBuilder, "%L", objectArray);
    }
}

