/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.preconditions;

import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeKt;
import androidx.room.log.RLog;
import java.lang.annotation.Annotation;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ7\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0010J?\u0010\u0011\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0015J9\u0010\u0016\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\f2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0019J7\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/room/preconditions/Checks;", "", "logger", "Landroidx/room/log/RLog;", "(Landroidx/room/log/RLog;)V", "check", "", "predicate", "element", "Landroidx/room/compiler/processing/XElement;", "errorMsgProducer", "Lkotlin/Function0;", "", "errorMsg", "args", "", "(ZLandroidx/room/compiler/processing/XElement;Ljava/lang/String;[Ljava/lang/Object;)Z", "hasAnnotation", "annotation", "Lkotlin/reflect/KClass;", "", "(Landroidx/room/compiler/processing/XElement;Lkotlin/reflect/KClass;Ljava/lang/String;[Ljava/lang/Object;)Z", "notBlank", "value", "msg", "(Ljava/lang/String;Landroidx/room/compiler/processing/XElement;Ljava/lang/String;[Ljava/lang/Object;)Z", "notUnbound", "type", "Landroidx/room/compiler/processing/XType;", "(Landroidx/room/compiler/processing/XType;Landroidx/room/compiler/processing/XElement;Ljava/lang/String;[Ljava/lang/Object;)Z", "room-compiler"})
@SourceDebugExtension(value={"SMAP\nChecks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Checks.kt\nandroidx/room/preconditions/Checks\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1747#2,3:100\n*S KotlinDebug\n*F\n+ 1 Checks.kt\nandroidx/room/preconditions/Checks\n*L\n72#1:100,3\n*E\n"})
public final class Checks {
    @NotNull
    private final RLog logger;

    public Checks(@NotNull RLog logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    public final boolean check(boolean predicate, @NotNull XElement element, @NotNull String errorMsg, Object ... args2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        if (!predicate) {
            Object[] objectArray = new Object[]{args2};
            this.logger.e(element, errorMsg, objectArray);
        }
        return predicate;
    }

    public final boolean check(boolean predicate, @NotNull XElement element, @NotNull Function0<String> errorMsgProducer) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(errorMsgProducer, (String)"errorMsgProducer");
        if (!predicate) {
            this.logger.e(element, (String)errorMsgProducer.invoke(), new Object[0]);
        }
        return predicate;
    }

    public final boolean hasAnnotation(@NotNull XElement element, @NotNull KClass<? extends Annotation> annotation, @NotNull String errorMsg, Object ... args2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        if (!element.hasAnnotation(annotation)) {
            Object[] objectArray = new Object[]{args2};
            this.logger.e(element, errorMsg, objectArray);
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public final boolean notUnbound(@NotNull XType type, @NotNull XElement element, @NotNull String errorMsg, Object ... args2) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)errorMsg, (String)"errorMsg");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Object[] objectArray = new Object[]{args2};
        boolean failed = this.check(!XTypeKt.isTypeVariable((XType)type), element, errorMsg, objectArray);
        if (!((Collection)type.getTypeArguments()).isEmpty()) {
            boolean bl;
            block4: {
                Iterable $this$any$iv = type.getTypeArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        XType it = (XType)element$iv;
                        boolean bl2 = false;
                        Object[] objectArray2 = new Object[]{args2};
                        if (!this.notUnbound(it, element, errorMsg, objectArray2)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            boolean nestedFailure = bl;
            return !failed && !nestedFailure;
        }
        return !failed;
    }

    public final boolean notBlank(@Nullable String value, @NotNull XElement element, @NotNull String msg, Object ... args2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Object[] objectArray = new Object[]{args2};
        return this.check(value != null && !StringsKt.isBlank((CharSequence)value), element, msg, objectArray);
    }
}

