/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.jarjarred.org.antlr.v4.codegen;

import androidx.room.jarjarred.org.antlr.runtime.ANTLRStringStream;
import androidx.room.jarjarred.org.antlr.runtime.CharStream;
import androidx.room.jarjarred.org.antlr.runtime.Token;
import androidx.room.jarjarred.org.antlr.v4.codegen.CodeGenerator;
import androidx.room.jarjarred.org.antlr.v4.codegen.OutputModelFactory;
import androidx.room.jarjarred.org.antlr.v4.codegen.Target;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.RuleFunction;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.ActionChunk;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.ActionText;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.ArgRef;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.LabelRef;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.ListLabelRef;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.LocalRef;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.NonLocalAttrRef;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.QRetValueRef;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.RetValueRef;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.RulePropertyRef;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.RulePropertyRef_ctx;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.RulePropertyRef_parser;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.RulePropertyRef_start;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.RulePropertyRef_stop;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.RulePropertyRef_text;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.SetAttr;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.SetNonLocalAttr;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.ThisRulePropertyRef_ctx;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.ThisRulePropertyRef_parser;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.ThisRulePropertyRef_start;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.ThisRulePropertyRef_stop;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.ThisRulePropertyRef_text;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.TokenPropertyRef;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.TokenPropertyRef_channel;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.TokenPropertyRef_index;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.TokenPropertyRef_int;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.TokenPropertyRef_line;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.TokenPropertyRef_pos;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.TokenPropertyRef_text;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.TokenPropertyRef_type;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.chunk.TokenRef;
import androidx.room.jarjarred.org.antlr.v4.codegen.model.decl.StructDecl;
import androidx.room.jarjarred.org.antlr.v4.parse.ActionSplitter;
import androidx.room.jarjarred.org.antlr.v4.parse.ActionSplitterListener;
import androidx.room.jarjarred.org.antlr.v4.tool.Attribute;
import androidx.room.jarjarred.org.antlr.v4.tool.ErrorType;
import androidx.room.jarjarred.org.antlr.v4.tool.Rule;
import androidx.room.jarjarred.org.antlr.v4.tool.ast.ActionAST;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionTranslator
implements ActionSplitterListener {
    public static final Map<String, Class<? extends RulePropertyRef>> thisRulePropToModelMap = new HashMap<String, Class<? extends RulePropertyRef>>();
    public static final Map<String, Class<? extends RulePropertyRef>> rulePropToModelMap;
    public static final Map<String, Class<? extends TokenPropertyRef>> tokenPropToModelMap;
    final CodeGenerator gen;
    final Target target;
    final ActionAST node;
    RuleFunction rf;
    final List<ActionChunk> chunks = new ArrayList<ActionChunk>();
    final OutputModelFactory factory;
    StructDecl nodeContext;

    public ActionTranslator(OutputModelFactory factory, ActionAST node) {
        this.factory = factory;
        this.node = node;
        this.gen = factory.getGenerator();
        this.target = this.gen.getTarget();
    }

    public static String toString(List<ActionChunk> chunks) {
        StringBuilder buf = new StringBuilder();
        for (ActionChunk c : chunks) {
            buf.append(c.toString());
        }
        return buf.toString();
    }

    public static List<ActionChunk> translateAction(OutputModelFactory factory, RuleFunction rf, Token tokenWithinAction, ActionAST node) {
        String action = tokenWithinAction.getText();
        if (action != null && action.length() > 0 && action.charAt(0) == '{') {
            int firstCurly = action.indexOf(123);
            int lastCurly = action.lastIndexOf(125);
            if (firstCurly >= 0 && lastCurly >= 0) {
                action = action.substring(firstCurly + 1, lastCurly);
            }
        }
        return ActionTranslator.translateActionChunk(factory, rf, action, node);
    }

    public static List<ActionChunk> translateActionChunk(OutputModelFactory factory, RuleFunction rf, String action, ActionAST node) {
        Token tokenWithinAction = node.token;
        ActionTranslator translator = new ActionTranslator(factory, node);
        translator.rf = rf;
        factory.getGrammar().tool.log("action-translator", "translate " + action);
        String altLabel = node.getAltLabel();
        if (rf != null) {
            translator.nodeContext = rf.ruleCtx;
            if (altLabel != null) {
                translator.nodeContext = rf.altLabelCtxs.get(altLabel);
            }
        }
        ANTLRStringStream in = new ANTLRStringStream(action);
        in.setLine(tokenWithinAction.getLine());
        in.setCharPositionInLine(tokenWithinAction.getCharPositionInLine());
        ActionSplitter trigger = new ActionSplitter((CharStream)in, translator);
        trigger.getActionTokens();
        return translator.chunks;
    }

    @Override
    public void attr(String expr, Token x) {
        this.gen.g.tool.log("action-translator", "attr " + x);
        Attribute a = this.node.resolver.resolveToAttribute(x.getText(), this.node);
        String name = x.getText();
        String escapedName = this.target.escapeIfNeeded(name);
        if (a != null) {
            switch (a.dict.type) {
                case ARG: {
                    this.chunks.add(new ArgRef(this.nodeContext, name, escapedName));
                    break;
                }
                case RET: {
                    this.chunks.add(new RetValueRef(this.rf.ruleCtx, name, escapedName));
                    break;
                }
                case LOCAL: {
                    this.chunks.add(new LocalRef(this.nodeContext, name, escapedName));
                    break;
                }
                case PREDEFINED_RULE: {
                    this.chunks.add(this.getRulePropertyRef(null, x));
                    break;
                }
            }
        }
        if (this.node.resolver.resolvesToToken(name, this.node)) {
            String tokenLabel = this.getTokenLabel(name);
            this.chunks.add(new TokenRef(this.nodeContext, tokenLabel, this.target.escapeIfNeeded(tokenLabel)));
            return;
        }
        if (this.node.resolver.resolvesToLabel(name, this.node)) {
            String tokenLabel = this.getTokenLabel(name);
            this.chunks.add(new LabelRef(this.nodeContext, tokenLabel, this.target.escapeIfNeeded(tokenLabel)));
            return;
        }
        if (this.node.resolver.resolvesToListLabel(name, this.node)) {
            this.chunks.add(new ListLabelRef(this.nodeContext, name, escapedName));
            return;
        }
        Rule r = this.factory.getGrammar().getRule(name);
        if (r != null) {
            String ruleLabel = this.getRuleLabel(name);
            this.chunks.add(new LabelRef(this.nodeContext, ruleLabel, this.target.escapeIfNeeded(ruleLabel)));
        }
    }

    @Override
    public void qualifiedAttr(String expr, Token x, Token y) {
        this.gen.g.tool.log("action-translator", "qattr " + x + "." + y);
        if (this.node.resolver.resolveToAttribute(x.getText(), this.node) != null) {
            this.attr(expr, x);
            this.chunks.add(new ActionText(this.nodeContext, "." + y.getText()));
            return;
        }
        Attribute a = this.node.resolver.resolveToAttribute(x.getText(), y.getText(), this.node);
        if (a == null) {
            this.gen.g.tool.errMgr.grammarError(ErrorType.UNKNOWN_SIMPLE_ATTRIBUTE, this.gen.g.fileName, x, x.getText(), "rule");
            return;
        }
        switch (a.dict.type) {
            case ARG: {
                this.chunks.add(new ArgRef(this.nodeContext, y.getText(), this.target.escapeIfNeeded(y.getText())));
                break;
            }
            case RET: {
                this.chunks.add(new QRetValueRef(this.nodeContext, this.getRuleLabel(x.getText()), y.getText(), this.target.escapeIfNeeded(y.getText())));
                break;
            }
            case PREDEFINED_RULE: {
                this.chunks.add(this.getRulePropertyRef(x, y));
                break;
            }
            case TOKEN: {
                this.chunks.add(this.getTokenPropertyRef(x, y));
                break;
            }
        }
    }

    @Override
    public void setAttr(String expr, Token x, Token rhs) {
        this.gen.g.tool.log("action-translator", "setAttr " + x + " " + rhs);
        List<ActionChunk> rhsChunks = ActionTranslator.translateActionChunk(this.factory, this.rf, rhs.getText(), this.node);
        String name = x.getText();
        SetAttr s = new SetAttr(this.nodeContext, name, this.target.escapeIfNeeded(name), rhsChunks);
        this.chunks.add(s);
    }

    @Override
    public void nonLocalAttr(String expr, Token x, Token y) {
        this.gen.g.tool.log("action-translator", "nonLocalAttr " + x + "::" + y);
        Rule r = this.factory.getGrammar().getRule(x.getText());
        String name = y.getText();
        this.chunks.add(new NonLocalAttrRef(this.nodeContext, x.getText(), name, this.target.escapeIfNeeded(name), r.index));
    }

    @Override
    public void setNonLocalAttr(String expr, Token x, Token y, Token rhs) {
        this.gen.g.tool.log("action-translator", "setNonLocalAttr " + x + "::" + y + "=" + rhs);
        Rule r = this.factory.getGrammar().getRule(x.getText());
        List<ActionChunk> rhsChunks = ActionTranslator.translateActionChunk(this.factory, this.rf, rhs.getText(), this.node);
        String name = y.getText();
        SetNonLocalAttr s = new SetNonLocalAttr(this.nodeContext, x.getText(), name, this.target.escapeIfNeeded(name), r.index, rhsChunks);
        this.chunks.add(s);
    }

    @Override
    public void text(String text) {
        this.chunks.add(new ActionText(this.nodeContext, text));
    }

    TokenPropertyRef getTokenPropertyRef(Token x, Token y) {
        try {
            Class<? extends TokenPropertyRef> c = tokenPropToModelMap.get(y.getText());
            Constructor<? extends TokenPropertyRef> ctor = c.getConstructor(StructDecl.class, String.class);
            return ctor.newInstance(this.nodeContext, this.getTokenLabel(x.getText()));
        }
        catch (Exception e) {
            this.factory.getGrammar().tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, e, new Object[0]);
            return null;
        }
    }

    RulePropertyRef getRulePropertyRef(Token x, Token prop) {
        try {
            Class<? extends RulePropertyRef> c = (x != null ? rulePropToModelMap : thisRulePropToModelMap).get(prop.getText());
            Constructor<? extends RulePropertyRef> ctor = c.getConstructor(StructDecl.class, String.class);
            return ctor.newInstance(this.nodeContext, this.getRuleLabel((x != null ? x : prop).getText()));
        }
        catch (Exception e) {
            this.factory.getGrammar().tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, e, prop.getText());
            return null;
        }
    }

    public String getTokenLabel(String x) {
        if (this.node.resolver.resolvesToLabel(x, this.node)) {
            return x;
        }
        return this.target.getImplicitTokenLabel(x);
    }

    public String getRuleLabel(String x) {
        if (this.node.resolver.resolvesToLabel(x, this.node)) {
            return x;
        }
        return this.target.getImplicitRuleLabel(x);
    }

    static {
        thisRulePropToModelMap.put("start", ThisRulePropertyRef_start.class);
        thisRulePropToModelMap.put("stop", ThisRulePropertyRef_stop.class);
        thisRulePropToModelMap.put("text", ThisRulePropertyRef_text.class);
        thisRulePropToModelMap.put("ctx", ThisRulePropertyRef_ctx.class);
        thisRulePropToModelMap.put("parser", ThisRulePropertyRef_parser.class);
        rulePropToModelMap = new HashMap<String, Class<? extends RulePropertyRef>>();
        rulePropToModelMap.put("start", RulePropertyRef_start.class);
        rulePropToModelMap.put("stop", RulePropertyRef_stop.class);
        rulePropToModelMap.put("text", RulePropertyRef_text.class);
        rulePropToModelMap.put("ctx", RulePropertyRef_ctx.class);
        rulePropToModelMap.put("parser", RulePropertyRef_parser.class);
        tokenPropToModelMap = new HashMap<String, Class<? extends TokenPropertyRef>>();
        tokenPropToModelMap.put("text", TokenPropertyRef_text.class);
        tokenPropToModelMap.put("type", TokenPropertyRef_type.class);
        tokenPropToModelMap.put("line", TokenPropertyRef_line.class);
        tokenPropToModelMap.put("index", TokenPropertyRef_index.class);
        tokenPropToModelMap.put("pos", TokenPropertyRef_pos.class);
        tokenPropToModelMap.put("channel", TokenPropertyRef_channel.class);
        tokenPropToModelMap.put("int", TokenPropertyRef_int.class);
    }
}

