/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.AutoMigration;
import androidx.room.Database;
import androidx.room.SkipQueryVerification;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.RoomTypeNames;
import androidx.room.log.RLog;
import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.migration.bundle.SchemaBundle;
import androidx.room.parser.Table;
import androidx.room.processor.AutoMigrationProcessor;
import androidx.room.processor.Context;
import androidx.room.processor.DaoProcessor;
import androidx.room.processor.DatabaseProcessor;
import androidx.room.processor.DatabaseViewProcessor;
import androidx.room.processor.EntityProcessorKt;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.SchemaFileResolver;
import androidx.room.verifier.DatabaseVerificationErrors;
import androidx.room.verifier.DatabaseVerifier;
import androidx.room.verifier.QueryResultInfo;
import androidx.room.vo.Dao;
import androidx.room.vo.DaoMethod;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.Field;
import androidx.room.vo.ForeignKey;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.HasFieldsKt;
import androidx.room.vo.Index;
import androidx.room.vo.InsertionMethod;
import androidx.room.vo.Pojo;
import androidx.room.vo.ShortcutEntity;
import androidx.room.vo.ShortcutMethod;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0013J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0!2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0002J$\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\"0\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0\u001cJ\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u001cH\u0002J\u001e\u0010.\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u001cH\u0002J,\u0010/\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u0002010\u001c2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u001cH\u0002J\u001e\u00102\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u001cH\u0002J,\u00103\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00052\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0\u001cH\u0002J$\u00104\u001a\u00020+2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\"0!2\u0006\u00106\u001a\u000207H\u0002R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00068"}, d2={"Landroidx/room/processor/DatabaseProcessor;", "", "baseContext", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;)V", "context", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "roomDatabaseType", "Landroidx/room/compiler/processing/XType;", "getRoomDatabaseType", "()Landroidx/room/compiler/processing/XType;", "roomDatabaseType$delegate", "Lkotlin/Lazy;", "doProcess", "Landroidx/room/vo/Database;", "getValidatedSchemaFile", "Ljava/io/File;", "version", "", "schemaFolderPath", "Ljava/nio/file/Path;", "process", "processAutoMigrations", "", "Landroidx/room/vo/AutoMigration;", "latestDbSchema", "Landroidx/room/migration/bundle/DatabaseBundle;", "processDatabaseViews", "", "Landroidx/room/vo/DatabaseView;", "dbAnnotation", "Landroidx/room/compiler/processing/XAnnotationBox;", "Landroidx/room/Database;", "processEntities", "Landroidx/room/vo/Entity;", "resolveDatabaseViews", "views", "validateExternalContentFts", "", "dbElement", "entities", "validateForeignKeys", "validateUniqueDaoClasses", "daoMethods", "Landroidx/room/vo/DaoMethod;", "validateUniqueIndices", "validateUniqueTableAndViewNames", "verifyDatabaseViews", "map", "dbVerifier", "Landroidx/room/verifier/DatabaseVerifier;", "room-compiler"})
public final class DatabaseProcessor {
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy roomDatabaseType$delegate;

    public DatabaseProcessor(@NotNull Context baseContext, @NotNull XTypeElement element) {
        Intrinsics.checkNotNullParameter((Object)baseContext, (String)"baseContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.element = element;
        this.context = Context.fork$default(baseContext, (XElement)this.element, null, 2, null);
        this.roomDatabaseType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XType>(this){
            final /* synthetic */ DatabaseProcessor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final XType invoke() {
                return this.this$0.getContext().getProcessingEnv().requireType(RoomTypeNames.INSTANCE.getROOM_DB().packageName() + '.' + RoomTypeNames.INSTANCE.getROOM_DB().simpleName());
            }
        }));
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final XType getRoomDatabaseType() {
        Lazy lazy = this.roomDatabaseType$delegate;
        return (XType)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final androidx.room.vo.Database process() {
        try {
            androidx.room.vo.Database database = this.doProcess();
            return database;
        }
        finally {
            DatabaseVerifier databaseVerifier = this.context.getDatabaseVerifier();
            if (databaseVerifier != null) {
                databaseVerifier.closeConnection(this.context);
            }
        }
    }

    private final androidx.room.vo.Database doProcess() {
        boolean bl;
        List daoMethods2;
        List<DatabaseView> views;
        List<Entity> entities;
        XAnnotationBox dbAnnotation;
        block4: {
            DatabaseVerifier dbVerifier;
            XAnnotationBox xAnnotationBox = this.element.getAnnotation(Reflection.getOrCreateKotlinClass(Database.class));
            Intrinsics.checkNotNull((Object)xAnnotationBox);
            dbAnnotation = xAnnotationBox;
            entities = this.processEntities((XAnnotationBox<Database>)dbAnnotation, this.element);
            Map<XTypeElement, DatabaseView> viewsMap = this.processDatabaseViews((XAnnotationBox<Database>)dbAnnotation);
            this.validateForeignKeys(this.element, entities);
            this.validateExternalContentFts(this.element, entities);
            boolean extendsRoomDb = this.getRoomDatabaseType().isAssignableFrom(this.element.getType());
            this.context.getChecker().check(extendsRoomDb, (XElement)this.element, ProcessorErrors.INSTANCE.getDB_MUST_EXTEND_ROOM_DB(), new Object[0]);
            views = this.resolveDatabaseViews(CollectionsKt.toList((Iterable)viewsMap.values()));
            DatabaseVerifier databaseVerifier = dbVerifier = this.element.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class)) ? (DatabaseVerifier)null : DatabaseVerifier.Companion.create(this.context, (XElement)this.element, entities, views);
            if (dbVerifier != null) {
                this.context.attachDatabaseVerifier(dbVerifier);
                this.verifyDatabaseViews(viewsMap, dbVerifier);
            }
            this.validateUniqueTableAndViewNames(this.element, entities, views);
            XType declaredType = this.element.getType();
            daoMethods2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)this.element.getAllMethods(), (Function1)doProcess.daoMethods.1.INSTANCE), (Function1)doProcess.daoMethods.2.INSTANCE), (Function1)((Function1)new Function1<XMethodElement, DaoMethod>(this, declaredType, dbVerifier){
                final /* synthetic */ DatabaseProcessor this$0;
                final /* synthetic */ XType $declaredType;
                final /* synthetic */ DatabaseVerifier $dbVerifier;
                {
                    this.this$0 = $receiver;
                    this.$declaredType = $declaredType;
                    this.$dbVerifier = $dbVerifier;
                    super(1);
                }

                @Nullable
                public final DaoMethod invoke(@NotNull XMethodElement executable) {
                    DaoMethod daoMethod;
                    Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
                    XType daoType = executable.getReturnType();
                    XTypeElement daoElement = daoType.getTypeElement();
                    if (daoElement == null) {
                        this.this$0.getContext().getLogger().e((XElement)executable, ProcessorErrors.INSTANCE.getDATABASE_INVALID_DAO_METHOD_RETURN_TYPE(), new Object[0]);
                        daoMethod = null;
                    } else {
                        Dao dao = new DaoProcessor(this.this$0.getContext(), daoElement, this.$declaredType, this.$dbVerifier).process();
                        daoMethod = new DaoMethod(executable, dao);
                    }
                    return daoMethod;
                }
            })));
            this.validateUniqueDaoClasses(this.element, daoMethods2, entities);
            this.validateUniqueIndices(this.element, entities);
            Iterable $this$any$iv = entities;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Entity it = (Entity)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = !((Collection)it.getForeignKeys()).isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean hasForeignKeys = bl;
        int n = ((Database)dbAnnotation.getValue()).version();
        XTypeElement xTypeElement = this.element;
        XType xType = this.element.getType();
        boolean bl4 = ((Database)dbAnnotation.getValue()).exportSchema();
        androidx.room.vo.Database database = new androidx.room.vo.Database(xTypeElement, xType, entities, views, daoMethods2, n, bl4, hasForeignKeys);
        database.setAutoMigrations(this.processAutoMigrations(this.element, database.getBundle()));
        return database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<androidx.room.vo.AutoMigration> processAutoMigrations(XTypeElement element, DatabaseBundle latestDbSchema) {
        v0 = element.getAnnotation(Reflection.getOrCreateKotlinClass(Database.class));
        Intrinsics.checkNotNull((Object)v0);
        dbAnnotation = v0;
        autoMigrationList = dbAnnotation.getAsAnnotationBoxArray("autoMigrations");
        if (autoMigrationList.length == 0 == false) {
            if (!((Database)dbAnnotation.getValue()).exportSchema()) {
                this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.getAUTO_MIGRATION_FOUND_BUT_EXPORT_SCHEMA_OFF(), new Object[0]);
                return CollectionsKt.emptyList();
            }
            if (this.context.getSchemaOutFolderPath() == null) {
                this.context.getLogger().e((XElement)element, ProcessorErrors.INSTANCE.getAUTO_MIGRATION_SCHEMA_OUT_FOLDER_NULL(), new Object[0]);
                return CollectionsKt.emptyList();
            }
        }
        $this$mapNotNull$iv = autoMigrationList;
        $i$f$mapNotNull = false;
        var7_7 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        var12_12 = $this$forEach$iv$iv$iv;
        var13_13 = 0;
        var14_14 = ((void)var12_12).length;
        while (var13_13 < var14_14) {
            block21: {
                block19: {
                    block20: {
                        element$iv$iv$iv = var12_12[var13_13];
                        ++var13_13;
                        element$iv$iv = element$iv$iv$iv;
                        $i$a$-forEach-ArraysKt___ArraysKt$mapNotNullTo$1$iv$iv = false;
                        it = element$iv$iv;
                        $i$a$-mapNotNull-DatabaseProcessor$processAutoMigrations$1 = false;
                        v1 = this.getContext().getSchemaOutFolderPath();
                        Intrinsics.checkNotNull((Object)v1);
                        var20_20 = new String[]{element.getClassName().canonicalName()};
                        databaseSchemaFolderPath = Path.of(v1, var20_20);
                        autoMigration = (AutoMigration)it.getValue();
                        v2 = autoMigration.from();
                        Intrinsics.checkNotNullExpressionValue((Object)databaseSchemaFolderPath, (String)"databaseSchemaFolderPath");
                        validatedFromSchemaFile = this.getValidatedSchemaFile(v2, databaseSchemaFolderPath);
                        if (validatedFromSchemaFile == null) break block19;
                        var23_23 = new FileInputStream(validatedFromSchemaFile);
                        var24_24 = null;
                        try {
                            it = (FileInputStream)var23_23;
                            $i$a$-use-DatabaseProcessor$processAutoMigrations$1$fromSchemaBundle$1 = false;
                            var25_25 = DatabaseProcessor.processAutoMigrations$lambda-3$deserializeSchemaFile(databaseSchemaFolderPath, it, autoMigration.from());
                        }
                        catch (Throwable var25_26) {
                            var24_24 = var25_26;
                            throw var25_26;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var23_23, (Throwable)var24_24);
                        }
                        fromSchemaBundle = var25_25;
                        if (autoMigration.to() != latestDbSchema.getVersion()) break block20;
                        v3 /* !! */  = latestDbSchema;
                        ** GOTO lbl77
                    }
                    validatedToSchemaFile = this.getValidatedSchemaFile(autoMigration.to(), databaseSchemaFolderPath);
                    if (validatedToSchemaFile == null) {
                        v4 = null;
                    } else {
                        var25_25 = new FileInputStream(validatedToSchemaFile);
                        var26_29 = null;
                        try {
                            it = (FileInputStream)var25_25;
                            $i$a$-use-DatabaseProcessor$processAutoMigrations$1$toSchemaBundle$1 = false;
                            var28_31 = DatabaseProcessor.processAutoMigrations$lambda-3$deserializeSchemaFile(databaseSchemaFolderPath, it, autoMigration.to());
                            v3 /* !! */  = var28_31;
                        }
                        catch (Throwable var28_32) {
                            var26_29 = var28_32;
                            throw var28_32;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)var25_25, (Throwable)var26_29);
                        }
lbl77:
                        // 2 sources

                        toSchemaBundle = v3 /* !! */ ;
                        if (!(fromSchemaBundle instanceof DatabaseBundle) || !(toSchemaBundle instanceof DatabaseBundle)) {
                            this.getContext().getLogger().e((XElement)element, ProcessorErrors.INSTANCE.autoMigrationSchemasMustBeRoomGenerated(autoMigration.from(), autoMigration.to()), new Object[0]);
                            v4 = null;
                        } else {
                            v5 = this.getContext();
                            v6 = it.getAsType("spec");
                            Intrinsics.checkNotNull((Object)v6);
                            v4 = new AutoMigrationProcessor(v5, v6, (DatabaseBundle)fromSchemaBundle, toSchemaBundle).process();
                        }
                    }
                    break block21;
                }
                v4 = null;
            }
            if (v4 == null) continue;
            it$iv$iv = v4;
            $i$a$-let-ArraysKt___ArraysKt$mapNotNullTo$1$1$iv$iv = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final File getValidatedSchemaFile(int version, Path schemaFolderPath) {
        SchemaFileResolver schemaFileResolver = SchemaFileResolver.Companion.getRESOLVER();
        Object[] objectArray = schemaFolderPath.resolve(version + ".json");
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"schemaFolderPath.resolve(\"$version.json\")");
        File schemaFile = schemaFileResolver.getFile((Path)objectArray);
        if (!schemaFile.exists()) {
            objectArray = new Object[]{this.element};
            this.context.getLogger().e(ProcessorErrors.INSTANCE.autoMigrationSchemasNotFound(version + ".json", ((Object)schemaFolderPath).toString()), objectArray);
            return null;
        }
        if (schemaFile.length() <= 0L) {
            objectArray = new Object[]{this.element};
            this.context.getLogger().e(ProcessorErrors.INSTANCE.autoMigrationSchemaIsEmpty(version + ".json", ((Object)schemaFolderPath).toString()), objectArray);
            return null;
        }
        return schemaFile;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateForeignKeys(XTypeElement element, List<? extends Entity> entities) {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = entities;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Entity entity = (Entity)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getTableName(), element$iv$iv);
        }
        Map byTableName = destination$iv$iv;
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity entity = (Entity)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = entity.getForeignKeys();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void $this$mapNotNullTo$iv$iv;
                ForeignKey foreignKey = (ForeignKey)element$iv2;
                boolean bl2 = false;
                Entity parent = (Entity)byTableName.get(foreignKey.getParentTable());
                if (parent == null) {
                    this.getContext().getLogger().e((XElement)element, ProcessorErrors.INSTANCE.foreignKeyMissingParentEntityInDatabase(foreignKey.getParentTable(), entity.getElement().getQualifiedName()), new Object[0]);
                    continue;
                }
                Iterable $this$mapNotNull$iv = foreignKey.getParentColumns();
                boolean $i$f$mapNotNull = false;
                Object object = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach3 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Field it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    String columnName = (String)element$iv$iv;
                    boolean bl4 = false;
                    Field parentField = HasFieldsKt.findFieldByColumnName(parent, columnName);
                    if (parentField == null) {
                        this.getContext().getLogger().e((XElement)entity.getElement(), ProcessorErrors.INSTANCE.foreignKeyParentColumnDoesNotExist(parent.getElement().getQualifiedName(), columnName, HasFieldsKt.getColumnNames(parent)), new Object[0]);
                    }
                    if (parentField == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List parentFields = (List)destination$iv$iv2;
                if (parentFields.size() != foreignKey.getParentColumns().size() || parent.isUnique(foreignKey.getParentColumns())) continue;
                ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
                String string = parent.getElement().getQualifiedName();
                object = entity.getElement().getQualifiedName();
                List<String> list = foreignKey.getParentColumns();
                $this$forEach$iv$iv$iv = foreignKey.getChildFields();
                XElement xElement = (XElement)parent.getElement();
                RLog rLog = this.getContext().getLogger();
                boolean $i$f$map = false;
                iterator = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Field bl4 = (Field)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl6 = false;
                    collection.add(it.getColumnName());
                }
                collection = (List)destination$iv$iv3;
                List list2 = collection;
                rLog.e(xElement, processorErrors.foreignKeyMissingIndexInParent(string, list, (String)object, list2), new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueIndices(XTypeElement element, List<? extends Entity> entities) {
        void $this$filterTo$iv$iv;
        Object it;
        Object $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Object object;
        Index index;
        Object element$iv$iv2;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = entities;
        boolean $i$f$flatMap = false;
        Object object2 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Entity entity = (Entity)element$iv$iv2;
            boolean bl = false;
            Iterable $this$map$iv = entity.getIndices();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                index = (Index)item$iv$iv;
                object = destination$iv$iv2;
                boolean bl2 = false;
                object.add(new Pair((Object)it2.getName(), (Object)entity));
            }
            list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object3;
            element$iv$iv2 = iterator.next();
            it = (Pair)element$iv$iv2;
            boolean bl = false;
            String key$iv$iv = (String)it.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object3;
            list$iv$iv.add(element$iv$iv2);
        }
        Object $this$filter$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv2 = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Object $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry element$iv;
            Map.Entry it3 = element$iv = (Map.Entry)object2.next();
            boolean bl = false;
            Iterable $this$distinctBy$iv = (Iterable)it3.getValue();
            boolean $i$f$distinctBy = false;
            HashSet<TypeName> set$iv = new HashSet<TypeName>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                Pair it4 = (Pair)e$iv;
                boolean bl4 = false;
                TypeName key$iv = ((Entity)it4.getSecond()).getTypeName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            if (((List)list$iv).size() <= 1) continue;
            $this$distinctBy$iv = (Iterable)it3.getValue();
            String string = (String)it3.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            index = (XElement)element;
            object = this.getContext().getLogger();
            boolean $i$f$map = false;
            set$iv = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it5;
                Pair bl4 = (Pair)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl5 = false;
                collection.add(((Entity)it5.getSecond()).getTypeName() + " > " + (String)it5.getFirst());
            }
            collection = (List)destination$iv$iv3;
            ((RLog)object).e((XElement)index, processorErrors.duplicateIndexInDatabase(string, (List<String>)collection), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueDaoClasses(XTypeElement dbElement, List<DaoMethod> daoMethods2, List<? extends Entity> entities) {
        Iterator<Map.Entry<String, ShortcutEntity>> iterator;
        void $this$forEach$iv;
        List list$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object element$iv$iv;
        Iterator $this$groupByTo$iv$iv;
        DaoMethod it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Entity entity = (Entity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Pojo)((Object)it)).getTypeName());
        }
        Set entityTypeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Object $this$groupBy$iv = daoMethods2;
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            element$iv$iv = iterator2.next();
            it = (DaoMethod)element$iv$iv;
            boolean bl3 = false;
            ClassName key$iv$iv = it.getDao().getTypeName();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$groupByTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$groupByTo$iv$iv.hasNext()) {
            Collection<String> collection;
            Iterator $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map.Entry element$iv;
            Map.Entry it2 = element$iv = $this$groupByTo$iv$iv.next();
            boolean bl = false;
            if (((List)it2.getValue()).size() <= 1) continue;
            element$iv$iv = (Iterable)it2.getValue();
            list$iv$iv = (TypeName)it2.getKey();
            ProcessorErrors bl3 = ProcessorErrors.INSTANCE;
            boolean $i$f$map2 = false;
            $this$getOrPut$iv$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator answer$iv$iv$iv = $this$mapTo$iv$iv2.iterator();
            while (answer$iv$iv$iv.hasNext()) {
                void it3;
                Object item$iv$iv = answer$iv$iv$iv.next();
                iterator = (DaoMethod)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(it3.getElement().getJvmName());
            }
            collection = (List)destination$iv$iv2;
            String error = bl3.duplicateDao((TypeName)list$iv$iv, (List<String>)collection);
            Iterable $this$forEach$iv2 = (Iterable)it2.getValue();
            boolean $i$f$forEach2 = false;
            $this$mapTo$iv$iv2 = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv2.hasNext()) {
                Object element$iv2 = $this$mapTo$iv$iv2.next();
                DaoMethod daoMethod = (DaoMethod)element$iv2;
                boolean bl5 = false;
                this.getContext().getLogger().e((XElement)daoMethod.getElement(), ProcessorErrors.INSTANCE.getDAO_METHOD_CONFLICTS_WITH_OTHERS(), new Object[0]);
            }
            this.getContext().getLogger().e((XElement)dbElement, error, new Object[0]);
        }
        Function3 check2 = (Function3)new Function3<XElement, Dao, TypeName, Unit>((Set<? extends TypeName>)entityTypeNames, this, dbElement){
            final /* synthetic */ Set<TypeName> $entityTypeNames;
            final /* synthetic */ DatabaseProcessor this$0;
            final /* synthetic */ XTypeElement $dbElement;
            {
                this.$entityTypeNames = $entityTypeNames;
                this.this$0 = $receiver;
                this.$dbElement = $dbElement;
                super(3);
            }

            public final void invoke(@NotNull XElement element, @NotNull Dao dao, @Nullable TypeName typeName2) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
                TypeName typeName3 = typeName2;
                if (typeName3 != null) {
                    TypeName typeName4 = typeName3;
                    Set<TypeName> set = this.$entityTypeNames;
                    DatabaseProcessor databaseProcessor = this.this$0;
                    XTypeElement xTypeElement = this.$dbElement;
                    TypeName it = typeName4;
                    boolean bl = false;
                    if (!set.contains(typeName2)) {
                        RLog rLog = databaseProcessor.getContext().getLogger();
                        String string = xTypeElement.getQualifiedName();
                        String string2 = dao.getTypeName().toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dao.typeName.toString()");
                        String string3 = string2;
                        string2 = typeName2.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"typeName.toString()");
                        rLog.e(element, ProcessorErrors.INSTANCE.shortcutEntityIsNotInDatabase(string, string3, string2), new Object[0]);
                    }
                }
            }
        };
        Iterable $this$forEach$iv3 = daoMethods2;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Map.Entry<String, ShortcutEntity> it4;
            Map.Entry<String, ShortcutEntity> element$iv3;
            boolean $i$f$forEach4;
            Map<String, ShortcutEntity> $this$forEach$iv4;
            Object method;
            DaoMethod daoMethod = (DaoMethod)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv5 = daoMethod.getDao().getShortcutMethods();
            boolean $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv5) {
                method = (ShortcutMethod)element$iv4;
                boolean bl6 = false;
                $this$forEach$iv4 = ((ShortcutMethod)method).getEntities();
                $i$f$forEach4 = false;
                iterator = $this$forEach$iv4.entrySet().iterator();
                while (iterator.hasNext()) {
                    it4 = element$iv3 = (Map.Entry<String, ShortcutEntity>)iterator.next();
                    boolean bl7 = false;
                    check2.invoke((Object)((ShortcutMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)((ShortcutEntity)it4.getValue()).getEntityTypeName());
                }
            }
            $this$forEach$iv5 = daoMethod.getDao().getInsertionMethods();
            $i$f$forEach5 = false;
            for (Object element$iv4 : $this$forEach$iv5) {
                method = (InsertionMethod)element$iv4;
                boolean bl8 = false;
                $this$forEach$iv4 = ((InsertionMethod)method).getEntities();
                $i$f$forEach4 = false;
                iterator = $this$forEach$iv4.entrySet().iterator();
                while (iterator.hasNext()) {
                    it4 = element$iv3 = iterator.next();
                    boolean bl9 = false;
                    check2.invoke((Object)((InsertionMethod)method).getElement(), (Object)daoMethod.getDao(), (Object)it4.getValue().getEntityTypeName());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateUniqueTableAndViewNames(XTypeElement dbElement, List<? extends Entity> entities, List<DatabaseView> views) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Object $this$filter$iv;
        String key$iv$iv;
        Object element$iv$iv2;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        void $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv = entities;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            Entity entity = (Entity)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getTableName();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            object = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).toLowerCase(locale)");
            collection.add(new Triple(object, (Object)it.getTypeName().toString(), (Object)it.getElement()));
        }
        List entitiesInfo = (List)destination$iv$iv;
        Iterable $this$map$iv2 = views;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            DatabaseView bl = (DatabaseView)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            String string = it.getViewName();
            object = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"US");
            String string2 = string.toLowerCase((Locale)object);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            collection.add(new Triple((Object)string2, (Object)it.getTypeName().toString(), (Object)it.getElement()));
        }
        List viewsInfo = (List)destination$iv$iv2;
        $this$map$iv2 = CollectionsKt.plus((Collection)entitiesInfo, (Iterable)viewsInfo);
        boolean $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
            Object object2;
            String name;
            Triple $dstr$name$_u24__u24$_u24__u24 = (Triple)element$iv$iv2;
            boolean bl = false;
            key$iv$iv = name = (String)$dstr$name$_u24__u24$_u24__u24.component1();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv2);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        item$iv$iv2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (item$iv$iv2.hasNext()) {
            Object it = element$iv$iv2 = (Map.Entry)item$iv$iv2.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv2.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        $this$filter$iv = destination$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Map.Entry element$iv;
            Map.Entry byName = element$iv = iterator.next();
            boolean bl = false;
            element$iv$iv2 = (Iterable)byName.getValue();
            String string = (String)byName.getKey();
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            boolean $i$f$map3 = false;
            key$iv$iv = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv4 : $this$mapTo$iv$iv3) {
                void $dstr$_u24__u24$typeName$_u24__u24;
                Triple triple = (Triple)item$iv$iv4;
                collection2 = destination$iv$iv3;
                boolean bl4 = false;
                String typeName2 = (String)$dstr$_u24__u24$typeName$_u24__u24.component2();
                Intrinsics.checkNotNullExpressionValue((Object)typeName2, (String)"typeName");
                collection2.add(typeName2);
            }
            collection2 = (List)destination$iv$iv3;
            String error = processorErrors.duplicateTableNames(string, (List<String>)collection2);
            Iterable $this$forEach$iv2 = (Iterable)byName.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Triple $dstr$_u24__u24$_u24__u24$element = (Triple)element$iv2;
                boolean bl5 = false;
                XTypeElement element = (XTypeElement)$dstr$_u24__u24$_u24__u24$element.component3();
                this.getContext().getLogger().e((XElement)element, error, new Object[0]);
            }
            this.getContext().getLogger().e((XElement)dbElement, error, new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateExternalContentFts(XTypeElement dbElement, List<? extends Entity> entities) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = CollectionsKt.filterIsInstance((Iterable)entities, FtsEntity.class);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FtsEntity it = (FtsEntity)element$iv$iv;
            boolean bl = false;
            if (it.getFtsOptions().getContentEntity() == null || entities.contains(it.getFtsOptions().getContentEntity())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FtsEntity it = (FtsEntity)element$iv;
            boolean bl = false;
            RLog rLog = this.getContext().getLogger();
            XElement xElement = (XElement)dbElement;
            String string = it.getElement().getQualifiedName();
            Entity entity = it.getFtsOptions().getContentEntity();
            Intrinsics.checkNotNull((Object)entity);
            rLog.e(xElement, ProcessorErrors.INSTANCE.missingExternalContentEntity(string, entity.getElement().getQualifiedName()), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Entity> processEntities(XAnnotationBox<Database> dbAnnotation, XTypeElement element) {
        void $this$mapNotNullTo$iv$iv;
        List entityList = dbAnnotation.getAsTypeList("entities");
        this.context.getChecker().check(!((Collection)entityList).isEmpty(), (XElement)element, ProcessorErrors.INSTANCE.getDATABASE_ANNOTATION_MUST_HAVE_LIST_OF_ENTITIES(), new Object[0]);
        Iterable $this$mapNotNull$iv = entityList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Entity entity;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            XType it = (XType)element$iv$iv;
            boolean bl2 = false;
            XTypeElement typeElement = it.getTypeElement();
            if (typeElement == null) {
                this.getContext().getLogger().e((XElement)element, ProcessorErrors.INSTANCE.invalidEntityTypeInDatabaseAnnotation(it.getTypeName()), new Object[0]);
                entity = null;
            } else {
                entity = EntityProcessorKt.EntityProcessor$default(this.getContext(), typeElement, null, 4, null).process();
            }
            if (entity == null) continue;
            Entity it$iv$iv = entity;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<XTypeElement, DatabaseView> processDatabaseViews(XAnnotationBox<Database> dbAnnotation) {
        void $this$mapNotNullTo$iv$iv;
        List viewList = dbAnnotation.getAsTypeList("views");
        Iterable $this$mapNotNull$iv = viewList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            XType it = (XType)element$iv$iv;
            boolean bl2 = false;
            XTypeElement viewElement = it.getTypeElement();
            if (viewElement == null) {
                this.getContext().getLogger().e((XElement)this.getElement(), ProcessorErrors.INSTANCE.invalidViewTypeInDatabaseAnnotation(it.getTypeName()), new Object[0]);
                pair = null;
            } else {
                pair = TuplesKt.to((Object)viewElement, (Object)new DatabaseViewProcessor(this.getContext(), viewElement, null, 4, null).process());
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final void verifyDatabaseViews(Map<XTypeElement, DatabaseView> map, DatabaseVerifier dbVerifier) {
        for (Map.Entry<XTypeElement, DatabaseView> entry : map.entrySet()) {
            XTypeElement viewElement = entry.getKey();
            DatabaseView view = entry.getValue();
            if (viewElement.hasAnnotation(Reflection.getOrCreateKotlinClass(SkipQueryVerification.class))) continue;
            view.getQuery().setResultInfo(dbVerifier.analyze(view.getQuery().getOriginal()));
            QueryResultInfo queryResultInfo = view.getQuery().getResultInfo();
            if ((queryResultInfo == null ? null : queryResultInfo.getError()) == null) continue;
            RLog rLog = this.context.getLogger();
            XElement xElement = (XElement)viewElement;
            QueryResultInfo queryResultInfo2 = view.getQuery().getResultInfo();
            Intrinsics.checkNotNull((Object)queryResultInfo2);
            SQLException sQLException = queryResultInfo2.getError();
            Intrinsics.checkNotNull((Object)sQLException);
            rLog.e(xElement, DatabaseVerificationErrors.INSTANCE.cannotVerifyQuery(sQLException), new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DatabaseView> resolveDatabaseViews(@NotNull List<DatabaseView> views) {
        Collection collection;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(views, (String)"views");
        if (views.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = views;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Set<String> destination$iv$iv = (Set<String>)((Object)new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10)));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator<Object> it;
            DatabaseView databaseView = (DatabaseView)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(((DatabaseView)((Object)it)).getViewName());
        }
        List viewNames = (List)((Object)destination$iv$iv);
        for (DatabaseView view : views) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            $this$mapTo$iv$iv = view.getQuery().getTables();
            object = view.getTables();
            boolean $i$f$map2 = false;
            void $i$f$mapTo2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void $dstr$name$_u24__u24;
                Table table = (Table)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                String name = $dstr$name$_u24__u24.component1();
                collection.add(name);
            }
            object.addAll((List)destination$iv$iv2);
        }
        List unresolvedViews = CollectionsKt.toMutableList((Collection)views);
        Map resolvedViews = new LinkedHashMap();
        List result = new ArrayList();
        do {
            Collection<String> collection2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Iterable $this$forEach$iv;
            DatabaseView view;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Set tables;
            for (Map.Entry $this$mapTo$iv$iv2 : resolvedViews.entrySet()) {
                String viewName = (String)$this$mapTo$iv$iv2.getKey();
                tables = (Set)$this$mapTo$iv$iv2.getValue();
                for (DatabaseView view2 : unresolvedViews) {
                    if (!view2.getTables().removeIf(arg_0 -> DatabaseProcessor.resolveDatabaseViews$lambda-40(viewName, arg_0))) continue;
                    view2.getTables().addAll(tables);
                }
            }
            int countNewlyResolved = 0;
            Iterable $this$mapTo$iv$iv2 = unresolvedViews;
            boolean $i$f$filter = false;
            tables = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator $dstr$name$_u24__u24 = $this$filterTo$iv$iv.iterator();
            while ($dstr$name$_u24__u24.hasNext()) {
                boolean bl;
                Object element$iv$iv;
                block13: {
                    element$iv$iv = $dstr$name$_u24__u24.next();
                    view = (DatabaseView)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$all$iv = view.getTables();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            if (DatabaseProcessor.resolveDatabaseViews$isTable(viewNames, it)) continue;
                            bl = false;
                            break block13;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv3;
            boolean $i$f$forEach = false;
            $this$filterTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$filterTo$iv$iv.hasNext()) {
                Object element$iv = $this$filterTo$iv$iv.next();
                DatabaseView view3 = (DatabaseView)element$iv;
                boolean bl = false;
                resolvedViews.put(view3.getViewName(), view3.getTables());
                unresolvedViews.remove(view3);
                result.add(view3);
                int element$iv$iv = countNewlyResolved;
                countNewlyResolved = element$iv$iv + 1;
            }
            if (countNewlyResolved != 0) continue;
            $this$forEach$iv = unresolvedViews;
            ProcessorErrors processorErrors = ProcessorErrors.INSTANCE;
            collection = (XElement)this.element;
            object = this.context.getLogger();
            boolean $i$f$map3 = false;
            $this$filterTo$iv$iv = $this$map$iv3;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                view = (DatabaseView)item$iv$iv;
                collection2 = destination$iv$iv3;
                boolean bl = false;
                collection2.add(it.getViewName());
            }
            collection2 = (List)destination$iv$iv3;
            ((RLog)object).e((XElement)collection, processorErrors.viewCircularReferenceDetected((List<String>)collection2), new Object[0]);
            break;
        } while (!((Collection)unresolvedViews).isEmpty());
        return result;
    }

    private static final Object processAutoMigrations$lambda-3$deserializeSchemaFile(Path databaseSchemaFolderPath, FileInputStream fileInputStream, int versionNumber) {
        Object object;
        try {
            object = SchemaBundle.deserialize((InputStream)fileInputStream).getDatabase();
        }
        catch (Throwable th) {
            object = ProcessorErrors.INSTANCE.invalidAutoMigrationSchema(versionNumber + ".json", ((Object)databaseSchemaFolderPath).toString());
        }
        DatabaseBundle databaseBundle = object;
        Intrinsics.checkNotNullExpressionValue((Object)databaseBundle, (String)"try {\n                  \u2026      )\n                }");
        return databaseBundle;
    }

    private static final boolean resolveDatabaseViews$isTable(List<String> viewNames, String name) {
        boolean bl;
        block3: {
            Iterable $this$none$iv = viewNames;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)it, (String)name, (boolean)true)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean resolveDatabaseViews$lambda-40(String $viewName, String it) {
        Intrinsics.checkNotNullParameter((Object)$viewName, (String)"$viewName");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.equals((String)it, (String)$viewName, (boolean)true);
    }
}

