/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.processor;

import androidx.room.AutoMigration;
import androidx.room.compiler.processing.XAnnotationBox;
import androidx.room.compiler.processing.XElement;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.ext.RoomTypeNames;
import androidx.room.migration.bundle.DatabaseBundle;
import androidx.room.migration.bundle.SchemaBundle;
import androidx.room.processor.Context;
import androidx.room.processor.ProcessorErrors;
import androidx.room.util.DiffException;
import androidx.room.util.SchemaDiffResult;
import androidx.room.util.SchemaDiffer;
import androidx.room.vo.AutoMigrationResult;
import com.squareup.javapoet.TypeName;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Landroidx/room/processor/AutoMigrationProcessor;", "", "context", "Landroidx/room/processor/Context;", "element", "Landroidx/room/compiler/processing/XTypeElement;", "latestDbSchema", "Landroidx/room/migration/bundle/DatabaseBundle;", "(Landroidx/room/processor/Context;Landroidx/room/compiler/processing/XTypeElement;Landroidx/room/migration/bundle/DatabaseBundle;)V", "getContext", "()Landroidx/room/processor/Context;", "getElement", "()Landroidx/room/compiler/processing/XTypeElement;", "getLatestDbSchema", "()Landroidx/room/migration/bundle/DatabaseBundle;", "getValidatedSchemaFile", "Ljava/io/File;", "version", "", "process", "Landroidx/room/vo/AutoMigrationResult;", "room-compiler"})
public final class AutoMigrationProcessor {
    @NotNull
    private final Context context;
    @NotNull
    private final XTypeElement element;
    @NotNull
    private final DatabaseBundle latestDbSchema;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final AutoMigrationResult process() {
        DatabaseBundle databaseBundle;
        Object object;
        boolean $i$a$-use-AutoMigrationProcessor$process$fromSchemaBundle$22;
        if (!this.element.isInterface()) {
            this.context.getLogger().e(ProcessorErrors.INSTANCE.getAUTOMIGRATION_ANNOTATED_TYPE_ELEMENT_MUST_BE_INTERFACE(), this.element);
            return null;
        }
        if (!this.context.getProcessingEnv().requireType((TypeName)RoomTypeNames.INSTANCE.getAUTO_MIGRATION_CALLBACK()).isAssignableFrom(this.element.getType())) {
            this.context.getLogger().e(ProcessorErrors.INSTANCE.getAUTOMIGRATION_ELEMENT_MUST_IMPLEMENT_AUTOMIGRATION_CALLBACK(), this.element);
            return null;
        }
        XAnnotationBox annotationBox = this.element.toAnnotationBox(Reflection.getOrCreateKotlinClass(AutoMigration.class));
        if (annotationBox == null) {
            this.context.getLogger().e((XElement)this.element, ProcessorErrors.INSTANCE.getAUTOMIGRATION_ANNOTATION_MISSING(), new Object[0]);
            return null;
        }
        int from = ((AutoMigration)annotationBox.getValue()).from();
        int to = ((AutoMigration)annotationBox.getValue()).to();
        if (to <= from) {
            this.context.getLogger().e(ProcessorErrors.INSTANCE.autoMigrationToVersionMustBeGreaterThanFrom(to, from), this.element);
            return null;
        }
        File file = this.getValidatedSchemaFile(from);
        if (file == null) {
            return null;
        }
        File validatedFromSchemaFile = file;
        Object object2 = validatedFromSchemaFile;
        boolean bl = false;
        object2 = new FileInputStream((File)object2);
        bl = false;
        boolean bl2 = false;
        Object object3 = null;
        try {
            FileInputStream it = (FileInputStream)object2;
            $i$a$-use-AutoMigrationProcessor$process$fromSchemaBundle$22 = false;
            SchemaBundle schemaBundle = SchemaBundle.deserialize((InputStream)it);
            Intrinsics.checkNotNullExpressionValue((Object)schemaBundle, (String)"deserialize(it)");
            object = schemaBundle.getDatabase();
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        DatabaseBundle fromSchemaBundle = object;
        File file2 = this.getValidatedSchemaFile(to);
        if (file2 == null) {
            return null;
        }
        File validatedToSchemaFile = file2;
        if (to == this.latestDbSchema.getVersion()) {
            databaseBundle = this.latestDbSchema;
        } else {
            object3 = validatedToSchemaFile;
            boolean bl3 = false;
            object3 = new FileInputStream((File)object3);
            bl3 = false;
            $i$a$-use-AutoMigrationProcessor$process$fromSchemaBundle$22 = false;
            Throwable $i$a$-use-AutoMigrationProcessor$process$fromSchemaBundle$22 = null;
            try {
                FileInputStream it = (FileInputStream)object3;
                boolean bl4 = false;
                SchemaBundle schemaBundle = SchemaBundle.deserialize((InputStream)it);
                Intrinsics.checkNotNullExpressionValue((Object)schemaBundle, (String)"deserialize(it)");
                DatabaseBundle databaseBundle2 = schemaBundle.getDatabase();
                databaseBundle = databaseBundle2;
            }
            catch (Throwable throwable) {
                $i$a$-use-AutoMigrationProcessor$process$fromSchemaBundle$22 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)$i$a$-use-AutoMigrationProcessor$process$fromSchemaBundle$22);
            }
        }
        DatabaseBundle toSchemaBundle = databaseBundle;
        try {
            DatabaseBundle databaseBundle3 = fromSchemaBundle;
            Intrinsics.checkNotNullExpressionValue((Object)databaseBundle3, (String)"fromSchemaBundle");
            DatabaseBundle databaseBundle4 = toSchemaBundle;
            Intrinsics.checkNotNullExpressionValue((Object)databaseBundle4, (String)"toSchemaBundle");
            object = new SchemaDiffer(databaseBundle3, databaseBundle4).diffSchemas();
        }
        catch (DiffException ex) {
            this.context.getLogger().e(ex.getErrorMessage(), new Object[0]);
            return null;
        }
        Object schemaDiff = object;
        return new AutoMigrationResult(this.element, fromSchemaBundle.getVersion(), toSchemaBundle.getVersion(), ((SchemaDiffResult)schemaDiff).getAddedColumn(), ((SchemaDiffResult)schemaDiff).getAddedTable());
    }

    private final File getValidatedSchemaFile(int version) {
        File schemaFile = new File(this.context.getSchemaOutFolder(), this.element.getQualifiedName() + '/' + version + ".json");
        if (!schemaFile.exists()) {
            this.context.getLogger().e(ProcessorErrors.INSTANCE.autoMigrationSchemasNotFound(String.valueOf(this.context.getSchemaOutFolder()), this.element.getQualifiedName() + '/' + version + ".json"), this.element);
            return null;
        }
        return schemaFile;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final XTypeElement getElement() {
        return this.element;
    }

    @NotNull
    public final DatabaseBundle getLatestDbSchema() {
        return this.latestDbSchema;
    }

    public AutoMigrationProcessor(@NotNull Context context, @NotNull XTypeElement element, @NotNull DatabaseBundle latestDbSchema) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)latestDbSchema, (String)"latestDbSchema");
        this.context = context;
        this.element = element;
        this.latestDbSchema = latestDbSchema;
    }
}

