/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.javac;

import androidx.room.compiler.processing.XFiler;
import androidx.room.compiler.processing.XProcessingEnv;
import com.squareup.javapoet.JavaFile;
import com.squareup.kotlinpoet.FileSpec;
import javax.annotation.processing.Filer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/room/compiler/processing/javac/JavacFiler;", "Landroidx/room/compiler/processing/XFiler;", "processingEnv", "Landroidx/room/compiler/processing/XProcessingEnv;", "delegate", "Ljavax/annotation/processing/Filer;", "(Landroidx/room/compiler/processing/XProcessingEnv;Ljavax/annotation/processing/Filer;)V", "getDelegate", "()Ljavax/annotation/processing/Filer;", "write", "", "javaFile", "Lcom/squareup/javapoet/JavaFile;", "mode", "Landroidx/room/compiler/processing/XFiler$Mode;", "fileSpec", "Lcom/squareup/kotlinpoet/FileSpec;", "room-compiler-processing"})
public final class JavacFiler
implements XFiler {
    @NotNull
    private final XProcessingEnv processingEnv;
    @NotNull
    private final Filer delegate;

    public JavacFiler(@NotNull XProcessingEnv processingEnv, @NotNull Filer delegate) {
        Intrinsics.checkNotNullParameter((Object)processingEnv, (String)"processingEnv");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.processingEnv = processingEnv;
        this.delegate = delegate;
    }

    @NotNull
    public final Filer getDelegate() {
        return this.delegate;
    }

    @Override
    public void write(@NotNull JavaFile javaFile, @NotNull XFiler.Mode mode) {
        Intrinsics.checkNotNullParameter((Object)javaFile, (String)"javaFile");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        javaFile.writeTo(this.delegate);
    }

    @Override
    public void write(@NotNull FileSpec fileSpec, @NotNull XFiler.Mode mode) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        if (!this.processingEnv.getOptions().containsKey("kapt.kotlin.generated")) {
            boolean bl = false;
            String filePath = StringsKt.replace$default((String)fileSpec.getPackageName(), (char)'.', (char)'/', (boolean)false, (int)4, null);
            String string = "Could not generate kotlin file " + filePath + '/' + fileSpec.getName() + ".kt. The annotation processing environment is not set to generate Kotlin files.";
            throw new IllegalArgumentException(string.toString());
        }
        fileSpec.writeTo(this.delegate);
    }
}

