/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.javac;

import androidx.room.compiler.processing.XEnumTypeElement;
import androidx.room.compiler.processing.XNullability;
import androidx.room.compiler.processing.javac.DefaultJavacType;
import androidx.room.compiler.processing.javac.JavacAnnotation;
import androidx.room.compiler.processing.javac.JavacAnnotationValue;
import androidx.room.compiler.processing.javac.JavacAnnotationValueKt;
import androidx.room.compiler.processing.javac.JavacArrayType;
import androidx.room.compiler.processing.javac.JavacDeclaredType;
import androidx.room.compiler.processing.javac.JavacEnumEntry;
import androidx.room.compiler.processing.javac.JavacProcessingEnv;
import androidx.room.compiler.processing.javac.JavacType;
import androidx.room.compiler.processing.javac.JavacTypeElement;
import androidx.room.compiler.processing.javac.VisitorData;
import com.google.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\t\n\u0000\n\u0002\b\u0003*\u0001\u0001\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"UNWRAP_VISITOR", "androidx/room/compiler/processing/javac/JavacAnnotationValueKt$UNWRAP_VISITOR$1", "Landroidx/room/compiler/processing/javac/JavacAnnotationValueKt$UNWRAP_VISITOR$1;", "room-compiler-processing"})
public final class JavacAnnotationValueKt {
    @NotNull
    private static final UNWRAP_VISITOR.1 UNWRAP_VISITOR = new AbstractAnnotationValueVisitor8<Object, VisitorData>(){

        @NotNull
        public Boolean visitBoolean(boolean b, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return b;
        }

        @NotNull
        public Byte visitByte(byte b, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return b;
        }

        @NotNull
        public Character visitChar(char c, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return Character.valueOf(c);
        }

        @NotNull
        public Double visitDouble(double d, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return d;
        }

        @NotNull
        public Float visitFloat(float f, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return Float.valueOf(f);
        }

        @NotNull
        public Integer visitInt(int i, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return i;
        }

        @NotNull
        public Long visitLong(long i, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return i;
        }

        @NotNull
        public Short visitShort(short s, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return s;
        }

        @Nullable
        public String visitString(@Nullable String s, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (Intrinsics.areEqual((Object)s, (Object)"<error>")) {
                throw new TypeNotPresentException(s, null);
            }
            return s;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public JavacType visitType(@NotNull TypeMirror t, @NotNull VisitorData data) {
            JavacType javacType;
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (t.getKind() == TypeKind.ERROR) {
                throw new TypeNotPresentException(((Object)t).toString(), null);
            }
            JavacProcessingEnv javacProcessingEnv = data.getEnv();
            Object var4_4 = null;
            XNullability elementNullability$iv = XNullability.NONNULL;
            boolean $i$f$wrap = false;
            TypeKind typeKind = t.getKind();
            switch (typeKind == null ? -1 : JavacProcessingEnv.WhenMappings.$EnumSwitchMapping$0[typeKind.ordinal()]) {
                case 1: {
                    JavacArrayType javacArrayType;
                    void this_$iv;
                    if (elementNullability$iv != null) {
                        ArrayType arrayType = MoreTypes.asArray((TypeMirror)t);
                        Intrinsics.checkNotNullExpressionValue((Object)arrayType, (String)"asArray(typeMirror)");
                        javacArrayType = new JavacArrayType((JavacProcessingEnv)this_$iv, arrayType, elementNullability$iv, null);
                    } else {
                        ArrayType arrayType = MoreTypes.asArray((TypeMirror)t);
                        Intrinsics.checkNotNullExpressionValue((Object)arrayType, (String)"asArray(typeMirror)");
                        javacArrayType = new JavacArrayType((JavacProcessingEnv)this_$iv, arrayType);
                    }
                    javacType = javacArrayType;
                    break;
                }
                case 2: {
                    JavacDeclaredType javacDeclaredType;
                    void this_$iv;
                    if (elementNullability$iv != null) {
                        DeclaredType declaredType = MoreTypes.asDeclared((TypeMirror)t);
                        Intrinsics.checkNotNullExpressionValue((Object)declaredType, (String)"asDeclared(typeMirror)");
                        javacDeclaredType = new JavacDeclaredType((JavacProcessingEnv)this_$iv, declaredType, elementNullability$iv);
                    } else {
                        DeclaredType declaredType = MoreTypes.asDeclared((TypeMirror)t);
                        Intrinsics.checkNotNullExpressionValue((Object)declaredType, (String)"asDeclared(typeMirror)");
                        javacDeclaredType = new JavacDeclaredType((JavacProcessingEnv)this_$iv, declaredType);
                    }
                    javacType = javacDeclaredType;
                    break;
                }
                default: {
                    void this_$iv;
                    javacType = elementNullability$iv != null ? new DefaultJavacType((JavacProcessingEnv)this_$iv, t, elementNullability$iv) : new DefaultJavacType((JavacProcessingEnv)this_$iv, t);
                }
            }
            return javacType;
        }

        @NotNull
        public JavacEnumEntry visitEnumConstant(@NotNull VariableElement c, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            TypeMirror type2 = c.asType();
            if (type2.getKind() == TypeKind.ERROR) {
                throw new TypeNotPresentException(((Object)type2).toString(), null);
            }
            TypeElement enumTypeElement = MoreTypes.asTypeElement((TypeMirror)type2);
            JavacProcessingEnv javacProcessingEnv = data.getEnv();
            Element element = c;
            JavacProcessingEnv javacProcessingEnv2 = data.getEnv();
            Intrinsics.checkNotNullExpressionValue((Object)enumTypeElement, (String)"enumTypeElement");
            return new JavacEnumEntry(javacProcessingEnv, element, (XEnumTypeElement)((Object)JavacTypeElement.Companion.create(javacProcessingEnv2, enumTypeElement)));
        }

        @NotNull
        public JavacAnnotation visitAnnotation(@NotNull AnnotationMirror a, @NotNull VisitorData data) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new JavacAnnotation(data.getEnv(), a);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<JavacAnnotationValue> visitArray(@NotNull List<? extends AnnotationValue> vals, @NotNull VisitorData data) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(vals, (String)"vals");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Iterable $this$map$iv = vals;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AnnotationValue annotationValue = (AnnotationValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new JavacAnnotationValue(data.getEnv(), data.getMethod(), (AnnotationValue)it, (Function0<? extends Object>)((Function0)new Function0<Object>((AnnotationValue)it, this, data){
                    final /* synthetic */ AnnotationValue $it;
                    final /* synthetic */ UNWRAP_VISITOR.1 this$0;
                    final /* synthetic */ VisitorData $data;
                    {
                        this.$it = $it;
                        this.this$0 = $receiver;
                        this.$data = $data;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$it.accept(this.this$0, this.$data);
                    }
                })));
            }
            return (List)destination$iv$iv;
        }
    };

    public static final /* synthetic */ UNWRAP_VISITOR.1 access$getUNWRAP_VISITOR$p() {
        return UNWRAP_VISITOR;
    }
}

